/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.SchemaNotFoundException;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.SequenceUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SequenceIT
extends ParallelStatsDisabledIT {
    private static final String SELECT_NEXT_VALUE_SQL = "SELECT NEXT VALUE FOR %s";
    private static final String SCHEMA_NAME = "S";
    private Connection conn;

    private static String generateTableNameWithSchema() {
        return SchemaUtil.getTableName((String)SCHEMA_NAME, (String)SequenceIT.generateUniqueName());
    }

    private static String generateSequenceNameWithSchema() {
        return SchemaUtil.getTableName((String)SCHEMA_NAME, (String)SequenceIT.generateUniqueSequenceName());
    }

    @Before
    public void init() throws Exception {
        this.createConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            boolean refCountLeaked = SequenceIT.isAnyStoreRefCountLeaked();
            this.conn.close();
            Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
        }
    }

    @Test
    public void testSystemTable() throws Exception {
        this.conn.createStatement().execute("CREATE SEQUENCE " + SequenceIT.generateSequenceNameWithSchema());
        String query = "SELECT sequence_schema, sequence_name, current_value, increment_by FROM \"SYSTEM\".\"SEQUENCE\"";
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testDuplicateSequences() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4\n");
        try {
            this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4\n");
            Assert.fail((String)"Duplicate sequences");
        }
        catch (SequenceAlreadyExistsException sequenceAlreadyExistsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateSequencesAtSameTimestamp() throws Exception {
        MyClock clock = new MyClock(1000L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try {
            String sequenceName = SequenceIT.generateSequenceNameWithSchema();
            this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4\n");
            try {
                this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4\n");
                Assert.fail((String)"Duplicate sequences");
            }
            catch (SequenceAlreadyExistsException sequenceAlreadyExistsException) {
                // empty catch block
            }
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testSequenceNotFound() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String query = "SELECT NEXT value FOR " + sequenceName;
        try {
            this.conn.prepareStatement(query).executeQuery();
            Assert.fail((String)"Sequence not found");
        }
        catch (SequenceNotFoundException sequenceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateSequenceWhenNamespaceEnabled() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        Connection nsConn = DriverManager.getConnection(SequenceIT.getUrl(), props);
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String sequenceSchemaName = SequenceIT.getSchemaName(sequenceName);
        try {
            nsConn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4");
            Assert.fail();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
        nsConn.createStatement().execute("CREATE SCHEMA " + sequenceSchemaName);
        nsConn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4");
        sequenceSchemaName = "TEST_SEQ_SCHEMA";
        sequenceName = "M_SEQ";
        nsConn.createStatement().execute("CREATE SCHEMA " + sequenceSchemaName);
        nsConn.createStatement().execute("USE " + sequenceSchemaName);
        nsConn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4");
        String query = "SELECT sequence_schema, sequence_name, current_value, increment_by FROM \"SYSTEM\".\"SEQUENCE\" WHERE sequence_name='" + sequenceName + "'";
        ResultSet rs = nsConn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)sequenceSchemaName, (Object)rs.getString("sequence_schema"));
        Assert.assertEquals((Object)sequenceName, (Object)rs.getString("sequence_name"));
        Assert.assertEquals((long)2L, (long)rs.getInt("current_value"));
        Assert.assertEquals((long)4L, (long)rs.getInt("increment_by"));
        Assert.assertFalse((boolean)rs.next());
        try {
            nsConn.createStatement().execute("CREATE SEQUENCE " + sequenceSchemaName + "." + sequenceName + " START WITH 2 INCREMENT BY 4");
            Assert.fail();
        }
        catch (SequenceAlreadyExistsException sequenceAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateSequenceWhenNamespaceEnabledAndIsLowerCase() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        Connection nsConn = DriverManager.getConnection(SequenceIT.getUrl(), props);
        String sequenceSchemaName = "\"test_seq_schema\"";
        String sequenceName = "\"m_seq\"";
        nsConn.createStatement().execute("CREATE SCHEMA " + sequenceSchemaName);
        nsConn.createStatement().execute("USE " + sequenceSchemaName);
        nsConn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4");
        String query = "SELECT sequence_schema, sequence_name, current_value, increment_by FROM \"SYSTEM\".\"SEQUENCE\" WHERE sequence_name='" + SchemaUtil.normalizeIdentifier((String)sequenceName) + "'";
        ResultSet rs = nsConn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)sequenceSchemaName), (Object)rs.getString("sequence_schema"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)sequenceName), (Object)rs.getString("sequence_name"));
        Assert.assertEquals((long)2L, (long)rs.getInt("current_value"));
        Assert.assertEquals((long)4L, (long)rs.getInt("increment_by"));
        Assert.assertFalse((boolean)rs.next());
        try {
            nsConn.createStatement().execute("CREATE SEQUENCE " + sequenceSchemaName + "." + sequenceName + " START WITH 2 INCREMENT BY 4");
            Assert.fail();
        }
        catch (SequenceAlreadyExistsException sequenceAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateSequence() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String sequenceNameWithoutSchema = SequenceIT.getNameWithoutSchema(sequenceName);
        String schemaName = SequenceIT.getSchemaName(sequenceName);
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4");
        int bucketNum = this.conn.unwrap(PhoenixConnection.class).getTableNoCache("SYSTEM.SEQUENCE").getBucketNum();
        Assert.assertEquals((String)"Salt bucket for SYSTEM.SEQUENCE should be test default", (long)bucketNum, (long)4L);
        String query = "SELECT sequence_schema, sequence_name, current_value, increment_by FROM \"SYSTEM\".\"SEQUENCE\" WHERE sequence_name='" + sequenceNameWithoutSchema + "'";
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)schemaName, (Object)rs.getString("sequence_schema"));
        Assert.assertEquals((Object)sequenceNameWithoutSchema, (Object)rs.getString("sequence_name"));
        Assert.assertEquals((long)2L, (long)rs.getInt("current_value"));
        Assert.assertEquals((long)4L, (long)rs.getInt("increment_by"));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testCurrentValueFor() throws Exception {
        ResultSet rs;
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4");
        try {
            rs = this.conn.createStatement().executeQuery("SELECT CURRENT VALUE FOR " + sequenceName);
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
        rs = this.conn.createStatement().executeQuery("SELECT NEXT VALUE FOR " + sequenceName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        rs = this.conn.createStatement().executeQuery("SELECT CURRENT VALUE FOR " + sequenceName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
    }

    @Test
    public void testDropSequence() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String sequenceNameWithoutSchema = SequenceIT.getNameWithoutSchema(sequenceName);
        String schemaName = SequenceIT.getSchemaName(sequenceName);
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 4");
        String query = "SELECT sequence_schema, sequence_name, current_value, increment_by FROM \"SYSTEM\".\"SEQUENCE\" WHERE sequence_name='" + sequenceNameWithoutSchema + "'";
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)schemaName, (Object)rs.getString("sequence_schema"));
        Assert.assertEquals((Object)sequenceNameWithoutSchema, (Object)rs.getString("sequence_name"));
        Assert.assertEquals((long)2L, (long)rs.getInt("current_value"));
        Assert.assertEquals((long)4L, (long)rs.getInt("increment_by"));
        Assert.assertFalse((boolean)rs.next());
        this.conn.createStatement().execute("DROP SEQUENCE " + sequenceName);
        query = "SELECT sequence_schema, sequence_name, current_value, increment_by FROM \"SYSTEM\".\"SEQUENCE\" WHERE sequence_name='" + sequenceNameWithoutSchema + "'";
        rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertFalse((boolean)rs.next());
        try {
            this.conn.createStatement().execute("DROP SEQUENCE " + sequenceName);
            Assert.fail();
        }
        catch (SequenceNotFoundException sequenceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSelectNextValueFor() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY 2");
        this.assertSequenceValuesForSingleRow(sequenceName, 3L, 5L, 7L);
    }

    @Test
    public void testInsertNextValueFor() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 1");
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " ( id INTEGER NOT NULL PRIMARY KEY)");
        this.conn.createStatement().execute("UPSERT INTO " + tableName + " (id) VALUES (NEXT VALUE FOR " + sequenceName + ")");
        this.conn.createStatement().execute("UPSERT INTO " + tableName + " (id) VALUES (NEXT VALUE FOR " + sequenceName + ")");
        this.conn.commit();
        String query = "SELECT id FROM " + tableName;
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
    }

    @Test
    public void testSequenceCreation() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String sequenceNameWithoutSchema = SequenceIT.getNameWithoutSchema(sequenceName);
        String schemaName = SequenceIT.getSchemaName(sequenceName);
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 3 MINVALUE 0 MAXVALUE 10 CYCLE CACHE 5");
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT start_with, current_value, increment_by, cache_size, min_value, max_value, cycle_flag, sequence_schema, sequence_name FROM \"SYSTEM\".\"SEQUENCE\" WHERE SEQUENCE_SCHEMA='" + schemaName + "' AND SEQUENCE_NAME='" + sequenceNameWithoutSchema + "'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getLong("start_with"));
        Assert.assertEquals((long)2L, (long)rs.getInt("current_value"));
        Assert.assertEquals((long)3L, (long)rs.getLong("increment_by"));
        Assert.assertEquals((long)5L, (long)rs.getLong("cache_size"));
        Assert.assertEquals((long)0L, (long)rs.getLong("min_value"));
        Assert.assertEquals((long)10L, (long)rs.getLong("max_value"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("cycle_flag"));
        Assert.assertEquals((Object)schemaName, (Object)rs.getString("sequence_schema"));
        Assert.assertEquals((Object)sequenceNameWithoutSchema, (Object)rs.getString("sequence_name"));
        Assert.assertFalse((boolean)rs.next());
        rs = this.conn.createStatement().executeQuery("SELECT NEXT VALUE FOR " + sequenceName + ", CURRENT VALUE FOR " + sequenceName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getLong(1));
        Assert.assertEquals((long)2L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        rs = this.conn.createStatement().executeQuery("SELECT CURRENT VALUE FOR " + sequenceName + ", NEXT VALUE FOR " + sequenceName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getLong(1));
        Assert.assertEquals((long)5L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSameMultipleSequenceValues() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 4 INCREMENT BY 7");
        String query = "SELECT NEXT VALUE FOR " + sequenceName + ", NEXT VALUE FOR " + sequenceName;
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertEquals((long)4L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        this.conn.close();
    }

    @Test
    public void testMultipleSequenceValues() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String alternateSequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 4 INCREMENT BY 7");
        this.conn.createStatement().execute("CREATE SEQUENCE " + alternateSequenceName + " START WITH 9 INCREMENT BY 2");
        String query = "SELECT NEXT VALUE FOR " + sequenceName + ", NEXT VALUE FOR " + alternateSequenceName + " FROM SYSTEM.\"SEQUENCE\" LIMIT 2";
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertEquals((long)9L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)11L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        Connection conn2 = DriverManager.getConnection(SequenceIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        rs = conn2.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)18L, (long)rs.getInt(1));
        Assert.assertEquals((long)13L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)25L, (long)rs.getInt(1));
        Assert.assertEquals((long)15L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        conn2.close();
    }

    @Test
    public void testMultipleSequencesNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String sequenceNameWithoutSchema = SequenceIT.getNameWithoutSchema(sequenceName);
        String schemaName = SequenceIT.getSchemaName(sequenceName);
        String alternateSequenceName = sequenceName + "_ALT";
        String alternatesequenceNameWithoutSchema = SequenceIT.getNameWithoutSchema(alternateSequenceName);
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 4 INCREMENT BY 7 MAXVALUE 24");
        this.conn.createStatement().execute("CREATE SEQUENCE " + alternateSequenceName + " START WITH 9 INCREMENT BY -2 MINVALUE 5");
        String query = "SELECT NEXT VALUE FOR " + sequenceName + ", NEXT VALUE FOR " + alternateSequenceName + " FROM SYSTEM.\"SEQUENCE\" LIMIT 2";
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertEquals((long)9L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)7L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)18L, (long)rs.getInt(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        try {
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            SQLException sqlEx1 = SequenceUtil.getException((String)schemaName, (String)sequenceNameWithoutSchema, (SQLExceptionCode)SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE);
            SQLException sqlEx2 = SequenceUtil.getException((String)schemaName, (String)alternatesequenceNameWithoutSchema, (SQLExceptionCode)SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE);
            this.verifyExceptions(e, Lists.newArrayList((Object[])new String[]{sqlEx1.getMessage(), sqlEx2.getMessage()}));
        }
        this.conn.close();
    }

    @Test
    public void testMultipleSequencesCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String alternateSequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 4 INCREMENT BY 7 MINVALUE 4 MAXVALUE 19 CYCLE");
        this.conn.createStatement().execute("CREATE SEQUENCE " + alternateSequenceName + " START WITH 9 INCREMENT BY -2 MINVALUE 5 MAXVALUE 9 CYCLE");
        String query = "SELECT NEXT VALUE FOR " + sequenceName + ", NEXT VALUE FOR " + alternateSequenceName + " FROM SYSTEM.\"SEQUENCE\" LIMIT 2";
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertEquals((long)9L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)11L, (long)rs.getInt(1));
        Assert.assertEquals((long)7L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)18L, (long)rs.getInt(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertEquals((long)9L, (long)rs.getInt(2));
    }

    @Test
    public void testCompilerOptimization() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY 2");
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " (k INTEGER NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) IMMUTABLE_ROWS=true");
        this.conn.createStatement().execute("CREATE INDEX " + SequenceIT.generateUniqueName() + " ON " + tableName + "(v1) INCLUDE (v2)");
        PhoenixStatement stmt = this.conn.createStatement().unwrap(PhoenixStatement.class);
        stmt.optimizeQuery("SELECT k, NEXT VALUE FOR " + sequenceName + " FROM " + tableName + " WHERE v1 = 'bar'");
    }

    @Test
    public void testSelectRowAndSequence() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 1 INCREMENT BY 4");
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " ( id INTEGER NOT NULL PRIMARY KEY)");
        this.conn.createStatement().execute("UPSERT INTO " + tableName + " (id) VALUES (NEXT VALUE FOR " + sequenceName + ")");
        this.conn.commit();
        String query = "SELECT NEXT VALUE FOR " + sequenceName + ", id FROM " + tableName;
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getInt(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSelectNextValueForOverMultipleBatches() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " (k BIGINT NOT NULL PRIMARY KEY)");
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR " + sequenceName + ")");
        int i = 0;
        while ((long)i < 7L) {
            stmt.execute();
            ++i;
        }
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT count(*),max(k) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)7L, (long)rs.getInt(1));
        Assert.assertEquals((long)7L, (long)rs.getInt(2));
    }

    @Test
    public void testSelectNextValueForGroupBy() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName1 = SequenceIT.generateTableNameWithSchema();
        String tableName2 = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.conn.createStatement().execute("CREATE TABLE " + tableName1 + " (k BIGINT NOT NULL PRIMARY KEY, v VARCHAR)");
        this.conn.createStatement().execute("CREATE TABLE " + tableName2 + " (k BIGINT NOT NULL PRIMARY KEY, v VARCHAR)");
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName1 + " VALUES(NEXT VALUE FOR " + sequenceName + ", ?)");
        stmt.setString(1, "a");
        stmt.execute();
        stmt.setString(1, "a");
        stmt.execute();
        stmt.setString(1, "b");
        stmt.execute();
        stmt.setString(1, "b");
        stmt.execute();
        stmt.setString(1, "c");
        stmt.execute();
        this.conn.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k from " + tableName1);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        this.conn.setAutoCommit(true);
        this.conn.createStatement().execute("UPSERT INTO " + tableName2 + " SELECT NEXT VALUE FOR " + sequenceName + ",v FROM " + tableName1 + " GROUP BY v");
        rs = this.conn.createStatement().executeQuery("SELECT * from " + tableName2);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)6L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)7L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)8L, (long)rs.getInt(1));
        Assert.assertEquals((Object)"c", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSelectNextValueForMultipleConn() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " (k BIGINT NOT NULL PRIMARY KEY)");
        Connection conn1 = this.conn;
        PreparedStatement stmt1 = conn1.prepareStatement("UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR " + sequenceName + ")");
        int i = 0;
        while ((long)i < 4L) {
            stmt1.execute();
            ++i;
        }
        conn1.commit();
        Connection conn2 = DriverManager.getConnection(SequenceIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement stmt2 = conn2.prepareStatement("UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR " + sequenceName + ")");
        stmt2.execute();
        stmt1.close();
        int i2 = 0;
        while ((long)i2 < 3L) {
            stmt2.execute();
            ++i2;
        }
        conn2.commit();
        conn2.close();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k FROM " + tableName);
        int i3 = 0;
        while ((long)i3 < 8L) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)(i3 + 1), (long)rs.getInt(1));
            ++i3;
        }
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSelectNextValueForMultipleConnWithStmtClose() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " (k BIGINT NOT NULL PRIMARY KEY)");
        PreparedStatement stmt1 = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR  " + sequenceName + " )");
        int i = 0;
        while ((long)i < 4L) {
            stmt1.execute();
            ++i;
        }
        this.conn.commit();
        stmt1.close();
        Connection conn2 = DriverManager.getConnection(SequenceIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement stmt2 = conn2.prepareStatement("UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR  " + sequenceName + " )");
        int i2 = 0;
        while ((long)i2 < 4L) {
            stmt2.execute();
            ++i2;
        }
        conn2.commit();
        conn2.close();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k FROM " + tableName);
        int i3 = 0;
        while ((long)i3 < 8L) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)(i3 + 1), (long)rs.getInt(1));
            ++i3;
        }
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSelectNextValueForMultipleConnWithConnClose() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " (k BIGINT NOT NULL PRIMARY KEY)");
        PreparedStatement stmt1 = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR  " + sequenceName + " )");
        int i = 0;
        while ((long)i < 4L) {
            stmt1.execute();
            ++i;
        }
        this.conn.commit();
        Connection conn2 = DriverManager.getConnection(SequenceIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement stmt2 = conn2.prepareStatement("UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR  " + sequenceName + " )");
        int i2 = 0;
        while ((long)i2 < 4L) {
            stmt2.execute();
            ++i2;
        }
        conn2.commit();
        conn2.close();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k FROM " + tableName);
        int i3 = 0;
        while ((long)i3 < 8L) {
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)(i3 + 1), (long)rs.getInt(1));
            ++i3;
        }
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDropCachedSeq1() throws Exception {
        this.testDropCachedSeq(false);
    }

    @Test
    public void testDropCachedSeq2() throws Exception {
        this.testDropCachedSeq(true);
    }

    private void testDropCachedSeq(boolean detectDeleteSeqInEval) throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String alternateSequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.conn.createStatement().execute("CREATE SEQUENCE " + alternateSequenceName + " START WITH 101");
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " (k BIGINT NOT NULL PRIMARY KEY)");
        String stmtStr1a = "UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR  " + sequenceName + " )";
        PreparedStatement stmt1a = this.conn.prepareStatement(stmtStr1a);
        stmt1a.execute();
        stmt1a.execute();
        String stmtStr1b = "UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR " + alternateSequenceName + ")";
        PreparedStatement stmt1b = this.conn.prepareStatement(stmtStr1b);
        stmt1b.execute();
        stmt1b.execute();
        stmt1b.execute();
        this.conn.commit();
        Connection conn2 = DriverManager.getConnection(SequenceIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement stmt2 = conn2.prepareStatement("UPSERT INTO " + tableName + " VALUES(NEXT VALUE FOR " + alternateSequenceName + ")");
        stmt2.execute();
        conn2.commit();
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT k FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)101L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)102L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)103L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)104L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        this.conn.createStatement().execute("DROP SEQUENCE " + alternateSequenceName);
        stmt1a = this.conn.prepareStatement(stmtStr1a);
        stmt1a.execute();
        if (!detectDeleteSeqInEval) {
            stmt1a.execute();
        }
        stmt1b = this.conn.prepareStatement(stmtStr1b);
        try {
            stmt1b.execute();
            Assert.fail();
        }
        catch (SequenceNotFoundException sequenceNotFoundException) {
            // empty catch block
        }
        conn2.close();
    }

    @Test
    public void testExplainPlanValidatesSequences() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String sequenceNameWithoutSchema = SequenceIT.getNameWithoutSchema(sequenceName);
        String tableName = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " (k BIGINT NOT NULL PRIMARY KEY)");
        Connection conn2 = DriverManager.getConnection(SequenceIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        String query = "SELECT NEXT VALUE FOR " + sequenceName + " FROM " + tableName;
        ExplainPlan plan = this.conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((long)1L, (long)explainPlanAttributes.getClientSequenceCount().intValue());
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT sequence_name, current_value FROM \"SYSTEM\".\"SEQUENCE\" WHERE sequence_name='" + sequenceNameWithoutSchema + "'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)sequenceNameWithoutSchema, (Object)rs.getString(1));
        Assert.assertEquals((long)1L, (long)rs.getInt(2));
        conn2.close();
        try {
            this.conn.createStatement().executeQuery("EXPLAIN SELECT NEXT VALUE FOR zzz FROM " + tableName);
            Assert.fail();
        }
        catch (SequenceNotFoundException sequenceNotFoundException) {
            // empty catch block
        }
        this.conn.close();
    }

    @Test
    public void testSelectNextValueAsInput() throws Exception {
        String sequenceName = this.generateSequenceName();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY 2");
        String query = "SELECT LPAD(ENCODE(NEXT VALUE FOR  " + sequenceName + " ,'base62'),5,'0') FROM \"SYSTEM\".\"SEQUENCE\"";
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00003", (Object)rs.getString(1));
    }

    private String generateSequenceName() {
        return SequenceIT.generateUniqueSequenceName();
    }

    @Test
    public void testSelectNextValueInArithmetic() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY 2");
        String query = "SELECT NEXT VALUE FOR  " + sequenceName + " +1";
        ResultSet rs = this.conn.prepareStatement(query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
    }

    private void createConnection() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.conn = DriverManager.getConnection(SequenceIT.getUrl(), props);
    }

    @Test
    public void testSequenceDefault() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.assertSequenceValuesForSingleRow(sequenceName, 1L, 2L, 3L);
        this.conn.createStatement().execute("DROP SEQUENCE " + sequenceName);
        sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " INCREMENT BY -1");
        this.assertSequenceValuesForSingleRow(sequenceName, 1L, 0L, -1L);
        this.conn.createStatement().execute("DROP SEQUENCE " + sequenceName);
        sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " MINVALUE 10");
        this.assertSequenceValuesForSingleRow(sequenceName, 10L, 11L, 12L);
        this.conn.createStatement().execute("DROP SEQUENCE " + sequenceName);
        sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " INCREMENT BY -1 MINVALUE 10 ");
        this.assertSequenceValuesForSingleRow(sequenceName, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL);
        this.conn.createStatement().execute("DROP SEQUENCE " + sequenceName);
        sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " MAXVALUE 0");
        this.assertSequenceValuesForSingleRow(sequenceName, Long.MIN_VALUE, -9223372036854775807L, -9223372036854775806L);
        this.conn.createStatement().execute("DROP SEQUENCE " + sequenceName);
        sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " INCREMENT BY -1 MAXVALUE 0");
        this.assertSequenceValuesForSingleRow(sequenceName, 0L, -1L, -2L);
    }

    @Test
    public void testSequenceValidateStartValue() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String alternateSequenceName = SequenceIT.generateSequenceNameWithSchema();
        try {
            this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 1 INCREMENT BY 1 MINVALUE 2 MAXVALUE 3");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.STARTS_WITH_MUST_BE_BETWEEN_MIN_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
        try {
            this.conn.createStatement().execute("CREATE SEQUENCE " + alternateSequenceName + " START WITH 4 INCREMENT BY 1 MINVALUE 2 MAXVALUE 3");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.STARTS_WITH_MUST_BE_BETWEEN_MIN_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceValidateMinValue() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        try {
            this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " MINVALUE abc");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MINVALUE_MUST_BE_CONSTANT.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceValidateMaxValue() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        try {
            this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " MAXVALUE null");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MAXVALUE_MUST_BE_CONSTANT.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceValidateMinValueLessThanOrEqualToMaxValue() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        try {
            this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " MINVALUE 2 MAXVALUE 1");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.MINVALUE_MUST_BE_LESS_THAN_OR_EQUAL_TO_MAXVALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceValidateIncrementConstant() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        try {
            this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " INCREMENT null");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.INCREMENT_BY_MUST_BE_CONSTANT.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceValidateIncrementNotEqualToZero() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        try {
            this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " INCREMENT 0");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.INCREMENT_BY_MUST_NOT_BE_ZERO.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceStartWithMinMaxSameValueIncreasingCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY 1 MINVALUE 3 MAXVALUE 3 CYCLE CACHE 1");
        this.assertSequenceValuesForSingleRow(sequenceName, 3L, 3L, 3L);
    }

    @Test
    public void testSequenceStartWithMinMaxSameValueDecreasingCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY -1 MINVALUE 3 MAXVALUE 3 CYCLE CACHE 2");
        this.assertSequenceValuesForSingleRow(sequenceName, 3L, 3L, 3L);
    }

    @Test
    public void testSequenceStartWithMinMaxSameValueIncreasingNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY 1 MINVALUE 3 MAXVALUE 3 CACHE 1");
        this.assertSequenceValuesForSingleRow(sequenceName, 3L);
        try {
            ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceStartWithMinMaxSameValueDecreasingNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY -1 MINVALUE 3 MAXVALUE 3 CACHE 2");
        this.assertSequenceValuesForSingleRow(sequenceName, 3L);
        try {
            ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceIncreasingCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 3 MINVALUE 1 MAXVALUE 10 CYCLE CACHE 2");
        this.assertSequenceValuesForSingleRow(sequenceName, 2L, 5L, 8L, 1L, 4L, 7L, 10L, 1L, 4L);
    }

    @Test
    public void testSequenceDecreasingCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY -2 MINVALUE 1 MAXVALUE 10 CYCLE CACHE 2");
        this.assertSequenceValuesForSingleRow(sequenceName, 3L, 1L, 10L, 8L, 6L, 4L, 2L, 10L, 8L);
    }

    @Test
    public void testSequenceIncreasingNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 2 INCREMENT BY 3 MINVALUE 1 MAXVALUE 10 CACHE 100");
        this.assertSequenceValuesForSingleRow(sequenceName, 2L, 5L, 8L);
        try {
            ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceIncreasingUsingMaxValueNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 8 INCREMENT BY 2 MINVALUE 1 MAXVALUE 10 CACHE 2");
        this.assertSequenceValuesForSingleRow(sequenceName, 8L, 10L);
        try {
            ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceDecreasingNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 4 INCREMENT BY -2 MINVALUE 1 MAXVALUE 10 CACHE 100");
        this.assertSequenceValuesForSingleRow(sequenceName, 4L, 2L);
        try {
            ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceDecreasingUsingMinValueNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY -2 MINVALUE 1 MAXVALUE 10 CACHE 2");
        this.assertSequenceValuesForSingleRow(sequenceName, 3L, 1L);
        try {
            ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceIncreasingOverflowNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 9223372036854775807 INCREMENT BY 1 CACHE 10");
        this.assertSequenceValuesForSingleRow(sequenceName, Long.MAX_VALUE);
        try {
            ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceIncreasingOverflowCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 9223372036854775807 INCREMENT BY 9223372036854775807 CYCLE CACHE 10");
        this.assertSequenceValuesForSingleRow(sequenceName, Long.MAX_VALUE, Long.MIN_VALUE, -1L, 0x7FFFFFFFFFFFFFFEL, Long.MIN_VALUE, -1L);
    }

    @Test
    public void testSequenceDecreasingOverflowNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH -9223372036854775807 INCREMENT BY -1 CACHE 10");
        this.assertSequenceValuesForSingleRow(sequenceName, -9223372036854775807L, Long.MIN_VALUE);
        try {
            ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
            rs.next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSequenceDecreasingOverflowCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH -9223372036854775807 INCREMENT BY -9223372036854775807 CYCLE CACHE 10");
        this.assertSequenceValuesForSingleRow(sequenceName, -9223372036854775807L, Long.MAX_VALUE, 0L, -9223372036854775807L, Long.MAX_VALUE, 0L);
    }

    @Test
    public void testMultipleSequenceValuesNoCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String alternateSequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 1 INCREMENT BY 2 MINVALUE 1 MAXVALUE 10 CACHE 2");
        this.conn.createStatement().execute("CREATE SEQUENCE " + alternateSequenceName);
        this.assertSequenceValuesMultipleSeq(sequenceName, 1L, 3L);
        this.assertSequenceValuesMultipleSeq(sequenceName, 5L, 7L);
        PreparedStatement stmt = this.conn.prepareStatement(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)9L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        try {
            stmt.executeQuery().next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
        try {
            stmt.executeQuery().next();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultipleSequenceValuesCycle() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String alternateSequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 1 INCREMENT BY 2 MINVALUE 1 MAXVALUE 10 CYCLE CACHE 2");
        this.conn.createStatement().execute("CREATE SEQUENCE " + alternateSequenceName);
        this.assertSequenceValuesMultipleSeq(sequenceName, 1L, 3L);
        this.assertSequenceValuesMultipleSeq(sequenceName, 5L, 7L);
        this.assertSequenceValuesMultipleSeq(sequenceName, 9L, 1L);
        this.assertSequenceValuesMultipleSeq(sequenceName, 3L, 5L);
        this.assertSequenceValuesMultipleSeq(sequenceName, 7L, 9L);
        this.assertSequenceValuesMultipleSeq(sequenceName, 1L, 3L);
        this.assertSequenceValuesMultipleSeq(sequenceName, 5L, 7L);
    }

    @Test
    public void testUpsertSelectGroupByWithSequence() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName1 = SequenceIT.generateTableNameWithSchema();
        String tableName2 = SequenceIT.generateTableNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        this.conn.createStatement().execute("CREATE TABLE " + tableName1 + "(event_id BIGINT NOT NULL PRIMARY KEY, user_id char(15), val BIGINT )");
        this.conn.createStatement().execute("CREATE TABLE " + tableName2 + " (metric_id char(15) NOT NULL PRIMARY KEY, agg_id char(15), metric_val INTEGER )");
        this.insertEvent(tableName1, 1L, "user1", 1L);
        this.insertEvent(tableName1, 2L, "user2", 1L);
        this.insertEvent(tableName1, 3L, "user1", 1L);
        this.insertEvent(tableName1, 4L, "user2", 1L);
        this.insertEvent(tableName1, 5L, "user2", 1L);
        this.insertEvent(tableName1, 6L, "user3", 1L);
        this.conn.commit();
        this.conn.createStatement().execute("UPSERT INTO " + tableName2 + " SELECT 'METRIC_'||(LPAD(ENCODE(NEXT VALUE FOR " + sequenceName + ",'base62'),5,'0')), user_id, sum(val) FROM " + tableName1 + " GROUP BY user_id ORDER BY user_id");
        this.conn.commit();
        PreparedStatement stmt = this.conn.prepareStatement("SELECT metric_id, agg_id, metric_val FROM " + tableName2);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"METRIC_00001", (Object)rs.getString("metric_id"));
        Assert.assertEquals((Object)"user1", (Object)rs.getString("agg_id"));
        Assert.assertEquals((long)2L, (long)rs.getLong("metric_val"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"METRIC_00002", (Object)rs.getString("metric_id"));
        Assert.assertEquals((Object)"user2", (Object)rs.getString("agg_id"));
        Assert.assertEquals((long)3L, (long)rs.getLong("metric_val"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"METRIC_00003", (Object)rs.getString("metric_id"));
        Assert.assertEquals((Object)"user3", (Object)rs.getString("agg_id"));
        Assert.assertEquals((long)1L, (long)rs.getLong("metric_val"));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNextValuesForSequenceClosingConnections() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 4990 MINVALUE 4990 MAXVALUE 5000 CACHE 10");
        try {
            long val = 0L;
            for (int i = 0; i <= 11; ++i) {
                ResultSet rs = this.conn.createStatement().executeQuery(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
                rs.next();
                val = rs.getLong(1);
            }
            Assert.fail((String)("Expect to fail as we have arrived at the max sequence value " + val));
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((e.getNextException() == null ? 1 : 0) != 0);
        }
    }

    private void insertEvent(String tableName, long id, String userId, long val) throws SQLException {
        PreparedStatement stmt = this.conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
        stmt.setLong(1, id);
        stmt.setString(2, userId);
        stmt.setLong(3, val);
        stmt.execute();
    }

    private void assertSequenceValuesForSingleRow(String sequenceName, long ... seqVals) throws SQLException {
        PreparedStatement stmt = this.conn.prepareStatement(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
        for (long seqVal : seqVals) {
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)seqVal, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
        }
        stmt.close();
    }

    private void assertSequenceValuesMultipleSeq(String sequenceName, long ... seqVals) throws SQLException {
        PreparedStatement stmt = this.conn.prepareStatement(String.format(SELECT_NEXT_VALUE_SQL, sequenceName));
        for (long seqVal : seqVals) {
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)seqVal, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
        stmt.close();
    }

    private void verifyExceptions(SQLException sqlE, List<String> expectedExceptions) {
        ArrayList missingExceptions = Lists.newArrayList(expectedExceptions);
        ArrayList unexpectedExceptions = Lists.newArrayList();
        do {
            if (!expectedExceptions.contains(sqlE.getMessage())) {
                unexpectedExceptions.add(sqlE.getMessage());
            }
            missingExceptions.remove(sqlE.getMessage());
        } while ((sqlE = sqlE.getNextException()) != null);
        if (unexpectedExceptions.size() != 0 && missingExceptions.size() != 0) {
            Assert.fail((String)("Actual exceptions does not match expected exceptions. Unexpected exceptions : " + unexpectedExceptions + " missing exceptions : " + missingExceptions));
        }
    }

    @Test
    public void testValidateBeforeReserve() throws Exception {
        String tableName = SequenceIT.generateTableNameWithSchema();
        String seqName = SequenceIT.generateSequenceNameWithSchema();
        this.conn.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR PRIMARY KEY, l BIGINT)");
        this.conn.createStatement().execute("CREATE SEQUENCE " + seqName);
        ResultSet rs = this.conn.createStatement().executeQuery("EXPLAIN SELECT NEXT VALUE FOR " + seqName + " FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        this.conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('a', NEXT VALUE FOR " + seqName + ")");
        this.conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('b', NEXT VALUE FOR " + seqName + ")");
        this.conn.commit();
        rs = this.conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)1L, (long)rs.getLong(2));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)2L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement stmt = this.conn.prepareStatement("SELECT NEXT VALUE FOR " + seqName + " FROM " + tableName);
        ParameterMetaData md = stmt.getParameterMetaData();
        Assert.assertEquals((long)0L, (long)md.getParameterCount());
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getLong(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getLong(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testNoFromClause() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String alternateSequenceName = SequenceIT.generateSequenceNameWithSchema();
        String seqName = sequenceName;
        String secondSeqName = alternateSequenceName;
        this.conn.createStatement().execute("CREATE SEQUENCE " + seqName + " START WITH 1 INCREMENT BY 1");
        this.conn.createStatement().execute("CREATE SEQUENCE " + secondSeqName + " START WITH 2 INCREMENT BY 3");
        String query = "SELECT NEXT VALUE FOR " + seqName;
        ExplainPlan plan = this.conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)new Integer(1), (Object)explainPlanAttributes.getClientSequenceCount());
        ResultSet rs = this.conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        query = "SELECT CURRENT VALUE FOR " + seqName;
        plan = this.conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)new Integer(1), (Object)explainPlanAttributes.getClientSequenceCount());
        rs = this.conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = this.conn.createStatement().executeQuery("SELECT NEXT VALUE FOR " + seqName + ", NEXT VALUE FOR " + secondSeqName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        rs = this.conn.createStatement().executeQuery("SELECT CURRENT VALUE FOR " + seqName + ", NEXT VALUE FOR " + secondSeqName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((long)5L, (long)rs.getInt(2));
    }

    @Test
    public void testBug6574() throws Exception {
        String sequenceName = SequenceIT.generateSequenceNameWithSchema();
        String tableName = SequenceIT.generateTableNameWithSchema();
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute("CREATE SEQUENCE " + sequenceName);
            stmt.execute("CREATE TABLE " + tableName + " (id integer primary key)");
            String query = "SELECT * FROM SYSTEM.\"SEQUENCE\" where SEQUENCE_NAME = '" + SequenceIT.getNameWithoutSchema(sequenceName) + "'";
            ResultSet rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            rs.close();
            stmt.execute("DROP TABLE " + tableName);
            rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            rs.close();
        }
    }

    private static String getSchemaName(String tableName) {
        return tableName.substring(0, tableName.indexOf("."));
    }

    private static String getNameWithoutSchema(String tableName) {
        return tableName.substring(tableName.indexOf(".") + 1);
    }

    private static class MyClock
    extends EnvironmentEdge {
        public volatile long time;

        public MyClock(long time) {
            this.time = time;
        }

        public long currentTime() {
            return this.time;
        }
    }
}

