/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ScanBoundaryFunctionIT
extends ParallelStatsDisabledIT {
    private String tableName;
    private String fullTableName;

    @Before
    public void setUp() throws Exception {
        this.tableName = ScanBoundaryFunctionIT.generateUniqueName();
        this.fullTableName = "\"" + this.tableName + "\"";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String createTableSql = "CREATE TABLE " + this.fullTableName + " (PK VARCHAR NOT NULL PRIMARY KEY, COL1 VARCHAR, COL2 INTEGER)";
            conn.createStatement().execute(createTableSql);
            String upsertSql = "UPSERT INTO " + this.fullTableName + " (PK, COL1, COL2) VALUES (?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(upsertSql);){
                for (int i = 1; i <= 30; ++i) {
                    String pk = String.format("KEY_%03d", i);
                    stmt.setString(1, pk);
                    stmt.setString(2, "Value_" + i);
                    stmt.setInt(3, i * 10);
                    stmt.executeUpdate();
                }
            }
            conn.commit();
        }
    }

    @Test
    public void testScanStartKeyOnly() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_010"));
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_010'", (byte[])Bytes.toBytes((String)"KEY_010"), (byte[])scan.getStartRow());
                Assert.assertEquals((String)"SCAN_END_KEY not specified, so stop row should be empty", (long)0L, (long)scan.getStopRow().length);
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                    Assert.assertEquals((String)"Should return 21 rows from KEY_010 to KEY_030 inclusive", (long)21L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_010 (inclusive start boundary)", (Object)"KEY_010", results.get(0));
                    Assert.assertEquals((String)"Last result should be KEY_030 (no end boundary specified)", (Object)"KEY_030", results.get(results.size() - 1));
                }
            }
        }
    }

    @Test
    public void testScanEndKeyOnly() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_END_KEY() = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_020"));
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertEquals((String)"SCAN_START_KEY not specified, so start row should be empty", (long)0L, (long)scan.getStartRow().length);
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to 'KEY_020'", (byte[])Bytes.toBytes((String)"KEY_020"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                    Assert.assertEquals((String)"Should return 19 rows from beginning to KEY_019 (exclusive end at KEY_020)", (long)19L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_001 (no start boundary specified)", (Object)"KEY_001", results.get(0));
                    Assert.assertEquals((String)"Last result should be KEY_019 (exclusive end boundary at KEY_020)", (Object)"KEY_019", results.get(results.size() - 1));
                }
            }
        }
    }

    @Test
    public void testScanBothBoundaries() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_010"));
                stmt.setBytes(2, Bytes.toBytes((String)"KEY_020"));
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_010'", (byte[])Bytes.toBytes((String)"KEY_010"), (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to 'KEY_020'", (byte[])Bytes.toBytes((String)"KEY_020"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                    Assert.assertEquals((String)"Should return 10 rows from KEY_010 (inclusive) to KEY_020 (exclusive)", (long)10L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_010 (inclusive start boundary)", (Object)"KEY_010", results.get(0));
                    Assert.assertEquals((String)"Last result should be KEY_019 (exclusive end boundary at KEY_020)", (Object)"KEY_019", results.get(results.size() - 1));
                }
            }
        }
    }

    @Test
    public void testScanBothBoundaries2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, null);
                stmt.setBytes(2, Bytes.toBytes((String)"KEY_020"));
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertEquals((String)"SCAN_START_KEY not specified, so start row should be empty", (long)0L, (long)scan.getStartRow().length);
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to 'KEY_020'", (byte[])Bytes.toBytes((String)"KEY_020"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                    Assert.assertEquals((String)"Should return 19 rows from KEY_001 (inclusive) to KEY_020 (exclusive)", (long)19L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_001 (inclusive start boundary)", (Object)"KEY_001", results.get(0));
                    Assert.assertEquals((String)"Last result should be KEY_019 (exclusive end boundary at KEY_020)", (Object)"KEY_019", results.get(results.size() - 1));
                }
            }
        }
    }

    @Test
    public void testScanBothBoundaries3() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_020"));
                stmt.setBytes(2, null);
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_020'", (byte[])Bytes.toBytes((String)"KEY_020"), (byte[])scan.getStartRow());
                Assert.assertEquals((String)"SCAN_END_KEY set to null, so stop row should be empty", (long)0L, (long)scan.getStopRow().length);
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                    Assert.assertEquals((String)"Should return 11 rows from KEY_020 (inclusive) to empty (exclusive)", (long)11L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_020 (inclusive start boundary)", (Object)"KEY_020", results.get(0));
                    Assert.assertEquals((String)"Last result should be KEY_030", (Object)"KEY_030", results.get(results.size() - 1));
                }
            }
        }
    }

    @Test
    public void testScanBoundariesWithAdditionalFilter() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK, COL2 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ? AND COL2 > ? ORDER BY PK, COL2";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_010"));
                stmt.setBytes(2, Bytes.toBytes((String)"KEY_020"));
                stmt.setInt(3, 150);
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_010'", (byte[])Bytes.toBytes((String)"KEY_010"), (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to 'KEY_020'", (byte[])Bytes.toBytes((String)"KEY_020"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    ArrayList<Integer> col2Values = new ArrayList<Integer>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                        col2Values.add(rs.getInt(2));
                    }
                    Assert.assertEquals((String)"Should return 4 rows (KEY_016-KEY_019) that satisfy scan boundaries and COL2 > 150", (long)4L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_016 (first row in range with COL2 > 150)", (Object)"KEY_016", results.get(0));
                    Assert.assertEquals((String)"Last result should be KEY_019 (last row in range with COL2 > 150)", (Object)"KEY_019", results.get(results.size() - 1));
                    for (int i = 0; i < col2Values.size(); ++i) {
                        Integer value = (Integer)col2Values.get(i);
                        Assert.assertTrue((String)("COL2 value for " + (String)results.get(i) + " should be > 150, but was: " + value), (value > 150 ? 1 : 0) != 0);
                    }
                }
            }
        }
    }

    @Test
    public void testScanBoundariesWithLiterals() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = 'KEY_005' AND SCAN_END_KEY() = 'KEY_015'";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY literal should set scan start row to 'KEY_005'", (byte[])Bytes.toBytes((String)"KEY_005"), (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY literal should set scan stop row to 'KEY_015'", (byte[])Bytes.toBytes((String)"KEY_015"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                    Assert.assertEquals((String)"Should return 10 rows from KEY_005 (inclusive) to KEY_015 (exclusive) using literals", (long)10L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_005 (inclusive start boundary from literal)", (Object)"KEY_005", results.get(0));
                    Assert.assertEquals((String)"Last result should be KEY_014 (exclusive end boundary at KEY_015 from literal)", (Object)"KEY_014", results.get(results.size() - 1));
                }
            }
        }
    }

    @Test
    public void testScanBoundariesWithColumnFilter() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK, COL1 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND COL1 LIKE 'Value_1%'";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_010"));
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_010'", (byte[])Bytes.toBytes((String)"KEY_010"), (byte[])scan.getStartRow());
                Assert.assertEquals((String)"SCAN_END_KEY not specified, so stop row should be empty", (long)0L, (long)scan.getStopRow().length);
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    ArrayList<String> col1Values = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                        col1Values.add(rs.getString(2));
                    }
                    Assert.assertEquals((String)"Should return 10 rows from KEY_010 onwards that match COL1 LIKE 'Value_1%'", (long)10L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_010 (start boundary with matching COL1)", (Object)"KEY_010", results.get(0));
                    Assert.assertEquals((String)"Last result should be KEY_019 (last row with COL1 starting with 'Value_1')", (Object)"KEY_019", results.get(results.size() - 1));
                    for (int i = 0; i < col1Values.size(); ++i) {
                        String value = (String)col1Values.get(i);
                        Assert.assertTrue((String)("COL1 value for " + (String)results.get(i) + " should start with 'Value_1', but was: " + value), (boolean)value.startsWith("Value_1"));
                    }
                }
            }
        }
    }

    @Test
    public void testScanBoundariesEmptyResult() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ? ORDER BY PK";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_020"));
                stmt.setBytes(2, Bytes.toBytes((String)"KEY_015"));
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_020'", (byte[])Bytes.toBytes((String)"KEY_020"), (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to 'KEY_015'", (byte[])Bytes.toBytes((String)"KEY_015"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        results.add(rs.getString(1));
                    }
                    Assert.assertEquals((String)"Should return 0 rows when start key (KEY_020) > end key (KEY_015)", (long)0L, (long)results.size());
                }
            }
        }
    }

    @Test
    public void testScanBoundariesWithComplexFilter() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK, COL1, COL2 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?  AND (COL2 BETWEEN ? AND ? OR COL1 = ?) ORDER BY PK";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_005"));
                stmt.setBytes(2, Bytes.toBytes((String)"KEY_025"));
                stmt.setInt(3, 100);
                stmt.setInt(4, 120);
                stmt.setString(5, "Value_15");
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_005'", (byte[])Bytes.toBytes((String)"KEY_005"), (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to 'KEY_025'", (byte[])Bytes.toBytes((String)"KEY_025"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        String pk = rs.getString(1);
                        String col1 = rs.getString(2);
                        int col2 = rs.getInt(3);
                        results.add(pk);
                        Assert.assertTrue((String)("Filter condition not satisfied for " + pk + " (COL2=" + col2 + ", COL1=" + col1 + "). Expected: (COL2 BETWEEN 100 AND 120) OR COL1='Value_15'"), (col2 >= 100 && col2 <= 120 || col1.equals("Value_15") ? 1 : 0) != 0);
                    }
                    Assert.assertEquals((String)"Should return 4 rows that satisfy complex filter within scan boundaries KEY_005 to KEY_025", (long)4L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_010 (COL2=100, within BETWEEN range)", (Object)"KEY_010", results.get(0));
                    Assert.assertEquals((String)"Second result should be KEY_011 (COL2=110, within BETWEEN range)", (Object)"KEY_011", results.get(1));
                    Assert.assertEquals((String)"Third result should be KEY_012 (COL2=120, within BETWEEN range)", (Object)"KEY_012", results.get(2));
                    Assert.assertEquals((String)"Fourth result should be KEY_015 (COL1='Value_15', matches OR condition)", (Object)"KEY_015", results.get(3));
                }
            }
        }
    }

    @Test
    public void testScanBoundariesFail() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? OR SCAN_END_KEY() = ?";
            PreparedStatement stmt = conn.prepareStatement(sql);
            try {
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_010"));
                stmt.setBytes(2, Bytes.toBytes((String)"KEY_020"));
                try {
                    PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                    ResultSet rs = stmt.executeQuery();
                    try {
                        rs.next();
                        throw new AssertionError((Object)"Should not reach here");
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Assert.assertTrue((String)"ScanStartKeyFunction should not be instantiated", (boolean)e.getMessage().contains("java.lang.InstantiationException: org.apache.phoenix.expression.function.ScanStartKeyFunction"));
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Throwable e) {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs) {
                        e.addSuppressed(rs);
                    }
                }
                throw e;
            }
            sql = "SELECT PK FROM " + this.fullTableName + " WHERE SCAN_END_KEY() <= ?";
            stmt = conn.prepareStatement(sql);
            try {
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_010"));
                try {
                    PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                    ResultSet rs = stmt.executeQuery();
                    try {
                        rs.next();
                        throw new AssertionError((Object)"Should not reach here");
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Assert.assertTrue((String)"ScanEndKeyFunction should not be instantiated", (boolean)e.getMessage().contains("java.lang.InstantiationException: org.apache.phoenix.expression.function.ScanEndKeyFunction"));
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                }
                throw throwable;
            }
        }
    }

    @Test
    public void testScanBoundariesMixedWithOrConditionShouldWork() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK, COL1, COL2 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ? AND (COL1 = ? OR COL2 = ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_010"));
                stmt.setBytes(2, Bytes.toBytes((String)"KEY_020"));
                stmt.setString(3, "Value_12");
                stmt.setInt(4, 150);
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_010' even with OR in additional filters", (byte[])Bytes.toBytes((String)"KEY_010"), (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to 'KEY_020' even with OR in additional filters", (byte[])Bytes.toBytes((String)"KEY_020"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    ArrayList<String> results = new ArrayList<String>();
                    while (rs.next()) {
                        String pk = rs.getString(1);
                        String col1 = rs.getString(2);
                        int col2 = rs.getInt(3);
                        results.add(pk);
                        Assert.assertTrue((String)("Filter condition not satisfied for " + pk + " (COL1=" + col1 + ", COL2=" + col2 + "). Expected: COL1='Value_12' OR COL2=150"), (col1.equals("Value_12") || col2 == 150 ? 1 : 0) != 0);
                    }
                    Assert.assertEquals((String)"Should return 2 rows", (long)2L, (long)results.size());
                    Assert.assertEquals((String)"First result should be KEY_012 which has COL1='Value_12'", (Object)"KEY_012", results.get(0));
                    Assert.assertEquals((String)"Second result should be KEY_015 which has COL2=150", (Object)"KEY_015", results.get(1));
                }
            }
        }
    }

    @Test
    public void testInvertedScanBoundaries() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ScanBoundaryFunctionIT.getUrl(), props);){
            String sql = "SELECT PK, COL1, COL2 FROM " + this.fullTableName + " WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ? AND (COL1 = ? OR COL2 = ?)";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBytes(1, Bytes.toBytes((String)"KEY_020"));
                stmt.setBytes(2, Bytes.toBytes((String)"KEY_010"));
                stmt.setString(3, "Value_12");
                stmt.setInt(4, 150);
                PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
                QueryPlan plan = pstmt.optimizeQuery(sql);
                Scan scan = plan.getContext().getScan();
                Assert.assertArrayEquals((String)"SCAN_START_KEY should set scan start row to 'KEY_020' even with OR in additional filters", (byte[])Bytes.toBytes((String)"KEY_020"), (byte[])scan.getStartRow());
                Assert.assertArrayEquals((String)"SCAN_END_KEY should set scan stop row to 'KEY_010' even with OR in additional filters", (byte[])Bytes.toBytes((String)"KEY_010"), (byte[])scan.getStopRow());
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertFalse((String)"No rows should be found", (boolean)rs.next());
                }
            }
        }
    }
}

