/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RowValueConstructorOffsetOptionalIT
extends ParallelStatsDisabledIT {
    private final long TS = System.currentTimeMillis();
    private final String[] stringDataSet = new String[]{"aaa", "aab", "aac"};
    private final String[] nullableStringDataSet = new String[]{null, "aaa", "bbb"};
    private final Double[] doubleDataSet = new Double[]{1.0, 1.1, 1.11};
    private final Short[] shortDataSet = new Short[]{(short)1, (short)11, (short)110};
    private final Integer[] intDataSet = new Integer[]{1, 11, 110};
    private final Long[] longDataSet = new Long[]{new Long(1L), new Long(11L), new Long(111L)};
    private final Date[] dateDataSet = new Date[]{new Date(this.TS - 1000L), new Date(this.TS), new Date(this.TS + 1000L)};
    private final BigDecimal[] decimalDataSet = new BigDecimal[]{new BigDecimal("0.01"), new BigDecimal("0.02"), new BigDecimal("0.03")};
    private final String[] types = new String[]{"CHAR", "VARCHAR", "TIMESTAMP", "DATE", "DECIMAL", "DOUBLE", "SMALLINT", "INTEGER", "BIGINT"};
    private static Connection conn = null;
    private String PREFIX = "000";
    private int EXPECTED_ROWS_PER_TENANT = 10;
    private int NUMBER_OF_TENANT_VIEWS = 5;

    @BeforeClass
    public static synchronized void init() throws SQLException {
        conn = DriverManager.getConnection(RowValueConstructorOffsetOptionalIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
    }

    @AfterClass
    public static synchronized void cleanup() {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Ignore
    @Test
    public void testSinglePkColumnTestSet() throws SQLException {
        for (String type : this.types) {
            this.testSinglePkColumnTypes(type);
        }
    }

    @Ignore
    @Test
    public void testMultiPkColumnsTestSet() throws SQLException {
        for (String type1 : this.types) {
            for (String type2 : this.types) {
                this.testMultiPkColumnTypes(type1, type2);
            }
        }
    }

    @Ignore
    @Test
    public void testMultiPkColumnsForNullableTestSet() throws SQLException {
        for (String type1 : this.types) {
            this.testMultiPkColumnForNullableTypes(type1, "VARCHAR");
        }
    }

    @Ignore
    @Test
    public void testMultiTenantViewTests() throws SQLException {
        String baseTable = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        this.createMultiTenantBaseTable(baseTable);
        String ddl = "CREATE VIEW %s (PK1 INTEGER NOT NULL PRIMARY KEY) AS SELECT * FROM " + baseTable + " WHERE PREFIX = '" + this.PREFIX + "'";
        for (int i = 0; i < this.NUMBER_OF_TENANT_VIEWS; ++i) {
            this.createAndupsertDataToTenantView(ddl, this.EXPECTED_ROWS_PER_TENANT);
        }
        this.verifyMultiTenantTable(baseTable);
    }

    @Ignore
    @Test
    public void testMultiTenantViewOnGlobalViewTests() throws SQLException {
        String baseTable = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String globalView = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        this.createMultiTenantBaseTable(baseTable);
        this.createGlobalView(baseTable, globalView);
        String ddl = "CREATE VIEW %s (PK1 INTEGER NOT NULL PRIMARY KEY) AS SELECT * FROM " + globalView;
        for (int i = 0; i < this.NUMBER_OF_TENANT_VIEWS; ++i) {
            this.createAndupsertDataToTenantView(ddl, this.EXPECTED_ROWS_PER_TENANT);
        }
        this.verifyMultiTenantTable(baseTable);
    }

    private void createGlobalView(String baseTable, String globalView) throws SQLException {
        String ddlBaseTable = "CREATE VIEW " + globalView + " AS SELECT * FROM " + baseTable + " WHERE PREFIX = '%s'";
        try (Statement statement = conn.createStatement();){
            statement.execute(String.format(ddlBaseTable, this.PREFIX));
        }
    }

    private void verifyMultiTenantTable(String baseTable) throws SQLException {
        String tenantId = "0";
        String sql = "SELECT * FROM " + baseTable + " LIMIT " + this.EXPECTED_ROWS_PER_TENANT + " OFFSET (TENANT_ID,PREFIX)=(?,?)";
        for (int i = 0; i <= this.NUMBER_OF_TENANT_VIEWS; ++i) {
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, tenantId);
                statement.setString(2, this.PREFIX);
                ResultSet rs = statement.executeQuery();
                if (i == this.NUMBER_OF_TENANT_VIEWS) {
                    Assert.assertFalse((boolean)rs.next());
                    continue;
                }
                int numberOfRows = 0;
                while (rs.next()) {
                    if (numberOfRows == 0) {
                        tenantId = rs.getString(1);
                    } else {
                        Assert.assertEquals((Object)tenantId, (Object)rs.getString(1));
                    }
                    ++numberOfRows;
                }
                Assert.assertEquals((long)this.EXPECTED_ROWS_PER_TENANT, (long)numberOfRows);
                continue;
            }
        }
    }

    private void createAndupsertDataToTenantView(String ddl, int numberRows) throws SQLException {
        String tenantView = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String tenantId = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String upsertSql = "UPSERT INTO " + tenantView + " (PK1) VALUES (?)";
        try (Connection tenantConn = this.getTenantConnection(tenantId);){
            try (Statement statement = tenantConn.createStatement();){
                statement.execute(String.format(ddl, tenantView));
            }
            for (int i = 0; i < numberRows; ++i) {
                try (PreparedStatement preparedStatement = tenantConn.prepareStatement(upsertSql);){
                    preparedStatement.setInt(1, i);
                    preparedStatement.execute();
                    continue;
                }
            }
            tenantConn.commit();
        }
    }

    private void createMultiTenantBaseTable(String baseTableName) throws SQLException {
        String ddlBaseTable = "CREATE TABLE " + baseTableName + " (TENANT_ID CHAR(10) NOT NULL, PREFIX CHAR(3) NOT NULL   CONSTRAINT PK PRIMARY KEY       (TENANT_ID,PREFIX)) MULTI_TENANT=TRUE";
        try (Statement statement = conn.createStatement();){
            statement.execute(ddlBaseTable);
        }
    }

    private Connection getTenantConnection(String tenantId) throws SQLException {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(RowValueConstructorOffsetOptionalIT.getUrl(), tenantProps);
    }

    private void testMultiPkColumnForNullableTypes(String type, String nullableType) throws SQLException {
        Object[][] data1 = new Object[2][];
        Object[][] data2 = new Object[2][];
        data1[0] = this.getData(type);
        data1[1] = this.getNullableData(nullableType);
        data2[0] = data1[1];
        data2[1] = data1[0];
        String ascTableName1 = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String descTableName1 = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String ascTableName2 = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String descTableName2 = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String ddlAsc1 = "CREATE TABLE " + ascTableName1 + " (PK1 %s NOT NULL,PK2 %s,CONSTRAINT PK PRIMARY KEY (PK1, PK2))";
        String ddlDesc1 = "CREATE TABLE " + descTableName1 + " (PK1 %s NOT NULL,PK2 %s,CONSTRAINT PK PRIMARY KEY (PK1 DESC, PK2 DESC))";
        String ddlAsc2 = "CREATE TABLE " + ascTableName2 + " (PK1 %s,PK2 %s NOT NULL,CONSTRAINT PK PRIMARY KEY (PK1, PK2))";
        String ddlDesc2 = "CREATE TABLE " + descTableName2 + " (PK1 %s,PK2 %s NOT NULL,CONSTRAINT PK PRIMARY KEY (PK1 DESC, PK2 DESC))";
        try (Statement statement = conn.createStatement();){
            statement.execute(String.format(ddlAsc1, this.getTypeString(type), nullableType));
            statement.execute(String.format(ddlDesc1, this.getTypeString(type), nullableType));
            statement.execute(String.format(ddlAsc2, nullableType, this.getTypeString(type)));
            statement.execute(String.format(ddlDesc2, nullableType, this.getTypeString(type)));
        }
        this.upsertRowsToMultiPkColumnTable(data1, ascTableName1, descTableName1, type, nullableType);
        this.verifyMultiPkColumnResults(data1, ascTableName1, descTableName1, type, nullableType);
        this.upsertRowsToMultiPkColumnTable(data2, ascTableName2, descTableName2, nullableType, type);
        this.verifyMultiPkColumnResults(data2, ascTableName2, descTableName2, nullableType, type);
    }

    private Object[] getNullableData(String type) {
        String[] data = null;
        switch (type) {
            case "VARCHAR": {
                data = this.nullableStringDataSet;
            }
        }
        return data;
    }

    private void testSinglePkColumnTypes(String type) throws SQLException {
        String ascTableName = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String descTableName = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String ddlAscTmp = "CREATE TABLE " + ascTableName + " (PK1 %s PRIMARY KEY)";
        String ddlDescTmp = "CREATE TABLE " + descTableName + " (PK1 %s PRIMARY KEY DESC)";
        String ddlAsc = String.format(ddlAscTmp, this.getTypeString(type));
        String ddlDesc = String.format(ddlDescTmp, this.getTypeString(type));
        Object[] data = this.getData(type);
        try (Statement statement = conn.createStatement();){
            statement.execute(ddlAsc);
            statement.execute(ddlDesc);
        }
        this.upsertRowsIntoSinglePkColumnTable(data, ascTableName, descTableName, type);
        this.verifySinglePkColumnResults(data, ascTableName, descTableName, type);
    }

    private Object[] getData(String type) {
        Object[] data = null;
        switch (type) {
            case "CHAR": 
            case "VARCHAR": {
                data = this.stringDataSet;
                break;
            }
            case "TIMESTAMP": 
            case "DATE": {
                data = this.dateDataSet;
                break;
            }
            case "DECIMAL": {
                data = this.decimalDataSet;
                break;
            }
            case "DOUBLE": {
                data = this.doubleDataSet;
                break;
            }
            case "SMALLINT": {
                data = this.shortDataSet;
                break;
            }
            case "INTEGER": {
                data = this.intDataSet;
                break;
            }
            case "BIGINT": {
                data = this.longDataSet;
            }
        }
        return data;
    }

    private void upsertRowsIntoSinglePkColumnTable(Object[] data, String ascTableName, String descTableName, String type) throws SQLException {
        String upsertAscTableSql = "UPSERT INTO " + ascTableName + " (PK1) VALUES (?)";
        String upsertDescTableSql = "UPSERT INTO " + descTableName + "(PK1) VALUES (?)";
        for (Object val : data) {
            this.upsertRowIntoSinglePkColumn(upsertAscTableSql, type, val);
            this.upsertRowIntoSinglePkColumn(upsertDescTableSql, type, val);
        }
    }

    private void upsertRowIntoSinglePkColumn(String sql, String type, Object val) throws SQLException {
        try (PreparedStatement pStatement = conn.prepareStatement(sql);){
            this.setPreparedStatementValue(pStatement, type, val, 1);
            pStatement.execute();
            conn.commit();
        }
    }

    private void verifySinglePkColumnResults(Object[] data, String ascTableName, String descTableName, String type) throws SQLException {
        String selectAscTableSql = "SELECT * FROM " + ascTableName + " OFFSET (PK1)=(?)";
        String selectDescTableSql = "SELECT * FROM " + descTableName + " OFFSET (PK1)=(?)";
        this.verifySinglePkColumnResults(data, selectAscTableSql, type, true);
        this.verifySinglePkColumnResults(data, selectDescTableSql, type, false);
    }

    private void verifySinglePkColumnResults(Object[] data, String sql, String type, boolean isAsc) throws SQLException {
        try (PreparedStatement pStatement = conn.prepareStatement(sql);){
            this.setPreparedStatementValue(pStatement, type, data[1], 1);
            ResultSet rs = pStatement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            this.verifyResult(data, rs, type, isAsc, 1);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void verifyResult(Object[] data, ResultSet rs, String type, boolean isAsc, int index) throws SQLException {
        switch (type) {
            case "CHAR": 
            case "VARCHAR": {
                if (isAsc) {
                    Assert.assertEquals((Object)data[2], (Object)rs.getString(index));
                    break;
                }
                Assert.assertEquals((Object)data[0], (Object)rs.getString(index));
                break;
            }
            case "TIMESTAMP": {
                if (isAsc) {
                    Assert.assertEquals((Object)data[2], (Object)rs.getTimestamp(index));
                    break;
                }
                Assert.assertEquals((Object)data[0], (Object)rs.getTimestamp(index));
                break;
            }
            case "DATE": {
                if (isAsc) {
                    Assert.assertEquals((Object)data[2], (Object)rs.getDate(index));
                    break;
                }
                Assert.assertEquals((Object)data[0], (Object)rs.getDate(index));
                break;
            }
            case "DECIMAL": {
                if (isAsc) {
                    Assert.assertEquals((Object)data[2], (Object)rs.getBigDecimal(index));
                    break;
                }
                Assert.assertEquals((Object)data[0], (Object)rs.getBigDecimal(index));
                break;
            }
            case "DOUBLE": {
                if (isAsc) {
                    Assert.assertEquals((Object)data[2], (Object)rs.getDouble(index));
                    break;
                }
                Assert.assertEquals((Object)data[0], (Object)rs.getDouble(index));
                break;
            }
            case "SMALLINT": {
                if (isAsc) {
                    Assert.assertEquals((Object)data[2], (Object)rs.getShort(index));
                    break;
                }
                Assert.assertEquals((Object)data[0], (Object)rs.getShort(index));
                break;
            }
            case "INTEGER": {
                if (isAsc) {
                    Assert.assertEquals((Object)data[2], (Object)rs.getInt(index));
                    break;
                }
                Assert.assertEquals((Object)data[0], (Object)rs.getInt(index));
                break;
            }
            case "BIGINT": {
                if (isAsc) {
                    Assert.assertEquals((Object)data[2], (Object)rs.getLong(index));
                    break;
                }
                Assert.assertEquals((Object)data[0], (Object)rs.getLong(index));
            }
        }
    }

    private void testMultiPkColumnTypes(String type1, String type2) throws SQLException {
        Object[][] data = new Object[][]{this.getData(type1), this.getData(type2)};
        String ascTableName = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String descTableName = RowValueConstructorOffsetOptionalIT.generateUniqueName();
        String ddlAsc = "CREATE TABLE " + ascTableName + " (PK1 %s NOT NULL,PK2 %s NOT NULL,CONSTRAINT PK PRIMARY KEY (PK1, PK2))";
        String ddlDesc = "CREATE TABLE " + descTableName + " (PK1 %s NOT NULL,PK2 %s NOT NULL,CONSTRAINT PK PRIMARY KEY (PK1 DESC, PK2 DESC))";
        try (Statement statement = conn.createStatement();){
            statement.execute(String.format(ddlAsc, this.getTypeString(type1), this.getTypeString(type2)));
            statement.execute(String.format(ddlDesc, this.getTypeString(type1), this.getTypeString(type2)));
        }
        this.upsertRowsToMultiPkColumnTable(data, ascTableName, descTableName, type1, type2);
        this.verifyMultiPkColumnResults(data, ascTableName, descTableName, type1, type2);
    }

    private String getTypeString(String type) {
        if (((String)type).equals("CHAR") || ((String)type).equals("VARCHAR")) {
            type = (String)type + "(3)";
        }
        return type;
    }

    private void upsertRowsToMultiPkColumnTable(Object[][] data, String ascTableName, String descTableName, String type1, String type2) throws SQLException {
        String upsertAscTableSql = "UPSERT INTO " + ascTableName + " (PK1,PK2) VALUES (?,?)";
        String upsertDescTableSql = "UPSERT INTO " + descTableName + "(PK1,PK2) VALUES (?,?)";
        for (int i = 0; i < data[0].length; ++i) {
            this.upsertRowIntoMultiPkColumn(upsertAscTableSql, type1, type2, data[0][i], data[1][i]);
            this.upsertRowIntoMultiPkColumn(upsertDescTableSql, type1, type2, data[0][i], data[1][i]);
        }
    }

    private void setPreparedStatementValue(PreparedStatement pStatement, String type, Object val, int index) throws SQLException {
        switch (type) {
            case "CHAR": 
            case "VARCHAR": {
                pStatement.setString(index, (String)val);
                break;
            }
            case "TIMESTAMP": 
            case "DATE": {
                pStatement.setDate(index, (Date)val);
                break;
            }
            case "DECIMAL": {
                pStatement.setBigDecimal(index, (BigDecimal)val);
                break;
            }
            case "DOUBLE": {
                pStatement.setDouble(index, (Double)val);
                break;
            }
            case "SMALLINT": {
                pStatement.setShort(index, (Short)val);
                break;
            }
            case "INTEGER": {
                pStatement.setInt(index, (Integer)val);
                break;
            }
            case "BIGINT": {
                pStatement.setLong(index, (Long)val);
            }
        }
    }

    private void upsertRowIntoMultiPkColumn(String sql, String type1, String type2, Object val1, Object val2) throws SQLException {
        try (PreparedStatement pStatement = conn.prepareStatement(sql);){
            this.setPreparedStatementValue(pStatement, type1, val1, 1);
            this.setPreparedStatementValue(pStatement, type2, val2, 2);
            pStatement.execute();
            conn.commit();
        }
    }

    private void verifyMultiPkColumnResults(Object[][] data, String ascTableName, String descTableName, String type1, String type2) throws SQLException {
        String selectAscTableSql = "SELECT * FROM " + ascTableName + " OFFSET (PK1,PK2)=(?,?)";
        String selectDescTableSql = "SELECT * FROM " + descTableName + " OFFSET (PK1,PK2)=(?,?)";
        this.verifyMultiPkColumnResults(data, selectAscTableSql, type1, type2, true);
        this.verifyMultiPkColumnResults(data, selectDescTableSql, type1, type2, false);
    }

    private void verifyMultiPkColumnResults(Object[][] data, String sql, String type1, String type2, boolean isAsc) throws SQLException {
        try (PreparedStatement pStatement = conn.prepareStatement(sql);){
            this.setPreparedStatementValue(pStatement, type1, data[0][1], 1);
            this.setPreparedStatementValue(pStatement, type2, data[1][1], 2);
            ResultSet rs = pStatement.executeQuery();
            if (!isAsc && data[0][0] == null) {
                Assert.assertFalse((String)String.format("Type %s and %s should not have expected row", type1, type2), (boolean)rs.next());
            } else {
                Assert.assertTrue((String)String.format("Type %s and %s should have expected row", type1, type2), (boolean)rs.next());
                this.verifyResult(data[0], rs, type1, isAsc, 1);
                this.verifyResult(data[1], rs, type2, isAsc, 2);
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

