/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class RowTimestampIT
extends ParallelStatsDisabledIT {
    private final boolean mutable;
    private final String sortOrder;
    private final String tableDDLOptions;

    public RowTimestampIT(boolean mutable, boolean ascending) {
        StringBuilder optionBuilder = new StringBuilder("UPDATE_CACHE_FREQUENCY=600000");
        this.mutable = mutable;
        String string = this.sortOrder = !ascending ? "DESC" : "";
        if (!mutable) {
            optionBuilder.append(", IMMUTABLE_ROWS=true");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="RowTimestampIT_mutable={0},ascending={1}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    @Test
    public void testUpsertingRowTimestampColSpecifiedWithTimestamp() throws Exception {
        this.upsertingRowTimestampColSpecified("TIMESTAMP");
    }

    @Test
    public void testUpsertingRowTimestampColSpecifiedWithDate() throws Exception {
        this.upsertingRowTimestampColSpecified("DATE");
    }

    private void upsertingRowTimestampColSpecified(String type) throws Exception {
        long timeStamp;
        PreparedStatement stmt;
        String tableName = RowTimestampIT.generateUniqueName();
        String indexName = RowTimestampIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(RowTimestampIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + tableName + " (PK1 VARCHAR NOT NULL, PK2 " + type + " NOT NULL, KV1 VARCHAR, KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 " + this.sortOrder + " ROW_TIMESTAMP)) " + this.tableDDLOptions);
        }
        try {
            conn = DriverManager.getConnection(RowTimestampIT.getUrl());
            try {
                conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + indexName + " ON  " + tableName + "  (PK2, KV1) INCLUDE (KV2)");
                if (this.mutable) {
                    Assert.fail((String)"Should not be able to create an index on a mutable table that has a ROW_TIMESTAMP column");
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            if (this.mutable) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_ON_MUTABLE_TABLE_WITH_ROWTIMESTAMP.getErrorCode(), (long)e.getErrorCode());
            }
            throw e;
        }
        Thread.sleep(1000L);
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        Date rowTimestampDate = new Date(rowTimestamp);
        Properties props = new Properties();
        long scn = rowTimestamp - 500L;
        try (java.sql.Connection conn = DriverManager.getConnection(RowTimestampIT.getUrl());){
            stmt = conn.prepareStatement("UPSERT INTO  " + tableName + "  (PK1, PK2, KV1, KV2) VALUES (?, ?, ?, ?)");
            stmt.setString(1, "PK1");
            stmt.setDate(2, rowTimestampDate);
            stmt.setString(3, "KV1");
            stmt.setString(4, "KV2");
            stmt.executeUpdate();
            conn.commit();
        }
        props.setProperty("CurrentSCN", Long.toString(rowTimestamp));
        conn = DriverManager.getConnection(RowTimestampIT.getUrl(), props);
        try {
            stmt = conn.prepareStatement("SELECT * FROM  " + tableName + "  WHERE PK1 = ? AND PK2 = ?");
            stmt.setString(1, "PK1");
            stmt.setDate(2, rowTimestampDate);
            ResultSet rs = stmt.executeQuery();
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(tableName));
            Assert.assertFalse((boolean)rs.next());
            if (!this.mutable) {
                stmt = conn.prepareStatement("SELECT KV1 FROM  " + tableName + "  WHERE PK2 = ?");
                stmt.setDate(1, rowTimestampDate);
                rs = stmt.executeQuery();
                plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
                Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(indexName));
                Assert.assertFalse((boolean)rs.next());
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Scan scan = new Scan();
        byte[] emptyKVQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((boolean)true).getFirst();
        Connection hbaseConn = ConnectionFactory.createConnection((Configuration)RowTimestampIT.getUtility().getConfiguration());
        Table hTable = hbaseConn.getTable(TableName.valueOf((String)tableName));
        ResultScanner resultScanner = hTable.getScanner(scan);
        for (Result result : resultScanner) {
            timeStamp = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, emptyKVQualifier).getTimestamp();
            Assert.assertEquals((long)rowTimestampDate.getTime(), (long)timeStamp);
        }
        if (!this.mutable) {
            hTable = hbaseConn.getTable(TableName.valueOf((String)indexName));
            resultScanner = hTable.getScanner(scan);
            for (Result result : resultScanner) {
                timeStamp = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, emptyKVQualifier).getTimestamp();
                Assert.assertEquals((long)rowTimestampDate.getTime(), (long)timeStamp);
            }
        }
        props.setProperty("CurrentSCN", Long.toString(rowTimestamp + 1L));
        try (java.sql.Connection conn = DriverManager.getConnection(RowTimestampIT.getUrl(), props);){
            PreparedStatement stmt2 = conn.prepareStatement("SELECT * FROM  " + tableName + "  WHERE PK1 = ? AND PK2 = ?");
            stmt2.setString(1, "PK1");
            stmt2.setDate(2, rowTimestampDate);
            ResultSet rs = stmt2.executeQuery();
            QueryPlan plan = stmt2.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(tableName));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"PK1", (Object)rs.getString("PK1"));
            Assert.assertEquals((Object)rowTimestampDate, (Object)rs.getDate("PK2"));
            Assert.assertEquals((Object)"KV1", (Object)rs.getString("KV1"));
            if (!this.mutable) {
                stmt2 = conn.prepareStatement("SELECT KV2 FROM  " + tableName + "  WHERE PK2 = ? AND KV1 = ?");
                stmt2.setDate(1, rowTimestampDate);
                stmt2.setString(2, "KV1");
                rs = stmt2.executeQuery();
                plan = stmt2.unwrap(PhoenixStatement.class).getQueryPlan();
                Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(indexName));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"KV2", (Object)rs.getString("KV2"));
            }
        }
    }

    @Test
    public void testAutomaticallySettingRowTimestampWithTimestamp() throws Exception {
        this.automaticallySettingRowTimestampForImmutableTableAndIndexes("TIMESTAMP");
    }

    @Test
    public void testAutomaticallySettingRowTimestampWithDate() throws Exception {
        this.automaticallySettingRowTimestampForImmutableTableAndIndexes("DATE");
    }

    private void automaticallySettingRowTimestampForImmutableTableAndIndexes(String type) throws Exception {
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        String tableName = RowTimestampIT.generateUniqueName();
        String indexName = RowTimestampIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(RowTimestampIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + tableName + " (PK1 VARCHAR NOT NULL, PK2 " + type + " NOT NULL, KV1 VARCHAR, KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 " + this.sortOrder + " ROW_TIMESTAMP)) " + this.tableDDLOptions);
        }
        try {
            conn = DriverManager.getConnection(RowTimestampIT.getUrl());
            try {
                conn.createStatement().execute("CREATE INDEX IF NOT EXISTS " + indexName + " ON  " + tableName + "  (PK2, KV1) INCLUDE (KV2)");
                if (this.mutable) {
                    Assert.fail((String)"Should not be able to create an index on a mutable table that has a ROW_TIMESTAMP column");
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            if (this.mutable) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_INDEX_ON_MUTABLE_TABLE_WITH_ROWTIMESTAMP.getErrorCode(), (long)e.getErrorCode());
            }
            throw e;
        }
        conn = DriverManager.getConnection(RowTimestampIT.getUrl());
        try {
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO  " + tableName + " (PK1, KV1, KV2) VALUES (?, ?, ?)");
            stmt.setString(1, "PK1");
            stmt.setString(2, "KV1");
            stmt.setString(3, "KV2");
            stmt.executeUpdate();
            conn.commit();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        long endTime = EnvironmentEdgeManager.currentTimeMillis();
        try (java.sql.Connection conn = DriverManager.getConnection(RowTimestampIT.getUrl());){
            long timeStamp;
            PreparedStatement stmt = conn.prepareStatement("SELECT KV1, KV2, PK2 FROM " + tableName + " WHERE PK1 = ? AND PK2 >= ? AND PK2 <= ? ");
            stmt.setString(1, "PK1");
            stmt.setDate(2, new Date(startTime));
            stmt.setDate(3, new Date(endTime));
            ResultSet rs = stmt.executeQuery();
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(tableName));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"KV1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"KV2", (Object)rs.getString(2));
            Date rowTimestampDate = rs.getDate(3);
            Assert.assertFalse((boolean)rs.next());
            Scan scan = new Scan();
            byte[] emptyKVQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((boolean)true).getFirst();
            Connection hbaseConn = ConnectionFactory.createConnection((Configuration)RowTimestampIT.getUtility().getConfiguration());
            Table hTable = hbaseConn.getTable(TableName.valueOf((String)tableName));
            ResultScanner resultScanner = hTable.getScanner(scan);
            for (Result result : resultScanner) {
                timeStamp = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, emptyKVQualifier).getTimestamp();
                Assert.assertEquals((long)rowTimestampDate.getTime(), (long)timeStamp);
            }
            if (!this.mutable) {
                hTable = hbaseConn.getTable(TableName.valueOf((String)indexName));
                resultScanner = hTable.getScanner(scan);
                for (Result result : resultScanner) {
                    timeStamp = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, emptyKVQualifier).getTimestamp();
                    Assert.assertEquals((long)rowTimestampDate.getTime(), (long)timeStamp);
                }
            }
            if (!this.mutable) {
                stmt = conn.prepareStatement("SELECT KV2 FROM " + tableName + " WHERE PK2 = ? AND KV1 = ?");
                stmt.setDate(1, rowTimestampDate);
                stmt.setString(2, "KV1");
                rs = stmt.executeQuery();
                plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
                Assert.assertTrue((boolean)plan.getTableRef().getTable().getName().getString().equals(indexName));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"KV2", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testComparisonOperatorsOnRowTimestampCol() throws Exception {
        String tableName = RowTimestampIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(RowTimestampIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + tableName + " (PK1 VARCHAR NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 " + this.sortOrder + " ROW_TIMESTAMP)) " + this.tableDDLOptions);
        }
        conn = DriverManager.getConnection(RowTimestampIT.getUrl());
        try {
            String upsert = "UPSERT INTO " + tableName + " VALUES (?, ?, ?)";
            PreparedStatement stmt = conn.prepareStatement(upsert);
            stmt.setString(1, "a");
            stmt.setDate(2, new Date(10L));
            stmt.setString(3, "KV");
            stmt.executeUpdate();
            stmt.setString(1, "b");
            stmt.setDate(2, new Date(20L));
            stmt.setString(3, "KV");
            stmt.executeUpdate();
            stmt.setString(1, "c");
            stmt.setDate(2, new Date(30L));
            stmt.setString(3, "KV");
            stmt.executeUpdate();
            stmt.setString(1, "d");
            stmt.setDate(2, new Date(40L));
            stmt.setString(3, "KV");
            stmt.executeUpdate();
            conn.commit();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(RowTimestampIT.getUrl());
        try {
            this.assertNumRecords(3, "SELECT count(*) from " + tableName + " WHERE PK2 > ?", conn, new Date(10L));
            this.assertNumRecords(1, "SELECT count(*) from " + tableName + " WHERE PK2 < ? AND PK2 > ?", conn, new Date(30L), new Date(10L));
            this.assertNumRecords(3, "SELECT count(*) from " + tableName + " WHERE PK2 <= ? AND PK2 >= ?", conn, new Date(30L), new Date(10L));
            this.assertNumRecords(2, "SELECT count(*) from " + tableName + " WHERE PK2 <= ? AND PK2 > ?", conn, new Date(30L), new Date(10L));
            this.assertNumRecords(2, "SELECT count(*) from " + tableName + " WHERE PK2 < ? AND PK2 >= ?", conn, new Date(30L), new Date(10L));
            this.assertNumRecords(0, "SELECT count(*) from " + tableName + " WHERE PK2 < ?", conn, new Date(10L));
            this.assertNumRecords(4, "SELECT count(*) from " + tableName, conn, new Date[0]);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private void assertNumRecords(int count, String sql, java.sql.Connection conn, Date ... params) throws Exception {
        PreparedStatement stmt = conn.prepareStatement(sql);
        int counter = 1;
        for (Date param : params) {
            stmt.setDate(counter++, param);
        }
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)count, (long)rs.getInt(1));
    }

    @Test
    public void testDisallowNegativeValuesForRowTsColumn() throws Exception {
        String tableName = RowTimestampIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(RowTimestampIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (PK1 DATE NOT NULL PRIMARY KEY " + this.sortOrder + " ROW_TIMESTAMP, KV1 VARCHAR) " + this.tableDDLOptions);
        }
        try {
            conn = DriverManager.getConnection(RowTimestampIT.getUrl());
            try {
                Date d = new Date(-100L);
                PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?) ");
                stmt.setDate(1, d);
                stmt.setString(2, "KV1");
                stmt.executeUpdate();
                Assert.fail();
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }
}

