/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.types.PInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RowKeyBytesStringFunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void getRowKeyBytesAndVerify() throws Exception {
        try (Connection conn = DriverManager.getConnection(RowKeyBytesStringFunctionIT.getUrl());){
            int[] values = new int[]{3, 7, 9, 158, 5};
            String tableName = RowKeyBytesStringFunctionIT.generateUniqueName();
            String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER NOT NULL, pkcol VARCHAR, page_id UNSIGNED_LONG, \"DATE\" BIGINT, \"value\" INTEGER, constraint pk primary key(id, pkcol)) COLUMN_ENCODED_BYTES = 0";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + tableName + " (id, pkcol, page_id, \"DATE\", \"value\") VALUES (1, 'a', 8, 1," + values[0] + ")");
            conn.createStatement().execute("UPSERT INTO " + tableName + " (id, pkcol, page_id, \"DATE\", \"value\") VALUES (2, 'ab', 8, 2," + values[1] + ")");
            conn.createStatement().execute("UPSERT INTO " + tableName + " (id, pkcol, page_id, \"DATE\", \"value\") VALUES (3, 'abc', 8, 3," + values[2] + ")");
            conn.createStatement().execute("UPSERT INTO " + tableName + " (id, pkcol, page_id, \"DATE\", \"value\") VALUES (5, 'abcde', 8, 5," + values[4] + ")");
            conn.createStatement().execute("UPSERT INTO " + tableName + " (id, pkcol, page_id, \"DATE\", \"value\") VALUES (4, 'abcd', 8, 4," + values[3] + ")");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT ROWKEY_BYTES_STRING() FROM " + tableName);
            try (org.apache.hadoop.hbase.client.Connection hconn = ConnectionFactory.createConnection((Configuration)config);){
                Table table = hconn.getTable(TableName.valueOf((String)tableName));
                int i = 0;
                while (rs.next()) {
                    String s = rs.getString(1);
                    Get get = new Get(Bytes.toBytesBinary((String)s));
                    Result hbaseRes = table.get(get);
                    Assert.assertFalse((boolean)hbaseRes.isEmpty());
                    Assert.assertTrue((boolean)Bytes.equals((byte[])hbaseRes.getValue(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"value")), (byte[])PInteger.INSTANCE.toBytes((Object)values[i])));
                    ++i;
                }
            }
        }
    }
}

