/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Doubles;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Floats;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RoundFloorCeilFuncIT
extends ParallelStatsDisabledIT {
    private static final long millisPart = 660L;
    private static final int nanosPart = 500100;
    private static final BigDecimal decimalUpserted = BigDecimal.valueOf(1.264);
    private static final double doubleUpserted = 1.264;
    private static final double unsignedDoubleUpserted = 1.264;
    private static final float floatUpserted = 1.264f;
    private static final float unsignedFloatUpserted = 1.264f;
    private String tableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        this.tableName = RoundFloorCeilFuncIT.generateUniqueName();
        String testString = "abc";
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
            String ddl = "CREATE TABLE IF NOT EXISTS " + this.tableName + " (s VARCHAR NOT NULL PRIMARY KEY, dt DATE, t TIME, ts TIMESTAMP, \"DEC\" DECIMAL, doub DOUBLE, undoub UNSIGNED_DOUBLE, fl FLOAT, unfl UNSIGNED_FLOAT)";
            conn.createStatement().execute(ddl);
            Date dateUpserted = DateUtil.parseDate((String)"2012-01-01 14:25:28");
            dateUpserted = new Date(dateUpserted.getTime() + 660L);
            long millis = dateUpserted.getTime();
            Time timeUpserted = new Time(millis);
            Timestamp tsUpserted = DateUtil.getTimestamp((long)millis, (int)500100);
            stmt = conn.prepareStatement("UPSERT INTO " + this.tableName + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            stmt.setString(1, testString);
            stmt.setDate(2, dateUpserted);
            stmt.setTime(3, timeUpserted);
            stmt.setTimestamp(4, tsUpserted);
            stmt.setBigDecimal(5, decimalUpserted);
            stmt.setDouble(6, 1.264);
            stmt.setDouble(7, 1.264);
            stmt.setFloat(8, 1.264f);
            stmt.setFloat(9, 1.264f);
            stmt.executeUpdate();
            conn.commit();
        }
        catch (Throwable throwable) {
            TestUtil.closeStmtAndConn(stmt, conn);
            throw throwable;
        }
        TestUtil.closeStmtAndConn(stmt, conn);
    }

    @Test
    public void testRoundingUpDate() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(dt, 'day'), ROUND(dt, 'hour', 1), ROUND(dt, 'minute', 1), ROUND(dt, 'second', 1),  ROUND(dt,'week'), ROUND(dt,'month') , ROUND(dt,'year') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Date expectedDate = DateUtil.parseDate((String)"2012-01-02 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(1));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 14:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(2));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 14:25:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(3));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 14:25:29");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(4));
        expectedDate = DateUtil.parseDate((String)"2012-01-02 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(5));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(6));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(7));
    }

    @Test
    public void testRoundingUpDateInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE ROUND(dt, 'day') = to_date('2012-01-02 00:00:00')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testFloorDate() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT FLOOR(dt, 'day', 1), FLOOR(dt, 'hour', 1), FLOOR(dt, 'minute', 1), FLOOR(dt, 'second', 1), FLOOR(dt,'week'), FLOOR(dt,'month'), FLOOR(dt,'year') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Date expectedDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(1));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 14:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(2));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 14:25:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(3));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 14:25:28");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(4));
        expectedDate = DateUtil.parseDate((String)"2011-12-26 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(5));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(6));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(7));
    }

    @Test
    public void testFloorDateInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE FLOOR(dt, 'hour') = to_date('2012-01-01 14:00:00')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testCeilDate() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT CEIL(dt, 'day', 1), CEIL(dt, 'hour', 1), CEIL(dt, 'minute', 1), CEIL(dt, 'second', 1),  CEIL(dt,'week') , CEIL(dt,'month') , CEIL(dt,'year')  FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Date expectedDate = DateUtil.parseDate((String)"2012-01-02 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(1));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 15:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(2));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 14:26:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(3));
        expectedDate = DateUtil.parseDate((String)"2012-01-01 14:25:29");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(4));
        expectedDate = DateUtil.parseDate((String)"2012-01-02 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(5));
        expectedDate = DateUtil.parseDate((String)"2012-02-01 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(6));
        expectedDate = DateUtil.parseDate((String)"2013-01-01 00:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)rs.getDate(7));
    }

    @Test
    public void testCeilDateInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE CEIL(dt, 'second') = to_date('2012-01-01 14:25:29')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testRoundingUpTimestamp() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(ts, 'day'), ROUND(ts, 'hour', 1), ROUND(ts, 'minute', 1), ROUND(ts, 'second', 1), ROUND(ts, 'millisecond', 1) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Timestamp expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-02 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(1));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(2));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:25:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(3));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:25:29").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(4));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:25:28").getTime() + 660L + 1L);
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(5));
    }

    @Test
    public void testRoundingUpTimestampInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE ROUND(ts, 'second') = to_date('2012-01-01 14:25:29')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testFloorTimestamp() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT FLOOR(ts, 'day'), FLOOR(ts, 'hour', 1), FLOOR(ts, 'minute', 1), FLOOR(ts, 'second', 1),  FLOOR(ts, 'millisecond', 1) , FLOOR(ts,'week') , FLOOR(ts,'month') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Timestamp expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(1));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(2));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:25:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(3));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:25:28").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(4));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:25:28").getTime() + 660L);
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(5));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2011-12-26 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(6));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(7));
    }

    @Test
    public void testFloorTimestampInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE FLOOR(ts, 'second') = to_date('2012-01-01 14:25:28')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testWeekFloorTimestampInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE FLOOR(ts, 'week') = to_date('2011-12-26 00:00:00')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testCeilTimestamp() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT CEIL(ts, 'day'), CEIL(ts, 'hour', 1), CEIL(ts, 'minute', 1), CEIL(ts, 'second', 1), CEIL(ts, 'millisecond', 1), CEIL(ts,'week'), CEIL(ts,'month') , CEIL(ts,'year') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Timestamp expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-02 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(1));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 15:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(2));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:26:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(3));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:25:29").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(4));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-01 14:25:28").getTime() + 660L + 1L);
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(5));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-01-02 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(6));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2012-02-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(7));
        expectedTimestamp = new Timestamp(DateUtil.parseDate((String)"2013-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp(8));
    }

    @Test
    public void testCeilTimestampInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE CEIL(ts, 'second') = to_date('2012-01-01 14:25:29')");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testRoundingUpTime() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(t, 'day', 1), ROUND(t, 'hour', 1), ROUND(t, 'minute', 1), ROUND(t, 'second', 1), ROUND(t,'week') , ROUND(t,'month') , ROUND(t,'year') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Time expectedTime = new Time(DateUtil.parseDate((String)"2012-01-02 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(1));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 14:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(2));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 14:25:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(3));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 14:25:29").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(4));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-02 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(5));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(6));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(7));
    }

    @Test
    public void testFloorTime() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT FLOOR(t, 'day', 1), FLOOR(t, 'hour', 1), FLOOR(t, 'minute', 1), FLOOR(t, 'second', 1),  FLOOR(t, 'week'),  FLOOR(t, 'month'), FLOOR(t, 'year') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Time expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(1));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 14:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(2));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 14:25:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(3));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 14:25:28").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(4));
        expectedTime = new Time(DateUtil.parseDate((String)"2011-12-26 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(5));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(6));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(7));
    }

    @Test
    public void testCeilTime() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT CEIL(t, 'day', 1), CEIL(t, 'hour', 1), CEIL(t, 'minute', 1), CEIL(t, 'second', 1), CEIL(t,'week') , CEIL(t,'month') , CEIL(t,'year') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Time expectedTime = new Time(DateUtil.parseDate((String)"2012-01-02 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(1));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 15:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(2));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 14:26:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(3));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-01 14:25:29").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(4));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-01-02 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(5));
        expectedTime = new Time(DateUtil.parseDate((String)"2012-02-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(6));
        expectedTime = new Time(DateUtil.parseDate((String)"2013-01-01 00:00:00").getTime());
        Assert.assertEquals((Object)expectedTime, (Object)rs.getTime(7));
    }

    @Test
    public void testRoundingUpDecimal() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(\"DEC\"), ROUND(\"DEC\", 1), ROUND(\"DEC\", 2), ROUND(\"DEC\", 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        BigDecimal expectedBd = BigDecimal.valueOf(1L);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(1));
        expectedBd = BigDecimal.valueOf(1.3);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(2));
        expectedBd = BigDecimal.valueOf(1.26);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(3));
        expectedBd = BigDecimal.valueOf(1.264);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(4));
    }

    @Test
    public void testRoundingUpDecimalInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE ROUND(\"DEC\", 2) = 1.26");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testFloorDecimal() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT FLOOR(\"DEC\"), FLOOR(\"DEC\", 1), FLOOR(\"DEC\", 2), FLOOR(\"DEC\", 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        BigDecimal expectedBd = BigDecimal.valueOf(1L);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(1));
        expectedBd = BigDecimal.valueOf(1.2);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(2));
        expectedBd = BigDecimal.valueOf(1.26);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(3));
        expectedBd = BigDecimal.valueOf(1.264);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(4));
    }

    @Test
    public void testFloorDecimalInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE FLOOR(\"DEC\", 2) = 1.26");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testCeilDecimal() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT CEIL(\"DEC\"), CEIL(\"DEC\", 1), CEIL(\"DEC\", 2), CEIL(\"DEC\", 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        BigDecimal expectedBd = BigDecimal.valueOf(2L);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(1));
        expectedBd = BigDecimal.valueOf(1.3);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(2));
        expectedBd = BigDecimal.valueOf(1.27);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(3));
        expectedBd = BigDecimal.valueOf(1.264);
        Assert.assertEquals((Object)expectedBd, (Object)rs.getBigDecimal(4));
    }

    @Test
    public void testCeilDecimalInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE CEIL(\"DEC\", 2) = 1.27");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testRoundingUpDouble() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(doub), ROUND(doub, 1), ROUND(doub, 2), ROUND(doub, 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.0, (double)rs.getDouble(1)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.3, (double)rs.getDouble(2)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.26, (double)rs.getDouble(3)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.264, (double)rs.getDouble(4)));
    }

    @Test
    public void testRoundingUpDoubleInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE ROUND(\"DEC\", 2) = 1.26");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testCeilDouble() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT CEIL(doub), CEIL(doub, 1), CEIL(doub, 2), CEIL(doub, 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)2.0, (double)rs.getDouble(1)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.3, (double)rs.getDouble(2)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.27, (double)rs.getDouble(3)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.264, (double)rs.getDouble(4)));
    }

    @Test
    public void testCeilDoubleInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE CEIL(doub, 2) = 1.27");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testFloorDouble() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT FLOOR(doub), FLOOR(doub, 1), FLOOR(doub, 2), FLOOR(doub, 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.0, (double)rs.getDouble(1)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.2, (double)rs.getDouble(2)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.26, (double)rs.getDouble(3)));
        Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.264, (double)rs.getDouble(4)));
    }

    @Test
    public void testFloorDoubleInWhere() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.tableName + " WHERE FLOOR(doub, 2) = 1.26");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testRoundFloat() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(fl), ROUND(fl, 1), ROUND(fl, 2), ROUND(fl, 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.0f, (float)rs.getFloat(1)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.3f, (float)rs.getFloat(2)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.26f, (float)rs.getFloat(3)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.264f, (float)rs.getFloat(4)));
    }

    @Test
    public void testRoundUnsignedFloat() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(unfl), ROUND(unfl, 1), ROUND(unfl, 2), ROUND(unfl, 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.0f, (float)rs.getFloat(1)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.3f, (float)rs.getFloat(2)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.26f, (float)rs.getFloat(3)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.264f, (float)rs.getFloat(4)));
    }

    @Test
    public void testRoundUnsignedDouble() throws Exception {
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("SELECT ROUND(undoub), ROUND(undoub, 1), ROUND(undoub, 2), ROUND(undoub, 3) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.0f, (float)rs.getFloat(1)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.3f, (float)rs.getFloat(2)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.26f, (float)rs.getFloat(3)));
        Assert.assertEquals((long)0L, (long)Floats.compare((float)1.264f, (float)rs.getFloat(4)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestampAggregateFunctions() throws Exception {
        String dateString = "2015-03-08 09:09:11.665";
        Properties props = new Properties();
        props.setProperty("phoenix.query.dateFormatTimeZone", "GMT+1");
        try (Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl(), props);){
            conn.prepareStatement("create table TIME_AGG_TABLE(ID unsigned_int NOT NULL, THE_DATE TIMESTAMP, constraint PK primary key (ID))").execute();
            PreparedStatement stmt = conn.prepareStatement("upsert into TIME_AGG_TABLE(    ID,     THE_DATE)VALUES (?, ?)");
            stmt.setInt(1, 1);
            stmt.setTimestamp(2, DateUtil.parseTimestamp((String)dateString));
            stmt.execute();
            conn.commit();
            ResultSet rs = conn.prepareStatement("SELECT THE_DATE ,TRUNC(THE_DATE,'DAY') AS day_from_dt ,TRUNC(THE_DATE,'HOUR') AS hour_from_dt ,TRUNC(THE_DATE,'MINUTE') AS min_from_dt ,TRUNC(THE_DATE,'SECOND') AS sec_from_dt ,TRUNC(THE_DATE,'MILLISECOND') AS mil_from_dt FROM TIME_AGG_TABLE").executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.665"), (Object)rs.getTimestamp("THE_DATE"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 00:00:00.0"), (Object)rs.getTimestamp("day_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:00:00.0"), (Object)rs.getTimestamp("hour_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:00.0"), (Object)rs.getTimestamp("min_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.0"), (Object)rs.getTimestamp("sec_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.665"), (Object)rs.getTimestamp("mil_from_dt"));
            rs.close();
            rs = conn.prepareStatement("SELECT THE_DATE ,ROUND(THE_DATE,'DAY') AS day_from_dt ,ROUND(THE_DATE,'HOUR') AS hour_from_dt ,ROUND(THE_DATE,'MINUTE') AS min_from_dt ,ROUND(THE_DATE,'SECOND') AS sec_from_dt ,ROUND(THE_DATE,'MILLISECOND') AS mil_from_dt FROM TIME_AGG_TABLE").executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.665"), (Object)rs.getTimestamp("THE_DATE"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 00:00:00.0"), (Object)rs.getTimestamp("day_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:00:00.0"), (Object)rs.getTimestamp("hour_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:00.0"), (Object)rs.getTimestamp("min_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:12.0"), (Object)rs.getTimestamp("sec_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.665"), (Object)rs.getTimestamp("mil_from_dt"));
            rs.close();
            rs = conn.prepareStatement("SELECT THE_DATE ,FLOOR(THE_DATE,'DAY') AS day_from_dt ,FLOOR(THE_DATE,'HOUR') AS hour_from_dt ,FLOOR(THE_DATE,'MINUTE') AS min_from_dt ,FLOOR(THE_DATE,'SECOND') AS sec_from_dt ,FLOOR(THE_DATE,'MILLISECOND') AS mil_from_dt FROM TIME_AGG_TABLE").executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.665"), (Object)rs.getTimestamp("THE_DATE"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 00:00:00.0"), (Object)rs.getTimestamp("day_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:00:00.0"), (Object)rs.getTimestamp("hour_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:00.0"), (Object)rs.getTimestamp("min_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.0"), (Object)rs.getTimestamp("sec_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.665"), (Object)rs.getTimestamp("mil_from_dt"));
            rs.close();
            rs = conn.prepareStatement("SELECT THE_DATE ,CEIL(THE_DATE,'DAY') AS day_from_dt ,CEIL(THE_DATE,'HOUR') AS hour_from_dt ,CEIL(THE_DATE,'MINUTE') AS min_from_dt ,CEIL(THE_DATE,'SECOND') AS sec_from_dt ,CEIL(THE_DATE,'MILLISECOND') AS mil_from_dt FROM TIME_AGG_TABLE").executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.665"), (Object)rs.getTimestamp("THE_DATE"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-09 00:00:00.0"), (Object)rs.getTimestamp("day_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 10:00:00.0"), (Object)rs.getTimestamp("hour_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:10:00.0"), (Object)rs.getTimestamp("min_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:12.0"), (Object)rs.getTimestamp("sec_from_dt"));
            Assert.assertEquals((Object)DateUtil.parseTimestamp((String)"2015-03-08 09:09:11.665"), (Object)rs.getTimestamp("mil_from_dt"));
            rs.close();
        }
    }

    @Test
    public void testRoundOffFunction() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl(), props);
        String uniquetableName = RoundFloorCeilFuncIT.generateUniqueName();
        String ddl = "create table " + uniquetableName + "(k bigint primary key)";
        conn.createStatement().execute(ddl);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + uniquetableName + " values(1380603308885)");
        stmt.execute();
        conn.commit();
        stmt = conn.prepareStatement("select round(k/1000000,0) from " + uniquetableName);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1380603L, (long)rs.getLong(1));
        stmt = conn.prepareStatement("select round(k/1000000,0) x from " + uniquetableName + " group by x");
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1380603L, (long)rs.getLong(1));
    }

    @Test
    public void testRoundFunctionsRowKey() throws SQLException {
        LocalDateTime LD_PAST = LocalDateTime.of(2000, 6, 6, 12, 0, 30, 0);
        Instant INSTANT_LD_PAST = LD_PAST.toInstant(ZoneOffset.UTC);
        LocalDateTime LD_FUTURE = LocalDateTime.of(2040, 6, 6, 12, 0, 30, 0);
        Instant INSTANT_LD_FUTURE = LD_FUTURE.toInstant(ZoneOffset.UTC);
        LocalDateTime LD_MID_MIN = LocalDateTime.of(2022, 6, 6, 12, 0, 30, 0);
        Instant INSTANT_MID_MIN = LD_MID_MIN.toInstant(ZoneOffset.UTC);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            String tableName = RoundFloorCeilFuncIT.generateUniqueName();
            stmt.executeUpdate("CREATE TABLE " + tableName + " (  df DATE primary key, dfv DATE) ");
            PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?)");
            ps.setTimestamp(1, Timestamp.from(INSTANT_LD_PAST));
            ps.setTimestamp(2, Timestamp.from(INSTANT_LD_PAST));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN.minusMillis(1L)));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN.minusMillis(1L)));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN.plusMillis(1L)));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN.plusMillis(1L)));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_LD_FUTURE));
            ps.setTimestamp(2, Timestamp.from(INSTANT_LD_FUTURE));
            ps.executeUpdate();
            conn.commit();
            ResultSet rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(df, 'MINUTE', 1) = DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(df, 'MINUTE', 1) = DATE '2022-06-06 12:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(df, 'MINUTE', 1) > DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(df, 'MINUTE', 1) >= DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(df, 'MINUTE', 1) < DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(df, 'MINUTE', 1) <= DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(df, 'MINUTE', 1) <= DATE '2022-06-06 12:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(dfv, 'MINUTE', 1) = DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(dfv, 'MINUTE', 1) = DATE '2022-06-06 12:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(dfv, 'MINUTE', 1) > DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(dfv, 'MINUTE', 1) >= DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(dfv, 'MINUTE', 1) < DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(dfv, 'MINUTE', 1) <= DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where round(dfv, 'MINUTE', 1) <= DATE '2022-06-06 12:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testFloorFunctionsRowKey() throws SQLException {
        LocalDateTime LD_PAST = LocalDateTime.of(2000, 6, 6, 12, 1, 0, 0);
        Instant INSTANT_LD_PAST = LD_PAST.toInstant(ZoneOffset.UTC);
        LocalDateTime LD_FUTURE = LocalDateTime.of(2040, 6, 6, 12, 1, 0, 0);
        Instant INSTANT_LD_FUTURE = LD_FUTURE.toInstant(ZoneOffset.UTC);
        LocalDateTime LD_MID_MIN = LocalDateTime.of(2022, 6, 6, 12, 1, 0, 0);
        Instant INSTANT_MID_MIN = LD_MID_MIN.toInstant(ZoneOffset.UTC);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            String tableName = RoundFloorCeilFuncIT.generateUniqueName();
            stmt.executeUpdate("CREATE TABLE " + tableName + " (  df DATE primary key, dfv DATE) ");
            PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?)");
            ps.setTimestamp(1, Timestamp.from(INSTANT_LD_PAST));
            ps.setTimestamp(2, Timestamp.from(INSTANT_LD_PAST));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN.minusMillis(1L)));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN.minusMillis(1L)));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN.plusMillis(1L)));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN.plusMillis(1L)));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_LD_FUTURE));
            ps.setTimestamp(2, Timestamp.from(INSTANT_LD_FUTURE));
            ps.executeUpdate();
            conn.commit();
            ResultSet rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(df, 'MINUTE', 1) = DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(df, 'MINUTE', 1) = DATE '2022-06-06 12:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(df, 'MINUTE', 1) > DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(df, 'MINUTE', 1) >= DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(df, 'MINUTE', 1) < DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(df, 'MINUTE', 1) <= DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(df, 'MINUTE', 1) <= DATE '2022-06-06 12:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(dfv, 'MINUTE', 1) = DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(dfv, 'MINUTE', 1) = DATE '2022-06-06 12:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(dfv, 'MINUTE', 1) > DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(dfv, 'MINUTE', 1) >= DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(dfv, 'MINUTE', 1) < DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(dfv, 'MINUTE', 1) <= DATE '2022-06-06 12:01:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where floor(dfv, 'MINUTE', 1) <= DATE '2022-06-06 12:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testCeilFunctionsRowKey() throws SQLException {
        LocalDateTime LD_PAST = LocalDateTime.of(2000, 6, 6, 12, 1, 0, 0);
        Instant INSTANT_LD_PAST = LD_PAST.toInstant(ZoneOffset.UTC);
        LocalDateTime LD_FUTURE = LocalDateTime.of(2040, 6, 6, 12, 0, 0, 0);
        Instant INSTANT_LD_FUTURE = LD_FUTURE.toInstant(ZoneOffset.UTC);
        LocalDateTime LD_MID_MIN = LocalDateTime.of(2022, 6, 1, 0, 0, 0, 0);
        Instant INSTANT_MID_MIN = LD_MID_MIN.toInstant(ZoneOffset.UTC);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(RoundFloorCeilFuncIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            String tableName = RoundFloorCeilFuncIT.generateUniqueName();
            stmt.executeUpdate("CREATE TABLE " + tableName + " (  df DATE primary key, dfv DATE) ");
            PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?)");
            ps.setTimestamp(1, Timestamp.from(INSTANT_LD_PAST));
            ps.setTimestamp(2, Timestamp.from(INSTANT_LD_PAST));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN.minusMillis(1L)));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN.minusMillis(1L)));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_MID_MIN.plusMillis(1L)));
            ps.setTimestamp(2, Timestamp.from(INSTANT_MID_MIN.plusMillis(1L)));
            ps.executeUpdate();
            ps.setTimestamp(1, Timestamp.from(INSTANT_LD_FUTURE));
            ps.setTimestamp(2, Timestamp.from(INSTANT_LD_FUTURE));
            ps.executeUpdate();
            conn.commit();
            ResultSet rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(df, 'MONTH', 1) = DATE '2022-06-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(df, 'MONTH', 1) = DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(df, 'MONTH', 1) > DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(df, 'MONTH', 1) >= DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(df, 'MONTH', 1) < DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(df, 'MONTH', 1) <= DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(df, 'MONTH', 1) <= DATE '2022-06-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(dfv, 'MONTH', 1) = DATE '2022-06-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(dfv, 'MONTH', 1) = DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(dfv, 'MONTH', 1) > DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(dfv, 'MONTH', 1) >= DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(dfv, 'MONTH', 1) < DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(dfv, 'MONTH', 1) <= DATE '2022-07-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = stmt.executeQuery("select count(*)  from " + tableName + " where ceil(dfv, 'MONTH', 1) <= DATE '2022-06-01 00:00:00'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
        }
    }
}

