/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ReverseScanIT
extends ParallelStatsDisabledIT {
    private static byte[][] getSplitsAtRowKeys(String tenantId) {
        return new byte[][]{Bytes.toBytes((String)(tenantId + "00A323122312312")), Bytes.toBytes((String)(tenantId + "00B723122312312")), Bytes.toBytes((String)(tenantId + "00C923122312312"))};
    }

    @Test
    public void testReverseRangeScan() throws Exception {
        String tenantId = ReverseScanIT.getOrganizationId();
        String tableName = ReverseScanIT.initATableValues(tenantId, ReverseScanIT.getSplitsAtRowKeys(tenantId), ReverseScanIT.getUrl());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ReverseScanIT.getUrl(), props);){
            String query = "SELECT entity_id FROM " + tableName + " WHERE entity_id >= '00A323122312312' ORDER BY organization_id DESC, entity_id DESC";
            Statement stmt = conn.createStatement();
            stmt.setFetchSize(2);
            ResultSet rs = stmt.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B523122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A423122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"REVERSE", (Object)explainPlanAttributes.getClientSortedBy());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)tableName, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY AND ENTITY_ID >= '00A323122312312'", (Object)explainPlanAttributes.getServerWhereFilter());
            PreparedStatement statement = conn.prepareStatement("SELECT entity_id FROM " + tableName + " WHERE organization_id = ? AND entity_id >= ? ORDER BY organization_id DESC, entity_id DESC");
            statement.setString(1, tenantId);
            statement.setString(2, "00B723122312312");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReverseSkipScan() throws Exception {
        String tenantId = ReverseScanIT.getOrganizationId();
        String tableName = ReverseScanIT.initATableValues(tenantId, ReverseScanIT.getSplitsAtRowKeys(tenantId), ReverseScanIT.getUrl());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String query = "SELECT entity_id FROM " + tableName + " WHERE organization_id = ? AND entity_id IN (?,?,?,?,?) ORDER BY organization_id DESC, entity_id DESC";
        try (Connection conn = DriverManager.getConnection(ReverseScanIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, "00A223122312312");
            statement.setString(3, "00A323122312312");
            statement.setString(4, "00B723122312312");
            statement.setString(5, "00C923122312312");
            statement.setString(6, "00BOGUSROW00000");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testReverseScanForSpecificRangeInRegion() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(ReverseScanIT.getUrl(), props);
        String tableName = ReverseScanIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + " ( k VARCHAR, c1.a bigint,c2.b bigint CONSTRAINT pk PRIMARY KEY (k)) ");
        conn.createStatement().execute("upsert into " + tableName + " values ('a',1,3)");
        conn.createStatement().execute("upsert into " + tableName + " values ('b',1,3)");
        conn.createStatement().execute("upsert into " + tableName + " values ('c',1,3)");
        conn.createStatement().execute("upsert into " + tableName + " values ('d',1,3)");
        conn.createStatement().execute("upsert into " + tableName + " values ('e',1,3)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k FROM " + tableName + " where k>'b' and k<'d' order by k desc");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"c", (Object)rs.getString(1));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        conn.close();
    }

    @Test
    public void testReverseScanIndex() throws Exception {
        String indexName = ReverseScanIT.generateUniqueName();
        String tenantId = ReverseScanIT.getOrganizationId();
        String tableName = ReverseScanIT.initATableValues(tenantId, ReverseScanIT.getSplitsAtRowKeys(tenantId), ReverseScanIT.getUrl());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ReverseScanIT.getUrl(), props);){
            String ddl = "CREATE INDEX " + indexName + " ON " + tableName + " (a_integer DESC) INCLUDE (    A_STRING,     B_STRING,     A_DATE)";
            conn.createStatement().execute(ddl);
            String query = "SELECT a_integer FROM " + tableName + " where a_integer is not null order by a_integer nulls last limit 1";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"SERIAL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"REVERSE", (Object)explainPlanAttributes.getClientSortedBy());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)indexName, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [not null]", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((long)1L, (long)explainPlanAttributes.getServerRowLimit().intValue());
            Assert.assertEquals((long)1L, (long)explainPlanAttributes.getClientRowLimit().intValue());
        }
    }
}

