/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RegexpSplitFunctionIT
extends ParallelStatsDisabledIT {
    private String tableName;

    private void initTable(Connection conn, String val) throws SQLException {
        this.initTable(conn, val, ",");
    }

    private void initTable(Connection conn, String val, String separator) throws SQLException {
        this.tableName = RegexpSplitFunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE " + this.tableName + " (ID INTEGER NOT NULL PRIMARY KEY,VAL VARCHAR,SEP VARCHAR,ARR VARCHAR ARRAY)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + this.tableName + " (ID, SEP, VAL) VALUES (?, ?, ?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.setInt(1, 1);
        if (separator == null) {
            stmt.setNull(2, 12);
        } else {
            stmt.setString(2, separator);
        }
        if (val == null) {
            stmt.setNull(3, 12);
        } else {
            stmt.setString(3, val);
        }
        stmt.execute();
        conn.commit();
    }

    @Test
    public void testSplit_ArrayReference() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE,TWO,THREE");
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, ',')[1] FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"ONE", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testArrayLenWithRegExpSplit() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        Object val = "T";
        for (int i = 1; i < 33267; ++i) {
            val = (String)val + ",T";
        }
        this.initTable(conn, (String)val);
        ResultSet rs = conn.createStatement().executeQuery("SELECT array_length(REGEXP_SPLIT(VAL, ',')) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)33267L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSplit_InFilter() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE,TWO,THREE");
        ResultSet rs = conn.createStatement().executeQuery("SELECT ID FROM " + this.tableName + " WHERE (REGEXP_SPLIT(VAL, ','))[1] = 'ONE'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSplit_Upsert() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE,TWO,THREE");
        conn.createStatement().executeUpdate("UPSERT INTO " + this.tableName + " (ID, ARR) SELECT ID, REGEXP_SPLIT(VAL, ',') FROM " + this.tableName);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT ARR FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Array array = rs.getArray(1);
        Object[] values = (String[])array.getArray();
        Assert.assertArrayEquals((Object[])new String[]{"ONE", "TWO", "THREE"}, (Object[])values);
    }

    @Test
    public void testSplit_AlternateSeparator() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE:TWO:THREE");
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, ':') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Array array = rs.getArray(1);
        Object[] values = (String[])array.getArray();
        Assert.assertArrayEquals((Object[])new String[]{"ONE", "TWO", "THREE"}, (Object[])values);
    }

    @Test
    public void testSplit_DynamicPattern() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE,TWO,THREE");
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, SEP) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Array array = rs.getArray(1);
        Object[] values = (String[])array.getArray();
        Assert.assertArrayEquals((Object[])new String[]{"ONE", "TWO", "THREE"}, (Object[])values);
    }

    @Test
    public void testSplit_NoSplitString() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "CANNOT BE SPLIT");
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, ',') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Array array = rs.getArray(1);
        Object[] values = (String[])array.getArray();
        Assert.assertArrayEquals((Object[])new String[]{"CANNOT BE SPLIT"}, (Object[])values);
    }

    @Test
    public void testSplit_PatternBasedSplit() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE!:TWO:::!THREE::!:FOUR");
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, '[:!]+') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Array array = rs.getArray(1);
        Object[] values = (String[])array.getArray();
        Assert.assertArrayEquals((Object[])new String[]{"ONE", "TWO", "THREE", "FOUR"}, (Object[])values);
    }

    @Test
    public void testSplit_PatternEscape() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE|TWO|THREE");
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, '\\\\|') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Array array = rs.getArray(1);
        Object[] values = (String[])array.getArray();
        Assert.assertArrayEquals((Object[])new String[]{"ONE", "TWO", "THREE"}, (Object[])values);
    }

    @Test
    public void testSplit_NullString() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, null);
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, ',') FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSplit_NullSeparator() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE,TWO,THREE");
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, NULL) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSplit_NullDynamicSeparator() throws SQLException {
        Connection conn = DriverManager.getConnection(RegexpSplitFunctionIT.getUrl());
        this.initTable(conn, "ONE,TWO,THREE", null);
        ResultSet rs = conn.createStatement().executeQuery("SELECT REGEXP_SPLIT(VAL, SEP) FROM " + this.tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNull((Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

