/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class RegexpReplaceFunctionIT
extends ParallelStatsDisabledIT {
    private int id;
    protected String tableName;

    @Before
    public void doBeforeTestSetup() throws Exception {
        this.tableName = RegexpReplaceFunctionIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(RegexpReplaceFunctionIT.getUrl());
        TestUtil.createGroupByTestTable(conn, this.tableName);
        this.insertRow(conn, "Report11", 10);
        this.insertRow(conn, "Report11", 10);
        this.insertRow(conn, "Report22", 30);
        this.insertRow(conn, "Report33", 30);
        conn.commit();
        conn.close();
    }

    private void insertRow(Connection conn, String uri, int appcpu) throws SQLException {
        PreparedStatement statement = conn.prepareStatement("UPSERT INTO " + this.tableName + "(id, uri, appcpu) values (?,?,?)");
        statement.setString(1, "id" + this.id);
        statement.setString(2, uri);
        statement.setInt(3, appcpu);
        statement.executeUpdate();
        ++this.id;
    }

    @Test
    public void testGroupByScanWithRegexpReplace() throws Exception {
        Connection conn = DriverManager.getConnection(RegexpReplaceFunctionIT.getUrl());
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select REGEXP_REPLACE(uri, '[1-3]+', '*') suburi, sum(appcpu) sumcpu from " + this.tableName + " group by suburi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("suburi"), (Object)"Report*");
        Assert.assertEquals((long)rs.getInt("sumcpu"), (long)80L);
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.createStatement();
        rs = stmt.executeQuery("select REGEXP_REPLACE(uri, '[1-3]+') suburi, sum(appcpu) sumcpu from " + this.tableName + " group by suburi");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)rs.getString("suburi"), (Object)"Report");
        Assert.assertEquals((long)rs.getInt("sumcpu"), (long)80L);
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testFilterWithRegexReplace() throws Exception {
        Connection conn = DriverManager.getConnection(RegexpReplaceFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery("select id from " + this.tableName + " where REGEXP_REPLACE(uri, '[2-3]+', '*') = 'Report*'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"id2", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"id3", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select id from " + this.tableName + " where REGEXP_REPLACE(uri, '[2-3]+') = 'Report'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"id2", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"id3", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }
}

