/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class RebuildIndexConnectionPropsIT
extends BaseTest {
    private static HBaseTestingUtility hbaseTestUtil;
    private static String zkQuorum;
    private static String url;
    private static int NUM_RPC_RETRIES;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        hbaseTestUtil = new HBaseTestingUtility(conf);
        HashMap<String, String> serverProps = new HashMap<String, String>();
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.index.rebuild.rpc.retries.counter", Long.toString(NUM_RPC_RETRIES));
        RebuildIndexConnectionPropsIT.setUpConfigForMiniCluster(conf, new ReadOnlyProps(serverProps.entrySet().iterator()));
        hbaseTestUtil.startMiniCluster();
        zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix+zk:" + zkQuorum;
        Properties driverProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        PhoenixConnection phxConn = DriverManager.getConnection(url, driverProps).unwrap(PhoenixConnection.class);
        if (phxConn != null) {
            phxConn.close();
        }
    }

    @Test
    public void testRebuildIndexConnectionProperties() throws Exception {
        try (PhoenixConnection rebuildIndexConnection = MetaDataRegionObserver.getRebuildIndexConnection((Configuration)hbaseTestUtil.getMiniHBaseCluster().getConfiguration());
             PhoenixConnection regularConnection = DriverManager.getConnection(url).unwrap(PhoenixConnection.class);){
            String rebuildUrl = rebuildIndexConnection.getURL();
            Assert.assertFalse((boolean)PhoenixEmbeddedDriver.isTestUrl((String)url));
            Assert.assertFalse((boolean)PhoenixEmbeddedDriver.isTestUrl((String)rebuildUrl));
            Assert.assertTrue((boolean)rebuildUrl.contains("REBUILDINDEX"));
            Assert.assertFalse((boolean)rebuildUrl.equals(regularConnection.getURL()));
            Configuration rebuildQueryServicesConfig = rebuildIndexConnection.getQueryServices().getConfiguration();
            Assert.assertEquals((Object)Long.toString(9002100L), (Object)rebuildQueryServicesConfig.get("phoenix.query.timeoutMs"));
            Assert.assertEquals((Object)Long.toString(1800000L), (Object)rebuildQueryServicesConfig.get("hbase.client.scanner.timeout.period"));
            Assert.assertEquals((Object)Long.toString(1800000L), (Object)rebuildQueryServicesConfig.get("hbase.rpc.timeout"));
            Assert.assertEquals((Object)Long.toString(NUM_RPC_RETRIES), (Object)rebuildQueryServicesConfig.get("hbase.client.retries.number"));
            ConnectionQueryServices rebuildQueryServices = rebuildIndexConnection.getQueryServices();
            Field parentField = DelegateQueryServices.class.getDeclaredField("parent");
            parentField.setAccessible(true);
            QueryServices parent = (QueryServices)parentField.get(rebuildQueryServices);
            Field connectionField = ConnectionQueryServicesImpl.class.getDeclaredField("connection");
            connectionField.setAccessible(true);
            Connection rebuildIndexHConnection = (Connection)connectionField.get(parent);
            Connection regularHConnection = (Connection)connectionField.get(regularConnection.getQueryServices());
            Assert.assertFalse((boolean)regularHConnection.toString().equals(rebuildIndexHConnection.toString()));
            Configuration rebuildHConnectionConfig = rebuildIndexHConnection.getConfiguration();
            Assert.assertEquals((Object)Long.toString(1800000L), (Object)rebuildHConnectionConfig.get("hbase.client.scanner.timeout.period"));
            Assert.assertEquals((Object)Long.toString(1800000L), (Object)rebuildHConnectionConfig.get("hbase.rpc.timeout"));
            Assert.assertEquals((Object)Long.toString(NUM_RPC_RETRIES), (Object)rebuildHConnectionConfig.get("hbase.client.retries.number"));
        }
    }

    static {
        NUM_RPC_RETRIES = 1;
    }
}

