/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseTenantSpecificViewIndexIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ReadOnlyViewOnReadOnlyIT
extends BaseTenantSpecificViewIndexIT {
    private static final long DEFAULT_TTL_FOR_TEST = 86400L;

    private Connection getTenantConnection(String tenantId) throws Exception {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(ReadOnlyViewOnReadOnlyIT.getUrl(), tenantProps);
    }

    @Test
    public void testReadOnlyTenantViewOnReadOnly() throws Exception {
        try (Connection connection = DriverManager.getConnection(ReadOnlyViewOnReadOnlyIT.getUrl());){
            PhoenixConnection conn = connection.unwrap(PhoenixConnection.class);
            String tableName = ReadOnlyViewOnReadOnlyIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS  " + tableName + "  (TID CHAR(15) NOT NULL, ID INTEGER NOT NULL, COL1 INTEGER NOT NULL, COL2 bigint NOT NULL, CREATED_DATE DATE, CREATION_TIME BIGINT, CONSTRAINT NAME_PK PRIMARY KEY (TID, ID, COL1, COL2)) TTL = 86400,UPDATE_CACHE_FREQUENCY = 100000000, MULTI_TENANT = true");
            String viewName = "VIEW_" + tableName + "_" + ReadOnlyViewOnReadOnlyIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + viewName + " (" + ReadOnlyViewOnReadOnlyIT.generateUniqueName() + " SMALLINT) as select * from " + tableName + " where id > 1 ");
            String TENANT_ID = ReadOnlyViewOnReadOnlyIT.generateUniqueName();
            try (PhoenixConnection tenantConn = (PhoenixConnection)this.getTenantConnection(TENANT_ID);){
                Statement tenantStmt = tenantConn.createStatement();
                tenantStmt.execute("CREATE VIEW TENANT_VIEW_" + viewName + " AS SELECT * FROM " + viewName);
                Assert.assertEquals((Object)PTable.ViewType.READ_ONLY, (Object)conn.getTable(viewName).getViewType());
                Assert.assertEquals((Object)PTable.ViewType.READ_ONLY, (Object)tenantConn.getTable("TENANT_VIEW_" + viewName).getViewType());
            }
        }
    }

    @Test
    public void testReadOnlyViewOnReadOnly() throws Exception {
        try (Connection connection = DriverManager.getConnection(ReadOnlyViewOnReadOnlyIT.getUrl());){
            PhoenixConnection conn = connection.unwrap(PhoenixConnection.class);
            String tableName = ReadOnlyViewOnReadOnlyIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS  " + tableName + "  ( ID INTEGER NOT NULL, COL1 INTEGER NOT NULL, COL2 bigint NOT NULL, CREATED_DATE DATE, CREATION_TIME BIGINT, CONSTRAINT NAME_PK PRIMARY KEY (ID, COL1, COL2)) TTL = 86400,UPDATE_CACHE_FREQUENCY = 100000000");
            String viewName = "VIEW_" + tableName + "_" + ReadOnlyViewOnReadOnlyIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + viewName + " (" + ReadOnlyViewOnReadOnlyIT.generateUniqueName() + " SMALLINT) as select * from " + tableName + " where id > 1 ");
            String childView = "VIEW_" + viewName + "_" + ReadOnlyViewOnReadOnlyIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + childView + " AS SELECT * FROM " + viewName);
            Assert.assertEquals((Object)PTable.ViewType.READ_ONLY, (Object)conn.getTable(viewName).getViewType());
            Assert.assertEquals((Object)PTable.ViewType.READ_ONLY, (Object)conn.getTable(childView).getViewType());
        }
    }
}

