/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ReadOnlyIT
extends ParallelStatsDisabledIT {
    @Test
    public void testConnectionReadOnly() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(ReadOnlyIT.getUrl(), props);
        String testTable = ReadOnlyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + "   (r varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (r))\n";
        ReadOnlyIT.createTestTable(ReadOnlyIT.getUrl(), ddl);
        String query = "UPSERT INTO " + testTable + "(r, col1) VALUES('row1', 777)";
        PreparedStatement statement = conn.prepareStatement(query);
        statement.executeUpdate();
        conn.commit();
        try {
            conn.setReadOnly(true);
            Assert.assertTrue((boolean)conn.isReadOnly());
            ddl = "CREATE TABLE " + testTable + "2   (r varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (r))\n";
            statement = conn.prepareStatement(ddl);
            statement.executeUpdate();
            conn.commit();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 518 (25502): Mutations are not permitted for a read-only connection."));
        }
        try {
            query = "UPSERT INTO " + testTable + "(r, col1) VALUES('row1', 888)";
            statement = conn.prepareStatement(query);
            statement.executeUpdate();
            conn.commit();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 518 (25502): Mutations are not permitted for a read-only connection."));
        }
        conn.setReadOnly(false);
        Assert.assertFalse((boolean)conn.isReadOnly());
        ddl = "ALTER TABLE " + testTable + " ADD col2 VARCHAR";
        statement = conn.prepareStatement(ddl);
        statement.executeUpdate();
        conn.commit();
        try {
            conn.setReadOnly(true);
            ddl = "ALTER TABLE " + testTable + " ADD col3 VARCHAR";
            statement = conn.prepareStatement(ddl);
            statement.executeUpdate();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 518 (25502): Mutations are not permitted for a read-only connection."));
        }
    }
}

