/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class QueryWithTableSampleIT
extends ParallelStatsEnabledIT {
    private String tableName;
    private String joinedTableName;

    @Before
    public void generateTableNames() {
        this.tableName = "T_" + QueryWithTableSampleIT.generateUniqueName();
        this.joinedTableName = "T_" + QueryWithTableSampleIT.generateUniqueName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=PhoenixParserException.class)
    public void testSingleQueryWrongSyntax() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT i1, i2 FROM " + this.tableName + " tablesample 15 ";
            ResultSet resultSet = conn.createStatement().executeQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=PhoenixParserException.class)
    public void testSingleQueryWrongSamplingRate() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT i1, i2 FROM " + this.tableName + " tablesample (175) ";
            ResultSet resultSet = conn.createStatement().executeQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleQueryZeroSamplingRate() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT i1, i2 FROM " + this.tableName + " tablesample (0) ";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT i1, i2 FROM " + this.tableName + " tablesample (45) ";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)200L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertEquals((long)600L, (long)rs.getInt(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleQueryWithWhereClause() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT i1, i2 FROM " + this.tableName + " tablesample (22) where i2>=300 and i1<14 LIMIT 4 ";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)8L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)12L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleQueryWithAggregator() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT count(i1) FROM " + this.tableName + " tablesample (22) where i2>=3000 or i1<2 ";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)14L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleQueryWithUnion() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT * FROM " + this.tableName + " tablesample (100) where i1<2 union all SELECT * FROM " + this.tableName + " tablesample (2) where i2<6000";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)30L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)44L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleQueryWithSubQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT count(*) FROM (SELECT * FROM " + this.tableName + " tablesample (50))";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)50L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleQueryWithJoins() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT count(*) FROM " + this.tableName + " as A tablesample (45), " + this.joinedTableName + " as B tablesample (75) where A.i1=B.i1";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)31L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testExplainSingleQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "SELECT i1, i2 FROM " + this.tableName + " tablesample (45) ";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((double)0.45, (double)explainPlanAttributes.getSamplingRate(), (double)0.0);
            Assert.assertEquals((Object)this.tableName, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplainSingleQueryWithUnion() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "EXPLAIN SELECT * FROM " + this.tableName + " tablesample (100) where i1<2 union all SELECT * FROM " + this.tableName + " tablesample (2) where i2<6000";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertEquals((Object)("UNION ALL OVER 2 QUERIES\n    CLIENT PARALLEL 1-WAY 1.0-SAMPLED RANGE SCAN OVER " + this.tableName + " [*] - [2]\n        SERVER FILTER BY FIRST KEY ONLY\n    CLIENT PARALLEL 1-WAY 0.02-SAMPLED FULL SCAN OVER " + this.tableName + "\n        SERVER FILTER BY FIRST KEY ONLY AND I2 < 6000"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplainSingleQueryWithJoins() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(QueryWithTableSampleIT.getUrl(), props);){
            this.prepareTableWithValues(conn, 100);
            String query = "EXPLAIN SELECT count(*) FROM " + this.tableName + " as A tablesample (45), " + this.joinedTableName + " as B tablesample (75) where A.i1=B.i1";
            System.out.println(query);
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY 0.45-SAMPLED FULL SCAN OVER " + this.tableName + "\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO SINGLE ROW\n    PARALLEL INNER-JOIN TABLE 0 (SKIP MERGE)\n        CLIENT PARALLEL 1-WAY 0.75-SAMPLED FULL SCAN OVER " + this.joinedTableName + "\n            SERVER FILTER BY FIRST KEY ONLY\n    DYNAMIC SERVER FILTER BY A.I1 IN (B.I1)"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        }
    }

    private final void prepareTableWithValues(Connection conn, int nRows) throws Exception {
        conn.createStatement().execute("create table " + this.tableName + "\n   (i1 integer not null, i2 integer not null\n    CONSTRAINT pk PRIMARY KEY (i1,i2))");
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.tableName + " VALUES (?, ?)");
        for (int i = 0; i < nRows; ++i) {
            stmt.setInt(1, i);
            stmt.setInt(2, i * 100);
            stmt.execute();
        }
        conn.commit();
        conn.createStatement().execute("UPDATE STATISTICS " + this.tableName);
        conn.createStatement().execute("create table " + this.joinedTableName + "\n   (i1 integer not null, i2 integer not null\n    CONSTRAINT pk PRIMARY KEY (i1,i2))");
        PreparedStatement stmt2 = conn.prepareStatement("upsert into " + this.joinedTableName + " VALUES (?, ?)");
        for (int i = 0; i < nRows; ++i) {
            stmt2.setInt(1, i);
            stmt2.setInt(2, i * -100);
            stmt2.execute();
        }
        conn.commit();
        conn.createStatement().execute("UPDATE STATISTICS " + this.joinedTableName);
    }
}

