/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class QueryTimeoutIT
extends BaseTest {
    private String tableName;

    @Before
    public void generateTableName() throws SQLException {
        this.tableName = QueryTimeoutIT.generateUniqueName();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)5);
        props.put("phoenix.stats.guidepost.width", Long.toString(700L));
        props.put("phoenix.query.queueSize", Integer.toString(10000));
        props.put("phoenix.explain.displayChunkCount", Boolean.TRUE.toString());
        props.put("phoenix.jdbc.extra.arguments", "");
        QueryTimeoutIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @After
    public void assertNoUnfreedMemory() throws Exception {
        boolean refCountLeaked = QueryTimeoutIT.isAnyStoreRefCountLeaked();
        try (Connection conn = DriverManager.getConnection(QueryTimeoutIT.getUrl());){
            long unfreedBytes = conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            Assert.assertEquals((long)0L, (long)unfreedBytes);
        }
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Test
    public void testSetRPCTimeOnConnection() throws Exception {
        Properties overriddenProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        overriddenProps.put("phoenix.jdbc.extra.arguments", "");
        overriddenProps.setProperty("hbase.rpc.timeout", Long.toString(100L));
        String url = QueryUtil.getConnectionUrl((Properties)overriddenProps, (Configuration)config, (String)"longRunning");
        Connection conn1 = DriverManager.getConnection(url, overriddenProps);
        ConnectionQueryServices s1 = conn1.unwrap(PhoenixConnection.class).getQueryServices();
        ReadOnlyProps configProps = s1.getProps();
        Assert.assertEquals((Object)"100", (Object)configProps.get("hbase.rpc.timeout"));
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.jdbc.extra.arguments", "");
        Connection conn2 = DriverManager.getConnection(QueryTimeoutIT.getUrl(), props);
        ConnectionQueryServices s2 = conn2.unwrap(PhoenixConnection.class).getQueryServices();
        Assert.assertFalse((s1 == s2 ? 1 : 0) != 0);
        Connection conn3 = DriverManager.getConnection(QueryTimeoutIT.getUrl(), props);
        ConnectionQueryServices s3 = conn3.unwrap(PhoenixConnection.class).getQueryServices();
        Assert.assertTrue((s2 == s3 ? 1 : 0) != 0);
        Connection conn4 = DriverManager.getConnection(url, overriddenProps);
        ConnectionQueryServices s4 = conn4.unwrap(PhoenixConnection.class).getQueryServices();
        Assert.assertTrue((s1 == s4 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryTimeout() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(QueryTimeoutIT.getUrl(), props);
        conn.createStatement().execute("CREATE TABLE " + this.tableName + "(k BIGINT PRIMARY KEY, v VARCHAR)");
        TestUtil.addCoprocessor(conn, this.tableName, SleepingRegionObserver.class);
        PhoenixStatement pstmt = conn.createStatement().unwrap(PhoenixStatement.class);
        pstmt.setQueryTimeout(1);
        long startTime = System.currentTimeMillis();
        try {
            ResultSet rs = pstmt.executeQuery("SELECT count(*) FROM " + this.tableName);
            startTime = System.currentTimeMillis();
            rs.next();
            Assert.fail((String)("Total time of query was " + (System.currentTimeMillis() - startTime) + " ms, but expected to be greater than 1000"));
        }
        catch (SQLTimeoutException e) {
            long elapsedTimeMillis = System.currentTimeMillis() - startTime;
            Assert.assertEquals((long)SQLExceptionCode.OPERATION_TIMED_OUT.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((String)("Total time of query was " + elapsedTimeMillis + " ms, but expected to be greater or equal to 1000"), (elapsedTimeMillis >= 1000L ? 1 : 0) != 0);
        }
        conn.close();
    }

    public static class SleepingRegionObserver
    extends SimpleRegionObserver {
        public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

