/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.log.QueryLogger;
import org.apache.phoenix.log.QueryStatus;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class QueryLoggerIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.query.request.metrics.enabled", String.valueOf(true));
        props.put("phoenix.scanner.lease.renew.enabled", String.valueOf(false));
        QueryLoggerIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @Test
    public void testDebugLogs() throws Exception {
        StatementContext context;
        String tableName = QueryLoggerIT.generateUniqueName();
        QueryLoggerIT.createTableAndInsertValues(tableName, true);
        Properties props = new Properties();
        props.setProperty("phoenix.log.level", LogLevel.DEBUG.name());
        Connection conn = DriverManager.getConnection(QueryLoggerIT.getUrl(), props);
        Assert.assertEquals((Object)conn.unwrap(PhoenixConnection.class).getLogLevel(), (Object)LogLevel.DEBUG);
        String query = "SELECT * FROM " + tableName;
        try (ResultSet rs = conn.createStatement().executeQuery(query);){
            context = ((PhoenixResultSet)rs).getContext();
            while (rs.next()) {
                rs.getString(1);
                rs.getString(2);
            }
        }
        String queryId = context.getQueryLogger().getQueryId();
        String logQuery = "SELECT * FROM SYSTEM.\"LOG\"";
        int delay = 5000;
        Thread.sleep(delay);
        try (ResultSet explainRS = conn.createStatement().executeQuery("Explain with regions " + query);
             ResultSet rs = conn.createStatement().executeQuery(logQuery);){
            boolean foundQueryLog = false;
            while (rs.next()) {
                if (rs.getString("QUERY_ID").equals(queryId)) {
                    foundQueryLog = true;
                    Assert.assertEquals((Object)rs.getString("BIND_PARAMETERS"), null);
                    Assert.assertEquals((Object)rs.getString("USER"), (Object)System.getProperty("user.name"));
                    Assert.assertEquals((Object)rs.getString("CLIENT_IP"), (Object)InetAddress.getLocalHost().getHostAddress());
                    Assert.assertEquals((Object)rs.getString("EXPLAIN_PLAN"), (Object)QueryUtil.getExplainPlan((ResultSet)explainRS));
                    Assert.assertEquals((Object)rs.getString("GLOBAL_SCAN_DETAILS"), (Object)context.getScan().toJSON());
                    Assert.assertEquals((long)rs.getLong("NO_OF_RESULTS_ITERATED"), (long)10L);
                    Assert.assertEquals((Object)rs.getString("QUERY"), (Object)query);
                    Assert.assertEquals((Object)rs.getString("QUERY_STATUS"), (Object)QueryStatus.COMPLETED.toString());
                    Assert.assertEquals((Object)rs.getString("TENANT_ID"), null);
                    Assert.assertTrue((rs.getString("SCAN_METRICS_JSON") == null ? 1 : 0) != 0);
                    Assert.assertEquals((Object)rs.getString("EXCEPTION_TRACE"), null);
                    continue;
                }
                Assert.assertFalse((boolean)rs.getString("QUERY").toString().contains("SYSTEM"));
            }
            Assert.assertTrue((boolean)foundQueryLog);
            conn.close();
        }
    }

    @Test
    public void testLogSampling() throws Exception {
        String tableName = QueryLoggerIT.generateUniqueName();
        QueryLoggerIT.createTableAndInsertValues(tableName, true);
        Properties props = new Properties();
        props.setProperty("phoenix.log.level", LogLevel.DEBUG.name());
        props.setProperty("phoenix.log.sample.rate", "0.5");
        Connection conn = DriverManager.getConnection(QueryLoggerIT.getUrl(), props);
        Assert.assertEquals((Object)conn.unwrap(PhoenixConnection.class).getLogLevel(), (Object)LogLevel.DEBUG);
        String query = "SELECT * FROM " + tableName;
        int count = 100;
        for (int i = 0; i < count; ++i) {
            try (ResultSet rs = conn.createStatement().executeQuery(query);){
                while (rs.next()) {
                }
                continue;
            }
        }
        String logQuery = "SELECT * FROM SYSTEM.\"LOG\"";
        int delay = 5000;
        Thread.sleep(delay);
        ResultSet rs = conn.createStatement().executeQuery(logQuery);
        int logCount = 0;
        while (rs.next()) {
            ++logCount;
        }
        Assert.assertTrue((logCount != 0 && (double)logCount < (double)count * 0.75 ? 1 : 0) != 0);
        conn.close();
    }

    @Test
    public void testInfoLogs() throws Exception {
        StatementContext context;
        String tableName = QueryLoggerIT.generateUniqueName();
        QueryLoggerIT.createTableAndInsertValues(tableName, true);
        Properties props = new Properties();
        props.setProperty("phoenix.log.level", LogLevel.INFO.name());
        Connection conn = DriverManager.getConnection(QueryLoggerIT.getUrl(), props);
        Assert.assertEquals((Object)conn.unwrap(PhoenixConnection.class).getLogLevel(), (Object)LogLevel.INFO);
        String query = "SELECT * FROM " + tableName;
        try (ResultSet rs = conn.createStatement().executeQuery(query);){
            context = ((PhoenixResultSet)rs).getContext();
            while (rs.next()) {
                rs.getString(1);
                rs.getString(2);
            }
        }
        String queryId = context.getQueryLogger().getQueryId();
        String logQuery = "SELECT * FROM SYSTEM.\"LOG\"";
        int delay = 5000;
        Thread.sleep(delay);
        try (ResultSet rs = conn.createStatement().executeQuery(logQuery);){
            boolean foundQueryLog = false;
            while (rs.next()) {
                if (!rs.getString("QUERY_ID").equals(queryId)) continue;
                foundQueryLog = true;
                Assert.assertEquals((Object)rs.getString("USER"), (Object)System.getProperty("user.name"));
                Assert.assertEquals((Object)rs.getString("CLIENT_IP"), (Object)InetAddress.getLocalHost().getHostAddress());
                Assert.assertEquals((Object)rs.getString("EXPLAIN_PLAN"), null);
                Assert.assertEquals((Object)rs.getString("GLOBAL_SCAN_DETAILS"), null);
                Assert.assertEquals((long)rs.getLong("NO_OF_RESULTS_ITERATED"), (long)10L);
                Assert.assertEquals((Object)rs.getString("QUERY"), (Object)query);
                Assert.assertEquals((Object)rs.getString("QUERY_STATUS"), (Object)QueryStatus.COMPLETED.toString());
                Assert.assertEquals((Object)rs.getString("TENANT_ID"), null);
            }
            Assert.assertTrue((boolean)foundQueryLog);
            conn.close();
        }
    }

    @Test
    public void testWithLoggingOFF() throws Exception {
        String tableName = QueryLoggerIT.generateUniqueName();
        QueryLoggerIT.createTableAndInsertValues(tableName, true);
        Properties props = new Properties();
        props.setProperty("phoenix.log.level", LogLevel.OFF.name());
        Connection conn = DriverManager.getConnection(QueryLoggerIT.getUrl(), props);
        Assert.assertEquals((Object)conn.unwrap(PhoenixConnection.class).getLogLevel(), (Object)LogLevel.OFF);
        conn.createStatement().executeUpdate("delete from SYSTEM.\"LOG\"");
        conn.commit();
        String query = "SELECT * FROM " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        StatementContext context = ((PhoenixResultSet)rs).getContext();
        Assert.assertEquals((Object)context.getQueryLogger(), (Object)QueryLogger.NO_OP_INSTANCE);
        while (rs.next()) {
            rs.getString(1);
            rs.getString(2);
        }
        String logQuery = "SELECT count(*) FROM SYSTEM.\"LOG\"";
        int delay = 5000;
        Thread.sleep(delay);
        rs = conn.createStatement().executeQuery(logQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rs.getInt(1), (long)0L);
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testPreparedStatementWithTrace() throws Exception {
        this.testPreparedStatement(LogLevel.TRACE);
    }

    @Test
    public void testPreparedStatementWithDebug() throws Exception {
        this.testPreparedStatement(LogLevel.DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPreparedStatement(LogLevel loglevel) throws Exception {
        String tableName = QueryLoggerIT.generateUniqueName();
        QueryLoggerIT.createTableAndInsertValues(tableName, true);
        Properties props = new Properties();
        props.setProperty("phoenix.log.level", loglevel.name());
        Connection conn = DriverManager.getConnection(QueryLoggerIT.getUrl(), props);
        Assert.assertEquals((Object)conn.unwrap(PhoenixConnection.class).getLogLevel(), (Object)loglevel);
        MyClock clock = new MyClock(100L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)clock);
        try {
            StatementContext context;
            String query = "SELECT * FROM " + tableName + " where V = ?";
            PreparedStatement pstmt = conn.prepareStatement(query);
            pstmt.setString(1, "value5");
            try (ResultSet rs = pstmt.executeQuery();){
                context = ((PhoenixResultSet)rs).getContext();
                while (rs.next()) {
                    rs.getString(1);
                    rs.getString(2);
                }
            }
            String queryId = context.getQueryLogger().getQueryId();
            String logQuery = "SELECT * FROM SYSTEM.\"LOG\"";
            int delay = 5000;
            Thread.sleep(delay);
            String explainQuery = "EXPLAIN WITH REGIONS SELECT * FROM " + tableName + " where V = 'value5'";
            try (ResultSet explainRS = conn.createStatement().executeQuery(explainQuery);
                 ResultSet rs = conn.createStatement().executeQuery(logQuery);){
                boolean foundQueryLog = false;
                while (rs.next()) {
                    if (!rs.getString("QUERY_ID").equals(queryId)) continue;
                    foundQueryLog = true;
                    Assert.assertEquals((Object)rs.getString("BIND_PARAMETERS"), (Object)(loglevel == LogLevel.TRACE ? "value5" : null));
                    Assert.assertEquals((Object)rs.getString("USER"), (Object)System.getProperty("user.name"));
                    Assert.assertEquals((Object)rs.getString("CLIENT_IP"), (Object)InetAddress.getLocalHost().getHostAddress());
                    Assert.assertEquals((Object)rs.getString("EXPLAIN_PLAN"), (Object)QueryUtil.getExplainPlan((ResultSet)explainRS));
                    Assert.assertEquals((Object)rs.getString("GLOBAL_SCAN_DETAILS"), (Object)context.getScan().toJSON());
                    Assert.assertEquals((long)rs.getLong("NO_OF_RESULTS_ITERATED"), (long)1L);
                    Assert.assertEquals((Object)rs.getString("QUERY"), (Object)query);
                    Assert.assertEquals((Object)rs.getString("QUERY_STATUS"), (Object)QueryStatus.COMPLETED.toString());
                    Assert.assertTrue((boolean)(LogLevel.TRACE == loglevel ? rs.getString("SCAN_METRICS_JSON").contains("scanMetrics") : rs.getString("SCAN_METRICS_JSON") == null));
                    Assert.assertEquals((long)rs.getTimestamp("START_TIME").getTime(), (long)100L);
                    Assert.assertEquals((Object)rs.getString("TENANT_ID"), null);
                }
                Assert.assertTrue((boolean)foundQueryLog);
                conn.close();
            }
        }
        finally {
            EnvironmentEdgeManager.injectEdge(null);
        }
    }

    @Test
    public void testFailedQuery() throws Exception {
        String tableName = QueryLoggerIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("phoenix.log.level", LogLevel.DEBUG.name());
        Connection conn = DriverManager.getConnection(QueryLoggerIT.getUrl(), props);
        Assert.assertEquals((Object)conn.unwrap(PhoenixConnection.class).getLogLevel(), (Object)LogLevel.DEBUG);
        String query = "SELECT * FROM " + tableName;
        try {
            conn.createStatement().executeQuery(query);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode());
        }
        String logQuery = "SELECT * FROM SYSTEM.\"LOG\"";
        int delay = 5000;
        Thread.sleep(delay);
        ResultSet rs = conn.createStatement().executeQuery(logQuery);
        boolean foundQueryLog = false;
        while (rs.next()) {
            if (!QueryStatus.FAILED.name().equals(rs.getString("QUERY_STATUS"))) continue;
            foundQueryLog = true;
            Assert.assertEquals((Object)rs.getString("USER"), (Object)System.getProperty("user.name"));
            Assert.assertEquals((Object)rs.getString("CLIENT_IP"), (Object)InetAddress.getLocalHost().getHostAddress());
            Assert.assertEquals((Object)rs.getString("EXPLAIN_PLAN"), null);
            Assert.assertEquals((Object)rs.getString("GLOBAL_SCAN_DETAILS"), null);
            Assert.assertEquals((long)rs.getLong("NO_OF_RESULTS_ITERATED"), (long)0L);
            Assert.assertEquals((Object)rs.getString("QUERY"), (Object)query);
            Assert.assertTrue((boolean)rs.getString("EXCEPTION_TRACE").contains(SQLExceptionCode.TABLE_UNDEFINED.getMessage()));
        }
        Assert.assertTrue((boolean)foundQueryLog);
        conn.close();
    }

    private static void createTableAndInsertValues(String tableName, boolean resetGlobalMetricsAfterTableCreate) throws Exception {
        String ddl = "CREATE TABLE " + tableName + " (K VARCHAR NOT NULL PRIMARY KEY, V VARCHAR)";
        Connection conn = DriverManager.getConnection(QueryLoggerIT.getUrl());
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES (?, ?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        for (int i = 1; i <= 10; ++i) {
            stmt.setString(1, "key" + i);
            stmt.setString(2, "value" + i);
            stmt.executeUpdate();
        }
        conn.commit();
    }

    private static class MyClock
    extends EnvironmentEdge {
        public volatile long time;

        public MyClock(long time) {
            this.time = time;
        }

        public long currentTime() {
            return this.time;
        }
    }
}

