/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class QueryExecWithoutSCNIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanNoSCN() throws Exception {
        String tenantId = QueryExecWithoutSCNIT.getOrganizationId();
        String tableName = QueryExecWithoutSCNIT.initATableValues(tenantId, QueryExecWithoutSCNIT.getDefaultSplits(tenantId), null, null, QueryExecWithoutSCNIT.getUrl());
        String query = "SELECT a_string, b_string FROM " + tableName + " WHERE organization_id=? and a_integer = 5";
        Properties props = new Properties();
        try (Connection conn = DriverManager.getConnection(QueryExecWithoutSCNIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"b");
            Assert.assertEquals((Object)rs.getString("B_string"), (Object)"c");
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

