/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ProjectArrayElemAfterHashJoinIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSalted() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProjectArrayElemAfterHashJoinIT.getUrl(), props);){
            String table = this.createSalted(conn);
            this.testTable(conn, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsalted() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(ProjectArrayElemAfterHashJoinIT.getUrl(), props);){
            String table = this.createUnsalted(conn);
            this.testTable(conn, table);
        }
    }

    private void testTable(Connection conn, String table) throws Exception {
        this.verifyExplain(conn, table, false, false);
        this.verifyExplain(conn, table, false, true);
        this.verifyExplain(conn, table, true, false);
        this.verifyExplain(conn, table, true, true);
        this.verifyResults(conn, table, false, false);
        this.verifyResults(conn, table, false, true);
        this.verifyResults(conn, table, true, false);
        this.verifyResults(conn, table, true, true);
    }

    private String createSalted(Connection conn) throws Exception {
        String table = "SALTED_" + ProjectArrayElemAfterHashJoinIT.generateUniqueName();
        String create = "CREATE TABLE " + table + " ( id INTEGER NOT NULL, vals TINYINT[], CONSTRAINT pk PRIMARY KEY (id)) SALT_BUCKETS = 4";
        conn.createStatement().execute(create);
        return table;
    }

    private String createUnsalted(Connection conn) throws Exception {
        String table = "UNSALTED_" + ProjectArrayElemAfterHashJoinIT.generateUniqueName();
        String create = "CREATE TABLE " + table + " ( id INTEGER NOT NULL, vals TINYINT[], CONSTRAINT pk PRIMARY KEY (id))";
        conn.createStatement().execute(create);
        return table;
    }

    private String getQuery(String table, boolean fullArray, boolean hashJoin) {
        String query = "SELECT id, vals[1] v1, vals[2] v2, vals[3] v3, vals[4] v4" + (fullArray ? ", vals" : "") + " FROM " + table + " WHERE id IN " + (hashJoin ? "(SELECT 1)" : "(1, 2, 3)");
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyExplain(Connection conn, String table, boolean fullArray, boolean hashJoin) throws Exception {
        String query = "EXPLAIN " + this.getQuery(table, fullArray, hashJoin);
        Statement stmt = conn.createStatement();
        try (ResultSet rs = stmt.executeQuery(query);){
            String plan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((plan != null ? 1 : 0) != 0);
            Assert.assertTrue((fullArray || plan.contains("SERVER ARRAY ELEMENT PROJECTION") ? 1 : 0) != 0);
            Assert.assertTrue((hashJoin == plan.contains("JOIN") ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyResults(Connection conn, String table, boolean fullArray, boolean hashJoin) throws Exception {
        String upsert = "UPSERT INTO " + table + "(id, vals) VALUES(1, ARRAY[10, 20, 30, 40, 50])";
        PreparedStatement upsertStmt = conn.prepareStatement(upsert);
        upsertStmt.execute();
        conn.commit();
        String query = this.getQuery(table, fullArray, hashJoin);
        Statement stmt = conn.createStatement();
        try (ResultSet rs = stmt.executeQuery(query);){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt("id"));
            Assert.assertEquals((long)10L, (long)rs.getInt("v1"));
            Assert.assertEquals((long)20L, (long)rs.getInt("v2"));
            Assert.assertEquals((long)30L, (long)rs.getInt("v3"));
            Assert.assertEquals((long)40L, (long)rs.getInt("v4"));
            if (fullArray) {
                java.sql.Array array = rs.getArray("vals");
                Assert.assertTrue((array != null ? 1 : 0) != 0);
                Object obj = array.getArray();
                Assert.assertTrue((obj != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)obj.getClass().isArray());
                Assert.assertEquals((long)5L, (long)Array.getLength(obj));
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void dropTable(Connection conn, String table) throws Exception {
        String drop = "DROP TABLE " + table;
        Statement stmt = conn.createStatement();
        stmt.execute(drop);
        stmt.close();
    }
}

