/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class PrimitiveTypeIT
extends ParallelStatsDisabledIT {
    private static final Properties PROPS = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);

    public static void initTableValues(Connection conn, String tableName) throws Exception {
        conn.createStatement().execute("create table " + tableName + " (l bigint not null primary key, b boolean)");
        PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + " VALUES(?)");
        stmt.setLong(1, 2L);
        stmt.execute();
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareLongGTDecimal() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "SELECT l FROM " + tableName + " where l > 1.5";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareLongGTEDecimal() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "SELECT l FROM " + tableName + " where l >= 1.5";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareLongLTDecimal() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "SELECT l FROM " + tableName + " where l < 1.5";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareLongLTEDecimal() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "SELECT l FROM " + tableName + " where l <= 1.5";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareLongGTDecimal2() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "SELECT l FROM " + tableName + " where l > 2.5";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareLongGTEDecimal2() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "SELECT l FROM " + tableName + " where l >= 2.5";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareLongLTDecimal2() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "SELECT l FROM " + tableName + " where l < 2.5";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareLongLTEDecimal2() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "SELECT l FROM " + tableName + " where l <= 2.5";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBooleanAsObject() throws Exception {
        String tableName = PrimitiveTypeIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(PrimitiveTypeIT.getUrl(), PROPS);
        PrimitiveTypeIT.initTableValues(conn, tableName);
        String query = "upsert into " + tableName + " values (2, ?)";
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setObject(1, new Boolean("false"));
            statement.execute();
            conn.commit();
            statement = conn.prepareStatement("SELECT l,b,? FROM " + tableName);
            statement.setObject(1, new Boolean("false"));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertEquals((Object)Boolean.FALSE, (Object)rs.getObject(2));
            Assert.assertEquals((Object)Boolean.FALSE, (Object)rs.getObject(3));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }
}

