/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PreStoreScannerOpenIT
extends BaseTest {
    private static final int TTL_IN_DAYS = 30;
    public static final String TABLE_NAME = PreStoreScannerOpenIT.generateUniqueName();
    public static final AtomicLong SEEK_COUNT = new AtomicLong(0L);
    public static final AtomicLong RESEEK_COUNT = new AtomicLong(0L);

    @BeforeClass
    public static void setUp() throws Exception {
        ByteBuddyAgent.install();
        new ByteBuddy().redefine(StoreFileScanner.class).visit((AsmVisitorWrapper)Advice.to(SeekAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"seek"))).visit((AsmVisitorWrapper)Advice.to(ReseekAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"reseek"))).make().load(StoreFileScanner.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
        System.out.println("ByteBuddy instrumentation installed for StoreFileScanner");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hbase.regionserver.optionalcacheflushinterval", "0");
        props.put("hbase.regionserver.compaction.enabled", "false");
        props.put("hbase.procedure.remote.dispatcher.delay.msec", "0");
        PreStoreScannerOpenIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testStoreScannerNotDoingExtraSeeks() throws Exception {
        Statement stmt;
        this.createTable(TABLE_NAME);
        try (Connection conn = DriverManager.getConnection(PreStoreScannerOpenIT.getUrl());){
            stmt = conn.createStatement();
            try {
                stmt.execute("UPSERT INTO " + TABLE_NAME + " (id, col1) VALUES (1, 'a')");
                stmt.execute("UPSERT INTO " + TABLE_NAME + " (id, col1) VALUES (10, 'b')");
                conn.commit();
                PreStoreScannerOpenIT.getUtility().flush(TableName.valueOf((String)TABLE_NAME));
                stmt.execute("UPSERT INTO " + TABLE_NAME + " (id, col1) VALUES (2, 'c')");
                stmt.execute("UPSERT INTO " + TABLE_NAME + " (id, col1) VALUES (9, 'd')");
                conn.commit();
                PreStoreScannerOpenIT.getUtility().flush(TableName.valueOf((String)TABLE_NAME));
                stmt.execute("UPSERT INTO " + TABLE_NAME + " (id, col1) VALUES (3, 'e')");
                conn.commit();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        Assert.assertEquals((long)2L, (long)this.getStoreFileCount(TABLE_NAME));
        conn = DriverManager.getConnection(PreStoreScannerOpenIT.getUrl());
        try {
            stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery("SELECT col1 FROM " + TABLE_NAME + " WHERE id = 3");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Assert.assertEquals((long)0L, (long)SEEK_COUNT.get());
        Assert.assertEquals((long)0L, (long)RESEEK_COUNT.get());
    }

    @Test
    public void testSCNScansCanSeeDeletedRows() throws Exception {
        long beforeRowWasDeleted;
        String tableName = PreStoreScannerOpenIT.generateUniqueName();
        this.createTable(tableName);
        try (Connection conn = DriverManager.getConnection(PreStoreScannerOpenIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("UPSERT INTO " + tableName + " (id, col1) VALUES (1, 'a')");
            conn.commit();
            PreStoreScannerOpenIT.getUtility().flush(TableName.valueOf((String)tableName));
            beforeRowWasDeleted = EnvironmentEdgeManager.currentTimeMillis();
            Thread.sleep(1L);
            stmt.execute("DELETE FROM " + tableName + " WHERE id = 1");
            conn.commit();
            PreStoreScannerOpenIT.getUtility().flush(TableName.valueOf((String)tableName));
            Thread.sleep(1L);
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE id = 1");
            Assert.assertFalse((boolean)rs.next());
        }
        Properties props = new Properties();
        props.put("CurrentSCN", Long.toString(beforeRowWasDeleted));
        try (Connection conn = DriverManager.getConnection(PreStoreScannerOpenIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE id = 1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowsAreNotExpiredPartially() throws Exception {
        String tableName = PreStoreScannerOpenIT.generateUniqueName();
        this.createTable(tableName);
        ManualEnvironmentEdge injectEdge = new ManualEnvironmentEdge();
        injectEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)injectEdge);
        try (Connection conn = DriverManager.getConnection(PreStoreScannerOpenIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("UPSERT INTO " + tableName + " (id, col1, col2) VALUES (1, 'a', 'ab')");
            conn.commit();
            injectEdge.incrementValue(1L);
            PreStoreScannerOpenIT.getUtility().flush(TableName.valueOf((String)tableName));
            Assert.assertTrue((boolean)true);
            injectEdge.incrementValue(Integer.MAX_VALUE);
            stmt.execute("UPSERT INTO " + tableName + " (id, col1) VALUES (1, 'b')");
            conn.commit();
            injectEdge.incrementValue(1L);
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE id = 1");
            while (rs.next()) {
                Assert.assertEquals((long)1L, (long)rs.getInt("id"));
                Assert.assertEquals((Object)"b", (Object)rs.getString("col1"));
                Assert.assertEquals((Object)"ab", (Object)rs.getString("col2"));
            }
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private void createTable(String tableName) throws Exception {
        try (Connection conn = DriverManager.getConnection(PreStoreScannerOpenIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (id INTEGER PRIMARY KEY, col1 VARCHAR, col2 VARCHAR) BLOOMFILTER = NONE, TTL = 2592000");
            conn.commit();
        }
    }

    private int getStoreFileCount(String tableName) throws Exception {
        TableName table = TableName.valueOf((String)tableName);
        int totalStoreFiles = 0;
        List regions = PreStoreScannerOpenIT.getUtility().getHBaseCluster().getRegionServerThreads().stream().flatMap(rs -> rs.getRegionServer().getRegions(table).stream()).collect(Collectors.toList());
        for (HRegion region : regions) {
            for (HStore store : region.getStores()) {
                totalStoreFiles += store.getStorefilesCount();
            }
        }
        return totalStoreFiles;
    }

    public static class SeekAdvice {
        @Advice.OnMethodEnter
        public static void onSeek(@Advice.This StoreFileScanner scanner) {
            if (scanner.getFilePath().toString().contains(TABLE_NAME)) {
                SEEK_COUNT.incrementAndGet();
                System.out.println("SEEK called! Total seeks: " + SEEK_COUNT.get());
            }
        }
    }

    public static class ReseekAdvice {
        @Advice.OnMethodEnter
        public static void onReseek(@Advice.This StoreFileScanner scanner) {
            if (scanner.getFilePath().toString().contains(TABLE_NAME)) {
                RESEEK_COUNT.incrementAndGet();
                System.out.println("RESEEK called! Total reseeks: " + RESEEK_COUNT.get());
            }
        }
    }
}

