/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseQueryIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PointInTimeScanQueryIT
extends BaseQueryIT {
    @Parameterized.Parameters(name="PointInTimeScanQueryIT_{index},columnEncoded={1}")
    public static synchronized Collection<Object> data() {
        return BaseQueryIT.allIndexesWithEncodedAndKeepDeleted();
    }

    public PointInTimeScanQueryIT(String idxDdl, boolean columnEncoded, boolean keepDeletedCells) throws Exception {
        super(idxDdl, columnEncoded, keepDeletedCells);
        PointInTimeScanQueryIT.initTables(idxDdl, columnEncoded, keepDeletedCells);
    }

    @Test
    public void testPointInTimeScan() throws Exception {
        String url = PointInTimeScanQueryIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String upsertStmt = "upsert into " + tableName + " (    ORGANIZATION_ID,     ENTITY_ID,     A_INTEGER) VALUES (?, ?, ?)";
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            PreparedStatement stmt = upsertConn.prepareStatement(upsertStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A423122312312");
            stmt.setInt(3, 5);
            stmt.execute();
        }
        long upsert1Time = System.currentTimeMillis();
        long timeDelta = 100L;
        Thread.sleep(timeDelta);
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            PreparedStatement stmt = upsertConn.prepareStatement(upsertStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A423122312312");
            stmt.setInt(3, 9);
            stmt.execute();
        }
        long queryTime = upsert1Time + timeDelta / 2L;
        String query = "SELECT organization_id, a_string AS a FROM " + tableName + " WHERE organization_id=? and a_integer = 5";
        props.setProperty("CurrentSCN", Long.toString(queryTime));
        try (Connection conn = DriverManager.getConnection(PointInTimeScanQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)tenantId, (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString("a"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)tenantId, (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testPointInTimeLimitedScan() throws Exception {
        String url = PointInTimeScanQueryIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String upsertStmt = "upsert into " + tableName + " (    ORGANIZATION_ID,     ENTITY_ID,     A_INTEGER) VALUES (?, ?, ?)";
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            PreparedStatement stmt = upsertConn.prepareStatement(upsertStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A123122312312");
            stmt.setInt(3, 6);
            stmt.execute();
        }
        long upsert1Time = System.currentTimeMillis();
        long timeDelta = 100L;
        Thread.sleep(timeDelta);
        url = PointInTimeScanQueryIT.getUrl();
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            PreparedStatement stmt = upsertConn.prepareStatement(upsertStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A123122312312");
            stmt.setInt(3, 0);
            stmt.execute();
        }
        long queryTime = upsert1Time + timeDelta / 2L;
        String query = "SELECT a_integer,b_string FROM " + tableName + " WHERE organization_id=? and a_integer <= 5 limit 2";
        props.setProperty("CurrentSCN", Long.toString(queryTime));
        try (Connection conn = DriverManager.getConnection(PointInTimeScanQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            ArrayList expectedResultsA = Lists.newArrayList((Object[])new List[]{Arrays.asList(2, "c"), Arrays.asList(3, "e")});
            ArrayList expectedResultsB = Lists.newArrayList((Object[])new List[]{Arrays.asList(5, "c"), Arrays.asList(4, "b")});
            PointInTimeScanQueryIT.assertOneOfValuesEqualsResultSet(rs, expectedResultsA, expectedResultsB);
        }
    }
}

