/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseQueryIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PointInTimeQueryIT
extends BaseQueryIT {
    @Parameterized.Parameters(name="PointInTimeQueryIT_{index},columnEncoded={1}")
    public static synchronized Collection<Object> data() {
        return BaseQueryIT.allIndexesWithEncodedAndKeepDeleted();
    }

    public PointInTimeQueryIT(String indexDDL, boolean columnEncoded, boolean keepDeletedCells) throws Exception {
        super(indexDDL, columnEncoded, keepDeletedCells);
        PointInTimeQueryIT.initTables(indexDDL, columnEncoded, keepDeletedCells);
    }

    @Test
    public void testPointInTimeDeleteUngroupedAggregation() throws Exception {
        String updateStmt = "upsert into " + tableName + " (    ORGANIZATION_ID,     ENTITY_ID,     A_STRING) VALUES (?, ?, ?)";
        String url = PointInTimeQueryIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement stmt = conn.prepareStatement(updateStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B723122312312");
            stmt.setString(3, null);
            stmt.execute();
            stmt = conn.prepareStatement("delete from " + tableName + " where organization_id=? and entity_id=?");
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B523122312312");
            stmt.execute();
            conn.commit();
        }
        long firstDeleteTime = System.currentTimeMillis();
        long timeDelta = 100L;
        Thread.sleep(timeDelta);
        try (Connection futureConn = DriverManager.getConnection(PointInTimeQueryIT.getUrl());){
            PreparedStatement stmt = futureConn.prepareStatement("delete from " + tableName + " where organization_id=? and entity_id=?");
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B623122312312");
            stmt.execute();
            futureConn.commit();
        }
        long queryTime = firstDeleteTime + timeDelta / 2L;
        String query = "SELECT count(1) FROM " + tableName + " WHERE organization_id=? and a_string = ?";
        props.setProperty("CurrentSCN", Long.toString(queryTime));
        try (Connection conn = DriverManager.getConnection(PointInTimeQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, "b");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void TestPointInTimeGroupedAggregation() throws Exception {
        String updateStmt = "upsert into " + tableName + " VALUES ('" + tenantId + "','00B523122312312','c')";
        String url = PointInTimeQueryIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            Statement stmt = upsertConn.createStatement();
            stmt.execute(updateStmt);
        }
        long upsert1Time = System.currentTimeMillis();
        long timeDelta = 100L;
        Thread.sleep(timeDelta);
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            updateStmt = "upsert into " + tableName + " VALUES (?, ?, ?)";
            PreparedStatement pstmt = upsertConn.prepareStatement(updateStmt);
            pstmt.setString(1, tenantId);
            pstmt.setString(2, "00B523122312312");
            pstmt.setString(3, "e");
            pstmt.execute();
        }
        long queryTime = upsert1Time + timeDelta / 2L;
        String query = "SELECT a_string, count(1) FROM " + tableName + " WHERE organization_id='" + tenantId + "' GROUP BY a_string";
        props.setProperty("CurrentSCN", Long.toString(queryTime));
        try (Connection conn = DriverManager.getConnection(PointInTimeQueryIT.getUrl(), props);){
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void TestPointInTimeUngroupedAggregation() throws Exception {
        String url = PointInTimeQueryIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String updateStmt = "upsert into " + tableName + " (    ORGANIZATION_ID,     ENTITY_ID,     A_STRING) VALUES (?, ?, ?)";
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            PreparedStatement stmt = upsertConn.prepareStatement(updateStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B523122312312");
            stmt.setString(3, null);
            stmt.execute();
            stmt.setString(3, "c");
            stmt.execute();
            stmt.setString(2, "00B723122312312");
            stmt.setString(3, "e");
            stmt.execute();
            upsertConn.commit();
        }
        long upsert1Time = System.currentTimeMillis();
        long timeDelta = 100L;
        Thread.sleep(timeDelta);
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            PreparedStatement stmt = upsertConn.prepareStatement(updateStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B623122312312");
            stmt.setString(3, "e");
            stmt.execute();
        }
        long queryTime = upsert1Time + timeDelta / 2L;
        String query = "SELECT count(1) FROM " + tableName + " WHERE organization_id=? and a_string = ?";
        props.put("CurrentSCN", Long.toString(queryTime));
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, "b");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void TestPointInTimeUngroupedLimitedAggregation() throws Exception {
        String updateStmt = "upsert into " + tableName + " (    ORGANIZATION_ID,     ENTITY_ID,     A_STRING) VALUES (?, ?, ?)";
        String url = PointInTimeQueryIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            PreparedStatement stmt = upsertConn.prepareStatement(updateStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B623122312312");
            stmt.setString(3, "c");
            stmt.execute();
            stmt.setString(3, "e");
            stmt.execute();
            stmt.setString(3, "b");
            stmt.execute();
            stmt.setString(3, "b");
            stmt.execute();
        }
        long upsert1Time = System.currentTimeMillis();
        long timeDelta = 100L;
        Thread.sleep(timeDelta);
        try (Connection upsertConn = DriverManager.getConnection(url, props);){
            upsertConn.setAutoCommit(true);
            PreparedStatement stmt = upsertConn.prepareStatement(updateStmt);
            stmt.setString(1, tenantId);
            stmt.setString(2, "00B623122312312");
            stmt.setString(3, "e");
            stmt.execute();
        }
        long queryTime = upsert1Time + timeDelta / 2L;
        String query = "SELECT count(1) FROM " + tableName + " WHERE organization_id=? and a_string = ? LIMIT 3";
        props.put("CurrentSCN", Long.toString(queryTime));
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, "b");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

