/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class PhoenixRuntimeIT
extends ParallelStatsDisabledIT {
    private static void assertTenantIds(Expression e, Table htable, Filter filter, String[] tenantIds) throws IOException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        Scan scan = new Scan();
        scan.setFilter(filter);
        ResultScanner scanner = htable.getScanner(scan);
        Result result = null;
        HashSet actualTenantIds = Sets.newHashSetWithExpectedSize((int)tenantIds.length);
        HashSet<String> expectedTenantIds = new HashSet<String>(Arrays.asList(tenantIds));
        while ((result = scanner.next()) != null) {
            ResultTuple tuple = new ResultTuple(result);
            e.evaluate((Tuple)tuple, ptr);
            String tenantId = (String)PVarchar.INSTANCE.toObject(ptr);
            actualTenantIds.add(tenantId == null ? "" : tenantId);
        }
        Assert.assertTrue((boolean)actualTenantIds.containsAll(expectedTenantIds));
    }

    @Test
    public void testGetTenantIdExpressionForSaltedTable() throws Exception {
        this.testGetTenantIdExpression(true);
    }

    @Test
    public void testGetTenantIdExpressionForUnsaltedTable() throws Exception {
        this.testGetTenantIdExpression(false);
    }

    @Test
    public void testGenererateColumnInfoTenantTable() throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixRuntimeIT.getUrl());
        conn.setAutoCommit(true);
        conn.createStatement().execute("CREATE TABLE MULTITENANT_TABLE (TENANT_ID VARCHAR NOT NULL, GLOBAL_COL1 VARCHAR, GLOBAL_COL2 VARCHAR CONSTRAINT pk PRIMARY KEY (TENANT_ID, GLOBAL_COL1)) MULTI_TENANT=true");
        Properties props = new Properties();
        props.setProperty("TenantId", "MyTenantId");
        Connection tconn = DriverManager.getConnection(PhoenixRuntimeIT.getUrl(), props);
        tconn.setAutoCommit(true);
        tconn.createStatement().execute("CREATE VIEW IF NOT EXISTS TENANT_VIEW(TENANT_ONLY_COL VARCHAR) AS SELECT * FROM MULTITENANT_TABLE");
        List<String> expected = Arrays.asList("GLOBAL_COL1", "GLOBAL_COL2", "TENANT_ONLY_COL");
        List result = PhoenixRuntime.generateColumnInfo((Connection)tconn, (String)"TENANT_VIEW", null).stream().map(ColumnInfo::getDisplayName).collect(Collectors.toList());
        Assert.assertEquals(expected, result);
    }

    private static Filter getUserTableAndViewsFilter() {
        SingleColumnValueFilter tableFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, CompareOperator.EQUAL, Bytes.toBytes((String)PTableType.TABLE.getSerializedValue()));
        tableFilter.setFilterIfMissing(true);
        SingleColumnValueFilter viewFilter = new SingleColumnValueFilter(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, CompareOperator.EQUAL, Bytes.toBytes((String)PTableType.VIEW.getSerializedValue()));
        viewFilter.setFilterIfMissing(true);
        FilterList filter = new FilterList(FilterList.Operator.MUST_PASS_ONE, Arrays.asList(tableFilter, viewFilter));
        return filter;
    }

    private void testGetTenantIdExpression(boolean isSalted) throws Exception {
        Connection conn = DriverManager.getConnection(PhoenixRuntimeIT.getUrl());
        conn.setAutoCommit(true);
        Object tableName = PhoenixRuntimeIT.generateUniqueName();
        String sequenceName = PhoenixRuntimeIT.generateUniqueName();
        String t1 = PhoenixRuntimeIT.generateUniqueName();
        String t2 = t1 + PhoenixRuntimeIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + (String)tableName + " (k1 VARCHAR NOT NULL, k2 VARCHAR, CONSTRAINT PK PRIMARY KEY(K1,K2)) MULTI_TENANT=true" + (isSalted ? ",SALT_BUCKETS=3" : ""));
        conn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        conn.createStatement().execute("UPSERT INTO " + (String)tableName + " VALUES('" + t1 + "','x')");
        conn.createStatement().execute("UPSERT INTO " + (String)tableName + " VALUES('" + t2 + "','y')");
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("TenantId", t1);
        Connection tsconn = DriverManager.getConnection(PhoenixRuntimeIT.getUrl(), props);
        tsconn.createStatement().execute("CREATE SEQUENCE " + sequenceName);
        Expression e1 = PhoenixRuntime.getTenantIdExpression((Connection)tsconn, (String)PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME);
        Table htable1 = tsconn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_NAME_BYTES);
        PhoenixRuntimeIT.assertTenantIds(e1, htable1, (Filter)new FirstKeyOnlyFilter(), new String[]{"", t1});
        String viewName = PhoenixRuntimeIT.generateUniqueName();
        tsconn.createStatement().execute("CREATE VIEW " + viewName + "(V1 VARCHAR) AS SELECT * FROM " + (String)tableName);
        Expression e2 = PhoenixRuntime.getTenantIdExpression((Connection)tsconn, (String)PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
        Table htable2 = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
        PhoenixRuntimeIT.assertTenantIds(e2, htable2, PhoenixRuntimeIT.getUserTableAndViewsFilter(), new String[]{"", t1});
        Expression e3 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)tableName);
        Table htable3 = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)tableName));
        PhoenixRuntimeIT.assertTenantIds(e3, htable3, (Filter)new FirstKeyOnlyFilter(), new String[]{t1, t2});
        String basTableName = PhoenixRuntimeIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + basTableName + " (k1 VARCHAR PRIMARY KEY)");
        Expression e4 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)basTableName);
        Assert.assertNull((Object)e4);
        String indexName1 = PhoenixRuntimeIT.generateUniqueName();
        tsconn.createStatement().execute("CREATE INDEX " + indexName1 + " ON " + viewName + "(V1)");
        Expression e5 = PhoenixRuntime.getTenantIdExpression((Connection)tsconn, (String)indexName1);
        Table htable5 = tsconn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)("_IDX_" + (String)tableName)));
        PhoenixRuntimeIT.assertTenantIds(e5, htable5, (Filter)new FirstKeyOnlyFilter(), new String[]{t1});
        String indexName2 = PhoenixRuntimeIT.generateUniqueName();
        conn.createStatement().execute("CREATE INDEX " + indexName2 + " ON " + (String)tableName + "(k2)");
        Expression e6 = PhoenixRuntime.getTenantIdExpression((Connection)conn, (String)indexName2);
        Table htable6 = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)indexName2));
        PhoenixRuntimeIT.assertTenantIds(e6, htable6, (Filter)new FirstKeyOnlyFilter(), new String[]{t1, t2});
        tableName = PhoenixRuntimeIT.generateUniqueName() + "BAR_" + (isSalted ? "SALTED" : "UNSALTED");
        conn.createStatement().execute("CREATE TABLE " + (String)tableName + " (k1 VARCHAR NOT NULL, k2 VARCHAR, CONSTRAINT PK PRIMARY KEY(K1,K2)) " + (isSalted ? "SALT_BUCKETS=3" : ""));
        conn.createStatement().execute("UPSERT INTO " + (String)tableName + " VALUES('" + t1 + "','x')");
        conn.createStatement().execute("UPSERT INTO " + (String)tableName + " VALUES('" + t2 + "','y')");
        Expression e7 = PhoenixRuntime.getFirstPKColumnExpression((Connection)conn, (String)tableName);
        Table htable7 = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)tableName));
        PhoenixRuntimeIT.assertTenantIds(e7, htable7, (Filter)new FirstKeyOnlyFilter(), new String[]{t1, t2});
    }
}

