/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class PhoenixRowTimestampFunctionIT
extends ParallelStatsDisabledIT {
    private final boolean encoded;
    private final boolean optimized;
    private final String tableDDLOptions;
    private static final int NUM_ROWS = 5;
    private static final long TS_OFFSET = 120000L;

    public PhoenixRowTimestampFunctionIT(PTable.QualifierEncodingScheme encoding, PTable.ImmutableStorageScheme storage) {
        StringBuilder optionBuilder = new StringBuilder();
        boolean bl = this.optimized = storage == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS;
        boolean bl2 = encoding != PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS ? true : (this.encoded = this.optimized);
        if (this.optimized && encoding == PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS) {
            optionBuilder.append(" COLUMN_ENCODED_BYTES = " + PTable.QualifierEncodingScheme.ONE_BYTE_QUALIFIERS.ordinal());
        } else {
            optionBuilder.append(" COLUMN_ENCODED_BYTES = " + encoding.ordinal());
        }
        optionBuilder.append(", IMMUTABLE_STORAGE_SCHEME = " + storage.toString());
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="encoding={0},storage={1}")
    public static synchronized Collection<Object[]> data() {
        ArrayList list = Lists.newArrayList();
        for (PTable.QualifierEncodingScheme encoding : PTable.QualifierEncodingScheme.values()) {
            for (PTable.ImmutableStorageScheme storage : PTable.ImmutableStorageScheme.values()) {
                list.add(new Object[]{encoding, storage});
            }
        }
        return list;
    }

    private void verifyHbaseAllRowsTimestamp(String tableName, ResultSet rs, int expectedRowCount) throws Exception {
        Scan scan = new Scan();
        byte[] emptyKVQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((boolean)this.encoded).getFirst();
        try (Connection hconn = ConnectionFactory.createConnection((Configuration)config);){
            Table table = hconn.getTable(TableName.valueOf((String)tableName));
            ResultScanner resultScanner = table.getScanner(scan);
            int rowCount = 0;
            while (rs.next()) {
                Result result = resultScanner.next();
                long timeStamp = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, emptyKVQualifier).getTimestamp();
                Assert.assertEquals((long)rs.getDate(1).getTime(), (long)timeStamp);
                ++rowCount;
            }
            Assert.assertEquals((long)expectedRowCount, (long)rowCount);
        }
    }

    private void verifyHbaseRowTimestamp(String tableName, String rowKey, Date expectedTimestamp) throws Exception {
        byte[] emptyKVQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((boolean)this.encoded).getFirst();
        try (Connection hconn = ConnectionFactory.createConnection((Configuration)config);){
            Table table = hconn.getTable(TableName.valueOf((String)tableName));
            Get get = new Get(Bytes.toBytesBinary((String)rowKey));
            Result result = table.get(get);
            Assert.assertFalse((boolean)result.isEmpty());
            long timeStamp = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, emptyKVQualifier).getTimestamp();
            Assert.assertEquals((long)expectedTimestamp.getTime(), (long)timeStamp);
        }
    }

    private String createTestData(long rowTimestamp, int numRows) throws Exception {
        String tableName = PhoenixRowTimestampFunctionIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            try (Statement stmt = conn.createStatement();){
                String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (PK1 INTEGER NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR, KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2))" + this.tableDDLOptions;
                stmt.execute(ddl);
            }
            String dml = "UPSERT INTO " + tableName + " (PK1, PK2, KV1, KV2) VALUES (?, ?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(dml);){
                Date rowTimestampDate = new Date(rowTimestamp);
                int count = numRows;
                int id = 0;
                while (id < count) {
                    int idValue = id++;
                    stmt.setInt(1, idValue);
                    stmt.setDate(2, rowTimestampDate);
                    stmt.setString(3, "KV1_" + idValue);
                    stmt.setString(4, "KV2_" + idValue);
                    stmt.executeUpdate();
                }
            }
            conn.commit();
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowTimestampDefault() throws Exception {
        if (this.encoded || this.optimized) {
            return;
        }
        String tableName = PhoenixRowTimestampFunctionIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            ResultSet rs;
            String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (PK INTEGER NOT NULL PRIMARY KEY, KV1 VARCHAR, KV2 VARCHAR)" + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            String dml = "UPSERT INTO " + tableName + " (PK, KV1, KV2) VALUES (?, ?, ?)";
            try (PreparedStatement stmt = conn.prepareStatement(dml);){
                int count = 5;
                for (int id = 0; id < count; ++id) {
                    stmt.setInt(1, id);
                    stmt.setString(2, "KV1_" + id);
                    stmt.setString(3, "KV2_" + id);
                    stmt.executeUpdate();
                }
            }
            finally {
                conn.commit();
            }
            String dql = "SELECT PHOENIX_ROW_TIMESTAMP() FROM " + tableName;
            try (Statement stmt = conn.createStatement();){
                rs = stmt.executeQuery(dql);
                this.verifyHbaseAllRowsTimestamp(tableName, rs, 5);
            }
            try {
                stmt = conn.createStatement();
                try {
                    stmt.execute("UPSERT INTO " + tableName + " (PK, KV1) VALUES (2, 'KV1_foo')");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                conn.commit();
            }
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(dql);
                this.verifyHbaseAllRowsTimestamp(tableName, rs, 5);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            dql = "SELECT ROWKEY_BYTES_STRING(), PHOENIX_ROW_TIMESTAMP() FROM " + tableName + " WHERE PK >= 1 AND PK <=3 ";
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(dql);
                while (rs.next()) {
                    this.verifyHbaseRowTimestamp(tableName, rs.getString(1), rs.getDate(2));
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowTimestampColumn() throws Exception {
        String tableName = PhoenixRowTimestampFunctionIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String ddl = "CREATE TABLE IF NOT EXISTS " + tableName + " (PK1 INTEGER NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR, KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 ROW_TIMESTAMP))" + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            String dml = "UPSERT INTO " + tableName + " (PK1, PK2, KV1, KV2) VALUES (?, ?, ?, ?)";
            long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis();
            Date rowTimestampDate = new Date(rowTimestamp);
            try (PreparedStatement stmt = conn.prepareStatement(dml);){
                int count = 5;
                for (int id = 0; id < count; ++id) {
                    stmt.setInt(1, id);
                    stmt.setDate(2, rowTimestampDate);
                    stmt.setString(3, "KV1_" + id);
                    stmt.setString(4, "KV2_" + id);
                    stmt.executeUpdate();
                }
            }
            finally {
                conn.commit();
            }
            String dql = "SELECT PHOENIX_ROW_TIMESTAMP() FROM " + tableName;
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(dql);
                while (rs.next()) {
                    Assert.assertEquals((Object)rs.getDate(1), (Object)rowTimestampDate);
                }
            }
        }
    }

    @Test
    public void testRowTimestampFunctionAndEqualPredicate() throws Exception {
        ResultSet rs;
        Statement stmt;
        String sql;
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() + 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            sql = "SELECT PHOENIX_ROW_TIMESTAMP() FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() = PK2 ";
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(sql);
                Assert.assertFalse((boolean)rs.next());
                rs.close();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());
        try {
            sql = "SELECT PHOENIX_ROW_TIMESTAMP(), KV1 FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() = PK2 ";
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(sql);
                Assert.assertFalse((boolean)rs.next());
                rs.close();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testRowTimestampFunctionOnlyWithLessThanPredicate() throws Exception {
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() + 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String sql = "SELECT PHOENIX_ROW_TIMESTAMP() FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() < PK2 ";
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(sql);
                int actualCount = 0;
                while (rs.next()) {
                    Assert.assertTrue((boolean)rs.getDate(1).before(new Date(rowTimestamp)));
                    ++actualCount;
                }
                Assert.assertEquals((long)5L, (long)actualCount);
                rs.close();
            }
        }
    }

    @Test
    public void testRowTimestampFunctionAndAdditionalColsWithLessThanPredicate() throws Exception {
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() + 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String sql = "SELECT PHOENIX_ROW_TIMESTAMP(), KV2 FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() < PK2 ";
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(sql);
                int actualCount = 0;
                while (rs.next()) {
                    Assert.assertTrue((boolean)rs.getDate(1).before(new Date(rowTimestamp)));
                    rs.getString(2);
                    Assert.assertFalse((boolean)rs.wasNull());
                    ++actualCount;
                }
                Assert.assertEquals((long)5L, (long)actualCount);
                rs.close();
            }
        }
    }

    @Test
    public void testRowTimestampFunctionOnlyWithGreaterThanPredicate() throws Exception {
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() - 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String sql = "SELECT PHOENIX_ROW_TIMESTAMP() FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() > PK2 ";
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(sql);
                int actualCount = 0;
                while (rs.next()) {
                    Assert.assertTrue((boolean)rs.getDate(1).after(new Date(rowTimestamp)));
                    ++actualCount;
                }
                Assert.assertEquals((long)5L, (long)actualCount);
                rs.close();
            }
        }
    }

    @Test
    public void testRowTimestampFunctionAndColsWithGreaterThanPredicate() throws Exception {
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() - 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String sql = "SELECT PHOENIX_ROW_TIMESTAMP(), KV1 FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() > PK2 ";
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(sql);
                int actualCount = 0;
                while (rs.next()) {
                    Assert.assertTrue((boolean)rs.getDate(1).after(new Date(rowTimestamp)));
                    rs.getString(2);
                    Assert.assertFalse((boolean)rs.wasNull());
                    ++actualCount;
                }
                Assert.assertEquals((long)5L, (long)actualCount);
                rs.close();
            }
        }
    }

    @Test
    public void testSimpleSelectColsWithPhoenixRowTimestampPredicate() throws Exception {
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() - 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String sql = "SELECT KV1 FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() > PK2 ";
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(sql);
                int actualCount = 0;
                while (rs.next()) {
                    String kv1Value = rs.getString(1);
                    Assert.assertFalse((boolean)rs.wasNull());
                    Assert.assertTrue((kv1Value.substring(0, "KV2_".length()).compareToIgnoreCase("KV1_") == 0 ? 1 : 0) != 0);
                    ++actualCount;
                }
                Assert.assertEquals((long)5L, (long)actualCount);
                rs.close();
            }
        }
    }

    @Test
    public void testSelectCountWithPhoenixRowTimestampPredicate() throws Exception {
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() - 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String sql = "SELECT COUNT(*) FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() > PK2 ";
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int rowCount = rs.getInt(1);
                    Assert.assertFalse((boolean)rs.wasNull());
                    Assert.assertTrue((rowCount == 5 ? 1 : 0) != 0);
                }
                rs.close();
            }
        }
    }

    @Test
    public void testSelectWithMultiplePredicates() throws Exception {
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() - 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String sql = "SELECT COUNT(*) FROM " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() > PK2 AND KV1 = 'KV1_1'";
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int rowCount = rs.getInt(1);
                    Assert.assertFalse((boolean)rs.wasNull());
                    Assert.assertTrue((rowCount == 1 ? 1 : 0) != 0);
                }
                rs.close();
            }
        }
    }

    @Test
    public void testTimestampComparePredicate() throws Exception {
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() - 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            int rowCount;
            ResultSet rs;
            String sql;
            try (Statement stmt = conn.createStatement();){
                sql = "SELECT COUNT(*) FROM " + tableName + " WHERE ((PHOENIX_ROW_TIMESTAMP() > PK2) AND  (PHOENIX_ROW_TIMESTAMP() > TO_TIME('2005-10-01 14:03:22.559')))";
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    rowCount = rs.getInt(1);
                    Assert.assertFalse((boolean)rs.wasNull());
                    Assert.assertTrue((rowCount == 5 ? 1 : 0) != 0);
                }
                rs.close();
            }
            stmt = conn.createStatement();
            try {
                sql = "SELECT COUNT(*) FROM " + tableName + " WHERE ((PHOENIX_ROW_TIMESTAMP() > PK2) AND  (PHOENIX_ROW_TIMESTAMP() < TO_TIME('2005-10-01 14:03:22.559')))";
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    rowCount = rs.getInt(1);
                    Assert.assertFalse((boolean)rs.wasNull());
                    Assert.assertTrue((rowCount == 0 ? 1 : 0) != 0);
                }
                rs.close();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testPhoenixRowTimestampWhenAggShouldFail() throws Exception {
        if (this.encoded || !this.optimized) {
            return;
        }
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() - 120000L;
        String tableName = this.createTestData(rowTimestamp, 5);
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());
             Statement stmt = conn.createStatement();){
            String sql = "SELECT PHOENIX_ROW_TIMESTAMP(), PK1, COUNT(*) FROM " + tableName + " WHERE ((PHOENIX_ROW_TIMESTAMP() > PK2) AND  (PHOENIX_ROW_TIMESTAMP() > TO_TIME('2005-10-01 14:03:22.559'))) GROUP BY PHOENIX_ROW_TIMESTAMP(), PK1";
            try {
                ResultSet rs = stmt.executeQuery(sql);
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("ERROR 1018 (42Y27"));
            }
        }
    }

    @Test
    public void testPhoenixRowTimestampWithWildcard() throws Exception {
        try (java.sql.Connection conn = DriverManager.getConnection(PhoenixRowTimestampFunctionIT.getUrl());){
            String dataTableName = PhoenixRowTimestampFunctionIT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (pk1 integer not null primary key, x.v1 float, y.v2 float, z.v3 float)" + this.tableDDLOptions);
            conn.createStatement().execute("upsert into " + dataTableName + " values(rand() * 100000000, rand(), rand(), rand())");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT v1 from " + dataTableName);
            Assert.assertTrue((boolean)rs.next());
            float v1 = rs.getFloat(1);
            rs = conn.createStatement().executeQuery("SELECT * from " + dataTableName + " order by phoenix_row_timestamp()");
            Assert.assertTrue((boolean)rs.next());
            System.out.println(v1);
            Assert.assertTrue((v1 == rs.getFloat(2) ? 1 : 0) != 0);
        }
    }
}

