/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixDriverIT
extends BaseTest {
    private static HBaseTestingUtility hbaseTestUtil;
    private static String zkQuorum;
    private static Configuration conf;

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        conf = HBaseConfiguration.create();
        hbaseTestUtil = new HBaseTestingUtility(conf);
        PhoenixDriverIT.setUpConfigForMiniCluster(conf);
        conf.set("phoenix.jdbc.extra.arguments", "");
        hbaseTestUtil.startMiniCluster();
        zkQuorum = "localhost:" + hbaseTestUtil.getZkCluster().getClientPort();
        url = "jdbc:phoenix+zk:" + zkQuorum;
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    public Connection createConnection(String tenantId, boolean isDifferentClient) throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.sequence.returnValues", "false");
        props.put("phoenix.jdbc.extra.arguments", "");
        if (tenantId != null) {
            props.setProperty("TenantId", tenantId);
        }
        if (isDifferentClient) {
            ConnectionInfo info = ConnectionInfo.createNoLogin((String)url, null, (Properties)props);
            return DriverManager.getConnection(info.withPrincipal(tenantId).toUrl(), props);
        }
        return DriverManager.getConnection(url, props);
    }

    @Test
    public void testReturnAllSequencesNotCalledForNoOpenConnections() throws Exception {
        String schemaName = "S";
        String sequenceNameWithoutSchema = PhoenixDriverIT.generateUniqueSequenceName();
        String sequenceName = SchemaUtil.getTableName((String)schemaName, (String)sequenceNameWithoutSchema);
        Connection conn = this.createConnection(null, false);
        conn.createStatement().execute("CREATE SEQUENCE " + sequenceName + " START WITH 3 INCREMENT BY 2 CACHE 5");
        Object query = "SELECT NEXT VALUE FOR " + sequenceName;
        ResultSet rs = conn.prepareStatement((String)query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.prepareStatement((String)query).executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)5L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
        conn = this.createConnection(null, false);
        query = "SELECT CURRENT_VALUE FROM \"SYSTEM\".\"SEQUENCE\" WHERE SEQUENCE_SCHEMA=? AND SEQUENCE_NAME=?";
        PreparedStatement preparedStatement = conn.prepareStatement((String)query);
        preparedStatement.setString(1, schemaName);
        preparedStatement.setString(2, sequenceNameWithoutSchema);
        rs = preparedStatement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)13L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testViewParentIndexLookupMutipleClients() throws Exception {
        this.helpTestViewParentIndexLookupMutipleClients(false);
    }

    @Test
    public void testMulitTenantViewParentIndexLookupMutipleClients() throws Exception {
        this.helpTestViewParentIndexLookupMutipleClients(true);
    }

    public void helpTestViewParentIndexLookupMutipleClients(boolean isMultiTenant) throws Exception {
        String baseTableName = PhoenixDriverIT.generateUniqueName();
        String baseTableIndexName = PhoenixDriverIT.generateUniqueName();
        String viewName = PhoenixDriverIT.generateUniqueName();
        try (Connection globalConn = this.createConnection(null, false);
             Connection conn1 = this.createConnection("tenant1", false);
             PhoenixConnection conn2 = (PhoenixConnection)this.createConnection("tenant1", false);){
            String baseTableDdl = "CREATE TABLE " + baseTableName + " (" + (isMultiTenant ? "TENANT_ID VARCHAR(1) NOT NULL," : "") + "PK CHAR(1) NOT NULL,V1 CHAR(1),V2 CHAR(1),V3 CHAR(1)CONSTRAINT pk PRIMARY KEY (" + (isMultiTenant ? "TENANT_ID," : "") + " pk))";
            globalConn.createStatement().execute(baseTableDdl);
            globalConn.createStatement().execute("CREATE INDEX " + baseTableIndexName + " ON " + baseTableName + " (V2) INCLUDE (v1, V3)");
            String viewDDL = "CREATE VIEW " + viewName + " AS SELECT * FROM " + baseTableName + " WHERE V1 = 'X'";
            conn1.createStatement().execute(viewDDL);
            conn1.commit();
            String sql = "SELECT V3 FROM " + viewName + " WHERE V2 = '3'";
            PhoenixStatement stmt = conn1.createStatement().unwrap(PhoenixStatement.class);
            stmt.executeQuery(sql);
            PTable indexTable = stmt.getQueryPlan().getTableRef().getTable();
            String tableName = indexTable.getName().getString();
            String expectedTableName = viewName + "#" + baseTableIndexName;
            Assert.assertEquals((String)"Parent Index table is not used ", (Object)expectedTableName, (Object)tableName);
            PTable table = conn2.getTable(tableName);
            Assert.assertEquals((Object)indexTable, (Object)table);
        }
    }

    @Test
    public void testMapMultiTenantTableToNamespaceDuringUpgrade() throws SQLException, SnapshotCreationException, IllegalArgumentException, IOException, InterruptedException {
        String[] tenantIds;
        String schemaName = "S_" + PhoenixDriverIT.generateUniqueName();
        String tableName = "T_" + PhoenixDriverIT.generateUniqueName();
        String phoenixFullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewName1 = "VB_" + PhoenixDriverIT.generateUniqueName();
        String viewName2 = "VC_" + PhoenixDriverIT.generateUniqueName();
        try (Connection conn = this.createConnection(null, false);){
            conn.createStatement().execute("CREATE TABLE " + phoenixFullTableName + "(k VARCHAR not null, v INTEGER not null, f INTEGER, g INTEGER NULL, h INTEGER NULL CONSTRAINT pk PRIMARY KEY(k,v)) MULTI_TENANT=true");
        }
        for (String tenantId : tenantIds = new String[]{"tenant1", "tenant2"}) {
            try (Connection conn = this.createConnection(tenantId, false);){
                conn.createStatement().execute("CREATE VIEW " + schemaName + "." + viewName1 + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
                conn.createStatement().execute("CREATE VIEW " + schemaName + "." + viewName2 + " (col2 VARCHAR) AS SELECT * FROM " + schemaName + "." + viewName1);
            }
        }
        try (Connection conn = this.createConnection(null, true);){
            String url = conn.unwrap(PhoenixConnection.class).getURL();
            Properties props = new Properties();
            props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
            props.setProperty("phoenix.schema.mapSystemTablesToNamespace", Boolean.toString(false));
            try (PhoenixConnection phxConn = DriverManager.getConnection(url, props).unwrap(PhoenixConnection.class);){
                UpgradeUtil.upgradeTable((PhoenixConnection)phxConn, (String)phoenixFullTableName);
            }
            String physicalTableName = SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)tableName, (boolean)true).getString();
            for (String tenantId : tenantIds) {
                Assert.assertEquals((Object)physicalTableName, (Object)this.getPhysicalTable(conn, tenantId, schemaName, viewName1));
                Assert.assertEquals((Object)physicalTableName, (Object)this.getPhysicalTable(conn, tenantId, schemaName, viewName2));
            }
        }
    }

    private String getPhysicalTable(Connection conn, String tenantId, String schemeName, String tableName) throws SQLException {
        String query = "SELECT COLUMN_FAMILY FROM SYSTEM.CATALOG WHERE TENANT_ID=? AND TABLE_SCHEM=? AND TABLE_NAME=? AND LINK_TYPE=" + PTable.LinkType.PHYSICAL_TABLE.getSerializedValue();
        PreparedStatement stmt = conn.prepareStatement(query);
        stmt.setString(1, tenantId);
        stmt.setString(2, schemeName);
        stmt.setString(3, tableName);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        String physicalTableName = rs.getString(1);
        Assert.assertFalse((boolean)rs.next());
        return physicalTableName;
    }

    @Test
    public void testDifferentQueryServiceForServerConnection() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(QueryUtil.getConnectionUrl((Properties)props, (Configuration)conf), props);
        Connection serverConn = QueryUtil.getConnectionOnServer((Properties)props, (Configuration)conf);
        ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
        ConnectionQueryServices serverCqs = serverConn.unwrap(PhoenixConnection.class).getQueryServices();
        Assert.assertNotSame((Object)cqs, (Object)serverCqs);
    }
}

