/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.QueryBuilder;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class ParallelStatsDisabledIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        ParallelStatsDisabledIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    protected ResultSet executeQueryThrowsException(Connection conn, QueryBuilder queryBuilder, String expectedPhoenixExceptionMsg, String expectedSparkExceptionMsg) {
        ResultSet rs = null;
        try {
            rs = this.executeQuery(conn, queryBuilder);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(expectedPhoenixExceptionMsg));
        }
        return rs;
    }

    public static void validateQueryPlan(Connection conn, QueryBuilder queryBuilder, String expectedPhoenixPlan, String expectedSparkPlan) throws SQLException {
        if (StringUtils.isNotBlank((CharSequence)expectedPhoenixPlan)) {
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + queryBuilder.build());
            Assert.assertEquals((Object)expectedPhoenixPlan, (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        }
    }
}

