/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class ParallelIteratorsIT
extends ParallelStatsEnabledIT {
    protected static final byte[] KMIN = new byte[]{33};
    protected static final byte[] KMIN2 = new byte[]{46};
    protected static final byte[] K1 = new byte[]{97};
    protected static final byte[] K3 = new byte[]{99};
    protected static final byte[] K4 = new byte[]{100};
    protected static final byte[] K5 = new byte[]{101};
    protected static final byte[] K6 = new byte[]{102};
    protected static final byte[] K9 = new byte[]{105};
    protected static final byte[] K11 = new byte[]{107};
    protected static final byte[] K12 = new byte[]{108};
    protected static final byte[] KMAX = new byte[]{126};
    protected static final byte[] KMAX2 = new byte[]{122};
    protected static final byte[] KR = new byte[]{114};
    protected static final byte[] KP = new byte[]{112};
    private String tableName;
    private String indexName;

    @Before
    public void generateTableNames() {
        this.tableName = "T_" + ParallelIteratorsIT.generateUniqueName();
        this.indexName = "I_" + ParallelIteratorsIT.generateUniqueName();
    }

    private List<KeyRange> getSplits(Connection conn, byte[] lowerRange, byte[] upperRange) throws SQLException {
        return TestUtil.getSplits(conn, this.tableName, "ID", lowerRange, upperRange, null, "COUNT(*)");
    }

    @Test
    public void testGetSplits() throws Exception {
        Connection conn = DriverManager.getConnection(ParallelIteratorsIT.getUrl(), TestUtil.TEST_PROPERTIES);
        byte[][] splits = new byte[][]{K3, K4, K9, K11};
        this.createTable(conn, splits);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.tableName + " VALUES (?, ?)");
        stmt.setString(1, new String(KMIN));
        stmt.setInt(2, 1);
        stmt.execute();
        stmt.setString(1, new String(KMAX));
        stmt.setInt(2, 2);
        stmt.execute();
        conn.commit();
        conn.createStatement().execute("UPDATE STATISTICS " + this.tableName);
        List<KeyRange> keyRanges = TestUtil.getAllSplits(conn, this.tableName);
        Assert.assertEquals((String)("Unexpected number of splits: " + keyRanges), (long)7L, (long)keyRanges.size());
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(KeyRange.UNBOUND, KMIN), (Object)keyRanges.get(0));
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(KMIN, K3), (Object)keyRanges.get(1));
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(K3, K4), (Object)keyRanges.get(2));
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(K4, K9), (Object)keyRanges.get(3));
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(K9, K11), (Object)keyRanges.get(4));
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(K11, KMAX), (Object)keyRanges.get(5));
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(KMAX, KeyRange.UNBOUND), (Object)keyRanges.get(6));
        keyRanges = this.getSplits(conn, K3, K6);
        Assert.assertEquals((String)("Unexpected number of splits: " + keyRanges), (long)2L, (long)keyRanges.size());
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(K3, K4), (Object)keyRanges.get(0));
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(K4, K6), (Object)keyRanges.get(1));
        keyRanges = this.getSplits(conn, K5, K6);
        Assert.assertEquals((String)("Unexpected number of splits: " + keyRanges), (long)1L, (long)keyRanges.size());
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(K5, K6), (Object)keyRanges.get(0));
        keyRanges = this.getSplits(conn, null, K1);
        Assert.assertEquals((String)("Unexpected number of splits: " + keyRanges), (long)2L, (long)keyRanges.size());
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(KeyRange.UNBOUND, KMIN), (Object)keyRanges.get(0));
        Assert.assertEquals((Object)ParallelIteratorsIT.newKeyRange(KMIN, K1), (Object)keyRanges.get(1));
        conn.close();
    }

    @Test
    public void testServerNameOnScan() throws Exception {
        Connection conn = DriverManager.getConnection(ParallelIteratorsIT.getUrl(), TestUtil.TEST_PROPERTIES);
        byte[][] splits = new byte[][]{K3, K9, KR};
        this.createTable(conn, splits);
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.tableName + " LIMIT 1");
        rs.next();
        QueryPlan plan = stmt.getQueryPlan();
        List nestedScans = plan.getScans();
        Assert.assertNotNull((Object)nestedScans);
        for (List scans : nestedScans) {
            for (Scan scan : scans) {
                byte[] serverNameBytes = scan.getAttribute("_SCAN_REGION_SERVER");
                Assert.assertNotNull((Object)serverNameBytes);
                ServerName serverName = ServerName.parseVersionedServerName((byte[])serverNameBytes);
                Assert.assertNotNull((Object)serverName.getHostname());
            }
        }
    }

    @Test
    public void testGuidePostsLifeCycle() throws Exception {
        Connection conn = DriverManager.getConnection(ParallelIteratorsIT.getUrl(), TestUtil.TEST_PROPERTIES);
        byte[][] splits = new byte[][]{K3, K9, KR};
        this.createTable(conn, splits);
        conn.createStatement().execute("CREATE INDEX " + this.indexName + " ON " + this.tableName + "( \"value\")");
        List<KeyRange> keyRanges = TestUtil.getAllSplits(conn, this.tableName);
        Assert.assertEquals((long)4L, (long)keyRanges.size());
        this.upsert(conn, new byte[][]{KMIN, K4, K11});
        TestUtil.analyzeTableColumns(conn, this.tableName);
        keyRanges = TestUtil.getAllSplits(conn, this.tableName);
        Assert.assertEquals((long)7L, (long)keyRanges.size());
        List<KeyRange> indexSplits = TestUtil.getAllSplits(conn, this.indexName);
        Assert.assertEquals((long)1L, (long)indexSplits.size());
        TestUtil.analyzeTableIndex(conn, this.tableName);
        keyRanges = TestUtil.getAllSplits(conn, this.tableName);
        Assert.assertEquals((long)7L, (long)keyRanges.size());
        indexSplits = TestUtil.getAllSplits(conn, this.indexName);
        Assert.assertEquals((long)4L, (long)indexSplits.size());
        this.upsert(conn, new byte[][]{KMIN2, K5, K12});
        TestUtil.analyzeTable(conn, this.tableName);
        keyRanges = TestUtil.getAllSplits(conn, this.tableName);
        Assert.assertEquals((long)10L, (long)keyRanges.size());
        indexSplits = TestUtil.getAllSplits(conn, this.indexName);
        Assert.assertEquals((long)7L, (long)indexSplits.size());
        this.upsert(conn, new byte[][]{K1, K6, KP});
        TestUtil.analyzeTableColumns(conn, this.tableName);
        keyRanges = TestUtil.getAllSplits(conn, this.tableName);
        Assert.assertEquals((long)13L, (long)keyRanges.size());
        indexSplits = TestUtil.getAllSplits(conn, this.indexName);
        Assert.assertEquals((long)7L, (long)indexSplits.size());
        TestUtil.analyzeTableIndex(conn, this.tableName);
        indexSplits = TestUtil.getAllSplits(conn, this.indexName);
        Assert.assertEquals((long)10L, (long)indexSplits.size());
        keyRanges = TestUtil.getAllSplits(conn, this.tableName);
        Assert.assertEquals((long)13L, (long)keyRanges.size());
        conn.close();
    }

    private void upsert(Connection conn, byte[][] val) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("upsert into " + this.tableName + " VALUES (?, ?)");
        stmt.setString(1, new String(val[0]));
        stmt.setInt(2, 1);
        stmt.execute();
        stmt.setString(1, new String(val[1]));
        stmt.setInt(2, 2);
        stmt.execute();
        stmt.setString(1, new String(val[2]));
        stmt.setInt(2, 3);
        stmt.execute();
        conn.commit();
    }

    private static KeyRange newKeyRange(byte[] lowerRange, byte[] upperRange) {
        return PChar.INSTANCE.getKeyRange(lowerRange, true, upperRange, false, SortOrder.ASC);
    }

    private void createTable(Connection conn, byte[][] splits) throws SQLException {
        ArrayList<CallSite> splitsList = new ArrayList<CallSite>(splits.length);
        for (byte[] split : splits) {
            splitsList.add((CallSite)((Object)("'" + Bytes.toString((byte[])split) + "'")));
        }
        conn.createStatement().execute("create table " + this.tableName + "   (id char(1) not null primary key,\n    \"value\" integer) SPLIT ON (" + Joiner.on((char)',').join(splitsList) + ")");
    }
}

