/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class OnDuplicateKeyIT
extends ParallelStatsDisabledIT {
    private final String indexDDL;

    public OnDuplicateKeyIT(String indexDDL) {
        this.indexDDL = indexDDL;
    }

    @Parameterized.Parameters
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(new String[]{""});
        testCases.add(new String[]{"create local index %s_IDX on %s(counter1) include (counter2)"});
        testCases.add(new String[]{"create local index %s_IDX on %s(counter1, counter2)"});
        testCases.add(new String[]{"create index %s_IDX on %s(counter1) include (counter2)"});
        testCases.add(new String[]{"create index %s_IDX on %s(counter1, counter2)"});
        testCases.add(new String[]{"create uncovered index %s_IDX on %s(counter1)"});
        testCases.add(new String[]{"create uncovered index %s_IDX on %s(counter1, counter2)"});
        return testCases;
    }

    private void createIndex(java.sql.Connection conn, String tableName) throws SQLException {
        if (this.indexDDL == null || this.indexDDL.length() == 0) {
            return;
        }
        String ddl = String.format(this.indexDDL, tableName, tableName);
        conn.createStatement().execute(ddl);
    }

    @Test
    public void testNewAndUpdateOnSingleNumericColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 smallint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        String dml = "UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)0L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute(dml);
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)1L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testNewAndUpdateOnSingleNumericColumnWithOtherColumns() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(k1 varchar, k2 varchar, counter1 varchar, counter2 date, other1 char(3), other2 varchar default 'f', constraint pk primary key (k1,k2))";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        String dml = "UPSERT INTO " + tableName + " VALUES('a','b','c',null,'eee') ON DUPLICATE KEY UPDATE counter1 = counter1 || CASE WHEN LENGTH(counter1) < 10 THEN 'SMALL' ELSE 'LARGE' END || k2 || other2 || other1 ";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertEquals((Object)"c", (Object)rs.getString(3));
        Assert.assertEquals(null, (Object)rs.getDate(4));
        Assert.assertEquals((Object)"eee", (Object)rs.getString(5));
        Assert.assertEquals((Object)"f", (Object)rs.getString(6));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute(dml);
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertEquals((Object)"cSMALLbfeee", (Object)rs.getString(3));
        Assert.assertEquals(null, (Object)rs.getDate(4));
        Assert.assertEquals((Object)"eee", (Object)rs.getString(5));
        Assert.assertEquals((Object)"f", (Object)rs.getString(6));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute(dml);
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertEquals((Object)"cSMALLbfeeeLARGEbfeee", (Object)rs.getString(3));
        Assert.assertEquals(null, (Object)rs.getDate(4));
        Assert.assertEquals((Object)"eee", (Object)rs.getString(5));
        Assert.assertEquals((Object)"f", (Object)rs.getString(6));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a','b','c',null,'eee') ON DUPLICATE KEY UPDATE counter1 = to_char(rand()), counter2 = current_date() + 1");
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        double d = Double.parseDouble(rs.getString(3));
        Assert.assertTrue((d >= 0.0 && d <= 1.0 ? 1 : 0) != 0);
        Date date = rs.getDate(4);
        Assert.assertTrue((boolean)date.after(new Date(System.currentTimeMillis())));
        Assert.assertEquals((Object)"eee", (Object)rs.getString(5));
        Assert.assertEquals((Object)"f", (Object)rs.getString(6));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testNewAndUpdateOnSingleVarcharColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 varchar, counter2 smallint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        String dml = "UPSERT INTO " + tableName + " VALUES('a','b') ON DUPLICATE KEY UPDATE counter1 = counter1 || 'b'";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE substr(counter1,1,1) = 'b'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute(dml);
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE substr(counter1,1,1) = 'b'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bb", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testDeleteOnSingleVarcharColumnAutoCommit() throws Exception {
        this.testDeleteOnSingleVarcharColumn(true);
    }

    @Test
    public void testDeleteOnSingleVarcharColumnNoAutoCommit() throws Exception {
        this.testDeleteOnSingleVarcharColumn(false);
    }

    private void testDeleteOnSingleVarcharColumn(boolean autoCommit) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        conn.setAutoCommit(autoCommit);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 varchar, counter2 smallint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        String dml = "UPSERT INTO " + tableName + " VALUES('a','b') ON DUPLICATE KEY UPDATE counter1 = null";
        conn.createStatement().execute(dml);
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        dml = "UPSERT INTO " + tableName + " VALUES('a','b',0)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES('a','b', 0) ON DUPLICATE KEY UPDATE counter1 = null, counter2 = counter2 + 1";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES('a','b', 0) ON DUPLICATE KEY UPDATE counter1 = 'c', counter2 = counter2 + 1";
        conn.createStatement().execute(dml);
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"c", (Object)rs.getString(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testIgnoreOnSingleColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 bigint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',10)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY IGNORE");
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testInitialIgnoreWithUpdateOnSingleColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 bigint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',10) ON DUPLICATE KEY IGNORE");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)11L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testOverrideOnDupKeyUpdateWithUpsert() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 bigint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',1) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',2) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',10)");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)10L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testNewAndMultiUpdateOnSingleColumnAutoCommit() throws Exception {
        this.testNewAndMultiUpdateOnSingleColumn(true);
    }

    @Test
    public void testNewAndMultiUpdateOnSingleColumnNoAutoCommit() throws Exception {
        this.testNewAndMultiUpdateOnSingleColumn(false);
    }

    private void testNewAndMultiUpdateOnSingleColumn(boolean autoCommit) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        conn.setAutoCommit(autoCommit);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 integer)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',5) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY IGNORE");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',10) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)2L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 2");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 2");
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)9L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testNewAndMultiDifferentUpdateOnSingleColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 decimal)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        String dml = "UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 2";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getLong(2));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testNewAndMultiDifferentUpdateOnMultipleColumnsAutoCommit() throws Exception {
        this.testNewAndMultiDifferentUpdateOnMultipleColumns(true);
    }

    @Test
    public void testNewAndMultiDifferentUpdateOnMultipleColumnsNoAutoCommit() throws Exception {
        this.testNewAndMultiDifferentUpdateOnMultipleColumns(false);
    }

    private void testNewAndMultiDifferentUpdateOnMultipleColumns(boolean autoCommit) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        conn.setAutoCommit(autoCommit);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 tinyint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        String dml = "UPSERT INTO " + tableName + " VALUES('a',0,0) ON DUPLICATE KEY UPDATE counter1 = counter2 + 1, counter2 = counter1 + 2";
        conn.createStatement().execute(dml);
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)1L, (long)rs.getLong(2));
        Assert.assertEquals((long)2L, (long)rs.getLong(3));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)1L, (long)rs.getLong(2));
        Assert.assertEquals((long)2L, (long)rs.getLong(3));
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute(dml);
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE counter1 >= 0");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getLong(2));
        Assert.assertEquals((long)3L, (long)rs.getLong(3));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)3L, (long)rs.getLong(2));
        Assert.assertEquals((long)3L, (long)rs.getLong(3));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testAtomicUpdate() throws Exception {
        ResultSet rs;
        int i;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        final String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 integer, counter2 integer)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        int nThreads = 10;
        final int[] resultHolder = new int[1];
        int nCommits = 100;
        int nIncrementsPerCommit = 2;
        ExecutorService exec = Executors.newFixedThreadPool(nThreads);
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)nThreads);
        java.sql.Connection[] connections = new java.sql.Connection[nThreads];
        for (i = 0; i < nThreads; ++i) {
            connections[i] = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        }
        for (i = 0; i < nThreads; ++i) {
            final java.sql.Connection myConn = connections[i];
            futures.add(exec.submit(new Runnable(){

                @Override
                public void run() {
                    String dml = "UPSERT INTO " + tableName + " VALUES('a',1) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1";
                    try {
                        for (int j = 0; j < 100; ++j) {
                            for (int k = 0; k < 2; ++k) {
                                myConn.createStatement().execute(dml);
                                resultHolder[0] = resultHolder[0] + 1;
                            }
                            myConn.commit();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }));
        }
        Collections.shuffle(futures);
        for (Future future : futures) {
            future.get();
        }
        exec.shutdownNow();
        int finalResult = nThreads * 100 * 2;
        boolean isIndexCreated = this.indexDDL != null && this.indexDDL.length() > 0;
        String selectSql = "SELECT * FROM " + tableName + " WHERE counter1 >= 0";
        if (isIndexCreated) {
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            IndexToolIT.assertExplainPlan(this.indexDDL.contains("local"), actualExplainPlan, tableName, tableName + "_IDX");
        }
        rs = conn.createStatement().executeQuery(selectSql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((long)finalResult, (long)rs.getInt(2));
        Assert.assertFalse((boolean)rs.next());
        if (isIndexCreated) {
            rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ * FROM " + tableName + " WHERE counter1 >= 0");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)finalResult, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
        conn.close();
    }

    @Test
    public void testDeleteOnSingleLowerCaseVarcharColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        conn.setAutoCommit(false);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, \"counter1\" varchar, \"counter2\" smallint)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES('a','b') ON DUPLICATE KEY UPDATE \"counter1\" = null";
        conn.createStatement().execute(dml);
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals(null, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        dml = "UPSERT INTO " + tableName + " VALUES('a','b',0)";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES('a','b', 0) ON DUPLICATE KEY UPDATE \"counter1\" = null, \"counter2\" = \"counter2\" + 1";
        conn.createStatement().execute(dml);
        dml = "UPSERT INTO " + tableName + " VALUES('a','b', 0) ON DUPLICATE KEY UPDATE \"counter1\" = 'c', \"counter2\" = \"counter2\" + 1";
        conn.createStatement().execute(dml);
        conn.commit();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"c", (Object)rs.getString(2));
        Assert.assertEquals((long)2L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateUpdateWithSaltedTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (id varchar not null,id1 varchar not null, counter1 bigint, counter2 bigint CONSTRAINT pk PRIMARY KEY (id,id1)) SALT_BUCKETS=6";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String dml = "UPSERT INTO " + tableName + " (id,id1, counter1, counter2) VALUES ('abc','123', 0, 0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1, counter2 = counter2 + 1";
            conn.createStatement().execute(dml);
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"0", (Object)rs.getString(3));
            Assert.assertEquals((Object)"0", (Object)rs.getString(4));
            conn.createStatement().execute(dml);
            conn.commit();
            rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"1", (Object)rs.getString(4));
        }
    }

    @Test
    public void testRowsCreatedViaUpsertOnDuplicateKeyShouldNotBeReturnedInQueryIfNotMatched() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ddl = "create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 smallint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        String dml1 = "UPSERT INTO " + tableName + " VALUES('a',NULL,2) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN (counter1 IS NULL) THEN NULL ELSE counter1 END, counter2 = CASE WHEN (counter1 IS NULL) THEN 2 ELSE counter2 END";
        conn.createStatement().execute(dml1);
        conn.commit();
        String dml2 = "UPSERT INTO " + tableName + " VALUES('b',1,2) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN (counter1 IS NULL) THEN 1 ELSE counter1 END, counter2 = CASE WHEN (counter1 IS NULL) THEN 2 ELSE counter2 END";
        conn.createStatement().execute(dml2);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT pk, counter1, counter2 FROM " + tableName + " WHERE counter2 = 2 AND (counter1 = 1 OR counter1 = 1)");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((long)1L, (long)rs.getLong(2));
        Assert.assertEquals((long)2L, (long)rs.getLong(3));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testOnDupAndUpsertInSameCommitBatch() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);){
            String ddl = "create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 varchar)";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            conn.createStatement().execute(String.format("UPSERT INTO %s VALUES('a',0,'abc')", tableName));
            conn.createStatement().execute(String.format("UPSERT INTO %s VALUES('a',1,'zzz') ON DUPLICATE KEY UPDATE counter1 = counter1 + 2", tableName));
            conn.commit();
            this.assertRow(conn, tableName, "a", 2, "abc");
            conn.createStatement().execute(String.format("UPSERT INTO %s VALUES('a', 7, 'fff')", tableName));
            conn.createStatement().execute(String.format("UPSERT INTO %s VALUES('a',1, 'bazz') ON DUPLICATE KEY UPDATE counter1 = counter1 + 2,counter2 = counter2 || 'ddd'", tableName));
            conn.commit();
            this.assertRow(conn, tableName, "a", 9, "fffddd");
            conn.createStatement().execute(String.format("UPSERT INTO %s (pk, counter2) VALUES('a', 'gggg') ON DUPLICATE KEY UPDATE counter1 = counter1 + 2", tableName));
            conn.createStatement().execute(String.format("UPSERT INTO %s (pk, counter2) VALUES ('a', 'bar')", tableName));
            conn.commit();
            this.assertRow(conn, tableName, "a", 11, "bar");
        }
    }

    @Test
    public void testMultiplePartialUpdatesInSameBatch() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);){
            String ddl = "create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 bigint)";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String dml = String.format("UPSERT INTO %s VALUES('a',0,0)", tableName);
            conn.createStatement().execute(dml);
            conn.commit();
            dml = String.format("UPSERT INTO %s VALUES('a',2,3) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1", tableName);
            conn.createStatement().execute(dml);
            dml = String.format("UPSERT INTO %s VALUES('a',2,3) ON DUPLICATE KEY UPDATE counter2 = counter2 + 2", tableName);
            conn.createStatement().execute(dml);
            dml = String.format("UPSERT INTO %s VALUES('a',2,3) ON DUPLICATE KEY UPDATE counter1 = counter1 + 100", tableName);
            conn.createStatement().execute(dml);
            dml = String.format("UPSERT INTO %s VALUES('a',2,3) ON DUPLICATE KEY UPDATE counter2 = counter2 + 200", tableName);
            conn.createStatement().execute(dml);
            conn.commit();
            String dql = String.format("SELECT counter1, counter2 FROM %s WHERE counter1 > 0", tableName);
            ResultSet rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)101L, (long)rs.getInt(1));
            Assert.assertEquals((long)202L, (long)rs.getInt(2));
        }
    }

    @Test
    public void testComplexDuplicateKeyExpression() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);){
            String ddl = "create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 bigint, approval varchar)";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String dml = String.format("UPSERT INTO %s VALUES('abc', 0, 100, 'NONE')", tableName);
            conn.createStatement().execute(dml);
            conn.commit();
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = counter1 + counter2,approval = CASE WHEN counter1 < 100 THEN 'NONE' WHEN counter1 < 1000 THEN 'MANAGER_APPROVAL' ELSE 'VP_APPROVAL' END", tableName);
            conn.createStatement().execute(dml);
            conn.commit();
            String dql = "SELECT * from " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertEquals((Object)"NONE", (Object)rs.getString("approval"));
            conn.createStatement().execute(dml);
            conn.commit();
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)200L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertEquals((Object)"MANAGER_APPROVAL", (Object)rs.getString("approval"));
        }
    }

    @Test
    public void testRowStampCol() throws Exception {
        if (this.indexDDL.length() > 0) {
            return;
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);){
            String ddl = "create table " + tableName + "(\nORGANIZATION_ID CHAR(15) NOT NULL,\nUSER_ID CHAR(15) NOT NULL,\nTIME_STAMP DATE NOT NULL,\nSTATUS VARCHAR,\nCONSTRAINT PK PRIMARY KEY \n    (\n        ORGANIZATION_ID, \n        USER_ID,\n        TIME_STAMP ROW_TIMESTAMP\n    ) \n)\n";
            conn.createStatement().execute(ddl);
            String orgid = "ORG1";
            String userid = "USER1";
            String original = "ORIGINAL";
            String updated = "UPDATED";
            String duplicate = "DUPLICATE";
            long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis() - 10L;
            String dml = "UPSERT INTO  " + tableName + "(ORGANIZATION_ID, USER_ID, TIME_STAMP, STATUS) VALUES (?, ?, ?, ?)";
            String ignoreDml = dml + "ON DUPLICATE KEY IGNORE";
            String updateDml = dml + "ON DUPLICATE KEY UPDATE status='" + duplicate + "'";
            String nullDml = dml + "ON DUPLICATE KEY UPDATE status = null";
            String dql = "SELECT count(*) from " + tableName + " WHERE STATUS = ?";
            this.upsertRecord(conn, ignoreDml, orgid, userid, rowTimestamp, original);
            this.assertNumRecords(1, conn, dql, original);
            this.assertHBaseRowTimestamp(tableName, rowTimestamp);
            this.upsertRecord(conn, ignoreDml, orgid, userid, rowTimestamp, updated);
            this.assertNumRecords(1, conn, dql, original);
            this.assertNumRecords(0, conn, dql, updated);
            this.assertHBaseRowTimestamp(tableName, rowTimestamp);
            this.upsertRecord(conn, dml, orgid, userid, rowTimestamp, updated);
            this.assertNumRecords(0, conn, dql, original);
            this.assertNumRecords(1, conn, dql, updated);
            this.assertHBaseRowTimestamp(tableName, rowTimestamp);
            this.upsertRecord(conn, updateDml, orgid, userid, rowTimestamp, "");
            this.assertNumRecords(0, conn, dql, updated);
            this.assertNumRecords(1, conn, dql, duplicate);
            this.upsertRecord(conn, nullDml, orgid, userid, rowTimestamp, "");
            this.assertNumRecords(0, conn, dql, duplicate);
            dql = "SELECT count(*) from " + tableName + " WHERE STATUS is null";
            this.assertNumRecords(1, conn, dql, new String[0]);
        }
    }

    @Test
    public void testConditionalTTL() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKeyIT.generateUniqueName();
        String ttlExpression = "counter1 >= 100";
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl(), props);){
            String ddl = String.format("create table %s (pk varchar primary key, counter1 bigint, counter2 bigint) TTL='%s'", tableName, ttlExpression);
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            conn.setAutoCommit(true);
            conn.createStatement().execute(String.format("UPSERT INTO %s VALUES('a',0, 0)", tableName));
            for (int i = 0; i < 2; ++i) {
                int retValue = conn.createStatement().executeUpdate(String.format("UPSERT INTO %s VALUES('a', 0, 0) ON DUPLICATE KEY UPDATE counter1 = counter1 + 50, counter2 = counter2 + 10", tableName));
                Assert.assertEquals((long)1L, (long)retValue);
            }
            String dql = String.format("select counter1, counter2 from %s where pk = 'a'", tableName);
            try (ResultSet rs = conn.createStatement().executeQuery(dql);){
                Assert.assertFalse((String)"row should have expired", (boolean)rs.next());
            }
            int retValue = conn.createStatement().executeUpdate(String.format("UPSERT INTO %s VALUES('a', -1, -1) ON DUPLICATE KEY UPDATE counter1 = counter1 + 50, counter2 = counter2 + 10", tableName));
            Assert.assertEquals((long)1L, (long)retValue);
            try (ResultSet rs = conn.createStatement().executeQuery(dql);){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)-1L, (long)rs.getInt("counter1"));
                Assert.assertEquals((long)-1L, (long)rs.getInt("counter2"));
            }
            retValue = conn.createStatement().executeUpdate(String.format("UPSERT INTO %s VALUES('a', 0, 0) ON DUPLICATE KEY IGNORE", tableName));
            Assert.assertEquals((long)0L, (long)retValue);
            rs = conn.createStatement().executeQuery(dql);
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)-1L, (long)rs.getInt("counter1"));
                Assert.assertEquals((long)-1L, (long)rs.getInt("counter2"));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    private void assertRow(java.sql.Connection conn, String tableName, String expectedPK, int expectedCol1, String expectedCol2) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)expectedPK, (Object)rs.getString(1));
        Assert.assertEquals((long)expectedCol1, (long)rs.getInt(2));
        Assert.assertEquals((Object)expectedCol2, (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
    }

    private void upsertRecord(java.sql.Connection conn, String dml, String orgid, String userid, long ts, String status) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(dml);){
            stmt.setString(1, orgid);
            stmt.setString(2, userid);
            stmt.setDate(3, new Date(ts));
            stmt.setString(4, status);
            stmt.executeUpdate();
            conn.commit();
        }
    }

    private void assertNumRecords(int count, java.sql.Connection conn, String dql, String ... params) throws Exception {
        PreparedStatement stmt = conn.prepareStatement(dql);
        int counter = 1;
        for (String param : params) {
            stmt.setString(counter++, param);
        }
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)count, (long)rs.getInt(1));
    }

    private void assertHBaseRowTimestamp(String tableName, long expectedTimestamp) throws Exception {
        long actualTimestamp = this.getEmptyKVLatestCellTimestamp(tableName);
        Assert.assertEquals((long)expectedTimestamp, (long)actualTimestamp);
    }

    private long getEmptyKVLatestCellTimestamp(String tableName) throws Exception {
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKeyIT.getUrl());
        PTable pTable = PhoenixRuntime.getTable((java.sql.Connection)conn, (String)tableName);
        byte[] emptyCQ = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((PTable)pTable).getFirst();
        return this.getColumnLatestCellTimestamp(tableName, emptyCQ);
    }

    private long getColumnLatestCellTimestamp(String tableName, byte[] cq) throws Exception {
        Scan scan = new Scan();
        try (Connection hconn = ConnectionFactory.createConnection((Configuration)config);){
            Table table = hconn.getTable(TableName.valueOf((String)tableName));
            ResultScanner resultScanner = table.getScanner(scan);
            Result result = resultScanner.next();
            long l = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, cq).getTimestamp();
            return l;
        }
    }
}

