/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class OnDuplicateKey2IT
extends ParallelStatsDisabledIT {
    private final String indexDDL;
    private final String tableDDLOptions;
    private static final String[] INDEX_DDLS = new String[]{"", "create local index %s_IDX on %s(counter1) include (counter2)", "create local index %s_IDX on %s(counter1, counter2)", "create index %s_IDX on %s(counter1) include (counter2)", "create index %s_IDX on %s(counter1, counter2)", "create uncovered index %s_IDX on %s(counter1)", "create uncovered index %s_IDX on %s(counter1, counter2)"};

    public OnDuplicateKey2IT(String indexDDL, boolean columnEncoded) {
        this.indexDDL = indexDDL;
        this.tableDDLOptions = columnEncoded ? "" : "COLUMN_ENCODED_BYTES=0";
    }

    @Parameterized.Parameters(name="OnDuplicateKey2IT_{index},columnEncoded={1}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        for (String indexDDL : INDEX_DDLS) {
            for (boolean columnEncoded : new boolean[]{false, true}) {
                testCases.add(new Object[]{indexDDL, columnEncoded});
            }
        }
        return testCases;
    }

    private void createIndex(java.sql.Connection conn, String tableName) throws SQLException {
        if (this.indexDDL == null || this.indexDDL.length() == 0) {
            return;
        }
        String ddl = String.format(this.indexDDL, tableName, tableName);
        conn.createStatement().execute(ddl);
    }

    @Test
    public void testIgnoreReturnValue() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);
        conn.setAutoCommit(true);
        String tableName = OnDuplicateKey2IT.generateUniqueName();
        String ddl = " create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 bigint)";
        conn.createStatement().execute(ddl);
        this.createIndex(conn, tableName);
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES('a',10)");
        int actualReturnValue = conn.createStatement().executeUpdate("UPSERT INTO " + tableName + " VALUES('a',0) ON DUPLICATE KEY IGNORE RETURNING *");
        Assert.assertEquals((long)0L, (long)actualReturnValue);
        conn.close();
    }

    @Test
    public void testReturnRowResult1() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Assume.assumeTrue((String)"ResultSet return does not work with local index", (!this.indexDDL.startsWith("create local index") ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        String sample2 = OnDuplicateKey2IT.getJsonString("json/sample_02.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = OnDuplicateKey2IT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            OnDuplicateKey2IT.validateAtomicUpsertReturnRow(tableName, conn, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2);
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ? RETURNING *");
            ps.setString(1, "pk000");
            ps.setDouble(2, -123.98);
            ps.setString(3, "pk003");
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, true, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, false, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateMultiRowDelete(tableName, conn, (BsonDocument)bsonDocument2);
        }
    }

    @Test
    public void testReturnRowResult2() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Assume.assumeTrue((String)"ResultSet return does not work with local index", (!this.indexDDL.startsWith("create local index") ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        String sample2 = OnDuplicateKey2IT.getJsonString("json/sample_02.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = OnDuplicateKey2IT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            OnDuplicateKey2IT.validateAtomicUpsertReturnRow(tableName, conn, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2);
            this.verifyIndexRow(conn, tableName, false);
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ? AND COL4 = ? RETURNING *");
            ps.setString(1, "pk000");
            ps.setDouble(2, -123.98);
            ps.setString(3, "pk003");
            ps.setInt(4, 235);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, false, (BsonDocument)bsonDocument2, 234);
            ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ? AND COL4 = ? RETURNING *");
            ps.setString(1, "pk000");
            ps.setDouble(2, -123.98);
            ps.setString(3, "pk003");
            ps.setInt(4, 234);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, true, (BsonDocument)bsonDocument2, 234);
            this.verifyIndexRow(conn, tableName, true);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, false, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateMultiRowDelete(tableName, conn, (BsonDocument)bsonDocument2);
        }
    }

    @Test
    public void testReturnRowResult4() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Assume.assumeTrue((String)"ResultSet return does not work with local index", (!this.indexDDL.startsWith("create local index") ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        String sample2 = OnDuplicateKey2IT.getJsonString("json/sample_02.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = "XYZ.\"abc123" + OnDuplicateKey2IT.generateUniqueName() + "\"";
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            if (!this.indexDDL.isEmpty()) {
                String indexDdl = String.format(this.indexDDL, "abc123" + OnDuplicateKey2IT.generateUniqueName(), tableName);
                conn.createStatement().execute(indexDdl);
            }
            OnDuplicateKey2IT.validateAtomicUpsertReturnRow(tableName, conn, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2);
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ? AND COL4 = ? RETURNING *");
            ps.setString(1, "pk000");
            ps.setDouble(2, -123.98);
            ps.setString(3, "pk003");
            ps.setInt(4, 235);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, false, (BsonDocument)bsonDocument2, 234);
            ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ? AND COL4 = ? RETURNING *");
            ps.setString(1, "pk000");
            ps.setDouble(2, -123.98);
            ps.setString(3, "pk003");
            ps.setInt(4, 234);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, true, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, false, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateMultiRowDelete(tableName, conn, (BsonDocument)bsonDocument2);
        }
    }

    @Test
    public void testReturnRowResult5() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Assume.assumeTrue((String)"ResultSet return does not work with local index", (!this.indexDDL.startsWith("create local index") ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        String sample2 = OnDuplicateKey2IT.getJsonString("json/sample_02.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = "XYZ.\"abc123" + OnDuplicateKey2IT.generateUniqueName() + "\"";
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            if (!this.indexDDL.isEmpty()) {
                String indexDdl = String.format(this.indexDDL, "abc123" + OnDuplicateKey2IT.generateUniqueName(), tableName);
                conn.createStatement().execute(indexDdl);
            }
            OnDuplicateKey2IT.validateAtomicUpsertOnlyReturnRow(tableName, conn, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2);
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ? AND COL4 = ? RETURNING *");
            ps.setString(1, "pk000");
            ps.setDouble(2, -123.98);
            ps.setString(3, "pk003");
            ps.setInt(4, 235);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, false, (BsonDocument)bsonDocument2, 234);
            ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ? AND COL4 = ? RETURNING *");
            ps.setString(1, "pk000");
            ps.setDouble(2, -123.98);
            ps.setString(3, "pk003");
            ps.setInt(4, 234);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, true, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, false, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateMultiRowDelete(tableName, conn, (BsonDocument)bsonDocument2);
        }
    }

    @Test
    public void testReturnRowResult3() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Assume.assumeTrue((String)"ResultSet return does not work with local index", (!this.indexDDL.startsWith("create local index") ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        String sample2 = OnDuplicateKey2IT.getJsonString("json/sample_02.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = "XYZ.\"abc123" + OnDuplicateKey2IT.generateUniqueName() + "\"";
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            if (!this.indexDDL.isEmpty()) {
                String indexDdl = String.format(this.indexDDL, "abc123" + OnDuplicateKey2IT.generateUniqueName(), tableName);
                conn.createStatement().execute(indexDdl);
            }
            OnDuplicateKey2IT.validateAtomicUpsertReturnRow(tableName, conn, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2);
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? AND PK3 = ? RETURNING *");
            ps.setString(1, "pk000");
            ps.setDouble(2, -123.98);
            ps.setString(3, "pk003");
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, true, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", true, false, (BsonDocument)bsonDocument2, 234);
            OnDuplicateKey2IT.validateMultiRowDelete(tableName, conn, (BsonDocument)bsonDocument2);
        }
    }

    private void verifyIndexRow(java.sql.Connection conn, String tableName, boolean deleted) throws SQLException {
        PreparedStatement preparedStatement = conn.prepareStatement("SELECT COUNTER2 FROM " + tableName + " WHERE COUNTER1 = ?");
        preparedStatement.setDouble(1, 2233.99);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!deleted) {
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"col2_001", (Object)resultSet.getString(1));
        }
        Assert.assertFalse((boolean)resultSet.next());
        ExplainPlan plan = preparedStatement.unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)(this.indexDDL.contains("index") ? (this.indexDDL.contains("local index") ? tableName + "_IDX(" + tableName + ")" : tableName + "_IDX") : tableName), (Object)explainPlanAttributes.getTableName());
    }

    private static void validateMultiRowDelete(String tableName, java.sql.Connection conn, BsonDocument bsonDocument2) throws SQLException {
        OnDuplicateKey2IT.addRows(tableName, conn);
        PreparedStatement ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 = ? AND PK2 = ? RETURNING *");
        ps.setString(1, "pk001");
        ps.setDouble(2, 122.34);
        OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", false, false, bsonDocument2, 234);
        ps = conn.prepareStatement("DELETE FROM " + tableName + " RETURNING *");
        OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", false, false, bsonDocument2, 234);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        Assert.assertFalse((boolean)rs.next());
        OnDuplicateKey2IT.addRows(tableName, conn);
        ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK1 IN (?) AND PK2 IN (?) AND PK3 IN (?, ?) RETURNING *");
        ps.setString(1, "pk001");
        ps.setDouble(2, 122.34);
        ps.setString(3, "pk004");
        ps.setString(4, "pk005");
        OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", false, false, bsonDocument2, 234);
    }

    private static void validateAtomicUpsertReturnRow(String tableName, java.sql.Connection conn, BsonDocument bsonDocument1, BsonDocument bsonDocument2) throws SQLException {
        String upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COL3, COL4) VALUES('pk000', -123.98, 'pk003', 1011.202, ?, 123) ON DUPLICATE KEY IGNORE RETURNING *";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 1011.202, null, true, bsonDocument1, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1) VALUES('pk000', -123.98, 'pk003', 0) ON DUPLICATE KEY IGNORE RETURNING *";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 1011.202, null, false, null, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COUNTER2) VALUES('pk000', -123.98, 'pk003', 234, 'col2_000')";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 234.0, "col2_000", true, null, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3) VALUES('pk000', -123.98, 'pk003') ON DUPLICATE KEY UPDATE COUNTER1 = CASE WHEN COUNTER1 < 2000 THEN COUNTER1 + 1999.99 ELSE COUNTER1 END, COUNTER2 = CASE WHEN COUNTER2 = 'col2_000' THEN 'col2_001' ELSE COUNTER2 END, COL3 = ?, COL4 = 234 RETURNING *";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 2233.99, "col2_001", true, bsonDocument2, bsonDocument2, 234);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3) VALUES('pk000', -123.98, 'pk003') ON DUPLICATE KEY UPDATE COUNTER1 = CASE WHEN COUNTER1 < 2000 THEN COUNTER1 + 1999.99 ELSE COUNTER1 END,COUNTER2 = CASE WHEN COUNTER2 = 'col2_000' THEN 'col2_001' ELSE COUNTER2 END RETURNING *";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 2233.99, "col2_001", false, null, bsonDocument2, 234);
    }

    private static void validateAtomicUpsertOnlyReturnRow(String tableName, java.sql.Connection conn, BsonDocument bsonDocument1, BsonDocument bsonDocument2) throws SQLException {
        String upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COL3, COL4) VALUES('pk000', -123.98, 'pk003', 1011.202, ?, 123) ON DUPLICATE KEY IGNORE RETURNING *";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 1011.202, null, true, bsonDocument1, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1) VALUES('pk000', -123.98, 'pk003', 0) ON DUPLICATE KEY IGNORE RETURNING *";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 1011.202, null, false, null, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COUNTER2) VALUES('pk000', -123.98, 'pk003', 234, 'col2_000')";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 234.0, "col2_000", true, null, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3) VALUES('pk000', -123.98, 'pk003') ON DUPLICATE KEY UPDATE_ONLY COUNTER1 = CASE WHEN COUNTER1 < 2000 THEN COUNTER1 + 1999.99 ELSE COUNTER1 END, COUNTER2 = CASE WHEN COUNTER2 = 'col2_000' THEN 'col2_001' ELSE COUNTER2 END, COL3 = ?, COL4 = 234 RETURNING *";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 2233.99, "col2_001", true, bsonDocument2, bsonDocument2, 234);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3) VALUES('pk000', -123.98, 'pk003') ON DUPLICATE KEY UPDATE_ONLY COUNTER1 = CASE WHEN COUNTER1 < 2000 THEN COUNTER1 + 1999.99 ELSE COUNTER1 END,COUNTER2 = CASE WHEN COUNTER2 = 'col2_000' THEN 'col2_001' ELSE COUNTER2 END RETURNING *";
        OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 2233.99, "col2_001", false, null, bsonDocument2, 234);
    }

    private static void addRows(String tableName, java.sql.Connection conn) throws SQLException {
        String upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COUNTER2) VALUES('pk001', 122.34, 'pk004', 23, 'col2_001')";
        conn.createStatement().execute(upsertSql);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COUNTER2) VALUES('pk001', 122.34, 'pk005', 23, 'col2_001')";
        conn.createStatement().execute(upsertSql);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COUNTER2) VALUES('pk003', 122.34, 'pk005', 23, 'col2_001')";
        conn.createStatement().execute(upsertSql);
    }

    private static void validateReturnedRowAfterDelete(PreparedStatement ps, String col2, boolean isSinglePointLookup, boolean atomicDeleteSuccessful, BsonDocument expectedDoc, Integer col4) throws SQLException {
        ps.executeUpdate();
        ResultSet resultSet = ps.getResultSet();
        if (!isSinglePointLookup) {
            Assert.assertNull((Object)resultSet);
            return;
        }
        if (resultSet != null) {
            Assert.assertTrue((boolean)resultSet.next());
        }
        if (!atomicDeleteSuccessful) {
            Assert.assertTrue((resultSet == null || resultSet.getObject(4) == null ? 1 : 0) != 0);
            return;
        }
        OnDuplicateKey2IT.validateReturnedRowResult(col2, expectedDoc, col4, resultSet);
    }

    private static void validateReturnedRowResult(String col2, BsonDocument expectedDoc, Integer col4, ResultSet resultSet) throws SQLException {
        if (col2 != null) {
            Assert.assertEquals((Object)col2, (Object)resultSet.getString(5));
        } else {
            Assert.assertNull((Object)resultSet.getString(5));
        }
        if (expectedDoc != null) {
            Assert.assertEquals((Object)expectedDoc, (Object)resultSet.getObject(6));
        } else {
            Assert.assertNull((Object)resultSet.getObject(6));
        }
        if (col4 != null) {
            Assert.assertEquals((Object)col4, (Object)resultSet.getObject(7));
        } else {
            Assert.assertNull((Object)resultSet.getObject(7));
        }
    }

    private static void validateReturnedRowAfterUpsert(java.sql.Connection conn, String upsertSql, String tableName, Double col1, String col2, boolean success, BsonDocument inputDoc, BsonDocument expectedDoc, Integer col4) throws SQLException {
        ResultSet resultSet;
        int updateCount;
        if (inputDoc != null) {
            PreparedStatement ps = conn.prepareStatement(upsertSql);
            ps.setObject(1, inputDoc);
            updateCount = ps.executeUpdate();
            resultSet = ps.getResultSet();
        } else {
            Statement stmt = conn.createStatement();
            resultSet = stmt.execute(upsertSql) ? stmt.getResultSet() : null;
            updateCount = stmt.getUpdateCount();
        }
        boolean isReturningRow = upsertSql.toUpperCase().contains("RETURNING *");
        if (conn.getAutoCommit() && isReturningRow) {
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)(success ? 1L : 0L), (long)updateCount);
            Assert.assertEquals((Object)"pk000", (Object)resultSet.getString(1));
            Assert.assertEquals((double)-123.98, (double)resultSet.getDouble(2), (double)0.0);
            Assert.assertEquals((Object)"pk003", (Object)resultSet.getString(3));
            Assert.assertEquals((double)col1, (double)resultSet.getDouble(4), (double)0.0);
            OnDuplicateKey2IT.validateReturnedRowResult(col2, expectedDoc, col4, resultSet);
            Assert.assertFalse((boolean)resultSet.next());
        } else {
            Assert.assertNull((Object)resultSet);
            Assert.assertEquals((long)1L, (long)updateCount);
        }
    }

    private static void validateReturnedRowBeforeUpsert(java.sql.Connection conn, String upsertSql, String tableName, Double col1, String col2, boolean success, BsonDocument inputDoc, BsonDocument expectedDoc, Integer col4) throws SQLException {
        ResultSet resultSet;
        int updateCount;
        if (inputDoc != null) {
            PreparedStatement ps = conn.prepareStatement(upsertSql);
            ps.setObject(1, inputDoc);
            Pair resultPair = ps.unwrap(PhoenixPreparedStatement.class).executeAtomicUpdateReturnOldRow();
            updateCount = (Integer)resultPair.getFirst();
            resultSet = (ResultSet)resultPair.getSecond();
        } else {
            Statement stmt = conn.createStatement();
            Pair resultPair = stmt.unwrap(PhoenixStatement.class).executeAtomicUpdateReturnOldRow(upsertSql);
            updateCount = (Integer)resultPair.getFirst();
            resultSet = (ResultSet)resultPair.getSecond();
        }
        if (conn.getAutoCommit()) {
            Assert.assertEquals((long)(success ? 1L : 0L), (long)updateCount);
            if (resultSet != null) {
                Assert.assertEquals((Object)"pk000", (Object)resultSet.getString(1));
                Assert.assertEquals((double)-123.98, (double)resultSet.getDouble(2), (double)0.0);
                Assert.assertEquals((Object)"pk003", (Object)resultSet.getString(3));
                Assert.assertEquals((double)col1, (double)resultSet.getDouble(4), (double)0.0);
                OnDuplicateKey2IT.validateReturnedRowResult(col2, expectedDoc, col4, resultSet);
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testReturnOldRowResult1() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Assume.assumeTrue((String)"ResultSet return does not work with local index", (!this.indexDDL.startsWith("create local index") ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        String sample2 = OnDuplicateKey2IT.getJsonString("json/sample_02.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = OnDuplicateKey2IT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            OnDuplicateKey2IT.validateAtomicUpsertReturnOldRow(tableName, conn, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2);
            this.verifyIndexRow(conn, tableName, false);
        }
    }

    @Test
    public void testReturnOldRowUsingUpdateOnly() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Assume.assumeTrue((String)"ResultSet return does not work with local index", (!this.indexDDL.startsWith("create local index") ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        String sample2 = OnDuplicateKey2IT.getJsonString("json/sample_02.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = OnDuplicateKey2IT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            OnDuplicateKey2IT.validateAtomicUpsertOnlyReturnOldRow(tableName, conn, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument2);
            this.verifyIndexRow(conn, tableName, false);
        }
    }

    private static void validateAtomicUpsertReturnOldRow(String tableName, java.sql.Connection conn, BsonDocument bsonDocument1, BsonDocument bsonDocument2) throws SQLException {
        String upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COL3, COL4) VALUES('pk000', -123.98, 'pk003', 1011.202, ?, 123) ON DUPLICATE KEY IGNORE";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 0.0, null, true, bsonDocument1, null, null);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1) VALUES('pk000', -123.98, 'pk003', 0) ON DUPLICATE KEY IGNORE";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 1011.202, null, false, null, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COUNTER2) VALUES('pk000', -123.98, 'pk003', 234, 'col2_000')";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 1011.202, null, true, null, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3) VALUES('pk000', -123.98, 'pk003') ON DUPLICATE KEY UPDATE COUNTER1 = CASE WHEN COUNTER1 < 2000 THEN COUNTER1 + 1999.99 ELSE COUNTER1 END, COUNTER2 = CASE WHEN COUNTER2 = 'col2_000' THEN 'col2_001' ELSE COUNTER2 END, COL3 = ?, COL4 = 234";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 234.0, "col2_000", true, bsonDocument2, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3) VALUES('pk000', -123.98, 'pk003') ON DUPLICATE KEY UPDATE COUNTER1 = CASE WHEN COUNTER1 < 2000 THEN COUNTER1 + 1999.99 ELSE COUNTER1 END,COUNTER2 = CASE WHEN COUNTER2 = 'col2_000' THEN 'col2_001' ELSE COUNTER2 END";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 2233.99, "col2_001", false, null, bsonDocument2, 234);
    }

    private static void validateAtomicUpsertOnlyReturnOldRow(String tableName, java.sql.Connection conn, BsonDocument bsonDocument1, BsonDocument bsonDocument2) throws SQLException {
        String upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COL3, COL4) VALUES('pk000', -123.98, 'pk003', 1011.202, ?, 123) ON DUPLICATE KEY IGNORE";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 0.0, null, true, bsonDocument1, null, null);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1) VALUES('pk000', -123.98, 'pk003', 0) ON DUPLICATE KEY IGNORE";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 1011.202, null, false, null, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COUNTER2) VALUES('pk000', -123.98, 'pk003', 234, 'col2_000')";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 1011.202, null, true, null, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3) VALUES('pk000', -123.98, 'pk003') ON DUPLICATE KEY UPDATE_ONLY COUNTER1 = CASE WHEN COUNTER1 < 2000 THEN COUNTER1 + 1999.99 ELSE COUNTER1 END, COUNTER2 = CASE WHEN COUNTER2 = 'col2_000' THEN 'col2_001' ELSE COUNTER2 END, COL3 = ?, COL4 = 234";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 234.0, "col2_000", true, bsonDocument2, bsonDocument1, 123);
        upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3) VALUES('pk000', -123.98, 'pk003') ON DUPLICATE KEY UPDATE_ONLY COUNTER1 = CASE WHEN COUNTER1 < 2000 THEN COUNTER1 + 1999.99 ELSE COUNTER1 END,COUNTER2 = CASE WHEN COUNTER2 = 'col2_000' THEN 'col2_001' ELSE COUNTER2 END";
        OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 2233.99, "col2_001", false, null, bsonDocument2, 234);
    }

    @Test
    public void testReturnOldRowResult2() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Assume.assumeTrue((String)"ResultSet return does not work with local index", (!this.indexDDL.startsWith("create local index") ? 1 : 0) != 0);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        String sample2 = OnDuplicateKey2IT.getJsonString("json/sample_02.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        RawBsonDocument bsonDocument2 = RawBsonDocument.parse((String)sample2);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = OnDuplicateKey2IT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COL3, COL4) VALUES('pk000', -123.98, 'pk003', 999.999, ?, 999) ON DUPLICATE KEY IGNORE";
            OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 0.0, null, true, (BsonDocument)bsonDocument1, null, null);
            upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COL3, COL4) VALUES('pk000', -123.98, 'pk003', 888.888, ?, 888) ON DUPLICATE KEY IGNORE";
            OnDuplicateKey2IT.validateReturnedRowBeforeUpsert(conn, upsertSql, tableName, 999.999, null, false, (BsonDocument)bsonDocument2, (BsonDocument)bsonDocument1, 999);
        }
    }

    @Test
    public void testReturnRowResultForMultiPointLookup() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String tableName = OnDuplicateKey2IT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + "(PK VARCHAR PRIMARY KEY, COL1 DOUBLE, COL2 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR)";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            OnDuplicateKey2IT.addRows2(tableName, conn);
            PreparedStatement ps = conn.prepareStatement("DELETE FROM " + tableName + " WHERE PK IN (?, ?, ?)");
            ps.setString(1, "pk001");
            ps.setString(2, "pk002");
            ps.setString(3, "pk003");
            OnDuplicateKey2IT.validateReturnedRowAfterDelete(ps, "col2_001", false, false, null, 234);
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void addRows2(String tableName, java.sql.Connection conn) throws SQLException {
        String upsertSql = "UPSERT INTO " + tableName + " (PK, COL1, COL2, COUNTER1, COUNTER2) VALUES('pk001', 122.34, 'pk004', 23, 'col2_001')";
        conn.createStatement().execute(upsertSql);
        upsertSql = "UPSERT INTO " + tableName + " (PK, COL1, COL2, COUNTER1, COUNTER2) VALUES('pk002', 122.34, 'pk005', 23, 'col2_001')";
        conn.createStatement().execute(upsertSql);
        upsertSql = "UPSERT INTO " + tableName + " (PK, COL1, COL2, COUNTER1, COUNTER2) VALUES('pk003', 122.34, 'pk005', 23, 'col2_001')";
        conn.createStatement().execute(upsertSql);
    }

    @Test
    public void testReturnRowResultWithoutAutoCommit() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String sample1 = OnDuplicateKey2IT.getJsonString("json/sample_01.json");
        RawBsonDocument bsonDocument1 = RawBsonDocument.parse((String)sample1);
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            String tableName = OnDuplicateKey2IT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + "(PK1 VARCHAR, PK2 DOUBLE NOT NULL, PK3 VARCHAR, COUNTER1 DOUBLE, COUNTER2 VARCHAR, COL3 BSON, COL4 INTEGER, CONSTRAINT pk PRIMARY KEY(PK1, PK2, PK3))";
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String upsertSql = "UPSERT INTO " + tableName + " (PK1, PK2, PK3, COUNTER1, COL3, COL4) VALUES('pk000', -123.98, 'pk003', 1011.202, ?, 123) ON DUPLICATE KEY IGNORE";
            OnDuplicateKey2IT.validateReturnedRowAfterUpsert(conn, upsertSql, tableName, 1011.202, null, true, (BsonDocument)bsonDocument1, (BsonDocument)bsonDocument1, 123);
        }
    }

    @Test
    public void testColumnsTimestampUpdateWithAllCombinations() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKey2IT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "create table " + tableName + "(pk varchar primary key, counter1 integer, counter2 integer, counter3 smallint, counter4 bigint, counter5 varchar)" + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            Object dml = String.format("UPSERT INTO %s VALUES('abc', 0, 10, 100, 1000, 'NONE')", tableName);
            int actualReturnValue = conn.createStatement().executeUpdate((String)dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            String dql = "SELECT * from " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            List<Long> oldTimestamps = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            dml = "UPSERT INTO " + tableName + " VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN counter1 < 1 THEN counter1 + 1 ELSE counter1 END, counter2 = CASE WHEN counter2 < 10 THEN counter2 + 1 ELSE counter2 END, counter3 = counter3 + 100, counter4 = counter4";
            actualReturnValue = conn.createStatement().executeUpdate((String)dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)10L, (long)rs.getInt("counter2"));
            Assert.assertEquals((long)200L, (long)rs.getInt("counter3"));
            Assert.assertEquals((long)1000L, (long)rs.getInt("counter4"));
            Assert.assertEquals((Object)"NONE", (Object)rs.getString("counter5"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> newTimestamps = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertEquals((long)6L, (long)oldTimestamps.size());
            Assert.assertEquals((long)6L, (long)newTimestamps.size());
            Assert.assertEquals((Object)oldTimestamps.get(2), (Object)newTimestamps.get(2));
            Assert.assertEquals((Object)oldTimestamps.get(5), (Object)newTimestamps.get(5));
            Assert.assertTrue((oldTimestamps.get(0) < newTimestamps.get(0) && oldTimestamps.get(1) < newTimestamps.get(1) && oldTimestamps.get(3) < newTimestamps.get(3) && oldTimestamps.get(4) < newTimestamps.get(4) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testColumnsTimestampUpdateWithOneConditionalUpdate() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKey2IT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 bigint)" + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String dml = String.format("UPSERT INTO %s VALUES('abc', 0, 100)", tableName);
            int actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            String dql = "SELECT * from " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            List<Long> timestampList0 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN counter1 < 1 THEN counter1 + 1 ELSE counter1 END", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList1 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertTrue((timestampList1.get(0) > timestampList0.get(0) && timestampList1.get(1) > timestampList0.get(1) ? 1 : 0) != 0);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)0L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList2 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertEquals((Object)timestampList1.get(0), (Object)timestampList2.get(0));
            Assert.assertEquals((Object)timestampList1.get(1), (Object)timestampList2.get(1));
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN counter1 < 1 THEN counter1 ELSE counter1 + 1 END", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)2L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList3 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertTrue((timestampList3.get(0) > timestampList2.get(0) && timestampList3.get(1) > timestampList2.get(1) ? 1 : 0) != 0);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList4 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertTrue((timestampList4.get(0) > timestampList3.get(0) && timestampList4.get(1) > timestampList3.get(1) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testColumnsTimestampUpdateWithOneConditionalValuesUpdate() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKey2IT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "create table " + tableName + "(pk varchar primary key, counter1 integer, counter2 integer)" + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String dml = String.format("UPSERT INTO %s VALUES('abc', 1, 100)", tableName);
            int actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            List<Long> timestampList0 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN counter2 <= 100 THEN 1 ELSE 0 END", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            String dql = "SELECT * from " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList1 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertTrue((timestampList0.get(0) < timestampList1.get(0) && timestampList0.get(1) < timestampList1.get(1) ? 1 : 0) != 0);
            Assert.assertEquals((Object)timestampList0.get(2), (Object)timestampList1.get(2));
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN counter2 > 100 THEN 0 ELSE 1 END", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)0L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList2 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertEquals((Object)timestampList1.get(0), (Object)timestampList2.get(0));
            Assert.assertEquals((Object)timestampList1.get(1), (Object)timestampList2.get(1));
            Assert.assertEquals((Object)timestampList1.get(2), (Object)timestampList2.get(2));
        }
    }

    @Test
    public void testColumnsTimestampUpdateWithMultipleConditionalUpdate() throws Exception {
        Assume.assumeTrue((String)"Set correct result to RegionActionResult on hbase versions 2.4.18+, 2.5.9+, and 2.6.0+", (boolean)this.isSetCorrectResultEnabledOnHBase());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKey2IT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "create table " + tableName + "(pk varchar primary key, counter1 integer, counter2 integer, approval varchar)" + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String dml = String.format("UPSERT INTO %s VALUES('abc', 0, 9, 'NONE')", tableName);
            int actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            List<Long> timestampList0 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN counter1 < 1 THEN 1 ELSE counter1 END,counter2 = CASE WHEN counter2 < 11 THEN counter2 + 1 ELSE counter2 END,approval = CASE WHEN counter2 < 10 THEN 'NONE' WHEN counter2 < 11 THEN 'MANAGER_APPROVAL' ELSE approval END", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            String dql = "SELECT * from " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)10L, (long)rs.getInt("counter2"));
            Assert.assertEquals((Object)"NONE", (Object)rs.getString("approval"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList1 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertTrue((timestampList1.get(0) > timestampList0.get(0) && timestampList1.get(1) > timestampList0.get(1) && timestampList1.get(2) > timestampList0.get(2) && timestampList1.get(3) > timestampList0.get(3) ? 1 : 0) != 0);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)11L, (long)rs.getInt("counter2"));
            Assert.assertEquals((Object)"MANAGER_APPROVAL", (Object)rs.getString("approval"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList2 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertEquals((Object)timestampList1.get(1), (Object)timestampList2.get(1));
            Assert.assertTrue((timestampList2.get(0) > timestampList1.get(0) && timestampList2.get(2) > timestampList1.get(2) && timestampList2.get(3) > timestampList1.get(3) ? 1 : 0) != 0);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)0L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)11L, (long)rs.getInt("counter2"));
            Assert.assertEquals((Object)"MANAGER_APPROVAL", (Object)rs.getString("approval"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList3 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertEquals((Object)timestampList2.get(0), (Object)timestampList3.get(0));
            Assert.assertEquals((Object)timestampList2.get(1), (Object)timestampList3.get(1));
            Assert.assertEquals((Object)timestampList2.get(2), (Object)timestampList3.get(2));
            Assert.assertEquals((Object)timestampList2.get(3), (Object)timestampList3.get(3));
        }
    }

    @Test
    public void testColumnsTimestampUpdateWithIntentionalUpdate() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKey2IT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "create table " + tableName + "(pk varchar primary key, counter1 bigint, counter2 bigint)" + this.tableDDLOptions;
            conn.createStatement().execute(ddl);
            this.createIndex(conn, tableName);
            String dml = String.format("UPSERT INTO %s VALUES('abc', 0, 100)", tableName);
            int actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            List<Long> timestampList0 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = counter1 + 1", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            String dql = "SELECT * from " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList1 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertEquals((Object)timestampList0.get(2), (Object)timestampList1.get(2));
            Assert.assertTrue((timestampList1.get(0) > timestampList0.get(0) && timestampList1.get(1) > timestampList0.get(1) ? 1 : 0) != 0);
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = counter1", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)100L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList2 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertEquals((Object)timestampList2.get(2), (Object)timestampList1.get(2));
            Assert.assertTrue((timestampList2.get(0) > timestampList1.get(0) && timestampList2.get(1) > timestampList1.get(1) ? 1 : 0) != 0);
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = counter1, counter2 = counter2 + 1", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)101L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList3 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertTrue((timestampList3.get(0) > timestampList2.get(0) && timestampList3.get(1) > timestampList2.get(1) && timestampList3.get(2) > timestampList2.get(2) ? 1 : 0) != 0);
            dml = String.format("UPSERT INTO %s(pk, counter1, counter2) VALUES ('abc', 0, 10) ON DUPLICATE KEY UPDATE counter1 = counter1, counter2 = counter2", tableName);
            actualReturnValue = conn.createStatement().executeUpdate(dml);
            Assert.assertEquals((long)1L, (long)actualReturnValue);
            rs = conn.createStatement().executeQuery(dql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)101L, (long)rs.getInt("counter2"));
            Assert.assertFalse((boolean)rs.next());
            List<Long> timestampList4 = this.getAllColumnsLatestCellTimestamp(conn, tableName);
            Assert.assertTrue((timestampList4.get(0) > timestampList3.get(0) && timestampList4.get(1) > timestampList3.get(1) && timestampList4.get(2) > timestampList3.get(2) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBatchedUpsertOnDupKeyAutoCommit() throws Exception {
        this.testBatchedUpsertOnDupKey(true);
    }

    @Test
    public void testBatchedUpsertOnDupKeyNoAutoCommit() throws Exception {
        this.testBatchedUpsertOnDupKey(false);
    }

    private void testBatchedUpsertOnDupKey(boolean autocommit) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = OnDuplicateKey2IT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl(), props);){
            conn.setAutoCommit(autocommit);
            Statement stmt = conn.createStatement();
            stmt.execute("create table " + tableName + "(pk varchar primary key, counter1 integer, counter2 integer, approval varchar)");
            this.createIndex(conn, tableName);
            stmt.execute("UPSERT INTO " + tableName + " VALUES('a', 0, 10, 'NONE')");
            conn.commit();
            stmt.addBatch("UPSERT INTO " + tableName + " (pk, counter1, counter2) VALUES ('a', 0, 10) ON DUPLICATE KEY IGNORE");
            stmt.addBatch("UPSERT INTO " + tableName + " (pk, counter1, counter2) VALUES ('a', 0, 10) ON DUPLICATE KEY UPDATE counter1 = CASE WHEN counter1 < 1 THEN 1 ELSE counter1 END");
            stmt.addBatch("UPSERT INTO " + tableName + " (pk, counter1, counter2) VALUES ('b', 0, 9) ON DUPLICATE KEY IGNORE");
            String dml = "UPSERT INTO " + tableName + " (pk, counter1, counter2) VALUES ('b', 0, 10) ON DUPLICATE KEY UPDATE counter2 = CASE WHEN counter2 < 11 THEN counter2 + 1 ELSE counter2 END, approval = CASE WHEN counter2 < 10 THEN 'NONE' WHEN counter2 < 11 THEN 'MANAGER_APPROVAL' ELSE approval END";
            stmt.addBatch(dml);
            stmt.addBatch(dml);
            stmt.addBatch(dml);
            int[] actualReturnValues = stmt.executeBatch();
            int[] expectedReturnValues = new int[]{1, 1, 1, 1, 1, 1};
            if (!autocommit) {
                conn.commit();
            }
            Assert.assertArrayEquals((int[])expectedReturnValues, (int[])actualReturnValues);
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString("pk"));
            Assert.assertEquals((long)1L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)10L, (long)rs.getInt("counter2"));
            Assert.assertEquals((Object)"NONE", (Object)rs.getString("approval"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("pk"));
            Assert.assertEquals((long)0L, (long)rs.getInt("counter1"));
            Assert.assertEquals((long)11L, (long)rs.getInt("counter2"));
            Assert.assertEquals((Object)"MANAGER_APPROVAL", (Object)rs.getString("approval"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private long getEmptyKVLatestCellTimestamp(String tableName) throws Exception {
        java.sql.Connection conn = DriverManager.getConnection(OnDuplicateKey2IT.getUrl());
        PTable pTable = PhoenixRuntime.getTable((java.sql.Connection)conn, (String)tableName);
        byte[] emptyCQ = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((PTable)pTable).getFirst();
        return this.getColumnLatestCellTimestamp(tableName, emptyCQ);
    }

    private long getColumnLatestCellTimestamp(String tableName, byte[] cq) throws Exception {
        Scan scan = new Scan();
        try (Connection hconn = ConnectionFactory.createConnection((Configuration)config);){
            Table table = hconn.getTable(TableName.valueOf((String)tableName));
            ResultScanner resultScanner = table.getScanner(scan);
            Result result = resultScanner.next();
            long l = result.getColumnLatestCell(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, cq).getTimestamp();
            return l;
        }
    }

    private List<Long> getAllColumnsLatestCellTimestamp(java.sql.Connection conn, String tableName) throws Exception {
        ArrayList<Long> timestampList = new ArrayList<Long>();
        PTable pTable = conn.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, tableName));
        List columns = pTable.getColumns();
        timestampList.add(this.getEmptyKVLatestCellTimestamp(tableName));
        for (int i = 1; i < columns.size(); ++i) {
            byte[] cq = ((PColumn)columns.get(i)).getColumnQualifierBytes();
            timestampList.add(this.getColumnLatestCellTimestamp(tableName, cq));
        }
        return timestampList;
    }

    private boolean isSetCorrectResultEnabledOnHBase() {
        String hbaseVersion = VersionInfo.getVersion();
        String[] versionArr = hbaseVersion.split("\\.");
        int majorVersion = Integer.parseInt(versionArr[0]);
        int minorVersion = Integer.parseInt(versionArr[1]);
        int patchVersion = Integer.parseInt(versionArr[2].split("-")[0]);
        if (majorVersion > 2) {
            return true;
        }
        if (majorVersion < 2) {
            return false;
        }
        if (minorVersion >= 6) {
            return true;
        }
        if (minorVersion < 4) {
            return false;
        }
        if (minorVersion == 4) {
            return patchVersion >= 18;
        }
        return patchVersion >= 9;
    }

    private static String getJsonString(String jsonFilePath) throws IOException {
        URL fileUrl = OnDuplicateKey2IT.class.getClassLoader().getResource(jsonFilePath);
        return FileUtils.readFileToString((File)new File(fileUrl.getFile()), (Charset)Charset.defaultCharset());
    }
}

