/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseQueryIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
public class NullIT
extends BaseQueryIT {
    @Parameterized.Parameters(name="NullIT_{index},columnEncoded={1}")
    public static synchronized Collection<Object> data() {
        return BaseQueryIT.allIndexesWithEncoded();
    }

    public NullIT(String indexDDL, boolean columnEncoded, boolean keepDeletedCells) {
        super(indexDDL, columnEncoded, keepDeletedCells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNoStringValue(String value) throws Exception {
        String url = NullIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection upsertConn = DriverManager.getConnection(url, props);
        upsertConn.setAutoCommit(true);
        PreparedStatement stmt = upsertConn.prepareStatement("upsert into " + tableName + " VALUES (?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "00B523122312312");
        stmt.setString(3, value);
        stmt.execute();
        upsertConn.close();
        Connection conn1 = DriverManager.getConnection(NullIT.getUrl(), props);
        TestUtil.analyzeTable(conn1, tableName);
        conn1.close();
        String query = "SELECT a_string, b_string FROM " + tableName + " WHERE organization_id=? and a_integer = 5";
        try (Connection conn = DriverManager.getConnection(NullIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((Object)"c", (Object)rs.getString("B_string"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testNullStringValue() throws Exception {
        this.testNoStringValue(null);
    }

    @Test
    public void testEmptyStringValue() throws Exception {
        this.testNoStringValue("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsNull() throws Exception {
        String query = "SELECT entity_id FROM " + tableName + " WHERE X_DECIMAL is null";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(NullIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A123122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A223122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A323122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00A423122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B523122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B623122312312");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsNotNull() throws Exception {
        String query = "SELECT entity_id FROM " + tableName + " WHERE X_DECIMAL is not null";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(NullIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B723122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00B823122312312");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"00C923122312312");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBinaryNullAssignment() throws SQLException {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(NullIT.getUrl(), props);
        try (Statement stmt = conn.createStatement();){
            String binTestTable = NullIT.generateUniqueName();
            stmt.execute("create table " + binTestTable + " (id integer not null, text varchar(255), testbin binary(16), CONSTRAINT pk primary key (id))");
            conn.commit();
            String queryIsNull = "select id, text , testbin from " + binTestTable + " where testbin is null";
            stmt.execute("upsert into " + binTestTable + "  (id,text) values (1,'anytext')");
            conn.commit();
            ResultSet rs = stmt.executeQuery(queryIsNull);
            Assert.assertTrue((boolean)rs.next());
            rs.close();
            stmt.execute("upsert into " + binTestTable + "  (id,text,testbin) values (1,'anytext',null)");
            conn.commit();
            rs = stmt.executeQuery(queryIsNull);
            Assert.assertTrue((boolean)rs.next());
            rs.close();
            stmt.execute("upsert into " + binTestTable + "  (id,text,testbin) values (1,'anytext','a')");
            conn.commit();
            rs = stmt.executeQuery(queryIsNull);
            Assert.assertTrue((false == rs.next() ? 1 : 0) != 0);
            rs.close();
            stmt.execute("upsert into " + binTestTable + "  (id,text,testbin) values (1,'anytext',null)");
            conn.commit();
            rs = stmt.executeQuery(queryIsNull);
            Assert.assertTrue((boolean)rs.next());
            rs.close();
            stmt.execute("DROP TABLE " + binTestTable + " ");
            conn.commit();
            rs.close();
        }
    }
}

