/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.PartialScannerResultsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class NoLookbackMutableIndexExtendedIT
extends BaseTest {
    protected final boolean localIndex;
    protected final String tableDDLOptions;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        NoLookbackMutableIndexExtendedIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    public NoLookbackMutableIndexExtendedIT(Boolean localIndex, String txProvider, Boolean columnEncoded) {
        this.localIndex = localIndex;
        StringBuilder optionBuilder = new StringBuilder();
        if (txProvider != null) {
            optionBuilder.append("TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + txProvider + "'");
        }
        if (!columnEncoded.booleanValue()) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    private static Connection getConnection(Properties props) throws SQLException {
        props.setProperty("phoenix.index.mutableBatchSizeThreshold", Integer.toString(1));
        Connection conn = DriverManager.getConnection(NoLookbackMutableIndexExtendedIT.getUrl(), props);
        return conn;
    }

    protected static Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        return NoLookbackMutableIndexExtendedIT.getConnection(props);
    }

    @Parameterized.Parameters(name="NoLookbackMutableIndexExtendedIT_localIndex={0},transactionProvider={1},columnEncoded={2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({false, null, false}, {false, null, true}, {false, "OMID", false}, {true, null, false}, {true, null, true});
    }

    @Test
    public void testCompactDisabledIndex() throws Exception {
        if (this.localIndex || this.tableDDLOptions.contains("TRANSACTIONAL=true")) {
            return;
        }
        try (Connection conn = NoLookbackMutableIndexExtendedIT.getConnection();){
            String schemaName = NoLookbackMutableIndexExtendedIT.generateUniqueName();
            String dataTableName = NoLookbackMutableIndexExtendedIT.generateUniqueName() + "_DATA";
            String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
            String indexTableName = NoLookbackMutableIndexExtendedIT.generateUniqueName() + "_IDX";
            String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
            conn.createStatement().execute(String.format("CREATE TABLE IF NOT EXISTS %s\n(\n    ORGANIZATION_ID CHAR(15) NOT NULL,\n    FEED_ELEMENT_ID CHAR(15) NOT NULL,\n    CONTAINER_ID CHAR(15) NOT NULL,\n    FEED_TYPE VARCHAR(1) NOT NULL, \n    NETWORK_ID CHAR(15) NOT NULL,\n    USER_ID CHAR(15) NOT NULL,\n    CREATED_TIME TIMESTAMP,\n    LAST_UPDATE TIMESTAMP,\n    RELEVANCE_SCORE DOUBLE,\n    FEED_ITEM_TYPE VARCHAR(1),\n    FEED_ELEMENT_TYPE VARCHAR(1),\n    FEED_ELEMENT_IS_SYS_GEN BOOLEAN,\n    FEED_ELEMENT_STATUS VARCHAR(1),\n    FEED_ELEMENT_VISIBILITY VARCHAR(1),\n    PARENT_ID CHAR(15),\n    CREATED_BY CHAR(15),\n    BEST_COMMENT_ID CHAR(15),\n    COMMENT_COUNT INTEGER,\n    CONSTRAINT PK PRIMARY KEY\n    (\n        ORGANIZATION_ID,\n        FEED_ELEMENT_ID,\n        CONTAINER_ID,\n        FEED_TYPE,\n        NETWORK_ID,\n        USER_ID\n    )\n) COLUMN_ENCODED_BYTES = 0", dataTableFullName));
            conn.createStatement().execute(String.format("CREATE INDEX IF NOT EXISTS %s\nON %s (\n    NETWORK_ID,\n    CONTAINER_ID,\n    FEED_TYPE,\n    USER_ID,\n    CREATED_TIME DESC,\n    FEED_ELEMENT_ID DESC,\n    CREATED_BY\n)     INCLUDE (\n    FEED_ITEM_TYPE,\n    FEED_ELEMENT_TYPE,\n    FEED_ELEMENT_IS_SYS_GEN,\n    FEED_ELEMENT_STATUS,\n    FEED_ELEMENT_VISIBILITY,\n    PARENT_ID,\n    BEST_COMMENT_ID,\n    COMMENT_COUNT\n)", indexTableName, dataTableFullName));
            PartialScannerResultsDisabledIT.writeSingleBatch(conn, 1, 1, dataTableFullName);
            List regions = NoLookbackMutableIndexExtendedIT.getUtility().getHBaseCluster().getRegions(TableName.valueOf((String)dataTableFullName));
            HRegion hRegion = (HRegion)regions.get(0);
            hRegion.flush(true);
            conn.createStatement().execute("DELETE FROM " + dataTableFullName);
            conn.commit();
            PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
            IndexUtil.updateIndexState((PhoenixConnection)pConn, (String)indexTableFullName, (PIndexState)PIndexState.DISABLE, (Long)EnvironmentEdgeManager.currentTimeMillis());
            hRegion.flush(true);
            hRegion.compact(true);
            Table dataTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)dataTableFullName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRawRowCount(dataTable));
            IndexUtil.updateIndexState((PhoenixConnection)pConn, (String)indexTableFullName, (PIndexState)PIndexState.INACTIVE, (Long)EnvironmentEdgeManager.currentTimeMillis());
            IndexUtil.updateIndexState((PhoenixConnection)pConn, (String)indexTableFullName, (PIndexState)PIndexState.ACTIVE, (Long)0L);
            hRegion.compact(true);
            dataTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)dataTableFullName));
            Assert.assertEquals((long)0L, (long)TestUtil.getRawRowCount(dataTable));
        }
    }
}

