/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseMutationBatchFailedStateMetricIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.ImmutableIndexIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class MutationBatchFailedStateMetricWithAllUpsertIT
extends BaseMutationBatchFailedStateMetricIT {
    String transactionProvider;

    public MutationBatchFailedStateMetricWithAllUpsertIT(String transactionProvider) {
        super(transactionProvider);
        this.transactionProvider = transactionProvider;
    }

    @Test
    public void testFailedUpsert() throws Exception {
        block4: {
            int numUpsertCount = 3;
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(MutationBatchFailedStateMetricWithAllUpsertIT.getUrl(), props);
                TestUtil.addCoprocessor(conn, this.deleteTableName, ImmutableIndexIT.DeleteFailingRegionObserver.class);
                for (int i = 0; i < numUpsertCount; ++i) {
                    String upsertSQL = String.format(this.upsertStatement, this.deleteTableName);
                    PreparedStatement preparedStatement = conn.prepareStatement(upsertSQL);
                    preparedStatement.setString(1, "ROW_" + i);
                    preparedStatement.setInt(2, i);
                    preparedStatement.setInt(3, 2 * i);
                    preparedStatement.execute();
                }
                conn.commit();
                Assert.fail((String)"Commit should not have succeeded");
            }
            catch (SQLException e) {
                Map mutationMetrics = conn.unwrap(PhoenixConnection.class).getMutationMetrics();
                int dbfs = ((Long)((Map)mutationMetrics.get(this.deleteTableName)).get(MetricType.DELETE_BATCH_FAILED_SIZE)).intValue();
                int upfs = ((Long)((Map)mutationMetrics.get(this.deleteTableName)).get(MetricType.UPSERT_BATCH_FAILED_SIZE)).intValue();
                int mfs = ((Long)((Map)mutationMetrics.get(this.deleteTableName)).get(MetricType.MUTATION_BATCH_FAILED_SIZE)).intValue();
                long gfs = GlobalClientMetrics.GLOBAL_MUTATION_BATCH_FAILED_COUNT.getMetric().getValue();
                Assert.assertEquals((long)0L, (long)dbfs);
                Assert.assertEquals((long)numUpsertCount, (long)upfs);
                Assert.assertEquals((long)numUpsertCount, (long)mfs);
                if (this.transactionProvider == null) {
                    Assert.assertEquals((long)(2 * numUpsertCount), (long)gfs);
                }
                if (!this.transactionProvider.equals("OMID")) break block4;
                Assert.assertEquals((long)numUpsertCount, (long)gfs);
            }
        }
    }
}

