/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.LiteralTTLExpression;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class MoveTTLDuringUpgradeIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveTTLDuringUpgradeIT.class);

    @Test
    public void testMoveHBaseLevelTTLToSYSCAT() throws Exception {
        String schema = "S_" + MoveTTLDuringUpgradeIT.generateUniqueName();
        Admin admin = MoveTTLDuringUpgradeIT.getUtility().getAdmin();
        Map<String, Integer> tableTTLMap = this.createMultiHBaseTablesAndEquivalentInSYSCAT(schema, admin);
        try (PhoenixConnection conn = this.getConnection(false, null).unwrap(PhoenixConnection.class);
             Connection metaConn = this.getConnection(false, null, false, false);){
            PhoenixConnection phxMetaConn = metaConn.unwrap(PhoenixConnection.class);
            phxMetaConn.setRunningUpgrade(true);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("hbase.rpc.timeout", Integer.toString(1800000));
            options.put("hbase.client.scanner.timeout.period", Integer.toString(1800000));
            String clientPort = MoveTTLDuringUpgradeIT.getUtility().getConfiguration().get("hbase.zookeeper.property.clientPort");
            String localQuorum = String.format("localhost:%s", clientPort);
            options.put("hbase.zookeeper.quorum", localQuorum);
            options.put("hbase.zookeeper.property.clientPort", clientPort);
            UpgradeUtil.moveHBaseLevelTTLToSYSCAT((PhoenixConnection)phxMetaConn, options);
            conn.getQueryServices().clearCache();
            phxMetaConn.getQueryServices().clearCache();
            String sql = String.format("SELECT TABLE_NAME, TTL FROM SYSTEM.CATALOG WHERE TABLE_SCHEM = '%s' AND TABLE_TYPE = '%s' AND TTL IS NOT NULL", schema, PTableType.TABLE.getSerializedValue());
            ResultSet rs = phxMetaConn.createStatement().executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                String table = rs.getString(1);
                LOGGER.info("found table {} : {} ", (Object)(++count), (Object)table);
                int ttl = tableTTLMap.get(table);
                int ttlInSyscat = Integer.valueOf(rs.getString(2));
                TableDescriptor tableDescriptor = admin.getDescriptor(TableName.valueOf((String)SchemaUtil.getTableName((String)schema, (String)table)));
                ColumnFamilyDescriptor[] columnFamilies = tableDescriptor.getColumnFamilies();
                if (ttlInSyscat == -1) {
                    Assert.assertEquals((long)ttl, (long)columnFamilies[0].getTimeToLive());
                    Assert.assertEquals((Object)new LiteralTTLExpression(-1), (Object)((PhoenixConnection)phxMetaConn.unwrap(PhoenixConnection.class)).getTableNoCache(null, SchemaUtil.getTableName((byte[])Bytes.toBytes((String)schema), (byte[])Bytes.toBytes((String)table))).getTTLExpression());
                    continue;
                }
                Assert.fail();
            }
            if (count == 0) {
                Assert.fail();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Integer> createMultiHBaseTablesAndEquivalentInSYSCAT(String schema, Admin admin) throws SQLException, IOException {
        TableDescriptorBuilder builder;
        TableName tableName;
        String ddl;
        int i;
        Object table = "";
        int numOfTable = 20;
        int randomTTL = 0;
        HashMap<String, Integer> tableTTLMap = new HashMap<String, Integer>();
        for (i = 0; i < numOfTable; ++i) {
            table = "T_" + MoveTTLDuringUpgradeIT.generateUniqueName();
            randomTTL = i % 3 == 0 ? Integer.MAX_VALUE : 100 + (int)(Math.random() * 1000.0);
            tableTTLMap.put((String)table, randomTTL);
            ddl = "CREATE TABLE  " + schema + "." + (String)table + "  (a_string varchar not null, b_string varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, b_string)) ";
            BaseTest.createTestTable(MoveTTLDuringUpgradeIT.getUrl(), ddl);
            tableName = TableName.valueOf((String)SchemaUtil.getTableName((String)schema, (String)table));
            builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES).setTimeToLive(randomTTL).build());
            admin.disableTable(tableName);
            admin.modifyTable(builder.build());
            admin.enableTable(tableName);
        }
        for (i = numOfTable; i < numOfTable + 2; ++i) {
            table = "T_" + MoveTTLDuringUpgradeIT.generateUniqueName();
            randomTTL = i % 2 == 0 ? Integer.MAX_VALUE : 100 + (int)(Math.random() * 1000.0);
            tableTTLMap.put((String)table, randomTTL);
            ddl = "CREATE TABLE  " + schema + "." + (String)table + "  (a_string varchar not null, b_string varbinary not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string, b_string)) DEFAULT_COLUMN_FAMILY='Z'";
            BaseTest.createTestTable(MoveTTLDuringUpgradeIT.getUrl(), ddl);
            tableName = TableName.valueOf((String)SchemaUtil.getTableName((String)schema, (String)table));
            builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"Z")).setTimeToLive(randomTTL).build());
            admin.disableTable(tableName);
            admin.modifyTable(builder.build());
            admin.enableTable(tableName);
        }
        return tableTTLMap;
    }

    private Connection getConnection(boolean tenantSpecific, String tenantId, boolean isNamespaceMappingEnabled, boolean copyChildLinksDuringUpgrade) throws SQLException {
        if (tenantSpecific) {
            Preconditions.checkNotNull((Object)tenantId);
            return this.createTenantConnection(tenantId);
        }
        Properties props = new Properties();
        if (isNamespaceMappingEnabled) {
            props.setProperty("phoenix.schema.isNamespaceMappingEnabled", "true");
        }
        if (copyChildLinksDuringUpgrade) {
            props.setProperty("phoenix.move.child_link.during.upgrade", "false");
        }
        return DriverManager.getConnection(MoveTTLDuringUpgradeIT.getUrl(), props);
    }

    private Connection getConnection(boolean tenantSpecific, String tenantId) throws SQLException {
        return this.getConnection(tenantSpecific, tenantId, false, false);
    }

    private Connection createTenantConnection(String tenantId) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(MoveTTLDuringUpgradeIT.getUrl(), props);
    }
}

