/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ModulusExpressionIT
extends ParallelStatsDisabledIT {
    private static final long SMALL_VALUE = 31L;
    private static final long LARGE_VALUE = 6767906627531184795L;
    private static final long[] DIVIDENDS = new long[]{Long.MAX_VALUE, 6767906627531184795L, 31L, 0L, -31L, -6767906627531184795L, Long.MIN_VALUE};
    private static final long[] DIVISORS = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 14L, 31L, 127L, 1024L};

    private void initTable(Connection conn, long value, String tableName) throws SQLException {
        String ddl = "CREATE TABLE " + tableName + " (pk BIGINT NOT NULL PRIMARY KEY, kv BIGINT)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES(?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.setLong(1, value);
        stmt.execute();
        conn.commit();
    }

    private void testDividend(long dividend) throws SQLException {
        Connection conn = DriverManager.getConnection(ModulusExpressionIT.getUrl());
        String tableName = ModulusExpressionIT.generateUniqueName();
        this.initTable(conn, dividend, tableName);
        for (long divisor : DIVISORS) {
            long remainder = dividend % divisor;
            String sql = "SELECT pk % " + divisor + " FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)remainder, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSmallPositiveDividend() throws SQLException {
        this.testDividend(31L);
    }

    @Test
    public void testLargePositiveDividend() throws SQLException {
        this.testDividend(6767906627531184795L);
    }

    @Test
    public void testLongMaxDividend() throws SQLException {
        this.testDividend(Long.MAX_VALUE);
    }

    @Test
    public void testSmallNegativeDividend() throws Exception {
        this.testDividend(-31L);
    }

    @Test
    public void testLargeNegativeDividend() throws SQLException {
        this.testDividend(-6767906627531184795L);
    }

    @Test
    public void testLongMinDividend() throws SQLException {
        this.testDividend(Long.MIN_VALUE);
    }

    @Test
    public void testZeroDividend() throws SQLException {
        this.testDividend(0L);
    }

    @Test
    public void testZeroDivisor() throws SQLException {
        Connection conn = DriverManager.getConnection(ModulusExpressionIT.getUrl());
        String tableName = ModulusExpressionIT.generateUniqueName();
        this.initTable(conn, 0L, tableName);
        for (long dividend : DIVIDENDS) {
            try {
                String sql = "SELECT " + dividend + " % pk FROM " + tableName;
                if (dividend == Long.MIN_VALUE) {
                    sql = "SELECT (" + (dividend + 1L) + " + -1) % pk FROM " + tableName;
                }
                ResultSet rs = conn.createStatement().executeQuery(sql);
                rs.next();
                rs.getLong(1);
                Assert.fail((String)("modulus by zero: dividend: " + dividend + ". divisor : 0"));
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testNullDividend() throws SQLException {
        Connection conn = DriverManager.getConnection(ModulusExpressionIT.getUrl());
        String tableName = ModulusExpressionIT.generateUniqueName();
        this.initTable(conn, 31L, tableName);
        for (long divisor : DIVISORS) {
            String sql = "SELECT kv % " + divisor + " FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getObject(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testNullDivisor() throws SQLException {
        Connection conn = DriverManager.getConnection(ModulusExpressionIT.getUrl());
        String tableName = ModulusExpressionIT.generateUniqueName();
        this.initTable(conn, 31L, tableName);
        for (long dividend : DIVIDENDS) {
            String sql = "SELECT " + dividend + " % kv FROM " + tableName;
            if (dividend == Long.MIN_VALUE) {
                sql = "SELECT (" + (dividend + 1L) + " + -1) % kv FROM " + tableName;
            }
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getObject(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testNullEverything() throws SQLException {
        Connection conn = DriverManager.getConnection(ModulusExpressionIT.getUrl());
        String tableName = ModulusExpressionIT.generateUniqueName();
        this.initTable(conn, 31L, tableName);
        String sql = "SELECT null % kv FROM " + tableName;
        ResultSet rs = conn.createStatement().executeQuery(sql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNull((Object)rs.getObject(1));
        Assert.assertFalse((boolean)rs.next());
        sql = "SELECT kv % null FROM " + tableName;
        rs = conn.createStatement().executeQuery(sql);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNull((Object)rs.getObject(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

