/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MixedCaseInnerJoinAliasesIT
extends ParallelStatsDisabledIT {
    @BeforeClass
    public static void setUp() throws Exception {
        Connection conn = DriverManager.getConnection(MixedCaseInnerJoinAliasesIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        String createContractTable = "CREATE TABLE T1 (ID CHAR(256) PRIMARY KEY, \"F\".DUMMY_COLUMN VARCHAR)";
        conn.createStatement().execute(createContractTable);
        String createContractViewSql = "CREATE VIEW V1(ROWKEY VARCHAR PRIMARY KEY,F.COL1 VARCHAR,F.COL2 VARCHAR,F.COL3 VARCHAR) AS SELECT * FROM T1";
        conn.createStatement().execute(createContractViewSql);
        String createCounterPartyTable = "CREATE TABLE T2 (ID CHAR(256) PRIMARY KEY, \"F2\".DUMMY_COLUMN VARCHAR)";
        conn.createStatement().execute(createCounterPartyTable);
        String createCounterPartyViewSql = "CREATE VIEW V2(ROWKEY VARCHAR PRIMARY KEY,F2.COL1 VARCHAR,F2.COL2 VARCHAR,F2.COL3 VARCHAR) AS SELECT * FROM T2";
        conn.createStatement().execute(createCounterPartyViewSql);
    }

    @Test
    public void testInInnerJoinAliasesWithoutQuotes() {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try {
            Connection conn = DriverManager.getConnection(MixedCaseInnerJoinAliasesIT.getUrl(), props);
            String selectQuery = "SELECT MixedCaseAlias1.\"COL1\" AS \"MixedCaseAlias1_COL1\", \"MixedCaseAlias2\".\"COL2\" AS \"MixedCaseAlias2_COL2\", \"MixedCaseAlias2\".\"COL3\" AS \"MixedCaseAlias2_COL3\" FROM (SELECT \"COL1\", \"COL2\" FROM V1) AS MixedCaseAlias1 INNER JOIN V2 AS \"MixedCaseAlias2\" ON (MixedCaseAlias1.\"COL1\" = \"MixedCaseAlias2\".\"COL1\")";
            conn.createStatement().executeQuery(selectQuery);
        }
        catch (Exception e) {
            Assert.fail((String)(e.getClass().getSimpleName() + " was not expectedly thrown: " + e.getMessage()));
        }
    }

    @Test
    public void testInInnerJoinWithAliasesWithQuotes() {
        try {
            Connection conn = DriverManager.getConnection(MixedCaseInnerJoinAliasesIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
            String selectQuery = "SELECT \"MixedCaseAlias1\".\"COL1\" AS \"MixedCaseAlias1_COL1\", \"MixedCaseAlias2\".\"COL2\" AS \"MixedCaseAlias2_COL2\", \"MixedCaseAlias2\".\"COL3\" as \"MixedCaseAlias2_COL3\" FROM (SELECT \"COL1\", \"COL2\" FROM V1) AS \"MixedCaseAlias1\" INNER JOIN V2 AS \"MixedCaseAlias2\" ON (\"MixedCaseAlias1\".\"COL1\" = \"MixedCaseAlias2\".\"COL1\")";
            conn.createStatement().executeQuery(selectQuery);
        }
        catch (Exception e) {
            Assert.fail((String)(e.getClass().getSimpleName() + " was not expectedly thrown: " + e.getMessage()));
        }
    }
}

