/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class MetadataServerConnectionsIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataServerConnectionsIT.class);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.disable.view.subtree.validation", "true");
        MetadataServerConnectionsIT.setUpTestDriver(new ReadOnlyProps((Map)props));
    }

    @Test
    public void testViewCreationAndServerConnections() throws Throwable {
        String tableName = MetadataServerConnectionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        String index_view03 = "idx_v03_" + tableName;
        String index_view04 = "idx_v04_" + tableName;
        int NUM_VIEWS = 50;
        TestMetaDataEndpointImpl.setTestCreateView(true);
        try (java.sql.Connection conn = DriverManager.getConnection(MetadataServerConnectionsIT.getUrl());){
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2)) UPDATE_CACHE_FREQUENCY=ALWAYS, MULTI_TENANT=true");
            conn.commit();
            for (int i = 0; i < 50; ++i) {
                Properties props = new Properties();
                String viewTenantId = String.format("00T%012d", i);
                props.setProperty("TenantId", viewTenantId);
                try (java.sql.Connection tConn = DriverManager.getConnection(MetadataServerConnectionsIT.getUrl(), props);){
                    Statement viewStmt = tConn.createStatement();
                    viewStmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8), COL5 VARCHAR) AS SELECT * FROM " + tableName + " WHERE COL2 = 'col2'");
                    viewStmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
                    tConn.commit();
                    Statement indexStmt = tConn.createStatement();
                    indexStmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
                    indexStmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
                    indexStmt.execute("CREATE INDEX " + index_view03 + " ON " + view01 + " (COL5) INCLUDE (COL2, COL1)");
                    indexStmt.execute("CREATE INDEX " + index_view04 + " ON " + view02 + " (COL6) INCLUDE (COL2, COL1)");
                    tConn.commit();
                    continue;
                }
            }
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        }
    }

    @Test
    public void testConnectionFromMetadataServer() throws Throwable {
        String tableName = MetadataServerConnectionsIT.generateUniqueName();
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        String index_view03 = "idx_v03_" + tableName;
        String index_view04 = "idx_v04_" + tableName;
        try (java.sql.Connection conn = DriverManager.getConnection(MetadataServerConnectionsIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2)) UPDATE_CACHE_FREQUENCY=ALWAYS");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8), COL5 VARCHAR) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            conn.commit();
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE INDEX " + index_view03 + " ON " + view01 + " (COL5) INCLUDE (COL2, COL1)");
            stmt.execute("CREATE INDEX " + index_view04 + " ON " + view02 + " (COL6) INCLUDE (COL2, COL1)");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0001', 'vcol2_01', 'col5_01', 'col6_01')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0002', 'vcol2_02', 'col5_02', 'col6_02')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0003', 'vcol2_03', 'col5_03', 'col6_03')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0004', 'vcol2', 'col3_04', 'col4_04', 'col5_04')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0005', 'vcol-2', 'col3_05', 'col4_05', 'col5_05')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0006', 'vcol-1', 'col3_06', 'col4_06', 'col5_06')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0007', 'vcol1', 'col3_07', 'col4_07', 'col5_07')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0008', 'vcol2_08', 'col5_08', 'col6_02')");
            conn.commit();
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        }
    }

    public static class TestMetaDataEndpointImpl
    extends MetaDataEndpointImpl {
        private RegionCoprocessorEnvironment env;
        private static volatile boolean testCreateView = false;

        public static void setTestCreateView(boolean testCreateView) {
            TestMetaDataEndpointImpl.testCreateView = testCreateView;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            super.start(env);
            if (!(env instanceof RegionCoprocessorEnvironment)) {
                throw new CoprocessorException("Must be loaded on a table region!");
            }
            this.env = (RegionCoprocessorEnvironment)env;
        }

        public void createTable(RpcController controller, MetaDataProtos.CreateTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
            super.createTable(controller, request, done);
            byte[][] rowKeyMetaData = new byte[3][];
            byte[] schemaName = null;
            byte[] tableName = null;
            String fullTableName = null;
            Connection conn = ServerUtil.ConnectionFactory.getConnection((ServerUtil.ConnectionType)ServerUtil.ConnectionType.DEFAULT_SERVER_CONNECTION, (RegionCoprocessorEnvironment)this.env);
            try {
                Table hTable;
                List tableMetadata = ProtobufUtil.getMutations((MetaDataProtos.CreateTableRequest)request);
                MetaDataUtil.getTenantIdAndSchemaAndTableName((List)tableMetadata, (byte[][])rowKeyMetaData);
                schemaName = rowKeyMetaData[1];
                tableName = rowKeyMetaData[2];
                fullTableName = SchemaUtil.getTableName((byte[])schemaName, (byte[])tableName);
                ThreadPoolExecutor ctpe = null;
                ThreadPoolExecutor htpe = null;
                if (conn instanceof ConnectionImplementation) {
                    ConnectionImplementation connImpl = (ConnectionImplementation)conn;
                    Field props = null;
                    props = ConnectionImplementation.class.getDeclaredField("batchPool");
                    props.setAccessible(true);
                    ctpe = (ThreadPoolExecutor)props.get(connImpl);
                    LOGGER.debug("ConnectionImplementation Thread pool info :" + ctpe.toString());
                }
                if ((hTable = ServerUtil.getHTableForCoprocessorScan((RegionCoprocessorEnvironment)this.env, (TableName)TableName.valueOf((String)fullTableName))) instanceof HTable) {
                    HTable testTable = (HTable)hTable;
                    Field props = testTable.getClass().getDeclaredField("pool");
                    props.setAccessible(true);
                    htpe = (ThreadPoolExecutor)props.get(hTable);
                    LOGGER.debug("HTable Thread pool info :" + htpe.toString());
                    Assert.assertEquals((long)htpe.getMaximumPoolSize(), (long)10L);
                    Assert.assertEquals((long)htpe.getCorePoolSize(), (long)10L);
                    LOGGER.debug("HTable threadpool info {}, {}, {}, {}", new Object[]{htpe.getCorePoolSize(), htpe.getMaximumPoolSize(), htpe.getQueue().remainingCapacity(), htpe.getKeepAliveTime(TimeUnit.SECONDS)});
                    int count = Thread.activeCount();
                    Thread[] th = new Thread[count];
                    Thread.enumerate(th);
                    long hTablePoolCount = Arrays.stream(th).filter(s -> s.getName().equals("htable-pool-0")).count();
                    Assert.assertEquals((long)0L, (long)hTablePoolCount);
                    LOGGER.debug("htable-pool-0 threads {}", (Object)hTablePoolCount);
                }
                Assert.assertEquals(ctpe, htpe);
            }
            catch (IOException | IllegalAccessException | NoSuchFieldException | RuntimeException t) {
                MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
                LOGGER.error("This is unexpected");
                ProtobufUtil.setControllerException((RpcController)controller, (IOException)ClientUtil.createIOException((String)SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, (boolean)false).toString(), (Throwable)new DoNotRetryIOException("Not allowed")));
                done.run((Object)builder.build());
            }
        }

        public void getVersion(RpcController controller, MetaDataProtos.GetVersionRequest request, RpcCallback<MetaDataProtos.GetVersionResponse> done) {
            MetaDataProtos.GetVersionResponse.Builder builder = MetaDataProtos.GetVersionResponse.newBuilder();
            LOGGER.error("This is unexpected");
            ProtobufUtil.setControllerException((RpcController)controller, (IOException)ClientUtil.createIOException((String)SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, (boolean)false).toString(), (Throwable)new DoNotRetryIOException("Not allowed")));
            builder.setVersion(-1L);
            done.run((Object)builder.build());
        }
    }
}

