/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class MetadataGetTableReadLockIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        MetadataGetTableReadLockIT.setUpTestDriver(new ReadOnlyProps((Map)props));
    }

    @Test
    public void testBlockedReadDoesNotBlockAnotherRead() throws Exception {
        long SLEEP_DURATION = 5000L;
        String tableName = MetadataGetTableReadLockIT.generateUniqueName();
        CountDownLatch sleepSignal = new CountDownLatch(1);
        try (Connection conn = DriverManager.getConnection(MetadataGetTableReadLockIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + tableName + "(k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER, v2 INTEGER)");
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
            BlockingMetaDataEndpointImpl.setSleepSignal(sleepSignal);
            BlockingMetaDataEndpointImpl.setSleepDuration(SLEEP_DURATION);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", BlockingMetaDataEndpointImpl.class);
            Thread t1 = MetadataGetTableReadLockIT.getQueryThread(tableName);
            Thread t2 = MetadataGetTableReadLockIT.getQueryThread(tableName);
            t1.start();
            sleepSignal.await();
            BlockingMetaDataEndpointImpl.setSleepDuration(0L);
            long start = System.currentTimeMillis();
            t2.start();
            t2.join();
            long end = System.currentTimeMillis();
            t1.join();
            Assert.assertTrue((String)"Second thread should not have been blocked by the first thread.", (end - start < SLEEP_DURATION ? 1 : 0) != 0);
        }
    }

    private static Thread getQueryThread(String tableName) {
        Runnable runnable = () -> {
            try (Connection conn1 = DriverManager.getConnection(MetadataGetTableReadLockIT.getUrl());){
                conn1.createStatement().execute("SELECT * FROM " + tableName + " LIMIT 1");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        Thread t = new Thread(runnable);
        return t;
    }

    @AfterClass
    public static synchronized void cleanup() throws Exception {
        try (Connection conn = DriverManager.getConnection(MetadataGetTableReadLockIT.getUrl());){
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", BlockingMetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        }
    }

    public static class BlockingMetaDataEndpointImpl
    extends MetaDataEndpointImpl {
        private static volatile long sleepDuration;
        private static CountDownLatch sleepSignal;

        public static void setSleepDuration(long sleepDuration) {
            BlockingMetaDataEndpointImpl.sleepDuration = sleepDuration;
        }

        public static void setSleepSignal(CountDownLatch sleepSignal) {
            BlockingMetaDataEndpointImpl.sleepSignal = sleepSignal;
        }

        protected Region.RowLock acquireLock(Region region, byte[] lockKey, List<Region.RowLock> locks, boolean readLock) throws IOException {
            long tmpSleepDuration = sleepDuration;
            Region.RowLock rowLock = region.getRowLock(lockKey, this.getMetadataReadLockEnabled && readLock);
            if (rowLock == null) {
                throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary((byte[])lockKey));
            }
            if (locks != null) {
                locks.add(rowLock);
            }
            sleepSignal.countDown();
            try {
                Thread.sleep(tmpSleepDuration);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return rowLock;
        }
    }
}

