/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class MappingTableDataTypeIT
extends ParallelStatsDisabledIT {
    @Test
    public void testMappingHbaseTableToPhoenixTable() throws Exception {
        String mtest = MappingTableDataTypeIT.generateUniqueName();
        TableName tableName = TableName.valueOf((String)mtest);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        PhoenixConnection conn = DriverManager.getConnection(MappingTableDataTypeIT.getUrl(), props).unwrap(PhoenixConnection.class);
        try (Table t = conn.getQueryServices().getTable(Bytes.toBytes((String)mtest));
             Admin admin = conn.getQueryServices().getAdmin();){
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"cf1"))).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"cf2")));
            admin.createTable(builder.build());
            this.insertData(tableName.getName(), admin, t);
            this.createPhoenixTable(mtest);
            String selectSql = "SELECT * FROM " + mtest;
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            Assert.assertTrue((String)"Expected single row", (boolean)rs.next());
            Assert.assertEquals((String)"Number of columns", (long)2L, (long)rsMetaData.getColumnCount());
            Assert.assertEquals((String)"Column Value", (Object)"value1", (Object)rs.getString(2));
            Assert.assertFalse((String)"Expected single row ", (boolean)rs.next());
            String deleteSql = "DELETE FROM " + mtest + " WHERE id = 'row'";
            conn.createStatement().executeUpdate(deleteSql);
            conn.commit();
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((String)"Expected no row` ", (boolean)rs.next());
            Scan scan = new Scan();
            ResultScanner results = t.getScanner(scan);
            Result result = results.next();
            Assert.assertNotNull((String)"Expected single row", (Object)result);
            List kvs = result.getColumnCells(Bytes.toBytes((String)"cf2"), Bytes.toBytes((String)"q2"));
            Assert.assertEquals((String)"Expected single value ", (long)1L, (long)kvs.size());
            Assert.assertEquals((String)"Column Value", (Object)"value2", (Object)Bytes.toString((byte[])((Cell)kvs.get(0)).getValueArray(), (int)((Cell)kvs.get(0)).getValueOffset(), (int)((Cell)kvs.get(0)).getValueLength()));
            Assert.assertNull((String)"Expected single row", (Object)results.next());
        }
    }

    private void insertData(byte[] tableName, Admin admin, Table t) throws IOException, InterruptedException {
        Put p = new Put(Bytes.toBytes((String)"row"));
        p.addColumn(Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"value1"));
        p.addColumn(Bytes.toBytes((String)"cf2"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"value2"));
        t.put(p);
        admin.flush(TableName.valueOf((byte[])tableName));
    }

    private void createPhoenixTable(String tableName) throws SQLException {
        String ddl = "create table IF NOT EXISTS " + tableName + " ( id varchar NOT NULL primary key, \"cf1\".\"q1\" varchar ) COLUMN_ENCODED_BYTES=NONE";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(MappingTableDataTypeIT.getUrl(), props);
        conn.createStatement().execute(ddl);
        conn.commit();
    }
}

