/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class MD5FunctionIT
extends ParallelStatsDisabledIT {
    @Test
    public void testRetrieve() throws Exception {
        String testString = "mwalsh";
        Connection conn = DriverManager.getConnection(MD5FunctionIT.getUrl());
        String md5_retrieve_test = MD5FunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + md5_retrieve_test + " (pk VARCHAR NOT NULL PRIMARY KEY)";
        conn.createStatement().execute(ddl);
        String dml = String.format("UPSERT INTO " + md5_retrieve_test + " VALUES('%s')", testString);
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT MD5(pk) FROM " + md5_retrieve_test);
        Assert.assertTrue((boolean)rs.next());
        byte[] first = MessageDigest.getInstance("MD5").digest(testString.getBytes());
        byte[] second = rs.getBytes(1);
        Assert.assertArrayEquals((byte[])first, (byte[])second);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testRetrieveCompositeKey() throws Exception {
        String testString = "FOOBAR";
        Connection conn = DriverManager.getConnection(MD5FunctionIT.getUrl());
        String md5_retrieve_test = MD5FunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + md5_retrieve_test + " (k1 CHAR(3) NOT NULL, k2 CHAR(3) NOT NULL, CONSTRAINT PK PRIMARY KEY (K1,K2))";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + md5_retrieve_test + " VALUES('FOO','BAR')";
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT MD5((K1,K2)) FROM " + md5_retrieve_test);
        Assert.assertTrue((boolean)rs.next());
        byte[] first = MessageDigest.getInstance("MD5").digest(testString.getBytes());
        byte[] second = rs.getBytes(1);
        Assert.assertArrayEquals((byte[])first, (byte[])second);
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testUpsert() throws Exception {
        String testString1 = "mwalsh1";
        String testString2 = "mwalsh2";
        Connection conn = DriverManager.getConnection(MD5FunctionIT.getUrl());
        String md5_upsert_test = MD5FunctionIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + md5_upsert_test + " (k1 binary(16) NOT NULL,k2 binary(16) NOT NULL  CONSTRAINT pk PRIMARY KEY (k1, k2))";
        conn.createStatement().execute(ddl);
        String dml = String.format("UPSERT INTO " + md5_upsert_test + " VALUES(md5('%s'),md5('%s'))", testString1, testString2);
        conn.createStatement().execute(dml);
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1,k2 FROM " + md5_upsert_test);
        Assert.assertTrue((boolean)rs.next());
        byte[] pk1 = MessageDigest.getInstance("MD5").digest(testString1.getBytes());
        byte[] pk2 = MessageDigest.getInstance("MD5").digest(testString2.getBytes());
        Assert.assertArrayEquals((byte[])pk1, (byte[])rs.getBytes(1));
        Assert.assertArrayEquals((byte[])pk2, (byte[])rs.getBytes(2));
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement stmt = conn.prepareStatement("SELECT k1,k2 FROM " + md5_upsert_test + " WHERE k1=md5(?)");
        stmt.setString(1, testString1);
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        byte[] second1 = rs.getBytes(1);
        byte[] second2 = rs.getBytes(2);
        Assert.assertArrayEquals((byte[])pk1, (byte[])second1);
        Assert.assertArrayEquals((byte[])pk2, (byte[])second2);
        Assert.assertFalse((boolean)rs.next());
    }
}

