/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.end2end.AlterTableIT;
import org.apache.phoenix.end2end.IndexScrutinyToolBaseIT;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.LogicalTableNameBaseIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.join.HashJoinGlobalIndexIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={NeedsOwnMiniClusterTest.class})
public class LogicalTableNameIT
extends LogicalTableNameBaseIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicalTableNameIT.class);
    protected boolean createChildAfterRename;
    private boolean immutable;
    private Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        LogicalTableNameIT.initCluster(false);
    }

    public LogicalTableNameIT(boolean createChildAfterRename, boolean immutable) {
        this.createChildAfterRename = createChildAfterRename;
        this.immutable = immutable;
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append(" ,IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN");
        if (immutable) {
            optionBuilder.append(" , IMMUTABLE_ROWS=true");
        }
        this.dataTableDdl = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="createChildAfterRename={0}, immutable={1}")
    public static synchronized Collection<Object[]> data() {
        boolean[] Booleans;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)2);
        for (boolean immutable : Booleans = new boolean[]{false, true}) {
            for (boolean createAfter : Booleans) {
                list.add(new Object[]{createAfter, immutable});
            }
        }
        return list;
    }

    @Test
    public void testUpdatePhysicalTableNameWithIndex() throws Exception {
        String schemaName = "S_" + LogicalTableNameIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameIT.generateUniqueName();
        String indexName = "IDX_" + LogicalTableNameIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = this.getConnection(this.props);
             Connection conn2 = this.getConnection(this.props);){
            HashMap<String, ArrayList<String>> expected = this.testBaseTableWithIndex_BaseTableChange(conn, conn2, schemaName, tableName, indexName, false, this.createChildAfterRename);
            IndexToolIT.runIndexTool(false, schemaName, tableName, indexName);
            this.validateTable(conn, fullTableName);
            this.validateTable(conn2, fullTableName);
            this.validateIndex(conn, fullIndexName, false, expected);
            this.validateIndex(conn2, fullIndexName, false, expected);
            this.populateTable(conn, fullTableName, 10, 1);
            ResultSet rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullIndexName + " WHERE \":PK1\"='PK10'");
            Assert.assertEquals((Object)true, (Object)rs.next());
            rs = conn.createStatement().executeQuery("SELECT * FROM " + fullTableName + " WHERE PK1='PK10'");
            Assert.assertEquals((Object)true, (Object)rs.next());
            conn.createStatement().execute("DELETE from " + fullTableName + " WHERE PK1='PK10'");
            rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullIndexName + " WHERE \":PK1\"='PK10'");
            Assert.assertEquals((Object)false, (Object)rs.next());
            rs = conn.createStatement().executeQuery("SELECT * FROM " + fullTableName + " WHERE PK1='PK10'");
            Assert.assertEquals((Object)false, (Object)rs.next());
            conn2.createStatement().execute("DROP TABLE " + fullTableName);
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                Assert.assertEquals((Object)false, (Object)admin.tableExists(TableName.valueOf((String)SchemaUtil.getTableName((String)schemaName, (String)("NEW_TBL_" + tableName)))));
                Assert.assertEquals((Object)false, (Object)admin.tableExists(TableName.valueOf((String)fullIndexName)));
            }
        }
    }

    @Test
    public void testUpdatePhysicalTableNameWithIndex_runScrutiny() throws Exception {
        String schemaName = "S_" + LogicalTableNameIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameIT.generateUniqueName();
        String indexName = "IDX_" + LogicalTableNameIT.generateUniqueName();
        try (Connection conn = this.getConnection(this.props);
             Connection conn2 = this.getConnection(this.props);){
            this.testBaseTableWithIndex_BaseTableChange(conn, conn2, schemaName, tableName, indexName, false, this.createChildAfterRename);
            List<Job> completedJobs = IndexScrutinyToolBaseIT.runScrutinyTool(schemaName, tableName, indexName, 1L, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE);
            Job job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            if (this.createChildAfterRename) {
                Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).getValue());
                Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue());
            } else {
                Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).getValue());
                Assert.assertEquals((long)1L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue());
            }
        }
    }

    @Test
    public void testUpdatePhysicalIndexTableName() throws Exception {
        String schemaName = "S_" + LogicalTableNameIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameIT.generateUniqueName();
        String indexName = "IDX_" + LogicalTableNameIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = this.getConnection(this.props);
             Connection conn2 = this.getConnection(this.props);){
            HashMap<String, ArrayList<String>> expected = this.test_IndexTableChange(conn, conn2, schemaName, tableName, indexName, QueryConstants.VERIFIED_BYTES, false);
            this.validateIndex(conn, fullIndexName, false, expected);
            this.validateIndex(conn2, fullIndexName, false, expected);
            String indexName2 = "IDX2_" + LogicalTableNameIT.generateUniqueName();
            String fullIndexName2 = SchemaUtil.getTableName((String)schemaName, (String)indexName2);
            if (this.createChildAfterRename) {
                this.createIndexOnTable(conn2, fullTableName, indexName2);
            }
            this.dropIndex(conn2, fullTableName, indexName);
            if (!this.createChildAfterRename) {
                this.createIndexOnTable(conn2, fullTableName, indexName2);
            }
            expected.remove("PK3");
            this.validateIndex(conn, fullIndexName2, false, expected);
            this.validateIndex(conn2, fullIndexName2, false, expected);
        }
    }

    @Test
    public void testUpdatePhysicalIndexTableName_runScrutiny() throws Exception {
        String schemaName = "S_" + LogicalTableNameIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameIT.generateUniqueName();
        String indexName = "IDX_" + LogicalTableNameIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (Connection conn = this.getConnection(this.props);
             Connection conn2 = this.getConnection(this.props);){
            this.test_IndexTableChange(conn, conn2, schemaName, tableName, indexName, QueryConstants.VERIFIED_BYTES, false);
            List<Job> completedJobs = IndexScrutinyToolBaseIT.runScrutinyTool(schemaName, tableName, indexName, 1L, IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
            Job job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).getValue());
            Assert.assertEquals((long)1L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue());
            String tableName2 = "TBL_" + LogicalTableNameIT.generateUniqueName();
            String indexName2 = "IDX_" + LogicalTableNameIT.generateUniqueName();
            this.test_IndexTableChange(conn, conn2, schemaName, tableName2, indexName2, QueryConstants.UNVERIFIED_BYTES, false);
            completedJobs = IndexScrutinyToolBaseIT.runScrutinyTool(schemaName, tableName2, indexName2, 1L, IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE);
            job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            counters = job.getCounters();
            Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue());
        }
    }

    @Test
    public void testUpdatePhysicalTableNameWithViews() throws Exception {
        try (Connection conn = this.getConnection(this.props);
             Connection conn2 = this.getConnection(this.props);){
            String schemaName = "S_" + LogicalTableNameIT.generateUniqueName();
            String tableName = "TBL_" + LogicalTableNameIT.generateUniqueName();
            String view1Name = "VW1_" + LogicalTableNameIT.generateUniqueName();
            String view1IndexName1 = "VW1IDX1_" + LogicalTableNameIT.generateUniqueName();
            String view1IndexName2 = "VW1IDX2_" + LogicalTableNameIT.generateUniqueName();
            String fullView1IndexName1 = SchemaUtil.getTableName((String)schemaName, (String)view1IndexName1);
            String fullView1IndexName2 = SchemaUtil.getTableName((String)schemaName, (String)view1IndexName2);
            String view2Name = "VW2_" + LogicalTableNameIT.generateUniqueName();
            String view2IndexName1 = "VW2IDX1_" + LogicalTableNameIT.generateUniqueName();
            String fullView1Name = SchemaUtil.getTableName((String)schemaName, (String)view1Name);
            String fullView2Name = SchemaUtil.getTableName((String)schemaName, (String)view2Name);
            String fullView2IndexName1 = SchemaUtil.getTableName((String)schemaName, (String)view2IndexName1);
            HashMap<String, ArrayList<String>> expected = this.testWithViewsAndIndex_BaseTableChange(conn, conn2, null, schemaName, tableName, view1Name, view1IndexName1, view1IndexName2, view2Name, view2IndexName1, false, this.createChildAfterRename);
            IndexToolIT.runIndexTool(false, schemaName, view1Name, view1IndexName1);
            IndexToolIT.runIndexTool(false, schemaName, view1Name, view1IndexName2);
            IndexToolIT.runIndexTool(false, schemaName, view2Name, view2IndexName1);
            this.validateIndex(conn, fullView1IndexName1, true, expected);
            this.validateIndex(conn2, fullView1IndexName2, true, expected);
            this.populateView(conn, fullView2Name, 20, 1);
            ResultSet rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullView2IndexName1 + " WHERE \":PK1\"='PK20'");
            Assert.assertEquals((Object)true, (Object)rs.next());
            rs = conn.createStatement().executeQuery("SELECT * FROM " + fullView2Name + " WHERE PK1='PK20'");
            Assert.assertEquals((Object)true, (Object)rs.next());
            conn.createStatement().execute("DELETE from " + fullView2Name + " WHERE PK1='PK20'");
            rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullView2IndexName1 + " WHERE \":PK1\"='PK20'");
            Assert.assertEquals((Object)false, (Object)rs.next());
            rs = conn.createStatement().executeQuery("SELECT * FROM " + fullView2Name + " WHERE PK1='PK20'");
            Assert.assertEquals((Object)false, (Object)rs.next());
            conn2.createStatement().execute("DROP VIEW " + fullView2Name);
            rs = conn.createStatement().executeQuery("SELECT * FROM " + fullView1Name);
            Assert.assertEquals((Object)true, (Object)rs.next());
            boolean failed = true;
            try (ResultSet rsFail = conn.createStatement().executeQuery("SELECT * FROM " + fullView2Name);){
                rsFail.next();
                failed = false;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Assert.assertEquals((Object)true, (Object)failed);
            rs = conn2.createStatement().executeQuery("SELECT * FROM " + fullView1IndexName1);
            Assert.assertEquals((Object)true, (Object)rs.next());
            try {
                rs = conn.createStatement().executeQuery("SELECT * FROM " + fullView2IndexName1);
                rs.next();
                failed = false;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Assert.assertEquals((Object)true, (Object)failed);
        }
    }

    @Test
    public void testUpdatePhysicalTableNameWithViews_runScrutiny() throws Exception {
        try (Connection conn = this.getConnection(this.props);
             Connection conn2 = this.getConnection(this.props);){
            String schemaName = "S_" + LogicalTableNameIT.generateUniqueName();
            String tableName = "TBL_" + LogicalTableNameIT.generateUniqueName();
            String view1Name = "VW1_" + LogicalTableNameIT.generateUniqueName();
            String view1IndexName1 = "VW1IDX1_" + LogicalTableNameIT.generateUniqueName();
            String view1IndexName2 = "VW1IDX2_" + LogicalTableNameIT.generateUniqueName();
            String view2Name = "VW2_" + LogicalTableNameIT.generateUniqueName();
            String view2IndexName1 = "VW2IDX1_" + LogicalTableNameIT.generateUniqueName();
            this.testWithViewsAndIndex_BaseTableChange(conn, conn2, null, schemaName, tableName, view1Name, view1IndexName1, view1IndexName2, view2Name, view2IndexName1, false, this.createChildAfterRename);
            List<Job> completedJobs = IndexScrutinyToolBaseIT.runScrutinyTool(schemaName, view2Name, view2IndexName1, 1L, IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE);
            Job job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            Counters counters = job.getCounters();
            if (this.createChildAfterRename) {
                Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).getValue());
                Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue());
            } else {
                Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).getValue());
                Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue());
            }
        }
    }

    @Test
    public void testWith2LevelViewsBaseTablePhysicalNameChange() throws Exception {
        String schemaName = "S_" + LogicalTableNameIT.generateUniqueName();
        String tableName = "TBL_" + LogicalTableNameIT.generateUniqueName();
        String view1Name = "VW1_" + LogicalTableNameIT.generateUniqueName();
        String level2ViewName = "VW1_CH1_" + LogicalTableNameIT.generateUniqueName();
        String fullLevel2ViewName = SchemaUtil.getTableName((String)schemaName, (String)level2ViewName);
        String view1IndexName1 = "VW1IDX1_" + LogicalTableNameIT.generateUniqueName();
        String level2ViewIndexName = "VW1_CH1IDX_" + LogicalTableNameIT.generateUniqueName();
        String fullView1Name = SchemaUtil.getTableName((String)schemaName, (String)view1Name);
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (Connection conn = this.getConnection(this.props);
             Connection conn2 = this.getConnection(this.props);){
            conn.setAutoCommit(true);
            conn2.setAutoCommit(true);
            HashMap<String, ArrayList<String>> expected = new HashMap<String, ArrayList<String>>();
            this.createTable(conn, fullTableName);
            this.createViewAndIndex(conn2, schemaName, tableName, view1Name, view1IndexName1);
            this.createViewAndIndex(conn2, schemaName, tableName, view1Name, view1IndexName1);
            expected.putAll(this.populateView(conn, fullView1Name, 1, 2));
            String ddl = "CREATE VIEW " + fullLevel2ViewName + "(chv2 VARCHAR) AS SELECT * FROM " + fullView1Name;
            String indexDdl = "CREATE INDEX " + level2ViewIndexName + " ON " + fullLevel2ViewName + " (chv2) INCLUDE (v1, VIEW_COL1)";
            if (!this.createChildAfterRename) {
                conn.createStatement().execute(ddl);
                conn.createStatement().execute(indexDdl);
            }
            String newTableName = "NEW_TBL_" + LogicalTableNameIT.generateUniqueName();
            String fullTableHbaseName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
            LogicalTableNameIT.createAndPointToNewPhysicalTable(conn, fullTableHbaseName, newTableName, false);
            conn.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            if (this.createChildAfterRename) {
                conn.createStatement().execute(ddl);
                conn.createStatement().execute(indexDdl);
            }
            String upsert = "UPSERT INTO " + fullLevel2ViewName + " (PK1, V1, VIEW_COL1, CHV2) VALUES (?,?,?,?)";
            PreparedStatement upsertStmt = conn.prepareStatement(upsert);
            ArrayList row = new ArrayList();
            upsertStmt.setString(1, "PK10");
            upsertStmt.setString(2, "V10");
            upsertStmt.setString(3, "VIEW_COL1_10");
            upsertStmt.setString(4, "CHV210");
            upsertStmt.executeUpdate();
            String selectFromL2View = "SELECT /*+ NO_INDEX */ * FROM " + fullLevel2ViewName + " WHERE chv2='CHV210'";
            ResultSet rs = conn2.createStatement().executeQuery(selectFromL2View);
            Assert.assertEquals((Object)true, (Object)rs.next());
            Assert.assertEquals((Object)false, (Object)rs.next());
            String indexSelect = "SELECT chv2, V1, VIEW_COL1 FROM " + fullLevel2ViewName + " WHERE chv2='CHV210'";
            rs = conn2.createStatement().executeQuery("EXPLAIN " + indexSelect);
            Assert.assertEquals((Object)true, (Object)QueryUtil.getExplainPlan((ResultSet)rs).contains("_IDX_"));
            rs = conn2.createStatement().executeQuery(indexSelect);
            Assert.assertEquals((Object)true, (Object)rs.next());
            Assert.assertEquals((Object)false, (Object)rs.next());
            conn2.createStatement().execute("DELETE FROM " + fullLevel2ViewName + " WHERE chv2='CHV210'");
            rs = conn2.createStatement().executeQuery(indexSelect);
            Assert.assertEquals((Object)false, (Object)rs.next());
        }
    }

    @Test
    @Ignore(value="Requires PHOENIX-6722")
    public void testChangeDetectionAfterTableNameChange() throws Exception {
        try (PhoenixConnection conn = (PhoenixConnection)this.getConnection(this.props);){
            String schemaName = "S_" + LogicalTableNameIT.generateUniqueName();
            String tableName = "T_" + LogicalTableNameIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
            this.createTable((Connection)conn, fullTableName);
            String alterDdl = "ALTER TABLE " + fullTableName + " SET CHANGE_DETECTION_ENABLED=true";
            conn.createStatement().execute(alterDdl);
            PTable table = conn.getTableNoCache(fullTableName);
            Assert.assertTrue((boolean)table.isChangeDetectionEnabled());
            Assert.assertNotNull((Object)table.getExternalSchemaId());
            AlterTableIT.verifySchemaExport(table, LogicalTableNameIT.getUtility().getConfiguration());
            String newTableName = "T_" + LogicalTableNameIT.generateUniqueName();
            String fullNewTableName = SchemaUtil.getTableName((String)schemaName, (String)newTableName);
            LogicalTableNameIT.createAndPointToNewPhysicalTable((Connection)conn, fullTableName, fullNewTableName, false);
            PTable newTable = conn.getTableNoCache(fullTableName);
            AlterTableIT.verifySchemaExport(newTable, LogicalTableNameIT.getUtility().getConfiguration());
        }
    }

    @Test
    public void testHashJoin() throws Exception {
        if (this.immutable || this.createChildAfterRename) {
            return;
        }
        Object[] arr = HashJoinGlobalIndexIT.data().toArray();
        String[] indexDDL = ((String[][])arr[0])[0];
        String[] plans = ((String[][])arr[0])[1];
        HashJoinGlobalIndexIT hjgit = new HashJoinGlobalIndexIT(indexDDL, plans);
        hjgit.createSchema();
        hjgit.testInnerJoin(false);
    }
}

