/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class LocalIndexSplitMergeIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        LocalIndexSplitMergeIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    private java.sql.Connection getConnectionForLocalIndexTest() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        return DriverManager.getConnection(LocalIndexSplitMergeIT.getUrl(), props);
    }

    private void createBaseTable(String tableName, String splits) throws SQLException {
        java.sql.Connection conn = this.getConnectionForLocalIndexTest();
        String ddl = "CREATE TABLE " + tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nk3 INTEGER,\nv1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n" + (String)(splits != null ? " split on " + splits : "");
        conn.createStatement().execute(ddl);
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexScanAfterRegionSplit() throws Exception {
        String schemaName = LocalIndexSplitMergeIT.generateUniqueName();
        String tableName = schemaName + "." + LocalIndexSplitMergeIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexSplitMergeIT.generateUniqueName();
        String fullIndexName = schemaName + "." + indexName;
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)false);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, "('e','j','o')");
        try (java.sql.Connection conn1 = this.getConnectionForLocalIndexTest();){
            Object[] strings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
            for (int i = 0; i < 26; ++i) {
                conn1.createStatement().execute("UPSERT INTO " + tableName + " values('" + strings[i] + "'," + i + "," + (i + 1) + "," + (i + 2) + ",'" + strings[25 - i] + "')");
            }
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + "_2 ON " + tableName + "(k3)");
            ResultSet rs = conn1.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Admin admin = conn1.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            for (int i = 1; i < 3; ++i) {
                admin.split(physicalTableName, ByteUtil.concat((byte[])Bytes.toBytes((String)strings[3 * i]), (byte[][])new byte[0][]));
                List regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)physicalTableName, (boolean)false);
                while (regionsOfUserTable.size() != 4 + i) {
                    Thread.sleep(100L);
                    regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)physicalTableName, (boolean)false);
                }
                Assert.assertEquals((long)(4 + i), (long)regionsOfUserTable.size());
                Object[] tIdColumnValues = new String[26];
                Object[] v1ColumnValues = new String[26];
                int[] k1ColumnValue = new int[26];
                String query = "SELECT t_id,k1,v1 FROM " + tableName;
                rs = conn1.createStatement().executeQuery(query);
                Thread.sleep(1000L);
                for (int j = 0; j < 26; ++j) {
                    Assert.assertTrue((String)("No row found at " + j), (boolean)rs.next());
                    tIdColumnValues[j] = rs.getString("t_id");
                    k1ColumnValue[j] = rs.getInt("k1");
                    v1ColumnValues[j] = rs.getString("V1");
                }
                Arrays.sort(tIdColumnValues);
                Arrays.sort(v1ColumnValues);
                Arrays.sort(k1ColumnValue);
                Assert.assertTrue((boolean)Arrays.equals(strings, tIdColumnValues));
                Assert.assertTrue((boolean)Arrays.equals(strings, v1ColumnValues));
                for (int m = 0; m < 26; ++m) {
                    Assert.assertEquals((long)m, (long)k1ColumnValue[m]);
                }
                ExplainPlan plan = conn1.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
                Assert.assertEquals((Object)("PARALLEL " + (4 + i) + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)(fullIndexName + "(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                query = "SELECT t_id,k1,k3 FROM " + tableName;
                plan = conn1.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
                explainPlanAttributes = plan.getPlanStepsAsAttributes();
                Assert.assertEquals((Object)("PARALLEL " + (((String)strings[3 * i]).compareTo("j") < 0 ? 4 + i : 4 + i - 1) + "-WAY"), (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)(fullIndexName + "_2(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [2]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                rs = conn1.createStatement().executeQuery(query);
                Thread.sleep(1000L);
                int[] k3ColumnValue = new int[26];
                for (int j = 0; j < 26; ++j) {
                    Assert.assertTrue((boolean)rs.next());
                    tIdColumnValues[j] = rs.getString("t_id");
                    k1ColumnValue[j] = rs.getInt("k1");
                    k3ColumnValue[j] = rs.getInt("k3");
                }
                Arrays.sort(tIdColumnValues);
                Arrays.sort(k1ColumnValue);
                Arrays.sort(k3ColumnValue);
                Assert.assertTrue((boolean)Arrays.equals(strings, tIdColumnValues));
                for (int m = 0; m < 26; ++m) {
                    Assert.assertEquals((long)m, (long)k1ColumnValue[m]);
                    Assert.assertEquals((long)(m + 2), (long)k3ColumnValue[m]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexScanAfterRegionsMerge() throws Exception {
        String schemaName = LocalIndexSplitMergeIT.generateUniqueName();
        String tableName = schemaName + "." + LocalIndexSplitMergeIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexSplitMergeIT.generateUniqueName();
        String fullIndexName = schemaName + "." + indexName;
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)false);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, "('e','j','o')");
        try (java.sql.Connection conn1 = this.getConnectionForLocalIndexTest();){
            String[] strings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
            for (int i = 0; i < 26; ++i) {
                conn1.createStatement().execute("UPSERT INTO " + tableName + " values('" + strings[i] + "'," + i + "," + (i + 1) + "," + (i + 2) + ",'" + strings[25 - i] + "')");
            }
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + "_2 ON " + tableName + "(k3)");
            ResultSet rs = conn1.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Admin admin = conn1.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            List regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)physicalTableName, (boolean)false);
            admin.mergeRegionsAsync(((RegionInfo)regionsOfUserTable.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regionsOfUserTable.get(1)).getEncodedNameAsBytes(), false);
            regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)physicalTableName, (boolean)false);
            while (regionsOfUserTable.size() != 3) {
                Thread.sleep(100L);
                regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)physicalTableName, (boolean)false);
            }
            String query = "SELECT t_id,k1,v1 FROM " + tableName;
            rs = conn1.createStatement().executeQuery(query);
            Thread.sleep(1000L);
            for (int j = 0; j < 26; ++j) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)strings[25 - j], (Object)rs.getString("t_id"));
                Assert.assertEquals((long)(25 - j), (long)rs.getInt("k1"));
                Assert.assertEquals((Object)strings[j], (Object)rs.getString("V1"));
            }
            ExplainPlan plan = conn1.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 3-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(fullIndexName + "(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            query = "SELECT t_id,k1,k3 FROM " + tableName;
            plan = conn1.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 3-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)(fullIndexName + "_2(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [2]", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            rs = conn1.createStatement().executeQuery(query);
            Thread.sleep(1000L);
            for (int j = 0; j < 26; ++j) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)strings[j], (Object)rs.getString("t_id"));
                Assert.assertEquals((long)j, (long)rs.getInt("k1"));
                Assert.assertEquals((long)(j + 2), (long)rs.getInt("k3"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexScanWithMergeSpecialCase() throws Exception {
        String schemaName = LocalIndexSplitMergeIT.generateUniqueName();
        String tableName = schemaName + "." + LocalIndexSplitMergeIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexSplitMergeIT.generateUniqueName();
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)false);
        this.createBaseTable(tableName, "('a','aaaab','def')");
        try (java.sql.Connection conn1 = this.getConnectionForLocalIndexTest();){
            int j;
            String[] strings = new String[]{"aa", "aaa", "aaaa", "bb", "cc", "dd", "dff", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
            for (int i = 0; i < 26; ++i) {
                conn1.createStatement().execute("UPSERT INTO " + tableName + " values('" + strings[i] + "'," + i + "," + (i + 1) + "," + (i + 2) + ",'" + strings[25 - i] + "')");
            }
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + "_2 ON " + tableName + "(k3)");
            Admin admin = conn1.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            List regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)physicalTableName, (boolean)false);
            admin.mergeRegionsAsync(((RegionInfo)regionsOfUserTable.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regionsOfUserTable.get(1)).getEncodedNameAsBytes(), false);
            regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)physicalTableName, (boolean)false);
            while (regionsOfUserTable.size() != 3) {
                Thread.sleep(100L);
                regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)physicalTableName, (boolean)false);
            }
            String query = "SELECT t_id,k1,v1 FROM " + tableName;
            ResultSet rs = conn1.createStatement().executeQuery(query);
            for (j = 0; j < 26; ++j) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)strings[25 - j], (Object)rs.getString("t_id"));
                Assert.assertEquals((long)(25 - j), (long)rs.getInt("k1"));
                Assert.assertEquals((Object)strings[j], (Object)rs.getString("V1"));
            }
            query = "SELECT t_id,k1,k3 FROM " + tableName;
            rs = conn1.createStatement().executeQuery(query);
            for (j = 0; j < 26; ++j) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)strings[j], (Object)rs.getString("t_id"));
                Assert.assertEquals((long)j, (long)rs.getInt("k1"));
                Assert.assertEquals((long)(j + 2), (long)rs.getInt("k3"));
            }
        }
    }
}

