/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.phoenix.exception.UpgradeBlockedException;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadSystemTableSnapshotBase
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadSystemTableSnapshotBase.class);
    public static final String SNAPSHOT_DIR = "snapshots4_7/";
    public static String rootDir;
    private static final HashMap<String, String> SNAPSHOTS_TO_LOAD;
    public static final byte[] MUTEX_LOCKED;

    private static void decompress(String in, File out) throws IOException {
        try (TarArchiveInputStream fin = new TarArchiveInputStream((InputStream)new FileInputStream(in));){
            TarArchiveEntry entry;
            while ((entry = fin.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                File curfile = new File(out, entry.getName());
                File parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                IOUtils.copy((InputStream)fin, (OutputStream)new FileOutputStream(curfile));
            }
        }
    }

    public static synchronized void setupCluster(boolean createBlockUpgradeMutex) throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        LoadSystemTableSnapshotBase.checkClusterInitialized(new ReadOnlyProps(serverProps.entrySet().iterator()));
        URL folderUrl = LoadSystemTableSnapshotBase.class.getClassLoader().getResource(SNAPSHOT_DIR);
        File archive = new File(folderUrl.getFile() + "snapshots47.tar.gz");
        File destination = new File(folderUrl.getFile());
        LoadSystemTableSnapshotBase.decompress(archive.toString(), destination);
        rootDir = CommonFSUtils.getRootDir((Configuration)config).toUri().toString();
        for (Map.Entry<String, String> snapshot : SNAPSHOTS_TO_LOAD.entrySet()) {
            String snapshotLoc = new File(folderUrl.getFile()).getAbsolutePath() + "/" + snapshot.getKey();
            LoadSystemTableSnapshotBase.importSnapshot(snapshot.getKey(), snapshot.getValue(), snapshotLoc);
        }
        if (createBlockUpgradeMutex) {
            try {
                Admin admin = utility.getAdmin();
                TableName mutexTableName = null;
                mutexTableName = SchemaUtil.getPhysicalTableName((String)PhoenixDatabaseMetaData.SYSTEM_MUTEX_NAME, (ReadOnlyProps)new ReadOnlyProps(serverProps.entrySet().iterator()));
                TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)mutexTableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES).setTimeToLive(900).build()).build();
                admin.createTable(tableDesc);
                Connection hbaseConn = ConnectionFactory.createConnection((Configuration)LoadSystemTableSnapshotBase.getUtility().getConfiguration());
                Table sysMutexTable = hbaseConn.getTable(mutexTableName);
                byte[] rowKey = Bytes.toBytes((String)"BLOCK_UPGRADE");
                byte[] family = PhoenixDatabaseMetaData.SYSTEM_MUTEX_FAMILY_NAME_BYTES;
                byte[] qualifier = PhoenixDatabaseMetaData.SYSTEM_MUTEX_COLUMN_NAME_BYTES;
                Put put = new Put(rowKey);
                put.addColumn(family, qualifier, MUTEX_LOCKED);
                CheckAndMutate checkAndMutate = CheckAndMutate.newBuilder((byte[])rowKey).ifNotExists(family, qualifier).build(put);
                boolean checkAndPut = sysMutexTable.checkAndMutate(checkAndMutate).isSuccess();
                if (!checkAndPut) {
                    throw new UpgradeBlockedException();
                }
            }
            catch (IOException e) {
                throw ClientUtil.parseServerException((Throwable)e);
            }
        }
    }

    private static void importSnapshot(String key, String value, String loc) throws IOException {
        LOGGER.info("importing {} snapshot from {}", (Object)key, (Object)value);
        Path localPath = new Path(loc);
        Assert.assertTrue((boolean)FileSystem.getLocal((Configuration)config).exists(new Path(localPath, ".hbase-snapshot")));
        FileSystem hdfsFs = FileSystem.get((Configuration)config);
        Path hdfsImportPath = new Path(hdfsFs.getHomeDirectory(), "snapshot-import/" + key + "/");
        Assert.assertTrue((boolean)hdfsFs.mkdirs(hdfsImportPath));
        hdfsFs.copyFromLocalFile(localPath, hdfsImportPath);
        hdfsImportPath = new Path(hdfsImportPath, localPath.getName());
        Assert.assertTrue((boolean)hdfsFs.exists(new Path(hdfsImportPath, ".hbase-snapshot")));
        ExportSnapshot exportTool = new ExportSnapshot();
        exportTool.setConf(config);
        int importExitCode = exportTool.run(new String[]{"-snapshot", key, "-copy-from", hdfsImportPath.toUri().toString(), "-copy-to", rootDir});
        Assert.assertEquals((long)0L, (long)importExitCode);
        utility.getAdmin().restoreSnapshot(key);
    }

    static {
        MUTEX_LOCKED = "MUTEX_LOCKED".getBytes(StandardCharsets.UTF_8);
        SNAPSHOTS_TO_LOAD = new HashMap();
        SNAPSHOTS_TO_LOAD.put("SYSTEM.CATALOG_SNAPSHOT", "SYSTEM.CATALOG");
        SNAPSHOTS_TO_LOAD.put("SYSTEM.FUNCTION_SNAPSHOT", "SYSTEM.FUNCTION");
        SNAPSHOTS_TO_LOAD.put("SYSTEM.SEQUENCE_SNAPSHOT", "SYSTEM.SEQUENCE");
        SNAPSHOTS_TO_LOAD.put("SYSTEM.STATS_SNAPSHOT", "SYSTEM.STATS");
    }
}

