/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class LnLogFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    private static final String KEY = "key";
    private String signedTableName;
    private String unsignedTableName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        this.signedTableName = LnLogFunctionEnd2EndIT.generateUniqueName();
        this.unsignedTableName = LnLogFunctionEnd2EndIT.generateUniqueName();
        try {
            conn = DriverManager.getConnection(LnLogFunctionEnd2EndIT.getUrl());
            String ddl = "CREATE TABLE " + this.signedTableName + " (k VARCHAR NOT NULL PRIMARY KEY, doub DOUBLE, fl FLOAT, inte INTEGER, lon BIGINT, smalli SMALLINT, tinyi TINYINT)";
            conn.createStatement().execute(ddl);
            ddl = "CREATE TABLE " + this.unsignedTableName + " (k VARCHAR NOT NULL PRIMARY KEY, doub UNSIGNED_DOUBLE, fl UNSIGNED_FLOAT, inte UNSIGNED_INT, lon UNSIGNED_LONG, smalli UNSIGNED_SMALLINT, tinyi UNSIGNED_TINYINT)";
            conn.createStatement().execute(ddl);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    private void updateTableSpec(Connection conn, double data, String tableName) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, KEY);
        Double d = data;
        stmt.setDouble(2, d);
        stmt.setFloat(3, d.floatValue());
        stmt.setInt(4, d.intValue());
        stmt.setLong(5, d.longValue());
        stmt.setShort(6, d.shortValue());
        stmt.setByte(7, d.byteValue());
        stmt.executeUpdate();
        conn.commit();
    }

    private void testNumberSpec(Connection conn, double data, String tableName) throws Exception {
        this.updateTableSpec(conn, data, tableName);
        ResultSet rs = conn.createStatement().executeQuery("SELECT LN(doub),LN(fl),LN(inte),LN(lon),LN(smalli),LN(tinyi) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Double d = data;
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), Math.log(d)));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(2), Math.log(d.floatValue())));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(3), Math.log(d.intValue())));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(4), Math.log(d.longValue())));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(5), Math.log(d.shortValue())));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(6), Math.log(d.byteValue())));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        rs = conn.createStatement().executeQuery("SELECT LOG(doub),LOG(fl),LOG(inte),LOG(lon),LOG(smalli),LOG(tinyi) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        d = data;
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), Math.log10(d)));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(2), Math.log10(d.floatValue())));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(3), Math.log10(d.intValue())));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(4), Math.log10(d.longValue())));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(5), Math.log10(d.shortValue())));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(6), Math.log10(d.byteValue())));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        rs = conn.createStatement().executeQuery("SELECT LOG(doub,3),LOG(fl,3),LOG(inte,3),LOG(lon,3),LOG(smalli,3),LOG(tinyi,3) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        d = data;
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(1), Math.log(d) / Math.log(3.0)));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(2), Math.log(d.floatValue()) / Math.log(3.0)));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(3), Math.log(d.intValue()) / Math.log(3.0)));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(4), Math.log(d.longValue()) / Math.log(3.0)));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(5), Math.log(d.shortValue()) / Math.log(3.0)));
        Assert.assertTrue((boolean)LnLogFunctionEnd2EndIT.twoDoubleEquals(rs.getDouble(6), Math.log(d.byteValue()) / Math.log(3.0)));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    @Test
    public void test() throws Exception {
        Connection conn = DriverManager.getConnection(LnLogFunctionEnd2EndIT.getUrl());
        for (double d : new double[]{0.0, 1.0, -1.0, 123.1234, -123.1234}) {
            this.testNumberSpec(conn, d, this.signedTableName);
            if (!(d >= 0.0)) continue;
            this.testNumberSpec(conn, d, this.unsignedTableName);
        }
    }
}

