/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IsNullIT
extends ParallelStatsDisabledIT {
    @Test
    public void testIsNullInPk() throws Exception {
        String tableName = IsNullIT.generateUniqueName();
        IsNullIT.ensureTableCreated(IsNullIT.getUrl(), tableName, "IntIntKeyTest");
        Connection conn = DriverManager.getConnection(IsNullIT.getUrl());
        String upsert = "UPSERT INTO " + tableName + " VALUES(4,2)";
        PreparedStatement upsertStmt = conn.prepareStatement(upsert);
        int rowsInserted = upsertStmt.executeUpdate();
        Assert.assertEquals((long)1L, (long)rowsInserted);
        upsert = "UPSERT INTO " + tableName + " VALUES(6)";
        upsertStmt = conn.prepareStatement(upsert);
        rowsInserted = upsertStmt.executeUpdate();
        Assert.assertEquals((long)1L, (long)rowsInserted);
        conn.commit();
        String select = "SELECT i/j FROM " + tableName + " WHERE j IS NULL";
        ResultSet rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertFalse((boolean)rs.next());
        select = "SELECT i/j FROM " + tableName + " WHERE j IS NOT NULL";
        rs = conn.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testIsNullWithLastPKColDesc() throws Exception {
        String tableName = IsNullIT.generateUniqueName();
        Connection conn = DriverManager.getConnection(IsNullIT.getUrl());
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 VARCHAR NOT NULL, k2 VARCHAR, k3 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1, k2, k3 DESC))");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('b')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('b',null,'c')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('ba', null, 'd')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT k1,k2,k3 FROM " + tableName + " WHERE k1='b' AND k2 IS NULL");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertNull((Object)rs.getString(2));
        Assert.assertNull((Object)rs.getString(3));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertNull((Object)rs.getString(2));
        Assert.assertEquals((Object)"c", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        conn.close();
    }

    @Test
    public void testIsNullInCompositeKey() throws Exception {
        Connection conn = DriverManager.getConnection(IsNullIT.getUrl());
        String tableName = IsNullIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k1 VARCHAR, k2 VARCHAR, CONSTRAINT pk PRIMARY KEY (k1,k2))");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (null,'a')");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES ('a','a')");
        conn.commit();
        ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + tableName + " WHERE k1 = 'a' or k1 is null");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        conn.close();
    }
}

