/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.phoenix.end2end.FailingPhoenixRegionServerEndpoint;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class InvalidateMetadataCacheIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvalidateMetadataCacheIT.class);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        NUM_SLAVES_BASE = 2;
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("hbase.client.retries.number", String.valueOf(0));
        props.put("phoenix.metadata.invalidate.cache.enabled", "true");
        props.put("hbase.coprocessor.regionserver.classes", FailingPhoenixRegionServerEndpoint.class.getName());
        props.put("phoenix.metadata.cache.invalidation.timeoutMs", String.valueOf(2000));
        InvalidateMetadataCacheIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testAddColumnWithTimeout() {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTableFullName = InvalidateMetadataCacheIT.generateUniqueName();
        String ddl = this.getCreateTableStmt(dataTableFullName);
        HRegionServer regionServerZero = utility.getMiniHBaseCluster().getRegionServer(0);
        FailingPhoenixRegionServerEndpoint coprocForRS0 = this.getFailingPhoenixRegionServerEndpoint(regionServerZero);
        coprocForRS0.sleep();
        try (Connection conn = DriverManager.getConnection(InvalidateMetadataCacheIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " ADD CF.col2 integer");
            Assert.fail((String)"Shouldn't reach here");
        }
        catch (Exception e) {
            LOGGER.error("Exception while adding column", (Throwable)e);
        }
    }

    @Test
    public void testAddColumnWithOneRSFailing() {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTableFullName = InvalidateMetadataCacheIT.generateUniqueName();
        String ddl = this.getCreateTableStmt(dataTableFullName);
        HRegionServer regionServerZero = utility.getMiniHBaseCluster().getRegionServer(0);
        FailingPhoenixRegionServerEndpoint coprocForRS0 = this.getFailingPhoenixRegionServerEndpoint(regionServerZero);
        coprocForRS0.throwException();
        try (Connection conn = DriverManager.getConnection(InvalidateMetadataCacheIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " ADD CF.col2 integer");
            Assert.fail((String)"Shouldn't reach here");
        }
        catch (Exception e) {
            LOGGER.error("Exception while adding column", (Throwable)e);
        }
    }

    @Test
    public void testAddColumnWithOneRSSucceedingOnRetry() {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTableFullName = InvalidateMetadataCacheIT.generateUniqueName();
        String ddl = this.getCreateTableStmt(dataTableFullName);
        HRegionServer regionServerZero = utility.getMiniHBaseCluster().getRegionServer(0);
        FailingPhoenixRegionServerEndpoint coprocForRS0 = this.getFailingPhoenixRegionServerEndpoint(regionServerZero);
        coprocForRS0.failFirstAndThenSucceed();
        try (Connection conn = DriverManager.getConnection(InvalidateMetadataCacheIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " ADD CF.col2 integer");
        }
        catch (Throwable e) {
            Assert.fail((String)"Shouldn't reach here");
        }
    }

    @Test
    public void testAddColumnWithBothRSPassing() {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String dataTableFullName = InvalidateMetadataCacheIT.generateUniqueName();
        String ddl = this.getCreateTableStmt(dataTableFullName);
        try (Connection conn = DriverManager.getConnection(InvalidateMetadataCacheIT.getUrl(), props);){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " ADD CF.col2 integer");
        }
        catch (Throwable t) {
            Assert.fail((String)"Shouldn't reach here");
        }
    }

    private String getCreateTableStmt(String tableName) {
        return "CREATE TABLE " + tableName + "  (a_string varchar not null, col1 integer  CONSTRAINT pk PRIMARY KEY (a_string)) ";
    }

    private FailingPhoenixRegionServerEndpoint getFailingPhoenixRegionServerEndpoint(HRegionServer regionServer) {
        FailingPhoenixRegionServerEndpoint coproc = (FailingPhoenixRegionServerEndpoint)regionServer.getRegionServerCoprocessorHost().findCoprocessor(FailingPhoenixRegionServerEndpoint.class);
        return coproc;
    }
}

