/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class InstrFunctionIT
extends ParallelStatsDisabledIT {
    private void initTable(Connection conn, String tableName, String sortOrder, String s, String subStr) throws Exception {
        String ddl = "CREATE TABLE " + tableName + " (name VARCHAR NOT NULL PRIMARY KEY " + sortOrder + ", substr VARCHAR)";
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " VALUES(?,?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.setString(1, s);
        stmt.setString(2, subStr);
        stmt.execute();
        conn.commit();
    }

    private void testInstr(Connection conn, String queryToExecute, Integer expValue) throws Exception {
        ResultSet rs = conn.createStatement().executeQuery(queryToExecute);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)expValue.intValue(), (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
    }

    private void testInstrFilter(Connection conn, String queryToExecute, String expected) throws Exception {
        PreparedStatement stmt = conn.prepareStatement(queryToExecute);
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
    }

    @Test
    public void testSingleByteInstrAscending() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "ASC", "abcdefghijkl", "fgh");
        String queryToExecute = "SELECT INSTR(name, 'fgh') FROM " + tableName;
        this.testInstr(conn, queryToExecute, 6);
    }

    @Test
    public void testSingleByteInstrDescending() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "DESC", "abcdefghijkl", "fgh");
        String queryToExecute = "SELECT INSTR(name, 'fgh') FROM " + tableName;
        this.testInstr(conn, queryToExecute, 6);
    }

    @Test
    public void testSingleByteInstrAscendingNoString() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "ASC", "abcde fghijkl", "lmn");
        String queryToExecute = "SELECT INSTR(name, 'lmn') FROM " + tableName;
        this.testInstr(conn, queryToExecute, 0);
    }

    @Test
    public void testSingleByteInstrDescendingNoString() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "DESC", "abcde fghijkl", "lmn");
        String queryToExecute = "SELECT INSTR(name, 'lmn') FROM " + tableName;
        this.testInstr(conn, queryToExecute, 0);
    }

    @Test
    public void testMultiByteInstrAscending() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "ASC", "A\u025a\u0266FGH", "\u025a\u0266");
        String queryToExecute = "SELECT INSTR(name, '\u025a\u0266') FROM " + tableName;
        this.testInstr(conn, queryToExecute, 2);
    }

    @Test
    public void testMultiByteInstrDecending() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "DESC", "A\u025a\u0266FGH", "\u025a\u0266");
        String queryToExecute = "SELECT INSTR(name, '\u025a\u0266') FROM " + tableName;
        this.testInstr(conn, queryToExecute, 2);
    }

    @Test
    public void testByteInstrAscendingFilter() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "ASC", "abcdefghijkl", "fgh");
        String queryToExecute = "select NAME from " + tableName + " where instr(name, 'fgh') > 0";
        this.testInstrFilter(conn, queryToExecute, "abcdefghijkl");
    }

    @Test
    public void testByteInstrDecendingFilter() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "DESC", "abcdefghijkl", "fgh");
        String queryToExecute = "select NAME from " + tableName + " where instr(name, 'fgh') > 0";
        this.testInstrFilter(conn, queryToExecute, "abcdefghijkl");
    }

    @Test
    public void testNonLiteralExpression() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "ASC", "asdf", "sdf");
        String query = "SELECT INSTR(name, substr) FROM " + tableName;
        this.testInstr(conn, query, 2);
    }

    @Test
    public void testNonLiteralSourceExpression() throws Exception {
        Connection conn = DriverManager.getConnection(InstrFunctionIT.getUrl());
        String tableName = InstrFunctionIT.generateUniqueName();
        this.initTable(conn, tableName, "ASC", "asdf", "sdf");
        String query = "SELECT INSTR('asdf', 'sdf') FROM " + tableName;
        this.testInstr(conn, query, 2);
        query = "SELECT INSTR('asdf', substr) FROM " + tableName;
        this.testInstr(conn, query, 2);
        query = "SELECT INSTR('qwerty', 'sdf') FROM " + tableName;
        this.testInstr(conn, query, 0);
        query = "SELECT INSTR('qwerty', substr) FROM " + tableName;
        this.testInstr(conn, query, 0);
        query = "SELECT name FROM " + tableName + " WHERE INSTR(name, substr) = 2";
        this.testInstrFilter(conn, query, "asdf");
        query = "SELECT name FROM " + tableName + " WHERE INSTR(name, 'sdf') = 2";
        this.testInstrFilter(conn, query, "asdf");
        query = "SELECT name FROM " + tableName + " WHERE INSTR('asdf', substr) = 2";
        this.testInstrFilter(conn, query, "asdf");
        query = "SELECT name FROM " + tableName + " WHERE INSTR('asdf', 'sdf') = 2";
        this.testInstrFilter(conn, query, "asdf");
    }
}

