/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.mapreduce.index.IndexUpgradeTool;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ParallelStatsDisabledTest.class})
public class IndexUpgradeToolIT
extends ParallelStatsDisabledIT {
    public static final String VERIFY_COUNT_ASSERT_MESSAGE = "view-index count in system table doesn't match";
    private final boolean multiTenant;
    private String tenantId = null;

    public IndexUpgradeToolIT(boolean multiTenant) {
        this.multiTenant = multiTenant;
    }

    @Parameterized.Parameters(name="isMultiTenant = {0}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void verifyViewAndViewIndexes() throws Exception {
        String tableName = IndexUpgradeToolIT.generateUniqueName();
        String schemaName = IndexUpgradeToolIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        if (this.multiTenant) {
            this.tenantId = IndexUpgradeToolIT.generateUniqueName();
            props.setProperty("TenantId", this.tenantId);
        }
        try (Connection conn = DriverManager.getConnection(IndexUpgradeToolIT.getUrl(), props);){
            this.prepareForTest(conn, schemaName, tableName);
            String viewQuery = IndexUpgradeTool.getViewSql((String)tableName, (String)schemaName);
            ResultSet rs = conn.createStatement().executeQuery(viewQuery);
            ArrayList<String> views = new ArrayList<String>();
            ArrayList<String> tenants = new ArrayList<String>();
            while (rs.next()) {
                views.add(rs.getString(1));
                if (this.multiTenant) {
                    Assert.assertNotNull((Object)rs.getString(2));
                }
                tenants.add(rs.getString(2));
            }
            Assert.assertEquals((String)"view count in system table doesn't match", (long)2L, (long)views.size());
            for (int i = 0; i < views.size(); ++i) {
                String viewName = SchemaUtil.getTableNameFromFullName((String)((String)views.get(i)));
                String viewIndexQuery = IndexUpgradeTool.getViewIndexesSql((String)viewName, (String)schemaName, (String)((String)tenants.get(i)));
                rs = conn.createStatement().executeQuery(viewIndexQuery);
                int indexes = 0;
                while (rs.next()) {
                    ++indexes;
                }
                Assert.assertEquals((String)VERIFY_COUNT_ASSERT_MESSAGE, (long)(2 - i), (long)indexes);
            }
        }
    }

    private void prepareForTest(Connection conn, String schemaName, String tableName) throws SQLException {
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        Connection globalConn = conn;
        if (this.multiTenant) {
            Properties prop = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            globalConn = DriverManager.getConnection(IndexUpgradeToolIT.getUrl(), prop);
        }
        globalConn.createStatement().execute("CREATE TABLE " + fullTableName + " (" + (this.multiTenant ? "TENANT_ID VARCHAR(15) NOT NULL, " : "") + "id bigint NOT NULL, a.name varchar, sal bigint, address varchar CONSTRAINT PK_1 PRIMARY KEY (" + (this.multiTenant ? "TENANT_ID, " : "") + "ID)) " + (this.multiTenant ? "MULTI_TENANT=true" : ""));
        for (int i = 0; i < 2; ++i) {
            String view = IndexUpgradeToolIT.generateUniqueName();
            String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)view);
            conn.createStatement().execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE a.name = 'a'");
            for (int j = i; j < 2; ++j) {
                String index = IndexUpgradeToolIT.generateUniqueName();
                conn.createStatement().execute("CREATE INDEX " + index + " ON " + fullViewName + " (address)");
            }
        }
    }
}

