/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.IndexTestUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRepository;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;
import org.apache.phoenix.mapreduce.index.PhoenixIndexImportDirectMapper;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.mapreduce.index.PhoenixServerBuildIndexMapper;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class IndexToolIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexToolIT.class);
    private static String tmpDir;
    private final boolean localIndex;
    private final boolean mutable;
    private final boolean transactional;
    private final String tableDDLOptions;
    private final String indexDDLOptions;
    private final boolean useSnapshot;
    private final boolean useTenantId;
    private final boolean namespaceMapped;

    public IndexToolIT(String transactionProvider, boolean mutable, boolean localIndex, boolean useSnapshot, boolean useTenantId, boolean namespaceMapped) {
        this.localIndex = localIndex;
        this.mutable = mutable;
        this.transactional = transactionProvider != null;
        this.useSnapshot = useSnapshot;
        this.useTenantId = useTenantId;
        this.namespaceMapped = namespaceMapped;
        StringBuilder optionBuilder = new StringBuilder();
        if (!mutable) {
            optionBuilder.append(" IMMUTABLE_ROWS=true ");
        }
        if (this.transactional) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append(" TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + transactionProvider + "'");
        }
        optionBuilder.append(" SPLIT ON(1,2)");
        this.tableDDLOptions = optionBuilder.toString();
        StringBuilder indexOptionBuilder = new StringBuilder();
        if (!localIndex && transactionProvider == null) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append(" COLUMN_ENCODED_BYTES=0");
            indexOptionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS,COLUMN_ENCODED_BYTES=2");
        }
        this.indexDDLOptions = indexOptionBuilder.toString();
    }

    @Parameterized.BeforeParam
    public static synchronized void setup(String transactionProvider, boolean mutable, boolean localIndex, boolean useSnapshot, boolean useTenantId, boolean namespaceMapped) throws Exception {
        if (clusterInitialized && Boolean.valueOf(namespaceMapped).equals(utility.getConfiguration().getBoolean("phoenix.schema.isNamespaceMappingEnabled", true))) {
            return;
        }
        if (clusterInitialized) {
            IndexToolIT.tearDownMiniCluster(0);
            System.setProperty("java.io.tmpdir", tmpDir);
        } else {
            tmpDir = System.getProperty("java.io.tmpdir");
        }
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        serverProps.put("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.index.rebuild_page_size_in_rows", Long.toString(8L));
        serverProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(namespaceMapped));
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        clientProps.put("phoenix.stats.updateFrequency", Long.toString(5L));
        clientProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(namespaceMapped));
        IndexToolIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Parameterized.Parameters(name="transactionProvider={0},mutable={1},localIndex={2},useSnapshot={3},useTenant={4},namespaceMapped={5}")
    public static synchronized Collection<Object[]> data() {
        boolean[] Booleans;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)48);
        for (boolean namespaceMapped : Booleans = new boolean[]{false, true}) {
            for (boolean useSnapshot : Booleans) {
                for (String transactionProvider : new String[]{"OMID", null}) {
                    for (boolean mutable : Booleans) {
                        for (boolean localIndex : Booleans) {
                            if (localIndex && useSnapshot || localIndex && transactionProvider != null && TransactionFactory.getTransactionProvider((TransactionFactory.Provider)TransactionFactory.Provider.valueOf((String)transactionProvider)).isUnsupported(PhoenixTransactionProvider.Feature.ALLOW_LOCAL_INDEX)) continue;
                            list.add(new Object[]{transactionProvider, mutable, localIndex, useSnapshot, false, namespaceMapped});
                        }
                    }
                }
            }
        }
        list.add(new Object[]{null, false, true, false, true, false});
        return list;
    }

    protected static void setEveryNthRowWithNull(int nrows, int nthRowNull, PreparedStatement stmt) throws Exception {
        for (int i = 1; i <= nrows; ++i) {
            stmt.setInt(1, i);
            stmt.setInt(2, i + 1);
            if (i % nthRowNull != 0) {
                stmt.setInt(3, i * i);
            } else {
                stmt.setNull(3, 4);
            }
            stmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryIndex() throws Exception {
        String schemaName = IndexToolIT.generateUniqueName();
        String dataTableName = IndexToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(IndexToolIT.getUrl(), props);){
            if (this.namespaceMapped) {
                conn.createStatement().execute("CREATE SCHEMA " + schemaName);
            }
            String stmString1 = "CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions;
            conn.createStatement().execute(stmString1);
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", dataTableFullName);
            PreparedStatement upsertStmt = conn.prepareStatement(upsertQuery);
            IndexToolIT.upsertRow(upsertStmt, 1);
            IndexToolIT.upsertRow(upsertStmt, 2);
            conn.commit();
            if (this.transactional) {
                try (Connection conn2 = DriverManager.getConnection(IndexToolIT.getUrl(), props);){
                    conn2.setAutoCommit(false);
                    PreparedStatement stmt2 = conn2.prepareStatement(upsertQuery);
                    IndexToolIT.upsertRow(stmt2, 5);
                    IndexToolIT.upsertRow(stmt2, 6);
                    ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) from " + dataTableFullName);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((String)"Unexpected row count ", (long)2L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                    rs = conn2.createStatement().executeQuery("SELECT count(*) from " + dataTableFullName);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((String)"Unexpected row count ", (long)4L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
            }
            String stmtString2 = String.format("CREATE %s INDEX %s ON %s  (LPAD(UPPER(NAME, 'en_US'),8,'x')||'_xyz') ASYNC " + this.indexDDLOptions, this.localIndex ? "LOCAL" : "", indexTableName, dataTableFullName);
            conn.createStatement().execute(stmtString2);
            String selectSql = String.format("SELECT ID FROM %s WHERE LPAD(UPPER(NAME, 'en_US'),8,'x')||'_xyz' = 'xxUNAME2_xyz'", dataTableFullName);
            ExplainPlan plan = conn.prepareStatement(selectSql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)dataTableFullName, (Object)explainPlanAttributes.getTableName().replaceAll(":", "."));
            Assert.assertEquals((Object)"SERVER FILTER BY (LPAD(UPPER(NAME, 'en_US'), 8, 'x') || '_xyz') = 'xxUNAME2_xyz'", (Object)explainPlanAttributes.getServerWhereFilter().replaceAll(":", "."));
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            conn.commit();
            IndexToolIT.runIndexTool(this.useSnapshot, schemaName, dataTableName, indexTableName);
            if (!this.localIndex) {
                IndexTestUtil.assertRowsForEmptyColValue((Connection)conn, indexTableFullName, QueryConstants.VERIFIED_BYTES);
            }
            IndexToolIT.upsertRow(upsertStmt, 3);
            IndexToolIT.upsertRow(upsertStmt, 4);
            conn.commit();
            if (!this.localIndex) {
                IndexTestUtil.assertRowsForEmptyColValue((Connection)conn, indexTableFullName, QueryConstants.VERIFIED_BYTES);
            }
            plan = conn.prepareStatement(selectSql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Object expectedTableName = this.localIndex ? indexTableFullName + "(" + dataTableFullName + ")" : indexTableFullName;
            Assert.assertEquals((Object)expectedTableName, (Object)explainPlanAttributes.getTableName().replaceAll(":", "."));
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            if (this.localIndex || this.transactional || this.useTenantId || this.useSnapshot) {
                return;
            }
            IndexTool indexTool = IndexToolIT.runIndexTool(this.useSnapshot, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            Assert.assertEquals((long)4L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            Assert.assertEquals((long)4L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)4L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_VALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_EXPIRED_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_EXTRA_CELLS).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT_COZ_MISSING_CELLS).getValue());
        }
    }

    protected static void dropIndexToolTables(Connection conn) throws Exception {
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        TableName indexToolOutputTable = TableName.valueOf((byte[])IndexVerificationOutputRepository.OUTPUT_TABLE_NAME_BYTES);
        admin.disableTable(indexToolOutputTable);
        admin.deleteTable(indexToolOutputTable);
        TableName indexToolResultTable = TableName.valueOf((byte[])IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES);
        admin.disableTable(indexToolResultTable);
        admin.deleteTable(indexToolResultTable);
    }

    private static void verifyIndexTableRowKey(byte[] rowKey, String indexTableFullName) {
        int offset = Bytes.indexOf((byte[])rowKey, (byte[])IndexVerificationResultRepository.ROW_KEY_SEPARATOR_BYTE);
        byte[] indexTableFullNameBytes = Bytes.toBytes((String)indexTableFullName);
        Assert.assertEquals((long)Bytes.compareTo((byte[])rowKey, (int)(++offset), (int)indexTableFullNameBytes.length, (byte[])indexTableFullNameBytes, (int)0, (int)indexTableFullNameBytes.length), (long)0L);
        Assert.assertEquals((long)rowKey[offset + indexTableFullNameBytes.length], (long)IndexVerificationResultRepository.ROW_KEY_SEPARATOR_BYTE[0]);
    }

    public static Cell getErrorMessageFromIndexToolOutputTable(Connection conn, String dataTableFullName, String indexTableFullName) throws Exception {
        byte[] indexTableFullNameBytes = Bytes.toBytes((String)indexTableFullName);
        byte[] dataTableFullNameBytes = Bytes.toBytes((String)dataTableFullName);
        Table hIndexTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(IndexVerificationOutputRepository.OUTPUT_TABLE_NAME_BYTES);
        Scan scan = new Scan();
        ResultScanner scanner = hIndexTable.getScanner(scan);
        boolean dataTableNameCheck = false;
        boolean indexTableNameCheck = false;
        Cell errorMessageCell = null;
        Result result = scanner.next();
        while (result != null) {
            for (Cell cell : result.rawCells()) {
                Assert.assertTrue((Bytes.compareTo((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])IndexVerificationOutputRepository.OUTPUT_TABLE_COLUMN_FAMILY, (int)0, (int)IndexVerificationOutputRepository.OUTPUT_TABLE_COLUMN_FAMILY.length) == 0 ? 1 : 0) != 0);
                if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])IndexVerificationOutputRepository.DATA_TABLE_NAME_BYTES, (int)0, (int)IndexVerificationOutputRepository.DATA_TABLE_NAME_BYTES.length) == 0) {
                    dataTableNameCheck = true;
                    Assert.assertTrue((String)("Value was different! Expected: " + Bytes.toString((byte[])dataTableFullNameBytes) + " Actual: " + Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength())), (Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])dataTableFullNameBytes, (int)0, (int)dataTableFullNameBytes.length) == 0 ? 1 : 0) != 0);
                    continue;
                }
                if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])IndexVerificationOutputRepository.INDEX_TABLE_NAME_BYTES, (int)0, (int)IndexVerificationOutputRepository.INDEX_TABLE_NAME_BYTES.length) == 0) {
                    indexTableNameCheck = true;
                    Assert.assertTrue((Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])indexTableFullNameBytes, (int)0, (int)indexTableFullNameBytes.length) == 0 ? 1 : 0) != 0);
                    continue;
                }
                if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])IndexVerificationOutputRepository.ERROR_MESSAGE_BYTES, (int)0, (int)IndexVerificationOutputRepository.ERROR_MESSAGE_BYTES.length) != 0) continue;
                errorMessageCell = cell;
            }
            result = scanner.next();
        }
        Assert.assertTrue((String)"DataTableNameCheck was false", (boolean)dataTableNameCheck);
        Assert.assertTrue((String)"IndexTableNameCheck was false", (boolean)indexTableNameCheck);
        Assert.assertTrue((String)"Error message cell was null", (errorMessageCell != null ? 1 : 0) != 0);
        IndexToolIT.verifyIndexTableRowKey(CellUtil.cloneRow(errorMessageCell), indexTableFullName);
        hIndexTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(IndexVerificationResultRepository.RESULT_TABLE_NAME_BYTES);
        scan = new Scan();
        scanner = hIndexTable.getScanner(scan);
        result = scanner.next();
        if (result != null) {
            IndexToolIT.verifyIndexTableRowKey(CellUtil.cloneRow((Cell)result.rawCells()[0]), indexTableFullName);
        }
        return errorMessageCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexToolWithTenantId() throws Exception {
        if (!this.useTenantId) {
            return;
        }
        String tenantId = IndexToolIT.generateUniqueName();
        String schemaName = IndexToolIT.generateUniqueName();
        String dataTableName = IndexToolIT.generateUniqueName();
        String viewTenantName = IndexToolIT.generateUniqueName();
        String indexNameGlobal = IndexToolIT.generateUniqueName();
        String indexNameTenant = IndexToolIT.generateUniqueName();
        String viewIndexTableName = "_IDX_" + dataTableName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection connGlobal = DriverManager.getConnection(IndexToolIT.getUrl(), props);
        props.setProperty("TenantId", tenantId);
        Connection connTenant = DriverManager.getConnection(IndexToolIT.getUrl(), props);
        String createTblStr = "CREATE TABLE %s (TENANT_ID VARCHAR(15) NOT NULL,ID INTEGER NOT NULL, NAME VARCHAR, CONSTRAINT PK_1 PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT=true";
        String createViewStr = "CREATE VIEW %s AS SELECT * FROM %s";
        String upsertQueryStr = "UPSERT INTO %s (TENANT_ID, ID, NAME) VALUES('%s' , %d, '%s')";
        String createIndexStr = "CREATE INDEX %s ON %s (NAME) " + this.indexDDLOptions;
        try {
            String tableStmtGlobal = String.format(createTblStr, dataTableName);
            connGlobal.createStatement().execute(tableStmtGlobal);
            String viewStmtTenant = String.format(createViewStr, viewTenantName, dataTableName);
            connTenant.createStatement().execute(viewStmtTenant);
            String idxStmtTenant = String.format(createIndexStr, indexNameTenant, viewTenantName);
            connTenant.createStatement().execute(idxStmtTenant);
            connTenant.createStatement().execute(String.format(upsertQueryStr, viewTenantName, tenantId, 1, "x"));
            connTenant.commit();
            IndexToolIT.runIndexTool(false, "", viewTenantName, indexNameTenant, tenantId, 0, new String[0]);
            String selectSql = String.format("SELECT ID FROM %s WHERE NAME='x'", viewTenantName);
            ExplainPlan plan = connTenant.prepareStatement(selectSql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)viewIndexTableName, (Object)explainPlanAttributes.getTableName());
            ResultSet rs = connTenant.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            ConnectionQueryServices queryServices = connGlobal.unwrap(PhoenixConnection.class).getQueryServices();
            Admin admin = queryServices.getAdmin();
            TableName tableName = TableName.valueOf((String)viewIndexTableName);
            admin.disableTable(tableName);
            admin.truncateTable(tableName, false);
            IndexToolIT.runIndexTool(false, "", viewTenantName, indexNameTenant, tenantId, 0, new String[0]);
            Table htable = queryServices.getTable(Bytes.toBytes((String)viewIndexTableName));
            int count = IndexToolIT.getUtility().countRows(htable);
            Assert.assertTrue((count == 1 ? 1 : 0) != 0);
            selectSql = String.format("SELECT /*+ INDEX(%s) */ COUNT(*) FROM %s", indexNameTenant, viewTenantName);
            rs = connTenant.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            String idxStmtGlobal = String.format(createIndexStr, indexNameGlobal, dataTableName);
            connGlobal.createStatement().execute(idxStmtGlobal);
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexNameGlobal, tenantId, -1, new String[0]);
        }
        finally {
            connGlobal.close();
            connTenant.close();
        }
    }

    @Test
    public void testSaltedVariableLengthPK() throws Exception {
        if (!this.mutable) {
            return;
        }
        if (this.transactional) {
            return;
        }
        String schemaName = IndexToolIT.generateUniqueName();
        String dataTableName = IndexToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(IndexToolIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            if (this.namespaceMapped) {
                conn.createStatement().execute("CREATE SCHEMA " + schemaName);
            }
            String dataDDL = "CREATE TABLE " + dataTableFullName + "(\nID VARCHAR NOT NULL PRIMARY KEY,\n\"info\".CAR_NUM VARCHAR(18) NULL,\n\"info\".CAP_DATE VARCHAR NULL,\n\"info\".ORG_ID BIGINT NULL,\n\"info\".ORG_NAME VARCHAR(255) NULL\n) SALT_BUCKETS=3";
            conn.createStatement().execute(dataDDL);
            String upsert = "UPSERT INTO " + dataTableFullName + "(ID,CAR_NUM,CAP_DATE,ORG_ID,ORG_NAME) VALUES('1','car1','2016-01-01 00:00:00',11,'orgname1')";
            conn.createStatement().execute(upsert);
            conn.commit();
            String indexDDL = String.format("CREATE %s INDEX %s on %s (\"info\".CAR_NUM,\"info\".CAP_DATE) ASYNC " + this.indexDDLOptions, this.localIndex ? "LOCAL" : "", indexTableName, dataTableFullName);
            conn.createStatement().execute(indexDDL);
            IndexToolIT.runIndexTool(this.useSnapshot, schemaName, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery("SELECT ORG_ID,CAP_DATE,CAR_NUM,ORG_NAME FROM " + dataTableFullName + " WHERE CAR_NUM='car1' AND CAP_DATE>='2016-01-01' AND CAP_DATE<='2016-05-02' LIMIT 10");
            Assert.assertTrue((boolean)rs.next());
            int orgId = rs.getInt(1);
            Assert.assertEquals((long)11L, (long)orgId);
        }
    }

    @Test
    public void testSplitIndex() throws Exception {
        if (this.localIndex) {
            return;
        }
        if (!this.mutable) {
            return;
        }
        if (this.transactional) {
            return;
        }
        String schemaName = IndexToolIT.generateUniqueName();
        String dataTableName = IndexToolIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(IndexToolIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
             Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            if (this.namespaceMapped) {
                conn.createStatement().execute("CREATE SCHEMA " + schemaName);
            }
            String dataDDL = "CREATE TABLE " + dataTableFullName + "(\nID VARCHAR NOT NULL PRIMARY KEY,\n\"info\".CAR_NUM VARCHAR(18) NULL,\n\"test\".CAR_NUM VARCHAR(18) NULL,\n\"info\".CAP_DATE VARCHAR NULL,\n\"info\".ORG_ID BIGINT NULL,\n\"info\".ORG_NAME VARCHAR(255) NULL\n) COLUMN_ENCODED_BYTES = 0";
            conn.createStatement().execute(dataDDL);
            String[] carNumPrefixes = new String[]{"a", "b", "c", "d"};
            int numSplits = carNumPrefixes.length;
            int targetNumRegions = numSplits + 1;
            byte[][] splitPoints = new byte[numSplits][];
            for (String prefix : carNumPrefixes) {
                splitPoints[--numSplits] = Bytes.toBytes((String)prefix);
            }
            TableName hDataName = TableName.valueOf((byte[])SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)dataTableName, (boolean)this.namespaceMapped).getBytes());
            TableDescriptor dataTD = admin.getDescriptor(hDataName);
            admin.disableTable(hDataName);
            admin.deleteTable(hDataName);
            admin.createTable(dataTD, (byte[][])splitPoints);
            Assert.assertEquals((long)targetNumRegions, (long)admin.getRegions(hDataName).size());
            int idCounter = 1;
            try (PreparedStatement ps = conn.prepareStatement("UPSERT INTO " + dataTableFullName + "(ID,\"info\".CAR_NUM,\"test\".CAR_NUM,CAP_DATE,ORG_ID,ORG_NAME) VALUES(?,?,?,'2016-01-01 00:00:00',11,'orgname1')");){
                for (String carNum : carNumPrefixes) {
                    for (int i = 0; i < 100; ++i) {
                        ps.setString(1, "" + idCounter++);
                        ps.setString(2, carNum + "_" + i);
                        ps.setString(3, "test-" + carNum + "_ " + i);
                        ps.addBatch();
                    }
                }
                ps.executeBatch();
                conn.commit();
            }
            String indexDDL = String.format("CREATE INDEX %s on %s (\"info\".CAR_NUM,\"test\".CAR_NUM,\"info\".CAP_DATE) ASYNC " + this.indexDDLOptions, indexTableName, dataTableFullName);
            conn.createStatement().execute(indexDDL);
            IndexToolIT.runIndexTool(this.useSnapshot, schemaName, dataTableName, indexTableName, "-sp", "50", "-spa", "3");
            TableName hIndexName = TableName.valueOf((byte[])SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)indexTableName, (boolean)this.namespaceMapped).getBytes());
            Assert.assertEquals((long)targetNumRegions, (long)admin.getRegions(hIndexName).size());
            ArrayList values = new ArrayList();
            for (HRegion region : IndexToolIT.getUtility().getHBaseCluster().getRegions(hIndexName)) {
                values.clear();
                RegionScannerImpl scanner = region.getScanner(new Scan());
                scanner.next(values);
                if (!values.isEmpty()) continue;
                Assert.fail((String)("Region did not have any results: " + region.getRegionInfo()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCaseSensitiveNames() throws Exception {
        String schemaName = IndexToolIT.generateUniqueName().toLowerCase();
        String dataTableName = IndexToolIT.generateUniqueName().toLowerCase();
        String sSchemaName = SchemaUtil.getCaseSensitiveColumnDisplayName(null, (String)schemaName);
        String sDataTableName = SchemaUtil.getCaseSensitiveColumnDisplayName(null, (String)dataTableName);
        String qDataTableName = SchemaUtil.getCaseSensitiveColumnDisplayName((String)schemaName, (String)dataTableName);
        String dataTableNameForExplain = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexToolIT.generateUniqueName().toLowerCase();
        String sIndexTableName = SchemaUtil.getCaseSensitiveColumnDisplayName(null, (String)indexTableName);
        String indexTableNameForExplain = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexToolIT.getUrl(), props);){
            ResultSet rs;
            if (this.namespaceMapped) {
                conn.createStatement().execute("CREATE SCHEMA " + sSchemaName);
            }
            String stmString1 = "CREATE TABLE " + qDataTableName + " (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) " + this.tableDDLOptions;
            conn.createStatement().execute(stmString1);
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", qDataTableName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            IndexToolIT.upsertRow(stmt1, 1);
            IndexToolIT.upsertRow(stmt1, 2);
            conn.commit();
            if (this.transactional) {
                try (Connection conn2 = DriverManager.getConnection(IndexToolIT.getUrl(), props);){
                    conn2.setAutoCommit(false);
                    PreparedStatement stmt2 = conn2.prepareStatement(upsertQuery);
                    IndexToolIT.upsertRow(stmt2, 5);
                    IndexToolIT.upsertRow(stmt2, 6);
                    rs = conn.createStatement().executeQuery("SELECT count(*) from " + qDataTableName);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((String)"Unexpected row count ", (long)2L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                    rs = conn2.createStatement().executeQuery("SELECT count(*) from " + qDataTableName);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((String)"Unexpected row count ", (long)4L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
            }
            String stmtString2 = String.format("CREATE %s INDEX %s ON %s  (LPAD(UPPER(NAME, 'en_US'),8,'x')||'_xyz') ASYNC ", this.localIndex ? "LOCAL" : "", sIndexTableName, qDataTableName);
            conn.createStatement().execute(stmtString2);
            String selectSql = String.format("SELECT ID FROM %s WHERE LPAD(UPPER(NAME, 'en_US'),8,'x')||'_xyz' = 'xxUNAME2_xyz'", qDataTableName);
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)String.format("CLIENT PARALLEL 1-WAY FULL SCAN OVER %s\n    SERVER FILTER BY (LPAD(UPPER(NAME, 'en_US'), 8, 'x') || '_xyz') = 'xxUNAME2_xyz'", dataTableNameForExplain), (Object)actualExplainPlan.replaceAll(":", "."));
            rs = stmt1.executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            conn.commit();
            IndexToolIT.runIndexTool(this.useSnapshot, sSchemaName, sDataTableName, sIndexTableName);
            IndexToolIT.upsertRow(stmt1, 3);
            IndexToolIT.upsertRow(stmt1, 4);
            conn.commit();
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            IndexToolIT.assertExplainPlan(this.localIndex, actualExplainPlan, dataTableNameForExplain, indexTableNameForExplain, false);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    public static void assertExplainPlan(boolean localIndex, String actualExplainPlan, String dataTableFullName, String indexTableFullName) {
        IndexToolIT.assertExplainPlan(localIndex, actualExplainPlan, dataTableFullName, indexTableFullName, true);
    }

    public static void assertExplainPlan(boolean localIndex, String actualExplainPlan, String dataTableFullName, String indexTableFullName, boolean normalizeTableNames) {
        String expectedExplainPlan = localIndex ? String.format(" RANGE SCAN OVER %s [1,", normalizeTableNames ? SchemaUtil.normalizeIdentifier((String)indexTableFullName) + "(" + SchemaUtil.normalizeIdentifier((String)dataTableFullName) + ")" : indexTableFullName + "(" + dataTableFullName + ")") : String.format(" RANGE SCAN OVER %s", normalizeTableNames ? SchemaUtil.normalizeIdentifier((String)indexTableFullName) : indexTableFullName);
        Assert.assertTrue((String)(actualExplainPlan + "\n expected to contain \n" + expectedExplainPlan), (boolean)actualExplainPlan.replaceAll(":", ".").contains(expectedExplainPlan));
    }

    public static CounterGroup getMRJobCounters(IndexTool indexTool) throws IOException {
        return (CounterGroup)indexTool.getJob().getCounters().getGroup(PhoenixIndexToolJobCounters.class.getName());
    }

    public static void dumpMRJobCounters(IndexTool indexTool) throws IOException {
        CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(indexTool);
        IndexToolIT.dumpMRJobCounters(mrJobCounters);
    }

    public static void dumpMRJobCounters(CounterGroup mrJobCounters) {
        for (Counter cntr : mrJobCounters) {
            LOGGER.info(String.format("%s=%d", cntr.getName(), cntr.getValue()));
        }
    }

    private static List<String> getArgList(boolean useSnapshot, String schemaName, String dataTable, String indxTable, String tenantId, IndexTool.IndexVerifyType verifyType, Long startTime, Long endTime, Long incrementalVerify) {
        return IndexToolIT.getArgList(useSnapshot, schemaName, dataTable, indxTable, tenantId, verifyType, startTime, endTime, IndexTool.IndexDisableLoggingType.NONE, incrementalVerify, false);
    }

    private static List<String> getArgList(boolean useSnapshot, String schemaName, String dataTable, String indxTable, String tenantId, IndexTool.IndexVerifyType verifyType, Long startTime, Long endTime, IndexTool.IndexDisableLoggingType disableLoggingType, Long incrementalVerify, boolean useIndexTableAsSource) {
        ArrayList args = Lists.newArrayList();
        if (schemaName != null) {
            args.add("--schema=" + schemaName);
        }
        args.add("--data-table=" + dataTable);
        args.add("--index-table=" + indxTable);
        args.add("-v");
        args.add(verifyType.getValue());
        args.add("-runfg");
        if (useSnapshot) {
            args.add("-snap");
        }
        if (tenantId != null) {
            args.add("-tenant");
            args.add(tenantId);
        }
        if (startTime != null) {
            args.add("-st");
            args.add(String.valueOf(startTime));
        }
        if (endTime != null) {
            args.add("-et");
            args.add(String.valueOf(endTime));
        }
        if (verifyType != IndexTool.IndexVerifyType.NONE && disableLoggingType != null) {
            args.add("-dl");
            args.add(disableLoggingType.getValue());
        }
        if (incrementalVerify != null) {
            args.add("-rv");
            args.add(String.valueOf(incrementalVerify));
        }
        if (useIndexTableAsSource) {
            args.add("-fi");
        }
        args.add("-op");
        args.add("/tmp/" + UUID.randomUUID().toString());
        return args;
    }

    public static String[] getArgValues(boolean useSnapshot, String schemaName, String dataTable, String indexTable, String tenantId, IndexTool.IndexVerifyType verifyType) {
        List<String> args = IndexToolIT.getArgList(useSnapshot, schemaName, dataTable, indexTable, tenantId, verifyType, null, null, null);
        return args.toArray(new String[0]);
    }

    public static String[] getArgValues(boolean useSnapshot, String schemaName, String dataTable, String indexTable, String tenantId, IndexTool.IndexVerifyType verifyType, IndexTool.IndexDisableLoggingType disableLoggingType) {
        List<String> args = IndexToolIT.getArgList(useSnapshot, schemaName, dataTable, indexTable, tenantId, verifyType, null, null, disableLoggingType, null, false);
        return args.toArray(new String[0]);
    }

    public static String[] getArgValues(boolean useSnapshot, String schemaName, String dataTable, String indexTable, String tenantId, IndexTool.IndexVerifyType verifyType, Long startTime, Long endTime) {
        List<String> args = IndexToolIT.getArgList(useSnapshot, schemaName, dataTable, indexTable, tenantId, verifyType, startTime, endTime, null);
        return args.toArray(new String[0]);
    }

    public static String[] getArgValues(boolean useSnapshot, String schemaName, String dataTable, String indexTable, String tenantId, IndexTool.IndexVerifyType verifyType, Long startTime, Long endTime, IndexTool.IndexDisableLoggingType disableLoggingType, Long incrementalVerify) {
        List<String> args = IndexToolIT.getArgList(useSnapshot, schemaName, dataTable, indexTable, tenantId, verifyType, startTime, endTime, disableLoggingType, incrementalVerify, false);
        return args.toArray(new String[0]);
    }

    public static String[] getArgValues(boolean directApi, boolean useSnapshot, String schemaName, String dataTable, String indexTable, String tenantId, IndexTool.IndexVerifyType verifyType, Long startTime, Long endTime, IndexTool.IndexDisableLoggingType disableLoggingType, Long incrementalVerify, boolean useIndexTableAsSource) {
        List<String> args = IndexToolIT.getArgList(useSnapshot, schemaName, dataTable, indexTable, tenantId, verifyType, startTime, endTime, disableLoggingType, incrementalVerify, useIndexTableAsSource);
        return args.toArray(new String[0]);
    }

    public static void upsertRow(PreparedStatement stmt, int i) throws SQLException {
        stmt.setInt(1, i);
        stmt.setString(2, "uname" + String.valueOf(i));
        stmt.setInt(3, 95050 + i);
        stmt.executeUpdate();
    }

    public static void runIndexTool(boolean useSnapshot, String schemaName, String dataTableName, String indexTableName) throws Exception {
        IndexToolIT.runIndexTool(useSnapshot, schemaName, dataTableName, indexTableName, new String[0]);
    }

    private static void verifyMapper(Job job, boolean useSnapshot, String schemaName, String dataTableName, String indexTableName, String tenantId) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        if (tenantId != null) {
            props.setProperty("TenantId", tenantId);
        }
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(IndexToolIT.getUrl(), props);){
            PTable indexTable = conn.getTableNoCache(SchemaUtil.normalizeFullTableName((String)SchemaUtil.getTableName((String)schemaName, (String)indexTableName)));
            PTable dataTable = conn.getTableNoCache(SchemaUtil.normalizeFullTableName((String)SchemaUtil.getTableName((String)schemaName, (String)dataTableName)));
            boolean transactional = dataTable.isTransactional();
            boolean localIndex = PTable.IndexType.LOCAL.equals((Object)indexTable.getIndexType());
            if (!(!localIndex && transactional || useSnapshot)) {
                Assert.assertEquals((Object)job.getMapperClass(), PhoenixServerBuildIndexMapper.class);
            } else {
                Assert.assertEquals((Object)job.getMapperClass(), PhoenixIndexImportDirectMapper.class);
            }
        }
    }

    public static void runIndexTool(boolean useSnapshot, String schemaName, String dataTableName, String indexTableName, String ... additionalArgs) throws Exception {
        IndexToolIT.runIndexTool(useSnapshot, schemaName, dataTableName, indexTableName, null, 0, additionalArgs);
    }

    public static IndexTool runIndexTool(boolean useSnapshot, String schemaName, String dataTableName, String indexTableName, String tenantId, int expectedStatus, String ... additionalArgs) throws Exception {
        return IndexToolIT.runIndexTool(useSnapshot, schemaName, dataTableName, indexTableName, tenantId, expectedStatus, IndexTool.IndexVerifyType.NONE, additionalArgs);
    }

    public static IndexTool runIndexTool(boolean useSnapshot, String schemaName, String dataTableName, String indexTableName, String tenantId, int expectedStatus, IndexTool.IndexVerifyType verifyType, String ... additionalArgs) throws Exception {
        Configuration conf = new Configuration(IndexToolIT.getUtility().getConfiguration());
        return IndexToolIT.runIndexTool(conf, useSnapshot, schemaName, dataTableName, indexTableName, tenantId, expectedStatus, verifyType, IndexTool.IndexDisableLoggingType.NONE, additionalArgs);
    }

    public static IndexTool runIndexTool(Configuration conf, boolean useSnapshot, String schemaName, String dataTableName, String indexTableName, String tenantId, int expectedStatus, IndexTool.IndexVerifyType verifyType, IndexTool.IndexDisableLoggingType disableLoggingType, String ... additionalArgs) throws Exception {
        IndexTool indexingTool = new IndexTool();
        conf.set("phoenix.transactions.enabled", Boolean.TRUE.toString());
        indexingTool.setConf(conf);
        String[] cmdArgs = IndexToolIT.getArgValues(useSnapshot, schemaName, dataTableName, indexTableName, tenantId, verifyType, disableLoggingType);
        ArrayList<String> cmdArgList = new ArrayList<String>(Arrays.asList(cmdArgs));
        cmdArgList.addAll(Arrays.asList(additionalArgs));
        LOGGER.info("Running IndexTool with {}", (Object)Arrays.toString(cmdArgList.toArray()), (Object)new Exception("Stack Trace"));
        int status = indexingTool.run(cmdArgList.toArray(new String[cmdArgList.size()]));
        if (expectedStatus == 0) {
            IndexToolIT.verifyMapper(indexingTool.getJob(), useSnapshot, schemaName, dataTableName, indexTableName, tenantId);
        }
        Assert.assertEquals((long)expectedStatus, (long)status);
        return indexingTool;
    }

    public static long verifyIndexTable(String fullTableName, String fullIndexName, Connection conn) throws Exception {
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)fullTableName);
        String tableName = SchemaUtil.getTableNameFromFullName((String)fullTableName);
        String indexName = SchemaUtil.getTableNameFromFullName((String)fullIndexName);
        try {
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, tableName, indexName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            TestUtil.dumpTable(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
            Counters counters = indexTool.getJob().getCounters();
            LOGGER.info(counters.toString());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).getValue());
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
            indexTool = IndexToolIT.runIndexTool(false, schemaName, tableName, indexName, null, 0, IndexTool.IndexVerifyType.ONLY, new String[0]);
            counters = indexTool.getJob().getCounters();
            LOGGER.info(counters.toString());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            PTable pIndexTable = conn.unwrap(PhoenixConnection.class).getTable(fullIndexName);
            if (pIndexTable.getIndexType() != PTable.IndexType.UNCOVERED_GLOBAL) {
                Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT).getValue());
            }
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_OLD_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)indexTool.getJob().getCounters().findCounter((Enum)PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNKNOWN_INDEX_ROW_COUNT).getValue());
            indexTool = IndexToolIT.runIndexTool(false, schemaName, tableName, indexName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            counters = indexTool.getJob().getCounters();
            LOGGER.info(counters.toString());
            Assert.assertEquals((long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_VALID_INDEX_ROW_COUNT).getValue(), (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.REBUILT_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            TableName physicalTableName = TableName.valueOf((byte[])pIndexTable.getPhysicalName().getBytes());
            PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
            try (Admin admin = pConn.getQueryServices().getAdmin();){
                admin.disableTable(physicalTableName);
                admin.truncateTable(physicalTableName, true);
            }
            indexTool = IndexToolIT.runIndexTool(false, schemaName, tableName, indexName, null, 0, IndexTool.IndexVerifyType.AFTER, new String[0]);
            counters = indexTool.getJob().getCounters();
            LOGGER.info(counters.toString());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_INVALID_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_MISSING_INDEX_ROW_COUNT).getValue());
            Assert.assertEquals((long)0L, (long)counters.findCounter((Enum)PhoenixIndexToolJobCounters.AFTER_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT).getValue());
            pConn.getQueryServices().clearTableRegionCache(TableName.valueOf((String)fullIndexName));
            long actualRowCountAfterCompaction = IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
            Assert.assertEquals((long)actualRowCount, (long)actualRowCountAfterCompaction);
            return actualRowCount;
        }
        catch (AssertionError e) {
            TestUtil.dumpTable(conn, TableName.valueOf((String)fullTableName));
            TestUtil.dumpTable(conn, TableName.valueOf((String)fullIndexName));
            throw e;
        }
    }

    public static class MutationCountingRegionObserver
    extends SimpleRegionObserver {
        public static AtomicInteger mutationCount = new AtomicInteger(0);

        public static void setMutationCount(int value) {
            mutationCount.set(0);
        }

        public static int getMutationCount() {
            return mutationCount.get();
        }

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws HBaseIOException {
            mutationCount.addAndGet(miniBatchOp.size());
        }
    }
}

