/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Table;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexToolForDeleteBeforeRebuildIT
extends ParallelStatsDisabledIT {
    private Connection conn;
    private String dataTableName;
    private String schemaName;
    private String dataTableFullName;
    private String viewName;
    private String viewFullName;
    private String globalIndexName;
    private String globalIndexFullName;
    private static final String DATA_TABLE_DDL = "CREATE TABLE %s (TENANT_ID VARCHAR(15) NOT NULL, ID INTEGER NOT NULL, NAME VARCHAR, ZIP INTEGER, EMPLOYER VARCHAR , CONSTRAINT PK_1 PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT=true";
    private static final String VIEW_DDL = "CREATE VIEW %s AS  SELECT * FROM %s";
    private static final String INDEX_GLOBAL_DDL = "CREATE INDEX %s ON %s (ID, NAME, ZIP) INCLUDE (EMPLOYER)";
    private static final String INDEX_LOCAL_DDL = "CREATE LOCAL INDEX %s ON %s (ZIP) INCLUDE (NAME)";
    private static final String UPSERT_SQL = "UPSERT INTO %s VALUES(?,?,?,?)";

    @BeforeClass
    public static synchronized void setup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)3);
        serverProps.put("phoenix.stats.guidepost.width", Long.toString(20L));
        serverProps.put("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", Long.toString(5L));
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)4);
        clientProps.put("phoenix.use.stats.parallelization", Boolean.toString(true));
        clientProps.put("phoenix.stats.updateFrequency", Long.toString(5L));
        clientProps.put("phoenix.transactions.enabled", Boolean.TRUE.toString());
        clientProps.put("phoenix.query.force.rowkeyorder", Boolean.TRUE.toString());
        IndexToolForDeleteBeforeRebuildIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Before
    public void prepareTest() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        this.conn = DriverManager.getConnection(IndexToolForDeleteBeforeRebuildIT.getUrl(), props);
        this.schemaName = IndexToolForDeleteBeforeRebuildIT.generateUniqueName();
        this.dataTableName = IndexToolForDeleteBeforeRebuildIT.generateUniqueName();
        this.viewName = IndexToolForDeleteBeforeRebuildIT.generateUniqueName();
        this.dataTableFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.dataTableName);
        this.viewFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.viewName);
        this.globalIndexName = "GLBL_IDX_" + IndexToolForDeleteBeforeRebuildIT.generateUniqueName();
        this.globalIndexFullName = SchemaUtil.getTableName((String)this.schemaName, (String)this.globalIndexName);
        IndexToolForDeleteBeforeRebuildIT.createTestTable(IndexToolForDeleteBeforeRebuildIT.getUrl(), String.format(DATA_TABLE_DDL, this.dataTableFullName));
        IndexToolForDeleteBeforeRebuildIT.createTestTable(IndexToolForDeleteBeforeRebuildIT.getUrl(), String.format(VIEW_DDL, this.viewFullName, this.dataTableFullName));
        String dataTableUpsert = String.format(UPSERT_SQL, this.dataTableFullName);
        PreparedStatement stmt = this.conn.prepareStatement(dataTableUpsert);
        for (int i = 1; i < 4; ++i) {
            this.upsertRow(stmt, "tenantID1", i, "name" + i, 9990 + i);
        }
        this.conn.commit();
    }

    private void upsertRow(PreparedStatement stmt, String tenantId, int id, String name, int zip) throws SQLException {
        int index = 1;
        stmt.setString(index++, tenantId);
        stmt.setInt(index++, id);
        stmt.setString(index++, name);
        stmt.setInt(index++, zip);
        stmt.executeUpdate();
    }

    @After
    public void teardown() throws Exception {
        if (this.conn != null) {
            boolean refCountLeaked = IndexToolForDeleteBeforeRebuildIT.isAnyStoreRefCountLeaked();
            this.conn.close();
            Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
        }
    }

    @Test
    public void testDeleteBeforeRebuildForViewIndexShouldFail() throws Exception {
        String createViewIndex = String.format(INDEX_GLOBAL_DDL, this.globalIndexName, this.viewFullName);
        PreparedStatement stmt = this.conn.prepareStatement(createViewIndex);
        stmt.execute();
        IndexToolForDeleteBeforeRebuildIT.runIndexTool(this.schemaName, this.viewName, this.globalIndexName, -1, new String[0]);
    }

    @Test
    public void testDeleteBeforeRebuildForGlobalIndex() throws Exception {
        this.conn.createStatement().execute(String.format(INDEX_GLOBAL_DDL, this.globalIndexName, this.dataTableFullName));
        String globalIndexUpsert = String.format(UPSERT_SQL, this.globalIndexFullName);
        PreparedStatement stmt = this.conn.prepareStatement(globalIndexUpsert);
        this.upsertRow(stmt, "tenantID1", 11, "name11", 99911);
        this.conn.commit();
        ConnectionQueryServices queryServices = this.conn.unwrap(PhoenixConnection.class).getQueryServices();
        PTable physicalTable = this.conn.unwrap(PhoenixConnection.class).getTable(this.globalIndexFullName);
        Table hIndexTable = queryServices.getTable(physicalTable.getPhysicalName().getBytes());
        int count = IndexToolForDeleteBeforeRebuildIT.getUtility().countRows(hIndexTable);
        Assert.assertEquals((long)4L, (long)count);
        IndexToolForDeleteBeforeRebuildIT.runIndexTool(this.schemaName, this.dataTableName, this.globalIndexName, 0, new String[0]);
        count = IndexToolForDeleteBeforeRebuildIT.getUtility().countRows(hIndexTable);
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testDeleteBeforeRebuildForLocalIndexShouldFail() throws Exception {
        String localIndexName = IndexToolForDeleteBeforeRebuildIT.generateUniqueName();
        this.conn.createStatement().execute(String.format(INDEX_LOCAL_DDL, localIndexName, this.dataTableFullName));
        this.conn.commit();
        IndexToolForDeleteBeforeRebuildIT.runIndexTool(this.schemaName, this.dataTableName, localIndexName, -1, new String[0]);
    }

    public static String[] getArgValues(String schemaName, String dataTable, String indxTable) {
        ArrayList args = Lists.newArrayList();
        if (schemaName != null) {
            args.add("-s");
            args.add(schemaName);
        }
        args.add("-dt");
        args.add(dataTable);
        args.add("-it");
        args.add(indxTable);
        args.add("-direct");
        args.add("-runfg");
        args.add("-deleteall");
        args.add("-op");
        args.add("/tmp/" + UUID.randomUUID().toString());
        return args.toArray(new String[0]);
    }

    public static void runIndexTool(String schemaName, String dataTableName, String indexTableName, int expectedStatus, String ... additionalArgs) throws Exception {
        IndexTool indexingTool = new IndexTool();
        Configuration conf = new Configuration(IndexToolForDeleteBeforeRebuildIT.getUtility().getConfiguration());
        conf.set("phoenix.transactions.enabled", Boolean.TRUE.toString());
        indexingTool.setConf(conf);
        String[] cmdArgs = IndexToolForDeleteBeforeRebuildIT.getArgValues(schemaName, dataTableName, indexTableName);
        ArrayList<String> cmdArgList = new ArrayList<String>(Arrays.asList(cmdArgs));
        cmdArgList.addAll(Arrays.asList(additionalArgs));
        int status = indexingTool.run(cmdArgList.toArray(new String[cmdArgList.size()]));
        Assert.assertEquals((long)expectedStatus, (long)status);
    }
}

