/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.end2end.IndexScrutinyToolBaseIT;
import org.apache.phoenix.end2end.NonParameterizedIndexScrutinyToolIT;
import org.apache.phoenix.mapreduce.index.IndexScrutinyMapper;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTableOutput;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class IndexScrutinyWithMaxLookbackIT
extends IndexScrutinyToolBaseIT {
    private static PreparedStatement upsertDataStmt;
    private static String dataTableFullName;
    private static String schema;
    private static String dataTableName;
    private static String indexTableName;
    private static String indexTableFullName;
    private static String viewName;
    private static boolean isViewIndex;
    private static ManualEnvironmentEdge testClock;
    public static final String UPSERT_DATA = "UPSERT INTO %s VALUES (?, ?, ?)";
    public static final String DELETE_SCRUTINY_METADATA = "DELETE FROM PHOENIX_INDEX_SCRUTINY_METADATA";
    public static final String DELETE_SCRUTINY_OUTPUT = "DELETE FROM PHOENIX_INDEX_SCRUTINY";
    public static final int MAX_LOOKBACK = 6;
    private long scrutinyTs;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)2);
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(6));
        props.put("hbase.procedure.remote.dispatcher.delay.msec", "0");
        IndexScrutinyWithMaxLookbackIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void setupTest() throws SQLException {
        try (Connection conn = DriverManager.getConnection(IndexScrutinyWithMaxLookbackIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            conn.createStatement().execute(DELETE_SCRUTINY_METADATA);
            conn.createStatement().execute(DELETE_SCRUTINY_OUTPUT);
            conn.commit();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testScrutinyOnRowsBeyondMaxLookBack() throws Exception {
        this.setupTables();
        try {
            this.upsertDataAndScrutinize(dataTableName, dataTableFullName, testClock);
            this.assertBeyondMaxLookbackOutput(dataTableFullName, indexTableFullName);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testScrutinyOnRowsBeyondMaxLookback_viewIndex() throws Exception {
        schema = "S" + IndexScrutinyWithMaxLookbackIT.generateUniqueName();
        dataTableName = "T" + IndexScrutinyWithMaxLookbackIT.generateUniqueName();
        dataTableFullName = SchemaUtil.getTableName((String)schema, (String)dataTableName);
        indexTableName = "VI" + IndexScrutinyWithMaxLookbackIT.generateUniqueName();
        isViewIndex = true;
        viewName = "V" + IndexScrutinyWithMaxLookbackIT.generateUniqueName();
        String viewFullName = SchemaUtil.getTableName((String)schema, (String)viewName);
        String indexFullName = SchemaUtil.getTableName((String)schema, (String)indexTableName);
        String dataTableDDL = "CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) COLUMN_ENCODED_BYTES = 0, VERSIONS = 1 ";
        String viewDDL = "CREATE VIEW %s AS SELECT * FROM %s";
        String indexTableDDL = "CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP) VERSIONS = 1";
        testClock = new ManualEnvironmentEdge();
        try (Connection conn = DriverManager.getConnection(IndexScrutinyWithMaxLookbackIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            conn.createStatement().execute(String.format(dataTableDDL, dataTableFullName));
            conn.createStatement().execute(String.format(viewDDL, viewFullName, dataTableFullName));
            conn.createStatement().execute(String.format(indexTableDDL, indexTableName, viewFullName));
            conn.commit();
        }
        this.upsertDataAndScrutinize(viewName, viewFullName, testClock);
        this.assertBeyondMaxLookbackOutput(viewFullName, indexFullName);
    }

    private void assertBeyondMaxLookbackOutput(String dataTableName, String indexTableName) throws Exception {
        try (Connection conn = DriverManager.getConnection(IndexScrutinyWithMaxLookbackIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            ResultSet metadataRS = IndexScrutinyTableOutput.queryAllLatestMetadata((Connection)conn, (String)dataTableName, (String)indexTableName);
            Assert.assertTrue((String)"No results from scrutiny metadata query!", (boolean)metadataRS.next());
            Assert.assertEquals((long)1L, (long)metadataRS.getLong("BEYOND_MAX_LOOKBACK_COUNT"));
            String beyondLookbackOutputSql = metadataRS.getString("INVALID_ROWS_QUERY_BEYOND_MAX_LOOKBACK");
            Assert.assertNotNull((Object)beyondLookbackOutputSql);
            ResultSet outputRS = conn.createStatement().executeQuery(beyondLookbackOutputSql);
            Assert.assertTrue((String)"No results from scrutiny beyond max lookback output query!", (boolean)outputRS.next());
            Assert.assertTrue((String)"Beyond max lookback flag not set", (boolean)outputRS.getBoolean("BEYOND_MAX_LOOKBACK"));
            Assert.assertFalse((String)"Too many rows output from scrutiny beyond max lookback output query!", (boolean)outputRS.next());
        }
    }

    @Test
    public void testScrutinyOnDeletedRowsBeyondMaxLookBack() throws Exception {
        this.setupTables();
        try {
            this.upsertDataThenDeleteAndScrutinize(dataTableName, dataTableFullName, testClock);
            this.assertBeyondMaxLookbackOutput(dataTableFullName, indexTableFullName);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private void setupTables() throws SQLException {
        schema = "S" + IndexScrutinyWithMaxLookbackIT.generateUniqueName();
        dataTableName = "T" + IndexScrutinyWithMaxLookbackIT.generateUniqueName();
        indexTableName = "I" + IndexScrutinyWithMaxLookbackIT.generateUniqueName();
        dataTableFullName = SchemaUtil.getTableName((String)schema, (String)dataTableName);
        indexTableFullName = SchemaUtil.getTableName((String)schema, (String)indexTableName);
        isViewIndex = false;
        String dataTableDDL = "CREATE TABLE %s (ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR, ZIP INTEGER) COLUMN_ENCODED_BYTES=0, VERSIONS=1";
        String indexTableDDL = "CREATE INDEX %s ON %s (NAME) INCLUDE (ZIP)";
        testClock = new ManualEnvironmentEdge();
        try (Connection conn = DriverManager.getConnection(IndexScrutinyWithMaxLookbackIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            conn.createStatement().execute(String.format(dataTableDDL, dataTableFullName));
            conn.createStatement().execute(String.format(indexTableDDL, indexTableName, dataTableFullName));
            conn.commit();
        }
    }

    private void upsertDataAndScrutinize(String tableName, String tableFullName, ManualEnvironmentEdge testClock) throws Exception {
        try (Connection conn = DriverManager.getConnection(IndexScrutinyWithMaxLookbackIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            this.populateTable(tableFullName, conn);
            long afterInsertSCN = EnvironmentEdgeManager.currentTimeMillis() + 1L;
            testClock.setValue(afterInsertSCN);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)testClock);
            testClock.incrementValue(3000L);
            this.scrutinyTs = EnvironmentEdgeManager.currentTimeMillis();
            this.updateIndexRows(conn);
            testClock.incrementValue(3000L);
            List<Job> completedJobs = this.runScrutiny(schema, tableName, indexTableName, this.scrutinyTs);
            Job job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            this.assertCounters(job.getCounters());
        }
    }

    private void populateTable(String tableFullName, Connection conn) throws SQLException {
        upsertDataStmt = IndexScrutinyWithMaxLookbackIT.getUpsertDataStmt(tableFullName, conn);
        NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 1, "name-1", 98051);
        NonParameterizedIndexScrutinyToolIT.upsertRow(upsertDataStmt, 2, "name-2", 98052);
        conn.commit();
    }

    private void updateIndexRows(Connection conn) throws SQLException {
        String tableName = isViewIndex ? SchemaUtil.getTableName((String)schema, (String)viewName) : dataTableFullName;
        PreparedStatement stmt = IndexScrutinyWithMaxLookbackIT.getUpsertDataStmt(tableName, conn);
        NonParameterizedIndexScrutinyToolIT.upsertRow(stmt, 1, "name-1", 38139);
        conn.commit();
    }

    private void upsertDataThenDeleteAndScrutinize(String tableName, String tableFullName, ManualEnvironmentEdge testClock) throws Exception {
        try (Connection conn = DriverManager.getConnection(IndexScrutinyWithMaxLookbackIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
            this.populateTable(tableFullName, conn);
            long afterInsertSCN = EnvironmentEdgeManager.currentTimeMillis() + 1L;
            testClock.setValue(afterInsertSCN);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)testClock);
            this.deleteIndexRows(conn);
            testClock.incrementValue(3000L);
            this.scrutinyTs = EnvironmentEdgeManager.currentTimeMillis();
            testClock.incrementValue(3000L);
            List<Job> completedJobs = this.runScrutiny(schema, tableName, indexTableName, this.scrutinyTs);
            Job job = completedJobs.get(0);
            Assert.assertTrue((boolean)job.isSuccessful());
            this.assertCounters(job.getCounters());
        }
    }

    private void deleteIndexRows(Connection conn) throws SQLException {
        String deleteSql = "DELETE FROM " + SchemaUtil.getTableName((String)schema, (String)indexTableName) + " LIMIT 1";
        conn.createStatement().execute(deleteSql);
        conn.commit();
    }

    private static PreparedStatement getUpsertDataStmt(String tableFullName, Connection conn) throws SQLException {
        return conn.prepareStatement(String.format(UPSERT_DATA, tableFullName));
    }

    private void assertCounters(Counters counters) {
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.VALID_ROW_COUNT));
        Assert.assertEquals((long)1L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.BEYOND_MAX_LOOKBACK_COUNT));
        Assert.assertEquals((long)0L, (long)this.getCounterValue(counters, (Enum<PhoenixScrutinyJobCounters>)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT));
    }

    private List<Job> runScrutiny(String schemaName, String dataTableName, String indexTableName, Long scrutinyTs) throws Exception {
        return this.runScrutiny(schemaName, dataTableName, indexTableName, null, null, scrutinyTs);
    }

    private List<Job> runScrutiny(String schemaName, String dataTableName, String indexTableName, Long batchSize, IndexScrutinyTool.SourceTable sourceTable, Long scrutinyTs) throws Exception {
        String[] cmdArgs = this.getArgValues(schemaName, dataTableName, indexTableName, batchSize, sourceTable, true, IndexScrutinyTool.OutputFormat.TABLE, null, null, scrutinyTs);
        return this.runScrutiny(MaxLookbackIndexScrutinyMapper.class, cmdArgs);
    }

    private static class MaxLookbackIndexScrutinyMapper
    extends IndexScrutinyMapper {
        private MaxLookbackIndexScrutinyMapper() {
        }

        public void postSetup() {
            try {
                String tableToCompact;
                if (isViewIndex) {
                    String physicalDataTableName = SchemaUtil.getPhysicalHBaseTableName((String)schema, (String)dataTableName, (boolean)false).getString();
                    tableToCompact = MetaDataUtil.getViewIndexPhysicalName((String)physicalDataTableName);
                } else {
                    tableToCompact = SchemaUtil.getPhysicalHBaseTableName((String)schema, (String)indexTableName, (boolean)false).getString();
                }
                TableName indexTable = TableName.valueOf((String)tableToCompact);
                testClock.incrementValue(1L);
                BaseTest.getUtility().getAdmin().flush(indexTable);
                TestUtil.majorCompact(BaseTest.getUtility(), indexTable);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

