/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRepository;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRow;
import org.apache.phoenix.mapreduce.index.PhoenixIndexToolJobCounters;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class IndexRepairRegionScannerIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexRepairRegionScannerIT.class);
    private final String tableDDLOptions;
    private final String indexDDLOptions;
    private boolean mutable;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    public IndexRepairRegionScannerIT(boolean mutable, boolean singleCellIndex) {
        StringBuilder optionBuilder = new StringBuilder();
        StringBuilder indexOptionBuilder = new StringBuilder();
        this.mutable = mutable;
        if (!mutable) {
            optionBuilder.append(" IMMUTABLE_ROWS=true ");
        }
        if (singleCellIndex) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES=2 ");
            indexOptionBuilder.append(" IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS,COLUMN_ENCODED_BYTES=2");
        }
        optionBuilder.append(" SPLIT ON(1,2)");
        this.indexDDLOptions = indexOptionBuilder.toString();
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="mutable={0}, singleCellIndex={1}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)3);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(0));
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        props.put("phoenix.index.verify.row.count.per.task", Long.toString(2L));
        props.put("hbase.procedure.remote.dispatcher.delay.msec", "0");
        IndexRepairRegionScannerIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void createIndexToolTables() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            IndexTool.createIndexToolTables((java.sql.Connection)conn);
        }
        IndexRepairRegionScannerIT.resetIndexRegionObserverFailPoints();
    }

    @After
    public void cleanup() throws Exception {
        boolean refCountLeaked = IndexRepairRegionScannerIT.isAnyStoreRefCountLeaked();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            this.deleteAllRows(conn, TableName.valueOf((byte[])IndexVerificationOutputRepository.OUTPUT_TABLE_NAME_BYTES));
            this.deleteAllRows(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL_RESULT"));
        }
        EnvironmentEdgeManager.reset();
        IndexRepairRegionScannerIT.resetIndexRegionObserverFailPoints();
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    private void setIndexRowStatusesToVerified(java.sql.Connection conn, String dataTableFullName, String indexTableFullName) throws Exception {
        PTable pDataTable = conn.unwrap(PhoenixConnection.class).getTable(dataTableFullName);
        PTable pIndexTable = conn.unwrap(PhoenixConnection.class).getTable(indexTableFullName);
        Table hTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(pIndexTable.getPhysicalName().getBytes());
        Scan scan = new Scan();
        PhoenixConnection phoenixConnection = conn.unwrap(PhoenixConnection.class);
        IndexMaintainer indexMaintainer = pIndexTable.getIndexMaintainer(pDataTable, phoenixConnection);
        scan.addColumn(indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), indexMaintainer.getEmptyKeyValueQualifier());
        ResultScanner scanner = hTable.getScanner(scan);
        Result result = scanner.next();
        while (result != null) {
            Put put = new Put(result.getRow());
            put.addColumn(indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), indexMaintainer.getEmptyKeyValueQualifier(), result.rawCells()[0].getTimestamp(), QueryConstants.VERIFIED_BYTES);
            hTable.put(put);
            result = scanner.next();
        }
    }

    private void initTablesAndAddExtraRowsToIndex(java.sql.Connection conn, String schemaName, String dataTableName, String indexTableName, int NROWS) throws Exception {
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
        PreparedStatement dataPreparedStatement = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
        for (int i = 1; i <= NROWS; ++i) {
            dataPreparedStatement.setInt(1, i);
            dataPreparedStatement.setInt(2, i + 1);
            dataPreparedStatement.setInt(3, i * 2);
            dataPreparedStatement.execute();
        }
        conn.commit();
        conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName, dataTableFullName));
        PreparedStatement indexPreparedStatement = conn.prepareStatement("UPSERT INTO " + indexTableFullName + " VALUES(?,?,?)");
        for (int i = NROWS + 1; i <= 2 * NROWS; ++i) {
            indexPreparedStatement.setInt(1, i + 1);
            indexPreparedStatement.setInt(2, i);
            indexPreparedStatement.setInt(3, i * 2);
            indexPreparedStatement.execute();
        }
        conn.commit();
        this.setIndexRowStatusesToVerified(conn, dataTableFullName, indexTableFullName);
    }

    private void truncateIndexToolTables() throws IOException {
        IndexRepairRegionScannerIT.getUtility().getAdmin().disableTable(TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
        IndexRepairRegionScannerIT.getUtility().getAdmin().truncateTable(TableName.valueOf((String)"PHOENIX_INDEX_TOOL"), true);
        IndexRepairRegionScannerIT.getUtility().getAdmin().disableTable(TableName.valueOf((String)"PHOENIX_INDEX_TOOL_RESULT"));
        IndexRepairRegionScannerIT.getUtility().getAdmin().truncateTable(TableName.valueOf((String)"PHOENIX_INDEX_TOOL_RESULT"), true);
    }

    private void assertExtraCounters(IndexTool indexTool, long extraVerified, long extraUnverified, boolean isBefore) throws IOException {
        CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(indexTool);
        if (isBefore) {
            Assert.assertEquals((long)extraVerified, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)extraUnverified, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
        } else {
            Assert.assertEquals((long)extraVerified, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.AFTER_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)extraUnverified, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.AFTER_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
        }
    }

    private void assertDisableLogging(java.sql.Connection conn, int expectedExtraRows, int expectedPITRows, IndexTool.IndexVerifyType verifyType, IndexTool.IndexDisableLoggingType disableLoggingType, byte[] expectedPhase, String schemaName, String dataTableName, String indexTableName, String indexTableFullName, int expectedStatus) throws Exception {
        IndexTool tool = IndexToolIT.runIndexTool(IndexRepairRegionScannerIT.getUtility().getConfiguration(), false, schemaName, dataTableName, indexTableName, null, expectedStatus, verifyType, disableLoggingType, "-fi");
        Assert.assertNotNull((Object)tool);
        try {
            this.assertExtraCounters(tool, expectedExtraRows, 0L, true);
        }
        catch (AssertionError e) {
            IndexToolIT.dumpMRJobCounters(tool);
            throw e;
        }
        byte[] indexTableFullNameBytes = Bytes.toBytes((String)indexTableFullName);
        IndexVerificationOutputRepository outputRepository = new IndexVerificationOutputRepository(indexTableFullNameBytes, conn);
        List rows = outputRepository.getAllOutputRows();
        try {
            if (expectedPITRows == 0) {
                Assert.assertTrue((boolean)rows.isEmpty());
            } else {
                Assert.assertTrue((expectedPITRows >= rows.size() ? 1 : 0) != 0);
            }
        }
        catch (AssertionError e) {
            TestUtil.dumpTable(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
            throw e;
        }
        if (expectedPITRows > 0) {
            Assert.assertArrayEquals((byte[])expectedPhase, (byte[])((IndexVerificationOutputRow)rows.get(0)).getPhaseValue());
        }
    }

    private static void resetIndexRegionObserverFailPoints() {
        IndexRegionObserver.setFailPreIndexUpdatesForTesting((boolean)false);
        IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
        IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
    }

    private static void commitWithException(java.sql.Connection conn) {
        try {
            conn.commit();
            IndexRepairRegionScannerIT.resetIndexRegionObserverFailPoints();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRepairExtraIndexRows() throws Exception {
        int NROWS = 20;
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            boolean failed;
            this.initTablesAndAddExtraRowsToIndex(conn, schemaName, dataTableName, indexTableName, 20);
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, new String[0]);
            try {
                IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
                failed = false;
            }
            catch (AssertionError e) {
                failed = true;
            }
            Assert.assertTrue((boolean)failed);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, "-fi");
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)20L, (long)actualRowCount);
            this.assertExtraCounters(indexTool, 20L, 0L, true);
        }
    }

    @Test
    public void testRepairExtraIndexRows_PostIndexUpdateFailure_overwrite() throws Exception {
        if (!this.mutable) {
            return;
        }
        int NROWS = 4;
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName, dataTableFullName));
            PreparedStatement dataPreparedStatement = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
            for (int i = 1; i <= 4; ++i) {
                dataPreparedStatement.setInt(1, i);
                dataPreparedStatement.setInt(2, i + 1);
                dataPreparedStatement.setInt(3, i * 2);
                dataPreparedStatement.execute();
            }
            conn.commit();
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("UPSERT INTO " + dataTableFullName + " VALUES(3, 100, 200)");
            conn.commit();
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, "-fi");
            CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(indexTool);
            Assert.assertEquals((long)2L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_BEYOND_MAXLOOKBACK_INVALID_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)2L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-fi");
            mrJobCounters = IndexToolIT.getMRJobCounters(indexTool);
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)4L, (long)actualRowCount);
        }
    }

    @Test
    public void testRepairExtraIndexRows_PostIndexUpdateFailure_delete() throws Exception {
        if (!this.mutable) {
            return;
        }
        int NROWS = 4;
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName, dataTableFullName));
            PreparedStatement dataPreparedStatement = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
            for (int i = 1; i <= 4; ++i) {
                dataPreparedStatement.setInt(1, i);
                dataPreparedStatement.setInt(2, i + 1);
                dataPreparedStatement.setInt(3, i * 2);
                dataPreparedStatement.execute();
            }
            conn.commit();
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            conn.createStatement().execute("DELETE FROM " + dataTableFullName + " WHERE ID = 3");
            conn.commit();
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
            TestUtil.doMajorCompaction(conn, dataTableFullName);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, "-fi");
            CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(indexTool);
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)1L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-fi");
            mrJobCounters = IndexToolIT.getMRJobCounters(indexTool);
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_INVALID_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REBUILD_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)3L, (long)actualRowCount);
        }
    }

    @Test
    public void testRepairExtraIndexRows_DataTableUpdateFailure() throws Exception {
        if (!this.mutable) {
            return;
        }
        int NROWS = 20;
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName, dataTableFullName));
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            PreparedStatement dataPreparedStatement = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
            for (int i = 1; i <= 20; ++i) {
                dataPreparedStatement.setInt(1, i);
                dataPreparedStatement.setInt(2, i + 1);
                dataPreparedStatement.setInt(3, i * 2);
                dataPreparedStatement.execute();
            }
            IndexRepairRegionScannerIT.commitWithException(conn);
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, "-fi");
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)0L, (long)actualRowCount);
            this.assertExtraCounters(indexTool, 0L, 20L, true);
        }
    }

    @Test
    public void testPITRow() throws Exception {
        boolean NROWS = true;
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            this.initTablesAndAddExtraRowsToIndex(conn, schemaName, dataTableName, indexTableName, 1);
            IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-fi");
            Cell cell = IndexToolIT.getErrorMessageFromIndexToolOutputTable(conn, dataTableFullName, indexTableFullName);
            String expectedErrorMsg = "Extra index row";
            String actualErrorMsg = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
            Assert.assertTrue((boolean)actualErrorMsg.contains(expectedErrorMsg));
        }
    }

    @Test
    public void testVerifyAfterExtraIndexRows() throws Exception {
        int NROWS = 20;
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            boolean failed;
            this.initTablesAndAddExtraRowsToIndex(conn, schemaName, dataTableName, indexTableName, 20);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, -1, IndexTool.IndexVerifyType.AFTER, "-fi");
            try {
                IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
                failed = false;
            }
            catch (AssertionError e) {
                failed = true;
            }
            Assert.assertTrue((boolean)failed);
        }
    }

    @Test
    public void testVerifyBothExtraIndexRows() throws Exception {
        int NROWS = 20;
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            this.initTablesAndAddExtraRowsToIndex(conn, schemaName, dataTableName, indexTableName, 20);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BOTH, "-fi");
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)20L, (long)actualRowCount);
            this.assertExtraCounters(indexTool, 0L, 0L, false);
        }
    }

    @Test
    public void testOverrideIndexRebuildPageSizeFromIndexTool() throws Exception {
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        int NROWS = 20;
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            this.initTablesAndAddExtraRowsToIndex(conn, schemaName, dataTableName, indexTableName, 20);
            Configuration conf = new Configuration(IndexRepairRegionScannerIT.getUtility().getConfiguration());
            conf.set("phoenix.index.rebuild_page_size_in_rows", Long.toString(2L));
            IndexTool indexTool = IndexToolIT.runIndexTool(conf, false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.BEFORE, IndexTool.IndexDisableLoggingType.NONE, "-fi");
            long actualRowCount = IndexScrutiny.scrutinizeIndex(conn, dataTableFullName, indexTableFullName);
            Assert.assertEquals((long)20L, (long)actualRowCount);
            this.assertExtraCounters(indexTool, 20L, 0L, true);
        }
    }

    @Test
    public void testViewIndexExtraRows() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
            String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
            String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
            String viewName = IndexRepairRegionScannerIT.generateUniqueName();
            String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
            String indexTableName1 = IndexRepairRegionScannerIT.generateUniqueName();
            String indexTableFullName1 = SchemaUtil.getTableName((String)schemaName, (String)indexTableName1);
            String indexTableName2 = IndexRepairRegionScannerIT.generateUniqueName();
            String indexTableFullName2 = SchemaUtil.getTableName((String)schemaName, (String)indexTableName2);
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
            conn.commit();
            conn.createStatement().execute("CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName);
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + viewFullName + " values (1, 2, 4)");
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName1, viewFullName));
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL2) INCLUDE (VAL1)", indexTableName2, viewFullName));
            conn.createStatement().execute("UPSERT INTO " + indexTableFullName1 + " VALUES (4, 2, 8)");
            conn.createStatement().execute("UPSERT INTO " + indexTableFullName2 + " VALUES (8, 2, 4)");
            conn.commit();
            this.setIndexRowStatusesToVerified(conn, viewFullName, indexTableFullName1);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName1, null, 0, IndexTool.IndexVerifyType.BEFORE, "-fi");
            this.assertExtraCounters(indexTool, 1L, 0L, true);
            indexTool = IndexToolIT.runIndexTool(false, schemaName, viewName, indexTableName2, null, 0, IndexTool.IndexVerifyType.BEFORE, "-fi");
            this.assertExtraCounters(indexTool, 1L, 0L, true);
            String indexTablePhysicalName = "_IDX" + dataTableFullName;
            byte[] indexTableFullNameBytes = Bytes.toBytes((String)indexTablePhysicalName);
            IndexVerificationOutputRepository outputRepository = new IndexVerificationOutputRepository(indexTableFullNameBytes, conn);
            List rows = outputRepository.getAllOutputRows();
            try {
                Assert.assertEquals((long)2L, (long)rows.size());
            }
            catch (AssertionError e) {
                TestUtil.dumpTable(conn, TableName.valueOf((String)"PHOENIX_INDEX_TOOL"));
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFromIndexToolForIncrementalVerify() throws Exception {
        int NROWS = 4;
        ManualEnvironmentEdge customEdge = new ManualEnvironmentEdge();
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        long delta = 2L;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            long t0 = EnvironmentEdgeManager.currentTimeMillis();
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
            PreparedStatement dataPreparedStatement = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
            for (int i = 1; i <= 4; ++i) {
                dataPreparedStatement.setInt(1, i);
                dataPreparedStatement.setInt(2, i + 1);
                dataPreparedStatement.setInt(3, i * 2);
                dataPreparedStatement.execute();
            }
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName, dataTableFullName));
            customEdge.setValue(EnvironmentEdgeManager.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)customEdge);
            customEdge.incrementValue(delta);
            long t1 = customEdge.currentTime();
            IndexTool it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-fi", "-st", String.valueOf(t0), "-et", String.valueOf(t1));
            CounterGroup mrJobCounters = IndexToolIT.getMRJobCounters(it);
            Assert.assertEquals((long)4L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            PreparedStatement indexPreparedStatement = conn.prepareStatement("UPSERT INTO " + indexTableFullName + " VALUES(?,?,?)");
            for (int i = 5; i <= 8; ++i) {
                indexPreparedStatement.setInt(1, i + 1);
                indexPreparedStatement.setInt(2, i);
                indexPreparedStatement.setInt(3, i * 2);
                indexPreparedStatement.execute();
            }
            conn.commit();
            this.setIndexRowStatusesToVerified(conn, dataTableFullName, indexTableFullName);
            customEdge.incrementValue(delta);
            long t2 = customEdge.currentTime();
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-fi", "-st", String.valueOf(t1), "-et", String.valueOf(t2));
            mrJobCounters = IndexToolIT.getMRJobCounters(it);
            Assert.assertEquals((long)4L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)4L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
            it = IndexToolIT.runIndexTool(false, schemaName, dataTableName, indexTableName, null, 0, IndexTool.IndexVerifyType.ONLY, "-fi", "-st", String.valueOf(t0), "-et", String.valueOf(t2));
            mrJobCounters = IndexToolIT.getMRJobCounters(it);
            Assert.assertEquals((long)8L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.SCANNED_DATA_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)4L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_VERIFIED_INDEX_ROW_COUNT.name()).getValue());
            Assert.assertEquals((long)0L, (long)mrJobCounters.findCounter(PhoenixIndexToolJobCounters.BEFORE_REPAIR_EXTRA_UNVERIFIED_INDEX_ROW_COUNT.name()).getValue());
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testDisableOutputLogging() throws Exception {
        if (!this.mutable) {
            return;
        }
        int NROWS = 4;
        String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = IndexRepairRegionScannerIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
            PreparedStatement dataPreparedStatement = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
            for (int i = 1; i <= 4; ++i) {
                dataPreparedStatement.setInt(1, i);
                dataPreparedStatement.setInt(2, i + 1);
                dataPreparedStatement.setInt(3, i * 2);
                dataPreparedStatement.execute();
            }
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName, dataTableFullName));
            PreparedStatement indexPreparedStatement = conn.prepareStatement("UPSERT INTO " + indexTableFullName + " VALUES(?,?,?)");
            for (int i = 5; i <= 8; ++i) {
                indexPreparedStatement.setInt(1, i + 1);
                indexPreparedStatement.setInt(2, i);
                indexPreparedStatement.setInt(3, i * 2);
                indexPreparedStatement.execute();
            }
            conn.commit();
            this.setIndexRowStatusesToVerified(conn, dataTableFullName, indexTableFullName);
            this.assertDisableLogging(conn, 4, 0, IndexTool.IndexVerifyType.ONLY, IndexTool.IndexDisableLoggingType.BEFORE, null, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
            this.truncateIndexToolTables();
            this.assertDisableLogging(conn, 4, 4, IndexTool.IndexVerifyType.ONLY, IndexTool.IndexDisableLoggingType.NONE, IndexVerificationOutputRepository.PHASE_BEFORE_VALUE, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
            this.truncateIndexToolTables();
            this.assertDisableLogging(conn, 4, 0, IndexTool.IndexVerifyType.BEFORE, IndexTool.IndexDisableLoggingType.BEFORE, null, schemaName, dataTableName, indexTableName, indexTableFullName, 0);
        }
    }

    public void deleteAllRows(java.sql.Connection conn, TableName tableName) throws SQLException, IOException, InterruptedException {
        Scan scan = new Scan();
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        Connection hbaseConn = admin.getConnection();
        Table table = hbaseConn.getTable(tableName);
        boolean deletedRows = false;
        try (ResultScanner scanner = table.getScanner(scan);){
            for (Result r : scanner) {
                Delete del = new Delete(r.getRow());
                table.delete(del);
                deletedRows = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (deletedRows) {
            IndexRepairRegionScannerIT.getUtility().getAdmin().flush(tableName);
            TestUtil.majorCompact(IndexRepairRegionScannerIT.getUtility(), tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConditionalTTL() throws Exception {
        if (!this.mutable) {
            return;
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(IndexRepairRegionScannerIT.getUrl(), props);){
            String schemaName = IndexRepairRegionScannerIT.generateUniqueName();
            String dataTableName = "T_" + IndexRepairRegionScannerIT.generateUniqueName();
            String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
            String viewName1 = "GV_" + IndexRepairRegionScannerIT.generateUniqueName();
            String viewFullName1 = SchemaUtil.getTableName((String)schemaName, (String)viewName1);
            String viewName2 = "GV_" + IndexRepairRegionScannerIT.generateUniqueName();
            String viewFullName2 = SchemaUtil.getTableName((String)schemaName, (String)viewName2);
            String indexTableName1 = "I_" + IndexRepairRegionScannerIT.generateUniqueName();
            String indexTableFullName1 = SchemaUtil.getTableName((String)schemaName, (String)indexTableName1);
            String indexTableName2 = "I_" + IndexRepairRegionScannerIT.generateUniqueName();
            String indexTableFullName2 = SchemaUtil.getTableName((String)schemaName, (String)indexTableName2);
            String ddl = String.format("CREATE TABLE %s (ID1 INTEGER NOT NULL, ID2 INTEGER NOT NULL, VAL1 INTEGER, VAL2 INTEGER CONSTRAINT PK PRIMARY KEY(ID1, ID2)) %s", dataTableFullName, this.tableDDLOptions);
            conn.createStatement().execute(ddl);
            conn.commit();
            ddl = String.format("CREATE VIEW %s AS SELECT * FROM %s WHERE ID1=1", viewFullName1, dataTableFullName);
            conn.createStatement().execute(ddl);
            conn.commit();
            ddl = String.format("CREATE VIEW %s AS SELECT * FROM %s WHERE ID1=2 TTL='VAL2 = -1'", viewFullName2, dataTableFullName);
            conn.createStatement().execute(ddl);
            conn.commit();
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName1, viewFullName1));
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName2, viewFullName2));
            for (String viewName : new String[]{viewFullName1, viewFullName2}) {
                conn.createStatement().execute(String.format("UPSERT INTO %s (ID2, VAL1, VAL2) values (1, 2, 4)", viewName));
            }
            conn.commit();
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            for (String viewName : new String[]{viewFullName1, viewFullName2}) {
                conn.createStatement().execute(String.format("UPSERT INTO %s (ID2, VAL1, VAL2) values (2, 0, 4)", viewName));
                conn.createStatement().execute(String.format("UPSERT INTO %s (ID2, VAL1, VAL2) values (3, 5, -1)", viewName));
                IndexRepairRegionScannerIT.commitWithException(conn);
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            this.setIndexRowStatusesToVerified(conn, viewFullName1, indexTableFullName1);
            IndexTool indexTool = IndexToolIT.runIndexTool(false, schemaName, viewName1, indexTableName1, null, 0, IndexTool.IndexVerifyType.BEFORE, "-fi");
            this.assertExtraCounters(indexTool, 2L, 0L, true);
            indexTool = IndexToolIT.runIndexTool(false, schemaName, viewName2, indexTableName2, null, 0, IndexTool.IndexVerifyType.BEFORE, "-fi");
            this.assertExtraCounters(indexTool, 1L, 0L, true);
        }
        finally {
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
        }
    }
}

